/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.util;

import com.siebel.extra.MangleString;
import com.siebel.integration.util.SiebelTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class SiebelJavaProperties
implements Cloneable,
Serializable {
    protected MangleString m_mangler = null;
    protected Properties m_properties = null;
    protected String m_propertiesFileName = "siebel.properties";
    public static final String DEFAULT_PROPERTY_FILE = "siebel.properties";

    public SiebelJavaProperties() {
        this.m_properties = new Properties();
    }

    public SiebelJavaProperties(String string) {
        this.m_properties = new Properties();
        this.load(string);
    }

    public SiebelJavaProperties(String string, Properties properties) {
        this.m_properties = new Properties(properties);
        this.load(string);
    }

    public SiebelJavaProperties(Properties properties) {
        this.m_properties = new Properties(properties);
    }

    public Object clone() {
        try {
            SiebelJavaProperties siebelJavaProperties = (SiebelJavaProperties)super.clone();
            return siebelJavaProperties;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getProperty(String string, boolean bl) {
        String string2 = this.m_properties.getProperty(string);
        if (this.m_mangler == null) {
            this.m_mangler = new MangleString();
        }
        return bl ? this.m_mangler.decrypt(string2) : string2;
    }

    public String getProperty(String string, String string2, boolean bl) {
        String string3 = this.m_properties.getProperty(string, string2);
        if (this.m_mangler == null) {
            this.m_mangler = new MangleString();
        }
        return bl ? this.m_mangler.decrypt(string3) : string3;
    }

    public boolean isEmpty() {
        return this.m_properties.isEmpty();
    }

    public void list(PrintStream printStream) {
        this.m_properties.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.m_properties.list(printWriter);
    }

    public void load(String string) {
        try {
            this.m_propertiesFileName = string;
            this.load();
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 2, "SiebelJavaProperties", "Could not load properties file: " + this.m_propertiesFileName);
            throw new IllegalArgumentException(this.m_propertiesFileName);
        }
        catch (NullPointerException nullPointerException) {
            SiebelTrace.getInstance().trace(null, 2, "SiebelJavaProperties", "Could not load properties file: " + this.m_propertiesFileName);
        }
    }

    public Enumeration propertyNames() {
        return this.m_properties.propertyNames();
    }

    public void setProperty(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            SiebelTrace.getInstance().trace(null, 2, "SiebelJavaProperties", "setProperty called with a null argument: name=" + string + "; value=" + string2);
            Thread.currentThread();
            Thread.dumpStack();
        }
        if (this.m_mangler == null) {
            this.m_mangler = new MangleString();
        }
        this.m_properties.setProperty(string, bl ? this.m_mangler.crypt(string2) : string2);
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        this.m_properties.store(outputStream, string);
    }

    protected void load() throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.m_propertiesFileName);
        this.m_properties.load(inputStream);
        SiebelTrace.getInstance().trace(null, 5, "SiebelJavaProperties", "Loaded file " + this.m_propertiesFileName);
    }
}

