/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.util;

import com.siebel.common.common.CSSUtilities;
import com.siebel.integration.util.SiebelTraceInterface;
import com.siebel.integration.util.SiebelTraceLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class SiebelTrace
implements SiebelTraceInterface,
Serializable {
    private static SiebelTrace sSiebelTraceSingleton = null;
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String logfile = null;
    private int logLevel = 1;
    private static Hashtable sRepresentations = new Hashtable();
    static final int sNumIters = 500;
    static final int sSleepTime = 30;

    private SiebelTrace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SiebelTrace getInstance() {
        if (sSiebelTraceSingleton != null) return sSiebelTraceSingleton;
        Class<SiebelTrace> clazz = SiebelTrace.class;
        synchronized (SiebelTrace.class) {
            sSiebelTraceSingleton = new SiebelTrace();
            sSiebelTraceSingleton.setLogfile(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSiebelTraceSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void trace(PrintWriter printWriter, int n, String string, String string2, boolean bl) {
        if (n > this.getLogLevel()) {
            return;
        }
        Object v = sRepresentations.get(this.logfile);
        if (v == null) return;
        boolean bl2 = bl || n >= 5;
        Class<SiebelTrace> clazz = SiebelTrace.class;
        synchronized (SiebelTrace.class) {
            ((Representation)v).trace(printWriter, this.format(n, string, string2), bl2);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void trace(PrintWriter printWriter, int n, String string, String string2) {
        this.trace(printWriter, n, string, string2, false);
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int n) {
        if (this.getLogLevel() == n) {
            return;
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("LogLevel");
        }
        this.trace(null, 5, "SiebelTrace", "Log level set to " + n);
        this.logLevel = n;
    }

    public void setLogLevel(String string) {
        String string2 = string.trim();
        for (int i = 0; i < SiebelTraceLevel.LOG_LEVEL.length; ++i) {
            String string3 = SiebelTraceLevel.LOG_LEVEL[i].trim();
            if (string3.compareToIgnoreCase(string2) != 0) continue;
            this.logLevel = i;
            return;
        }
        throw new IllegalArgumentException("LogLevel");
    }

    public void pushStack(String string) {
    }

    public void popStack() {
    }

    protected String format(int n, String string, String string2) {
        return "[SIEBEL " + SiebelTraceLevel.getLogLevelName(n) + "]\t" + Thread.currentThread().toString() + "\t[" + dateFormat.format(new Date()) + "] " + "[" + string + "] " + string2;
    }

    public synchronized void setLogfile(String string) {
        if ((string = CSSUtilities.ValidateAndFormatLogFileName(string)) == null) {
            string = new String();
        }
        if (!string.equals(this.logfile)) {
            if (sRepresentations.get(string) == null) {
                sRepresentations.put(string, new Representation(string));
            }
            this.logfile = string;
        }
    }

    public static void main(String[] stringArray) {
        try {
            SiebelTrace siebelTrace = SiebelTrace.getInstance();
            siebelTrace.setLogLevel(5);
            File file = new File("test.txt");
            if (!file.delete()) {
                System.err.println("delete failed");
            }
            for (int i = 0; i < 500; ++i) {
                siebelTrace.setLogfile("test.txt");
                siebelTrace.trace(null, 3, "Module", "A long message " + Integer.toString(i));
                Thread.sleep(30L);
            }
            siebelTrace.setLogfile(null);
            Thread thread = new Thread(){
                SiebelTrace c1 = SiebelTrace.getInstance();

                @Override
                public void run() {
                    for (int i = 0; i < 500; ++i) {
                        this.c1.setLogfile("testfile1.txt");
                        this.c1.trace(null, 1, "Module", "A long message in thread 1 " + Integer.toString(i));
                        try {
                            Thread.sleep(30L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            Thread thread2 = new Thread(){
                SiebelTrace c2 = SiebelTrace.getInstance();

                @Override
                public void run() {
                    for (int i = 0; i < 500; ++i) {
                        this.c2.setLogfile("testfile1.txt");
                        this.c2.trace(null, 1, "Module", "A long message in thread 2 " + Integer.toString(i));
                        try {
                            Thread.sleep(30L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            Thread thread3 = new Thread(){
                SiebelTrace c2 = SiebelTrace.getInstance();

                @Override
                public void run() {
                    for (int i = 0; i < 500; ++i) {
                        this.c2.setLogfile("testfile2.txt");
                        this.c2.trace(null, 1, "Module", "A long message in thread 3 " + Integer.toString(i));
                        try {
                            Thread.sleep(30L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            thread.start();
            thread2.start();
            thread3.start();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.out);
        }
    }

    private class Representation {
        private String mLogFileName = null;
        private File mLogFile = null;
        private FileOutputStream mFOS = null;
        private PrintWriter mFileWriter = new PrintWriter(System.out);

        public Representation(String string) {
            if (string != null && string.length() != 0) {
                this.openFile(string);
                this.mFileWriter.println("---------------------------------------------------------------------------");
                this.mFileWriter.println("   New trace " + dateFormat.format(new Date()));
            }
        }

        public void trace(PrintWriter printWriter, String string, boolean bl) {
            try {
                this.renameIfLong();
                if (printWriter == null) {
                    printWriter = this.mFileWriter;
                }
                printWriter.println(string);
                if (bl) {
                    Throwable throwable = new Throwable();
                    throwable.fillInStackTrace();
                    throwable.printStackTrace(printWriter);
                }
                printWriter.flush();
            }
            catch (Exception exception) {
                System.err.println("[SIEBEL WARNING]\t Error during logging");
                exception.printStackTrace();
            }
        }

        private void openFile(String string) {
            try {
                if (string != null && string.length() != 0) {
                    this.mLogFileName = string;
                    this.mLogFile = new File(string);
                    String string2 = string.substring(0, string.lastIndexOf(this.mLogFile.getName()));
                    File file = new File(string2);
                    file.mkdirs();
                    this.mFOS = new FileOutputStream(string, true);
                    PrintStream printStream = new PrintStream(this.mFOS);
                    this.mFileWriter = new PrintWriter(printStream);
                } else {
                    this.mLogFileName = "SiebelJCALog.txt";
                    this.mLogFile = new File(this.mLogFileName);
                    this.mFOS = new FileOutputStream(this.mLogFileName, true);
                    PrintStream printStream = new PrintStream(this.mFOS);
                    this.mFileWriter = new PrintWriter(printStream);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(SiebelTrace.this.format(2, "SiebelTrace", "Could not create log file " + this.mLogFileName));
            }
            catch (IOException iOException) {
                System.err.println(SiebelTrace.this.format(2, "SiebelTrace", "Could not create log file " + this.mLogFileName));
            }
        }

        private void renameIfLong() {
            if (this.mLogFile == null) {
                return;
            }
            long l = this.mLogFile.length();
            if (l < 100000000L) {
                return;
            }
            int n = this.mLogFileName.indexOf(46, 0);
            if (n == -1) {
                n = this.mLogFileName.length();
            }
            StringBuffer stringBuffer = new StringBuffer(this.mLogFileName);
            stringBuffer.insert(n, "_" + Long.toString(System.currentTimeMillis()));
            String string = stringBuffer.toString();
            File file = new File(string);
            try {
                if (this.mFOS != null) {
                    this.mFOS.close();
                }
                if (!this.mLogFile.renameTo(file)) {
                    throw new IOException();
                }
            }
            catch (IOException iOException) {
                System.err.println("rename failed");
            }
            this.openFile(this.mLogFileName);
        }
    }
}

