/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.util;

import com.siebel.extra.MangleString;
import com.siebel.integration.util.SiebelJavaProperties;
import com.siebel.integration.util.SiebelTrace;
import java.io.Serializable;

public class SiebelUserProperties
extends SiebelJavaProperties
implements Cloneable,
Serializable {
    protected static final String CONNECT_PROPERTY = "siebel.connection.string";
    protected static final String USERNAME_PROPERTY = "siebel.user.name";
    protected static final String PASSWORD_PROPERTY = "siebel.user.password";
    protected static final String LANGUAGE_PROPERTY = "siebel.user.language";
    public static final String DEFAULT_LANGUAGE = "enu";
    protected static final String LOGLEVEL_PROPERTY = "siebel.loglevel";
    protected static final String LOGFILE_PROPERTY = "siebel.logfile";
    protected static final String ENCRYPTED_PROPERTY = "siebel.user.encrypted";
    protected static final String CLOSE_ONAPPERR = "siebel.connection.closeonapperr";
    private static final String B2B_PROPERTY = "siebel.jcamode.b2b";
    private static final String B2BUSER_PROPERTY = "siebel.b2b.user";
    private static final String B2BPWD_PROPERTY = "siebel.b2b.password";
    private static final String SESS_TOKEN_MAX_AGE = "siebel.sessiontoken.maxage";
    private static final String SESS_TOKEN_TIMEOUT = "siebel.sessiontoken.timeout";
    private static final String MAX_ANON_USERS = "siebel.max.anonusers";
    protected boolean m_encrypted = false;

    public SiebelUserProperties() {
    }

    private void initialize() {
        this.m_encrypted = this.getEncrypted();
        if (this.getLogLevelString() != null) {
            SiebelTrace.getInstance().setLogLevel(this.getLogLevel());
        }
        if (this.getLogfile() != null) {
            SiebelTrace.getInstance().setLogfile(this.getLogfile());
        }
    }

    public SiebelUserProperties(String string) {
        super(string);
        this.initialize();
    }

    public SiebelUserProperties(String string, String string2, String string3) {
        super("siebel.properties");
        this.initialize();
        this.setUserName(string);
        this.setPassword(string2);
        this.setConnectString(string3);
    }

    public SiebelUserProperties(String string, String string2, String string3, String string4) {
        super("siebel.properties");
        this.initialize();
        this.setUserName(string);
        this.setPassword(string2);
        this.setLanguage(string4);
        this.setConnectString(string3);
    }

    public String getConnectString() {
        return this.getProperty(CONNECT_PROPERTY, false);
    }

    public boolean getEncrypted() {
        return new Boolean(this.getProperty(ENCRYPTED_PROPERTY, this.m_encrypted));
    }

    public String getLanguage() {
        String string = this.getProperty(LANGUAGE_PROPERTY, false);
        if (string != null) {
            string = string.toLowerCase();
        }
        return string;
    }

    public int getLogLevel() {
        try {
            return Integer.parseInt(this.getLogLevelString());
        }
        catch (NumberFormatException numberFormatException) {
            return SiebelTrace.getInstance().getLogLevel();
        }
    }

    public String getLogLevelString() {
        return this.getProperty(LOGLEVEL_PROPERTY, false);
    }

    public String getLogfile() {
        return this.getProperty(LOGFILE_PROPERTY, false);
    }

    public String getPassword() {
        if (this.isB2BMode()) {
            return this.getB2BPassword();
        }
        return this.getProperty(PASSWORD_PROPERTY, this.m_encrypted);
    }

    public String getUserName() {
        if (this.isB2BMode()) {
            return this.getB2BUser();
        }
        return this.getProperty(USERNAME_PROPERTY, this.m_encrypted);
    }

    public String getCloseOnAppErr() {
        return this.getProperty(CLOSE_ONAPPERR, false);
    }

    public void SetCloseOnAppErr(String string) {
        this.setProperty(CLOSE_ONAPPERR, string, false);
    }

    public boolean isB2BMode() {
        String string = this.getProperty(B2B_PROPERTY, false);
        if (string != null) {
            return new Boolean(string);
        }
        return false;
    }

    public String getB2BUser() {
        return this.getProperty(B2BUSER_PROPERTY, this.m_encrypted);
    }

    public String getB2BPassword() {
        return this.getProperty(B2BPWD_PROPERTY, this.m_encrypted);
    }

    public String getSessionTokenMaxAge() {
        return this.getProperty(SESS_TOKEN_MAX_AGE, false);
    }

    public String getSessionTokenTimeout() {
        return this.getProperty(SESS_TOKEN_TIMEOUT, false);
    }

    public int getMaxAnonUsers() {
        String string = this.getProperty(MAX_ANON_USERS, false);
        int n = -1;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return n;
    }

    public void setConnectString(String string) {
        this.setProperty(CONNECT_PROPERTY, string, false);
    }

    public void setEncrypt(boolean bl) {
        this.setProperty(ENCRYPTED_PROPERTY, bl ? "true" : "false", false);
        this.m_encrypted = bl;
    }

    public void setLanguage(String string) {
        this.setProperty(LANGUAGE_PROPERTY, string, false);
    }

    public void setLogLevel(int n) {
        String string = "" + n;
        this.setProperty(LOGLEVEL_PROPERTY, string, false);
    }

    public void setLogLevel(String string) {
        this.setProperty(LOGLEVEL_PROPERTY, string, false);
    }

    public void setPassword(String string) {
        this.setProperty(PASSWORD_PROPERTY, string, this.m_encrypted);
    }

    public void setB2BPassword(String string) {
        this.setProperty(B2BPWD_PROPERTY, string, this.m_encrypted);
    }

    public void setUserName(String string) {
        this.setProperty(USERNAME_PROPERTY, string, this.m_encrypted);
    }

    public void setB2BUserName(String string) {
        this.setProperty(B2BUSER_PROPERTY, string, this.m_encrypted);
    }

    public void setSessionTokenMaxAge(String string) {
        this.setProperty(SESS_TOKEN_MAX_AGE, string, false);
    }

    public void setSessionTokenTimeout(String string) {
        this.setProperty(SESS_TOKEN_TIMEOUT, string, false);
    }

    public void setMaxAnonUsers(String string) {
        this.setProperty(MAX_ANON_USERS, string, false);
    }

    public void setUserProperties(String string, String string2, String string3, String string4) {
        boolean bl = false;
        bl = this.getEncrypted();
        if (string != null) {
            this.setProperty(USERNAME_PROPERTY, string, bl);
        }
        if (string2 != null) {
            this.setProperty(PASSWORD_PROPERTY, string2, bl);
        }
        if (string4 != null) {
            this.setProperty(LANGUAGE_PROPERTY, string4, false);
        }
        if (string3 != null) {
            this.setProperty(CONNECT_PROPERTY, string3, false);
        }
    }

    public boolean equals(SiebelUserProperties siebelUserProperties) {
        String string = this.getUserName();
        String string2 = siebelUserProperties.getUserName();
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && !string.equals(string2)) {
            return false;
        }
        string = this.getPassword();
        string2 = siebelUserProperties.getPassword();
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && !string.equals(string2)) {
            return false;
        }
        string = this.getConnectString();
        string2 = siebelUserProperties.getConnectString();
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && !string.equals(string2)) {
            return false;
        }
        string = this.getLanguage();
        string2 = siebelUserProperties.getLanguage();
        if (string == null && string2 != null) {
            return false;
        }
        return string == null || string.equals(string2);
    }

    public int hashCode() {
        String string = this.getUserName() + this.getPassword() + this.getConnectString() + this.getLanguage();
        return string.hashCode();
    }

    @Override
    public Object clone() {
        SiebelUserProperties siebelUserProperties = (SiebelUserProperties)super.clone();
        return siebelUserProperties;
    }

    public static void main(String[] stringArray) {
        try {
            MangleString mangleString = new MangleString();
            SiebelUserProperties[] siebelUserPropertiesArray = new SiebelUserProperties[]{new SiebelUserProperties(), new SiebelUserProperties("adapter.base.test.properties"), new SiebelUserProperties("u1", "p1", "c1"), new SiebelUserProperties(mangleString.crypt("user2"), "p2", "c2", "l2")};
            SiebelUserProperties[] siebelUserPropertiesArray2 = new SiebelUserProperties[]{(SiebelUserProperties)siebelUserPropertiesArray[0].clone(), (SiebelUserProperties)siebelUserPropertiesArray[1].clone(), (SiebelUserProperties)siebelUserPropertiesArray[2].clone(), (SiebelUserProperties)siebelUserPropertiesArray[3].clone()};
            for (int i = 0; i < siebelUserPropertiesArray.length; ++i) {
                System.out.print("User for " + (i + 1) + " is " + siebelUserPropertiesArray[i].getUserName() + " ... " + siebelUserPropertiesArray2[i].getUserName());
                siebelUserPropertiesArray[i].setEncrypt(true);
                System.out.println("   Encrypted : " + siebelUserPropertiesArray[i].getUserName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }
}

