/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.xsdcreator;

import com.siebel.integration.common.XSDAppletField;
import com.siebel.integration.common.XSDCompField;
import com.siebel.integration.common.XSDCompKey;
import com.siebel.integration.common.XSDComponent;
import com.siebel.integration.common.XSDObject;
import com.siebel.integration.common.tmpl.XSDCompFieldTmpl;
import com.siebel.integration.common.tmpl.XSDCompKeyTmpl;
import com.siebel.integration.common.tmpl.XSDCompTmpl;
import com.siebel.integration.common.tmpl.XSDObjTmpl;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.xsdcreator.DBProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class SiebelDBTransaction {
    private static Connection m_dbConn = null;
    private static DBProperties m_dbConsts = null;

    public SiebelDBTransaction() {
        m_dbConn = null;
        m_dbConsts = null;
    }

    public void SetDBConnection(Connection connection) {
        m_dbConn = connection;
    }

    public Connection GetDBConnection() {
        return m_dbConn;
    }

    public static void CreateDbConnection() throws SQLException {
        try {
            if (m_dbConn != null) {
                return;
            }
            Class.forName(m_dbConsts.getOraDriver()).newInstance();
            m_dbConn = DriverManager.getConnection(m_dbConsts.getDbConnectString(), m_dbConsts.getUsername(), m_dbConsts.getPassword());
        }
        catch (SQLException sQLException) {
            String string = "Unable to connect to the database. ";
            string = string + "\n";
            string = string + "SQLState = " + sQLException.getSQLState();
            string = string + "\n";
            string = string + sQLException.getMessage();
            SiebelTrace.getInstance().trace(null, 0, "SiebelDBTransaction::CreateDbConnection", string);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 0, "SiebelDBTransaction::CreateDbConnection", "Error occured while trying to establish database connection.");
            SiebelTrace.getInstance().trace(null, 0, "SiebelDBTransaction::CreateDbConnection", "Exception Occured : " + exception.getMessage());
            return;
        }
    }

    public static Connection getDBConnectionInst() {
        return m_dbConn;
    }

    public void ReleaseDbConnection() {
        try {
            if (m_dbConn != null) {
                m_dbConn.close();
            }
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 0, "SiebelDBTransaction::ReleaseDbConnection", "Error occured while releasing connection.");
            SiebelTrace.getInstance().trace(null, 0, "SiebelDBTransaction::ReleaseDbConnection", "Exception Occured : " + exception.getMessage());
        }
    }

    public XSDObject buildXSDObjectFromXSDObjectTmpl(XSDObjTmpl xSDObjTmpl) {
        XSDObject xSDObject = null;
        try {
            SiebelDBTransaction.CreateDbConnection();
            String string = this.getRowIdForIOName(xSDObjTmpl.getBaseIOName());
            if (string == null || string.equals("")) {
                this.trace(1, "XSDCreator:buildXSDObjectFromXSDObjectTmpl", "IO row id is null. Integration Object " + xSDObjTmpl.getBaseIOName() + " doesn't exists.");
                return null;
            }
            xSDObject = this.BuildXSDObject(string);
            if (xSDObject == null) {
                this.trace(1, "XSDCreator:buildXSDObjectFromXSDObjectTmpl", "XSDObject that is created is null.");
                return null;
            }
            Vector<XSDComponent> vector = null;
            vector = xSDObjTmpl.getXsdComps() != null ? this.buildXSDComponentFromXSDCompTmpl(string, xSDObjTmpl.getXsdComps()) : this.BuildXSDComponent(string);
            if (vector == null) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                xSDObject.addXSDComponent(vector.get(i));
            }
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::buildXSDObjectFromXSDObjectTmpl", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::buildXSDObjectFromXSDObjectTmpl", "Details : " + sQLException);
        }
        return xSDObject;
    }

    private Vector<XSDComponent> buildXSDComponentFromXSDCompTmpl(String string, Vector<XSDCompTmpl> vector) {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getSelectedIC(string, vector);
            this.trace(3, "SiebelDBTransaction::buildXSDComponentFromXSDCompTmpl", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            Object var6_7 = null;
            Vector<XSDComponent> vector2 = new Vector<XSDComponent>();
            while (resultSet.next()) {
                String string3 = resultSet.getString("Name");
                XSDCompTmpl xSDCompTmpl = this.getXSDCompTmpl(string3, vector);
                String string4 = resultSet.getString("row_id");
                Properties properties = this.getXCTmplUserProp(string4, xSDCompTmpl.getXcUserProp());
                Vector<XSDCompKey> vector3 = this.getXCUserKeyFromXSDCompKeyTmpl(string4, xSDCompTmpl.getXsdCompKey());
                XSDComponent xSDComponent = new XSDComponent();
                xSDComponent.setXcName(string3);
                xSDComponent.setRowId(string4);
                xSDComponent.setXmlTag(resultSet.getString("xml_tag"));
                xSDComponent.setParentXCName(resultSet.getString("par_int_comp"));
                xSDComponent.setCardinality(resultSet.getString("cardinality_cd"));
                xSDComponent.setXcUserProps(properties);
                for (int i = 0; i < vector3.size(); ++i) {
                    xSDComponent.addXCKey(vector3.get(i));
                }
                Statement statement2 = m_dbConn.createStatement();
                String string5 = null;
                string5 = xSDCompTmpl.getXsdCompField() != null ? m_dbConsts.getSelectedFields(string4, xSDCompTmpl.getXsdCompField()) : m_dbConsts.getIcFieldQuery() + string4 + m_dbConsts.getInactive();
                ResultSet resultSet2 = statement2.executeQuery(string5);
                while (resultSet2.next()) {
                    String string6 = resultSet2.getString("Name");
                    XSDCompFieldTmpl xSDCompFieldTmpl = null;
                    xSDCompFieldTmpl = xSDCompTmpl.getXsdCompField() != null ? this.getXSDCompFieldTmpl(string6, xSDCompTmpl.getXsdCompField()) : null;
                    XSDCompField xSDCompField = new XSDCompField();
                    xSDCompField.setFieldName(string6);
                    String string7 = resultSet2.getString("row_id");
                    xSDCompField.setRowId(string7);
                    xSDCompField.setDataType(resultSet2.getString("phys_data_type"));
                    xSDCompField.setXmlStyle(resultSet2.getString("xml_style"));
                    xSDCompField.setXmlTag(resultSet2.getString("xml_tag"));
                    xSDCompField.setExtName(resultSet2.getString("EXT_NAME"));
                    if (xSDCompFieldTmpl != null) {
                        xSDCompField.setFieldUserProps(this.getXCFieldUserProperties(string7, xSDCompFieldTmpl.getFieldUserProp()));
                    } else {
                        xSDCompField.setFieldUserProps(this.getXCFieldUserProperties(string7, null));
                    }
                    xSDComponent.addXCField(xSDCompField);
                }
                vector2.add(xSDComponent);
                statement2.close();
            }
            statement.close();
            return vector2;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::buildXSDComponentFromXSDCompTmpl", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::buildXSDComponentFromXSDCompTmpl", "Details : " + sQLException);
            return null;
        }
    }

    private XSDCompTmpl getXSDCompTmpl(String string, Vector<XSDCompTmpl> vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equals(vector.get(i).getName())) continue;
                return vector.get(i);
            }
        }
        return null;
    }

    private XSDCompFieldTmpl getXSDCompFieldTmpl(String string, Vector<XSDCompFieldTmpl> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!string.equals(vector.get(i).getName())) continue;
            return vector.get(i);
        }
        return null;
    }

    private Properties getXCTmplUserProp(String string, Properties properties) {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcFieldUserPropQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::getXCTmplUserProp", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                properties.setProperty(resultSet.getString("Name"), resultSet.getString("value"));
            }
            statement.close();
            return properties;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::getXCTmplUserProp", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::getXCTmplUserProp", "Details : " + sQLException);
            return null;
        }
    }

    private Vector<XSDCompKey> getXCUserKeyFromXSDCompKeyTmpl(String string, Vector<XSDCompKeyTmpl> vector) {
        try {
            Vector<XSDCompKey> vector2 = new Vector<XSDCompKey>();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    XSDCompKeyTmpl xSDCompKeyTmpl = vector.get(i);
                    XSDCompKey xSDCompKey = new XSDCompKey();
                    xSDCompKey.setKeyName(xSDCompKeyTmpl.getName());
                    xSDCompKey.setKeyType(xSDCompKeyTmpl.getKeyType());
                    Vector<XSDCompFieldTmpl> vector3 = xSDCompKeyTmpl.getKeyFields();
                    if (vector3 != null) {
                        for (int j = 0; j < vector3.size(); ++j) {
                            XSDCompFieldTmpl xSDCompFieldTmpl = vector3.get(j);
                            XSDCompField xSDCompField = new XSDCompField();
                            xSDCompField.setFieldName(xSDCompFieldTmpl.getName());
                            xSDCompKey.addKeyField(xSDCompField);
                        }
                    }
                    vector2.add(xSDCompKey);
                }
                return vector2;
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcUserKeyQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::getXCFieldUserProperties", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                XSDCompKey xSDCompKey = new XSDCompKey();
                xSDCompKey.setKeyName(resultSet.getString("Name"));
                String string3 = resultSet.getString("row_id");
                xSDCompKey.setRowId(string3);
                xSDCompKey.setKeySequence(resultSet.getString("key_seq"));
                xSDCompKey.setKeyType(resultSet.getString("key_type"));
                Statement statement2 = m_dbConn.createStatement();
                String string4 = m_dbConsts.getIcFieldUserKeyQuery() + string3 + m_dbConsts.getInactive();
                this.trace(3, "SiebelDBTransaction::getXCFieldUserProperties", "Executing SQL Query : " + string2);
                ResultSet resultSet2 = statement2.executeQuery(string4);
                while (resultSet2.next()) {
                    XSDCompField xSDCompField = new XSDCompField();
                    xSDCompField.setFieldName(resultSet2.getString("Name"));
                    xSDCompField.setRowId(resultSet2.getString("row_id"));
                    xSDCompField.setFieldName(resultSet2.getString("field_name"));
                    xSDCompField.setSequence(resultSet2.getString("seq_num"));
                    xSDCompKey.addKeyField(xSDCompField);
                }
                vector2.add(xSDCompKey);
                statement2.close();
            }
            statement.close();
            return vector2;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::getXCUserKeyFromXSDCompKeyTmpl", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::getXCUserKeyFromXSDCompKeyTmpl", "Details : " + sQLException);
            return null;
        }
    }

    private Properties getXCFieldUserProperties(String string, Properties properties) {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcFieldUserPropQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::getXCFieldUserProperties", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                properties = new Properties();
                properties.setProperty(resultSet.getString("Name"), resultSet.getString("value"));
            }
            statement.close();
            return properties;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::getXCFieldUserProperties", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::getXCFieldUserProperties", "Details : " + sQLException);
            return null;
        }
    }

    public XSDObject BuildXSDObjectFromIO(String string) {
        XSDObject xSDObject = null;
        try {
            SiebelDBTransaction.CreateDbConnection();
            String string2 = this.getRowIdForIOName(string);
            xSDObject = this.BuildXSDObject(string2);
            Vector<XSDComponent> vector = this.BuildXSDComponent(string2);
            if (vector == null) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                xSDObject.addXSDComponent(vector.get(i));
            }
            if (xSDObject == null) {
                return null;
            }
        }
        catch (Exception exception) {
            this.trace(1, "SiebelDBTransaction::BuildXSDObjectFromIO", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::BuildXSDObjectFromIO", "Details : " + exception);
            return null;
        }
        return xSDObject;
    }

    public String getRowIdForIOName(String string) {
        try {
            if (m_dbConn == null) {
                System.err.println("No database connection.");
                return null;
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIoRowidQuery() + string + m_dbConsts.getDelimiter();
            this.trace(3, "SiebelDBTransaction::getRowIdForIOName", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString("ROW_ID");
            }
            statement.close();
            return string3;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::getRowIdForIOName", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::getRowIdForIOName", "Details : " + sQLException);
            return null;
        }
    }

    public XSDObject BuildXSDObject(String string) {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIoQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::BuildXSDObject", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            XSDObject xSDObject = new XSDObject();
            while (resultSet.next()) {
                xSDObject.setBaseXOName(resultSet.getString("NAME"));
                xSDObject.setMajorVersion(resultSet.getString("EXT_MAJOR_VER"));
                xSDObject.setMinorVersion(resultSet.getString("EXT_MINOR_VER"));
                xSDObject.setRowId(string);
                xSDObject.setXmlTag(resultSet.getString("XML_TAG"));
                Properties properties = this.GetIOUserProperties(string);
                xSDObject.setXoUserProps(properties);
            }
            statement.close();
            return xSDObject;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::BuildXSDObject", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::BuildXSDObject", "Details : " + sQLException);
            return null;
        }
    }

    public Properties GetIOUserProperties(String string) {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Properties properties = new Properties();
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIoUserPropQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::GetIOUserProperties", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                properties.setProperty(resultSet.getString("Name"), resultSet.getString("value"));
            }
            statement.close();
            return properties;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetIOUserProperties", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetIOUserProperties", "Details : " + sQLException);
            return null;
        }
    }

    public Vector<XSDComponent> BuildXSDComponent(String string) {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcQuery() + string + m_dbConsts.getInactiveSeq();
            this.trace(3, "SiebelDBTransaction::BuildXSDComponent", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            Object var5_6 = null;
            Vector<XSDComponent> vector = new Vector<XSDComponent>();
            while (resultSet.next()) {
                String string3 = resultSet.getString("Name");
                String string4 = resultSet.getString("row_id");
                Properties properties = this.GetICUserProperties(string4);
                Vector<XSDCompKey> vector2 = this.GetICUserKey(string4);
                XSDComponent xSDComponent = new XSDComponent();
                xSDComponent.setXcName(string3);
                xSDComponent.setRowId(string4);
                xSDComponent.setXmlTag(resultSet.getString("xml_tag"));
                xSDComponent.setParentXCName(resultSet.getString("par_int_comp"));
                xSDComponent.setCardinality(resultSet.getString("cardinality_cd"));
                xSDComponent.setXcExternalName(resultSet.getString("EXT_NAME"));
                xSDComponent.setXcUserProps(properties);
                for (int i = 0; i < vector2.size(); ++i) {
                    xSDComponent.addXCKey(vector2.get(i));
                }
                Statement statement2 = m_dbConn.createStatement();
                String string5 = m_dbConsts.getIcFieldQuery() + string4 + m_dbConsts.getInactive();
                this.trace(3, "SiebelDBTransaction::BuildXSDComponent", "Executing SQL Query : " + string5);
                ResultSet resultSet2 = statement2.executeQuery(string5);
                while (resultSet2.next()) {
                    String string6 = resultSet2.getString("Name");
                    XSDCompField xSDCompField = new XSDCompField();
                    xSDCompField.setFieldName(string6);
                    String string7 = resultSet2.getString("row_id");
                    xSDCompField.setRowId(string7);
                    xSDCompField.setDataType(resultSet2.getString("phys_data_type"));
                    xSDCompField.setXmlStyle(resultSet2.getString("xml_style"));
                    xSDCompField.setXmlTag(resultSet2.getString("xml_tag"));
                    xSDCompField.setExtName(resultSet2.getString("EXT_NAME"));
                    xSDCompField.setFieldUserProps(this.GetICFieldUserProperties(string7));
                    xSDComponent.addXCField(xSDCompField);
                }
                vector.add(xSDComponent);
                statement2.close();
            }
            statement.close();
            return vector;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::BuildXSDComponent", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::BuildXSDComponent", "Details : " + sQLException);
            return null;
        }
    }

    public Properties GetICUserProperties(String string) {
        try {
            Properties properties = new Properties();
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcFieldUserPropQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::GetICUserProperties", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                properties.setProperty(resultSet.getString("Name"), resultSet.getString("value"));
            }
            statement.close();
            return properties;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetICUserProperties", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetICUserProperties", "Details : " + sQLException);
            return null;
        }
    }

    public Properties GetICFieldUserProperties(String string) {
        try {
            Properties properties = null;
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcFieldUserPropQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::GetICFieldUserProperties", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                properties = new Properties();
                properties.setProperty(resultSet.getString("Name"), resultSet.getString("value"));
            }
            statement.close();
            return properties;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetICFieldUserProperties", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetICFieldUserProperties", "Details : " + sQLException);
            return null;
        }
    }

    public Vector<XSDCompKey> GetICUserKey(String string) {
        try {
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcUserKeyQuery() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::GetICUserKey", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            Vector<XSDCompKey> vector = new Vector<XSDCompKey>();
            while (resultSet.next()) {
                XSDCompKey xSDCompKey = new XSDCompKey();
                xSDCompKey.setKeyName(resultSet.getString("Name"));
                String string3 = resultSet.getString("row_id");
                xSDCompKey.setRowId(string3);
                xSDCompKey.setKeySequence(resultSet.getString("key_seq"));
                xSDCompKey.setKeyType(resultSet.getString("key_type"));
                Statement statement2 = m_dbConn.createStatement();
                String string4 = m_dbConsts.getIcFieldUserKeyQuery() + string3 + m_dbConsts.getInactive();
                this.trace(3, "SiebelDBTransaction::GetICUserKey", "Executing SQL Query : " + string4);
                ResultSet resultSet2 = statement2.executeQuery(string4);
                while (resultSet2.next()) {
                    XSDCompField xSDCompField = new XSDCompField();
                    xSDCompField.setFieldName(resultSet2.getString("Name"));
                    xSDCompField.setRowId(resultSet2.getString("row_id"));
                    xSDCompField.setFieldName(resultSet2.getString("field_name"));
                    xSDCompField.setSequence(resultSet2.getString("seq_num"));
                    xSDCompKey.addKeyField(xSDCompField);
                }
                vector.add(xSDCompKey);
                statement2.close();
            }
            statement.close();
            return vector;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetICUserKey", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetICUserKey", "Details : " + sQLException);
            return null;
        }
    }

    public Vector GetICForIO(String string) {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Statement statement = m_dbConn.createStatement();
            String string2 = m_dbConsts.getIcQuery3() + string + m_dbConsts.getInactive();
            this.trace(3, "SiebelDBTransaction::GetICForIO", "Executing SQL Query : " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.add(resultSet.getString("Name"));
            }
            statement.close();
            return vector;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetICForIO", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetICForIO", "Details : " + sQLException);
            return null;
        }
    }

    public Vector GetICFieldsFromIC(Vector vector, String string) {
        try {
            if (vector == null || vector.size() == 0 || string == null || string.equals("")) {
                return null;
            }
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            Vector<String> vector2 = new Vector<String>();
            for (int i = 0; i < vector.size(); ++i) {
                Statement statement = m_dbConn.createStatement();
                String string2 = m_dbConsts.getIcQuery2() + vector.get(i) + "' and int_obj_id = '" + string + m_dbConsts.getDelimiter();
                this.trace(3, "SiebelDBTransaction::GetICFieldsFromIC", "Executing SQL Query : " + string2);
                ResultSet resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    String string3 = resultSet.getString("row_id");
                    String string4 = resultSet.getString("name");
                    Statement statement2 = m_dbConn.createStatement();
                    String string5 = m_dbConsts.getIcFieldQuery2() + string3 + m_dbConsts.getInactive();
                    this.trace(3, "SiebelDBTransaction::GetICFieldsFromIC", "Executing SQL Query : " + string5);
                    ResultSet resultSet2 = statement2.executeQuery(string5);
                    while (resultSet2.next()) {
                        String string6 = resultSet2.getString("name");
                        String string7 = "[" + string4 + "]" + string6;
                        vector2.add(string7);
                    }
                    statement2.close();
                }
                statement.close();
            }
            return vector2;
        }
        catch (SQLException sQLException) {
            this.trace(1, "SiebelDBTransaction::GetICFieldsFromIC", "Exception occured while executing query.");
            this.trace(1, "SiebelDBTransaction::GetICFieldsFromIC", "Details : " + sQLException);
            return null;
        }
    }

    public void setDbConsts(DBProperties dBProperties) {
        m_dbConsts = dBProperties;
    }

    public DBProperties getDbConsts() {
        return m_dbConsts;
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }

    public Vector getAllBaseIntegrationObjects() {
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            String string = m_dbConsts.getBaseIOQuery();
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string);
            this.trace(3, "XSDCreator:getAllBaseIntegrationObjects", "Executing SQL Query : " + string);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.add(resultSet.getString("Name"));
            }
            preparedStatement.close();
            this.trace(3, "XSDCreator:getAllBaseIntegrationObjects", "SQL Query executed.");
            return vector;
        }
        catch (SQLException sQLException) {
            String string = "Error occured while querying Base IO. \n";
            String string2 = string + "Details : " + sQLException.getMessage();
            this.trace(1, "XSDCreator:getAllBaseIntegrationObjects", string2);
            return null;
        }
    }

    public String getBaseIOForView(String string) {
        try {
            Vector vector;
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            if ((vector = this.getAllBaseIntegrationObjects()) == null || vector.size() == 0) {
                this.trace(1, "XSDCreator:getBaseIOForView", "There are no base Integration object configured in the repository.");
                return null;
            }
            String string2 = m_dbConsts.getBusobjQuery() + string + "'";
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string2);
            this.trace(3, "XSDCreator:getBaseIOForView", "Executing SQL Query : " + string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString("BUSOBJ_NAME");
            }
            preparedStatement.close();
            if (string3 == null || string3.equals("")) {
                return null;
            }
            String string4 = null;
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i).equals("Base " + string3)) {
                    string4 = vector.get(i).toString();
                    break;
                }
                if (!vector.get(i).equals(string3)) continue;
                string4 = vector.get(i).toString();
                break;
            }
            this.trace(3, "XSDCreator:getBaseIOForView", "SQL Query executed.");
            return string4;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getBaseIOForView", "Business object query failed.");
            this.trace(0, "XSDCreator:getBaseIOForView", "Details : " + sQLException);
            return null;
        }
    }

    public String getBaseIOForBO(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Vector vector = this.getAllBaseIntegrationObjects();
        if (vector == null || vector.size() == 0) {
            this.trace(1, "XSDCreator:getBaseIOForBO", "There are no base Integration object configured in the repository.");
            return null;
        }
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).equals(string)) continue;
            string2 = vector.get(i).toString();
        }
        this.trace(3, "XSDCreator:getBaseIOForBO", "SQL Query executed.");
        return string2;
    }

    public String getBCForApplet(String string) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getBCForApplet", "Invalid applet name specified.");
            return null;
        }
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            String string2 = m_dbConsts.getBusCompQuery() + string + "'";
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string2);
            this.trace(3, "XSDCreator:getBCForApplet", "Executing SQL Query : " + string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString("BUSCOMP_NAME");
            }
            preparedStatement.close();
            if (string3 == null || string3.equals("")) {
                return null;
            }
            this.trace(3, "XSDCreator:getBCForApplet", "SQL Query executed.");
            return string3;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getBCForApplet", "Business component query for applet failed.");
            this.trace(0, "XSDCreator:getBCForApplet", "Details : " + sQLException);
            return null;
        }
    }

    public XSDComponent getICForApplet(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getICForApplet", "There are no base Integration objects configured.");
            return null;
        }
        if (string2 == null || string2.trim().equals("")) {
            this.trace(1, "XSDCreator:getICForApplet", "Applet name is empty.");
            return null;
        }
        try {
            String string3;
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            if ((string3 = this.getRowIdForIOName(string)) == null || string3.trim().equals("")) {
                this.trace(1, "XSDCreator:getICForApplet", "Row ID is null for selected base IO.");
                return null;
            }
            Statement statement = m_dbConn.createStatement();
            String string4 = m_dbConsts.getIcQuery() + string3 + m_dbConsts.getInactiveSeq();
            this.trace(3, "XSDCreator:getICForApplet", "Executing SQL Query : " + string4);
            ResultSet resultSet = statement.executeQuery(string4);
            XSDComponent xSDComponent = null;
            while (resultSet.next()) {
                String string5 = resultSet.getString("EXT_NAME");
                String string6 = this.getBCForApplet(string2);
                if (string6 == null || string6.trim().equals("")) {
                    this.trace(1, "XSDCreator:getICForApplet", "There is no business component for the selected applet.");
                    return null;
                }
                if (!string6.equals(string5)) continue;
                String string7 = resultSet.getString("row_id");
                xSDComponent = new XSDComponent();
                xSDComponent.setXcName(string5);
                xSDComponent.setRowId(string7);
                xSDComponent.setXmlTag(resultSet.getString("xml_tag"));
                xSDComponent.setParentXCName(resultSet.getString("par_int_comp"));
                xSDComponent.setCardinality(resultSet.getString("cardinality_cd"));
                xSDComponent.setXcExternalName(string5);
                Statement statement2 = m_dbConn.createStatement();
                String string8 = m_dbConsts.getIcFieldQuery() + string7 + m_dbConsts.getInactive();
                ResultSet resultSet2 = statement2.executeQuery(string8);
                while (resultSet2.next()) {
                    String string9 = resultSet2.getString("Name");
                    XSDCompField xSDCompField = new XSDCompField();
                    xSDCompField.setFieldName(string9);
                    String string10 = resultSet2.getString("row_id");
                    xSDCompField.setRowId(string10);
                    xSDCompField.setDataType(resultSet2.getString("phys_data_type"));
                    xSDCompField.setXmlStyle(resultSet2.getString("xml_style"));
                    xSDCompField.setXmlTag(resultSet2.getString("xml_tag"));
                    xSDCompField.setExtName(resultSet2.getString("EXT_NAME"));
                    xSDComponent.addXCField(xSDCompField);
                }
                statement2.close();
                break;
            }
            statement.close();
            return xSDComponent;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getICForApplet", "Business component query for applet failed.");
            this.trace(0, "XSDCreator:getICForApplet", "Details : " + sQLException);
            return null;
        }
    }

    public String getAppletRowID(String string) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getAppletRowID", "Invalid applet name specified.");
            return null;
        }
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            String string2 = m_dbConsts.getBusCompQuery() + string + "'";
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string2);
            this.trace(3, "XSDCreator:getAppletRowID", "Executing SQL Query : " + string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString("ROW_ID");
            }
            preparedStatement.close();
            this.trace(3, "XSDCreator:getAppletRowID", "SQL Query executed.");
            return string3;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getAppletRowID", "Applet row id query failed.");
            this.trace(0, "XSDCreator:getAppletRowID", "Details : " + sQLException);
            return null;
        }
    }

    public Vector<XSDAppletField> getFieldsForListApplet(String string, String string2, Vector vector) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getFieldsForApplet", "Invalid base IO name specified.");
            return null;
        }
        if (string2 == null || string2.trim().equals("")) {
            this.trace(1, "XSDCreator:getFieldsForApplet", "Invalid applet name specified.");
            return null;
        }
        try {
            String string3;
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            if ((string3 = this.getAppletRowID(string2)) == null || string3.trim().equals("")) {
                this.trace(1, "XSDCreator:getFieldsForApplet", "Row ID is null for selected applet.");
                return null;
            }
            String string4 = m_dbConsts.getSelectedICFileds(string3, vector);
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string4);
            this.trace(3, "XSDCreator:getFieldsForApplet", "Executing SQL Query : " + string4);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<XSDAppletField> vector2 = new Vector<XSDAppletField>();
            while (resultSet.next()) {
                XSDComponent xSDComponent;
                XSDAppletField xSDAppletField = new XSDAppletField();
                xSDAppletField.setColumnName(resultSet.getString("NAME"));
                xSDAppletField.setFieldName(resultSet.getString("FIELD_NAME"));
                XSDComponent xSDComponent2 = this.getICForApplet(string, string2);
                if (xSDComponent2 != null) {
                    xSDAppletField.setICName(xSDComponent2.getXcName());
                }
                xSDAppletField.setPickAppletName(resultSet.getString("PICK_APPLET_NAME"));
                xSDAppletField.setRowID(resultSet.getString("ROW_ID"));
                String string5 = resultSet.getString("MVG_APPLET_NAME");
                xSDAppletField.setMvgApplet(string5);
                if (string5 != null && !string5.equals("") && (xSDComponent = this.getICForApplet(string, xSDAppletField.getMvgApplet())) != null) {
                    xSDAppletField.setMvgIC(xSDComponent.getXcName());
                }
                vector2.add(xSDAppletField);
            }
            preparedStatement.close();
            this.trace(3, "XSDCreator:getFieldsForApplet", "SQL Query executed.");
            return vector2;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getFieldsForApplet", "Applet field query failed.");
            this.trace(0, "XSDCreator:getFieldsForApplet", "Details : " + sQLException);
            return null;
        }
    }

    public Vector<XSDAppletField> getFieldsForFormApplet(String string, String string2, Vector vector) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getFieldsForApplet", "Invalid base IO name specified.");
            return null;
        }
        if (string2 == null || string2.trim().equals("")) {
            this.trace(1, "XSDCreator:getFieldsForApplet", "Invalid applet name specified.");
            return null;
        }
        try {
            String string3;
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            if ((string3 = this.getAppletRowID(string2)) == null || string3.trim().equals("")) {
                this.trace(1, "XSDCreator:getFieldsForApplet", "Row ID is null for selected applet.");
                return null;
            }
            String string4 = m_dbConsts.getFormAppletSelectedICFileds(string3, vector);
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string4);
            this.trace(3, "XSDCreator:getFieldsForApplet", "Executing SQL Query : " + string4);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<XSDAppletField> vector2 = new Vector<XSDAppletField>();
            while (resultSet.next()) {
                XSDComponent xSDComponent;
                XSDAppletField xSDAppletField = new XSDAppletField();
                xSDAppletField.setColumnName(resultSet.getString("NAME"));
                xSDAppletField.setFieldName(resultSet.getString("FIELD_NAME"));
                XSDComponent xSDComponent2 = this.getICForApplet(string, string2);
                if (xSDComponent2 != null) {
                    xSDAppletField.setICName(xSDComponent2.getXcName());
                }
                xSDAppletField.setPickAppletName(resultSet.getString("PICK_APPLET_NAME"));
                xSDAppletField.setRowID(resultSet.getString("ROW_ID"));
                String string5 = resultSet.getString("MVG_APPLET_NAME");
                xSDAppletField.setMvgApplet(string5);
                if (string5 != null && !string5.equals("") && (xSDComponent = this.getICForApplet(string, xSDAppletField.getMvgApplet())) != null) {
                    xSDAppletField.setMvgIC(xSDComponent.getXcName());
                }
                vector2.add(xSDAppletField);
            }
            preparedStatement.close();
            this.trace(3, "XSDCreator:getFieldsForApplet", "SQL Query executed.");
            return vector2;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getFieldsForApplet", "Applet field query failed.");
            this.trace(0, "XSDCreator:getFieldsForApplet", "Details : " + sQLException);
            return null;
        }
    }

    public Vector<XSDAppletField> getICFieldsForAppletFields(String string, String string2, Vector vector, int n) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getICFieldsForAppletFields", "View name is empty.");
            return null;
        }
        if (string2 == null || string2.trim().equals("")) {
            this.trace(1, "XSDCreator:getICFieldsForAppletFields", "Applet name is empty.");
            return null;
        }
        if (vector == null || vector.size() == 0) {
            this.trace(1, "XSDCreator:getICFieldsForAppletFields", "selected fields are empty.");
            return null;
        }
        try {
            String string3;
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            if ((string3 = this.getBaseIOForView(string)) == null || string3.trim().equals("")) {
                this.trace(1, "XSDCreator:getICFieldsForAppletFields", "No base IO is configured for view :" + string);
                return null;
            }
            String string4 = this.getAppletRowID(string2);
            if (string4 == null || string4.trim().equals("")) {
                this.trace(1, "XSDCreator:getICFieldsForAppletFields", "Row ID is null for selected applet.");
                return null;
            }
            Vector<XSDAppletField> vector2 = null;
            switch (n) {
                case 0: {
                    this.trace(3, "XSDCreator:getICFieldsForAppletFields", "Selected applet is a List applet.");
                    vector2 = this.getFieldsForListApplet(string3, string2, vector);
                    break;
                }
                case 1: {
                    this.trace(3, "XSDCreator:getICFieldsForAppletFields", "Selected applet is a form applet.");
                    vector2 = this.getFieldsForFormApplet(string3, string2, vector);
                    break;
                }
                default: {
                    this.trace(1, "XSDCreator:getICFieldsForAppletFields", "Specified applet is neither list applet nor form applet.");
                    return null;
                }
            }
            if (vector2 == null || vector2.size() == 0) {
                this.trace(1, "XSDCreator:getICFieldsForAppletFields", "No fields for applet :" + string2);
                return null;
            }
            String string5 = this.getRowIdForIOName(string3);
            Vector<XSDComponent> vector3 = this.BuildXSDComponent(string5);
            if (vector3 == null || vector3.size() == 0) {
                this.trace(1, "XSDCreator:getICFieldsForAppletFields", "No IC is configured for applet :" + string2);
                return null;
            }
            Vector<XSDAppletField> vector4 = new Vector<XSDAppletField>();
            boolean bl = false;
            for (int i = 0; i < vector3.size(); ++i) {
                XSDComponent xSDComponent = vector3.get(i);
                Vector<XSDCompField> vector5 = xSDComponent.getXcFields();
                for (int j = 0; j < vector2.size(); ++j) {
                    if (!xSDComponent.getXcExternalName().equals(vector2.get(j).getICName()) && !xSDComponent.getXcExternalName().equals(vector2.get(j).getMvgIC())) continue;
                    for (int k = 0; k < vector5.size(); ++k) {
                        if (!vector2.get(j).getFieldName().equals(vector5.get(k).getExtName())) continue;
                        vector2.get(j).setXmlTag(vector5.get(k).getXmlTag());
                        vector4.add(vector2.get(j));
                        if (vector4.size() != vector2.size()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
                if (bl) break;
            }
            return vector4;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getICFieldsForAppletFields", "Business component query for applet failed.");
            this.trace(0, "XSDCreator:getICFieldsForAppletFields", "Details : " + sQLException);
            return null;
        }
    }

    private String getAppletWebTmpl(String string) {
        if (string == null || string.trim().equals("")) {
            this.trace(1, "XSDCreator:getAppletWebTmpl", "Row ID is null for selected applet.");
            return null;
        }
        try {
            if (m_dbConn == null) {
                SiebelDBTransaction.CreateDbConnection();
            }
            String string2 = m_dbConsts.getWebTmpl() + string + "'";
            PreparedStatement preparedStatement = m_dbConn.prepareStatement(string2);
            this.trace(3, "XSDCreator:getAppletWebTmpl", "Executing SQL Query : " + string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString("WEB_TEMPLATE");
            }
            preparedStatement.close();
            this.trace(3, "XSDCreator:getAppletWebTmpl", "SQL Query executed.");
            return string3;
        }
        catch (SQLException sQLException) {
            this.trace(0, "XSDCreator:getAppletWebTmpl", "Applet field query failed.");
            this.trace(0, "XSDCreator:getAppletWebTmpl", "Details : " + sQLException);
            return null;
        }
    }
}

