/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.xsdcreator;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.common.XSDCompField;
import com.siebel.integration.common.XSDCompKey;
import com.siebel.integration.common.XSDComponent;
import com.siebel.integration.common.XSDObject;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class XSDCreator {
    private String m_xsdSchema = "";
    private String m_appendUserKeys = "";
    private boolean m_addedXOUserProp = false;
    private boolean m_addedFieldUserProp = false;
    private String m_parentXCXMLTag = "";
    private Hashtable<String, XSDComponent> m_components = new Hashtable();

    public void createXSD(String string, XSDObject xSDObject) {
        try {
            this.trace(3, "XSDCreator.createXSD", "Creating XSD");
            this.m_xsdSchema = this.m_xsdSchema + this.addXSDHeader(xSDObject);
            this.trace(3, "XSDCreator.createXSD", "Added header. Adding envelope");
            this.m_xsdSchema = this.m_xsdSchema + this.addXSDEnvelope(xSDObject);
            this.trace(3, "XSDCreator.createXSD", "Adding all the XSD components.");
            if (xSDObject.getXsdComponents() != null) {
                this.m_xsdSchema = this.m_xsdSchema + this.addXSDComponents(xSDObject.getXsdComponents());
            } else {
                this.trace(2, "XSDCreator.createXSD", "There are no XSD components to be added");
            }
            this.m_xsdSchema = this.m_xsdSchema + this.m_appendUserKeys;
            this.trace(3, "XSDCreator.createXSD", "Appending the user keys");
            if (this.m_addedXOUserProp) {
                this.m_xsdSchema = this.m_xsdSchema + "<xsd:complexType name=\"UserProperty\"\r\n><xsd:simpleContent\r\n><xsd:extension base=\"xsd:string\"\r\n/></xsd:simpleContent\r\n></xsd:complexType\r\n>";
            }
            if (this.m_addedFieldUserProp) {
                this.m_xsdSchema = this.m_xsdSchema + "<xsd:complexType name=\"FieldUserProperty\"\r\n><xsd:simpleContent\r\n><xsd:extension base=\"xsd:string\"\r\n/></xsd:simpleContent\r\n></xsd:complexType\r\n>";
            }
            this.m_xsdSchema = this.m_xsdSchema + "</xsd:schema>";
            this.trace(3, "XSDCreator.createXSD", "Completed creating XSD. Now writing to the file");
            this.writeSchemaToFile(string, this.m_xsdSchema);
            this.trace(3, "XSDCreator.createXSD", "Validating the created XSD");
            this.validateSchema(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String addXSDHeader(XSDObject xSDObject) {
        String string = "";
        string = string + "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n";
        string = string + "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ";
        string = string + "targetNamespace=\"http://www.siebel.com/xml/" + xSDObject.getBaseXOName() + "\" ";
        string = string + "xmlns:xsdLocal=\"http://www.siebel.com/xml/" + xSDObject.getBaseXOName() + "\" ";
        string = string + "attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" ";
        if (xSDObject.getMinorVersion() != null && !xSDObject.getMinorVersion().equals("")) {
            string = string + "xsdLocal:minorVersion=\"" + xSDObject.getMinorVersion() + "\" ";
        }
        if (xSDObject.getMajorVersion() != null && !xSDObject.getMajorVersion().equals("")) {
            string = string + "xsdLocal:majorVersion=\"" + xSDObject.getMajorVersion() + "\" ";
        }
        if (xSDObject.getBaseXOName() != null && !xSDObject.getBaseXOName().equals("")) {
            string = string + "xsdLocal:baseIntegrationObject=\"" + xSDObject.getBaseXOName() + "\">" + "\r\n";
        }
        string = string + "<xsd:annotation>\r\n";
        string = string + "<xsd:documentation>\r\n";
        string = string + "Copyright \u00a9 2009, Oracle. All rights reserved. Siebel XSD Generation\r\n";
        string = string + "</xsd:documentation>\r\n";
        string = string + "</xsd:annotation>";
        return string;
    }

    private String addXSDEnvelope(XSDObject xSDObject) {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        string = string + "<xsd:element name=\"SiebelMessage\" type=\"xsdLocal:SiebelMessage\" />\r\n";
        string = string + "<xsd:complexType name=\"SiebelMessage\">\r\n";
        string = string + "<xsd:sequence>\r\n";
        string2 = xSDObject.getXsdComponents().get(0).getXmlTag();
        string3 = this.getMaxOccurs(xSDObject.getXsdComponents().get(0));
        if (string2.toLowerCase().startsWith("listof")) {
            string2 = string2.substring(6);
        }
        if (string2 != null && !string2.equals("")) {
            string = string + "<xsd:element name=\"" + string2 + "\" type=\"xsdLocal:" + string2 + "\" minOccurs=\"" + n + "\" maxOccurs=\"" + string3 + "\" />" + "\r\n";
        }
        string = string + this.addXOUserProps(xSDObject);
        string = string + "</xsd:sequence>\r\n";
        string = string + "</xsd:complexType>\r\n";
        return string;
    }

    private String addXSDComponents(Vector<XSDComponent> vector) throws Exception {
        String string = "";
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            XSDComponent xSDComponent = vector.get(i);
            if (xSDComponent.getXmlTag() == null || xSDComponent.getXmlTag().equals("")) continue;
            string = string + this.getComplexTypeBeginTag() + "name=\"" + xSDComponent.getXmlTag() + "\">" + "\r\n";
            string = string + this.getSequenceBeginTag() + "\r\n";
            string = string + this.addElementFields(xSDComponent);
            string = string + this.addChildren(xSDComponent.getChildrenXsdComponents());
            string2 = this.addUserKeys(xSDComponent);
            if (string2.equals("")) {
                this.trace(0, "XSDCreator.createXSD", "There is no user key configured for the Integration Component : '" + xSDComponent.getXcName() + "'. Atleast one user key must be configued.");
                throw new Exception("There is no user key configured for the Integration Component : '" + xSDComponent.getXcName() + "'. Atleast one user key must be configued.");
            }
            string = string + string2;
            string = string + this.addXCUserProps(xSDComponent);
            string = string + this.getSequenceEndTag() + "\r\n";
            string = string + this.addAttributeFields(xSDComponent);
            string = string + this.getComplexTypeEndTag() + "\r\n";
            if (xSDComponent.getChildrenXsdComponents() == null) continue;
            string = string + this.addXSDComponents(xSDComponent.getChildrenXsdComponents());
        }
        return string;
    }

    private String addElementFields(XSDComponent xSDComponent) {
        String string = "";
        Vector<XSDCompField> vector = xSDComponent.getXcFields();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                XSDCompField xSDCompField = vector.get(i);
                if (!xSDCompField.getXmlStyle().equals("Element") || xSDCompField.getXmlTag() == null || xSDCompField.getXmlTag().equals("")) continue;
                string = string + "<xsd:element name=\"" + xSDCompField.getXmlTag() + "\" type=\"" + this.getXSDCompFieldType(xSDCompField.getDataType()) + "\" minOccurs=\"" + this.getMinOccurs(xSDCompField) + "\" maxOccurs=\"1\"" + "/>" + "\r\n";
                string = string + this.addFieldUserProps(xSDCompField);
            }
        }
        return string;
    }

    private String addChildren(Vector<XSDComponent> vector) {
        String string = "";
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                XSDComponent xSDComponent = vector.get(i);
                if (xSDComponent.getXmlTag() == null || xSDComponent.getXmlTag().equals("")) continue;
                string = string + "<xsd:element name=\"" + xSDComponent.getXmlTag() + "\" type=\"xsdLocal:" + xSDComponent.getXmlTag() + "\" minOccurs=\"" + this.getMinOccurs(xSDComponent) + "\" maxOccurs=\"" + this.getMaxOccurs(xSDComponent) + "\"" + "/>" + "\r\n";
            }
        }
        return string;
    }

    private String addUserKeys(XSDComponent xSDComponent) throws Exception {
        this.trace(3, "XSDCreator.addUserKeys", "Adding user keys...");
        String string = "";
        Vector<XSDCompKey> vector = xSDComponent.getXcKeys();
        int n = 0;
        if (xSDComponent.getXmlTag() != null && !xSDComponent.getXmlTag().equals("") && vector != null) {
            n = this.genInitSeqNum(vector);
            for (int i = 0; i < vector.size(); ++i) {
                XSDCompKey xSDCompKey = vector.get(i);
                String string2 = this.beautifyName(xSDCompKey.getKeyName(), false);
                if (xSDCompKey.getKeySequence() == null) {
                    xSDCompKey.setKeySequence("" + n++);
                }
                String string3 = this.beautifyName(xSDComponent.getXcName() + xSDCompKey.getKeyType() + xSDCompKey.getKeySequence(), false);
                if (string2 == null || string2.equals("") || string3 == null || string3.equals("") || !this.verifyKeyFields(xSDComponent, xSDCompKey)) continue;
                string = string + "<xsd:element name=\"" + string2 + "\" type=\"xsdLocal:" + string3 + "\" minOccurs=\"0\" maxOccurs=\"1\"" + "/>" + "\r\n";
                this.appendKeys(xSDComponent, string3, xSDCompKey);
            }
        }
        return string;
    }

    private int genInitSeqNum(Vector<XSDCompKey> vector) {
        int n = 0;
        XSDCompKey xSDCompKey = null;
        try {
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                xSDCompKey = vector.get(i);
                String string = xSDCompKey.getKeySequence();
                if (string == null || (n2 = Integer.parseInt(string)) <= n) continue;
                n = n2 + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.trace(0, "XSDCreator:genInitSeqNum ", numberFormatException.getMessage());
            throw new IllegalArgumentException(CSSMsgMgr.get(8716826, xSDCompKey.getKeyName()));
        }
        return n;
    }

    private boolean verifyKeyFields(XSDComponent xSDComponent, XSDCompKey xSDCompKey) {
        Vector<String> vector = xSDComponent.getFieldNames();
        Vector<XSDCompField> vector2 = xSDCompKey.getKeyFields();
        int n = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            if (!vector.contains(vector2.get(i).getFieldName())) continue;
            ++n;
        }
        return n == vector2.size();
    }

    private void appendKeys(XSDComponent xSDComponent, String string, XSDCompKey xSDCompKey) {
        this.m_appendUserKeys = this.m_appendUserKeys + this.getComplexTypeBeginTag() + "name=\"" + string + "\">" + "\r\n";
        this.m_appendUserKeys = this.m_appendUserKeys + this.getSequenceBeginTag() + "\r\n";
        Vector<XSDCompField> vector = xSDCompKey.getKeyFields();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                XSDCompField xSDCompField = vector.get(i);
                String[] stringArray = new String[2];
                stringArray = this.generateXMLTagForKeyField(xSDComponent, xSDCompField.getFieldName());
                if (stringArray == null) continue;
                this.m_appendUserKeys = this.m_appendUserKeys + "<xsd:element name=\"" + stringArray[0] + "\" type=\"" + stringArray[1] + "\" minOccurs=\"1\" maxOccurs=\"1\"" + "/>" + "\r\n";
            }
        } else {
            this.trace(2, "XSDCreator:appendKeys", "No Key Fields Selected");
        }
        this.m_appendUserKeys = this.m_appendUserKeys + this.getSequenceEndTag() + "\r\n";
        this.m_appendUserKeys = this.m_appendUserKeys + this.getComplexTypeEndTag() + "\r\n";
    }

    private String addAttributeFields(XSDComponent xSDComponent) {
        String string = "";
        Vector<XSDCompField> vector = xSDComponent.getXcFields();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                XSDCompField xSDCompField = vector.get(i);
                if (!xSDCompField.getXmlStyle().equals("Attribute")) continue;
                string = string + "<xsd:attribute name=\"" + xSDCompField.getXmlTag() + "\" type=\"" + this.getXSDCompFieldType(xSDCompField.getDataType()) + "\"/>" + "\r\n";
                string = string + this.addFieldUserProps(xSDCompField);
            }
        }
        return string;
    }

    private String addXCUserProps(XSDComponent xSDComponent) {
        String string = "";
        Properties properties = xSDComponent.getXcUserProps();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                string = string + "<xsd:element name=\"" + string2 + "\" type=\"xsdLocal:UserProperty\" minOccurs=\"1\" maxOccurs=\"1\" default=\"" + properties.getProperty(string2) + "\"/>" + "\r\n";
            }
        }
        return string;
    }

    private String addXOUserProps(XSDObject xSDObject) {
        String string = "";
        Properties properties = xSDObject.getXoUserProps();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                string = string + "<xsd:element name=\"" + this.beautifyName(string2, true) + "\" type=\"xsdLocal:UserProperty\" minOccurs=\"1\" maxOccurs=\"1\" default=\"" + properties.getProperty(string2) + "\"/>" + "\r\n";
                this.m_addedXOUserProp = true;
            }
        }
        return string;
    }

    private String addFieldUserProps(XSDCompField xSDCompField) {
        String string = "";
        Properties properties = xSDCompField.getFieldUserProps();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                string = string + "<xsd:element name=\"" + string2 + "\" type=\"xsdLocal:FieldUserProperty\" minOccurs=\"1\" maxOccurs=\"1\" default=\"" + properties.getProperty(string2) + "\"/>" + "\r\n";
                this.m_addedFieldUserProp = true;
            }
        }
        return string;
    }

    private void writeSchemaToFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes("UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException : " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException : " + iOException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception.getMessage());
        }
    }

    private void validateSchema(String string) {
        File file = new File(string);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(file);
            this.trace(3, "validateSchema", "Completed Validation. XSD Built Successfully");
        }
        catch (Exception exception) {
            System.out.println("Schema validation failed. Deleting the file. Please check log file for details");
            this.trace(1, "validateSchema", "Schema validation failed. Deleting the file");
            file.delete();
            this.trace(1, "validateSchema", exception.getMessage());
        }
    }

    private String getComplexTypeBeginTag() {
        return "<xsd:complexType ";
    }

    private String getComplexTypeEndTag() {
        return "</xsd:complexType>";
    }

    private String getSequenceBeginTag() {
        return "<xsd:sequence>";
    }

    private String getSequenceEndTag() {
        return "</xsd:sequence>";
    }

    private String getMaxOccurs(XSDComponent xSDComponent) {
        if (xSDComponent.getCardinality().contains("More")) {
            return "unbounded";
        }
        return "1";
    }

    private int getMinOccurs(XSDComponent xSDComponent) {
        if (xSDComponent.getCardinality().contains("Zero")) {
            return 0;
        }
        return 1;
    }

    private int getMinOccurs(XSDCompField xSDCompField) {
        if (xSDCompField.isRequired()) {
            return 1;
        }
        return 0;
    }

    private String getXSDCompFieldType(String string) {
        if (string != null) {
            if (string.equals("DTYPE_DATETIME") || string.equals("DTYPE_UTCDATETIME")) {
                return "xsd:dateTime";
            }
            if (string.equals("DATE") || string.equals("DTYPE_DATE")) {
                return "xsd:date";
            }
            if (string.equals("DTYPE_TIME")) {
                return "xsd:time";
            }
            if (string.equals("DTYPE_BOOL")) {
                return "xsd:boolean";
            }
            if (string.equals("DTYPE_INTEGER")) {
                return "xsd:integer";
            }
            if (string.equals("NUMBER") || string.equals("DTYPE_NUMBER") || string.equals("DTYPE_CURRENCY")) {
                return "xsd:decimal";
            }
            if (string.equals("DTYPE_ATTACHMENT")) {
                return "xsd:base64Binary";
            }
            return "xsd:string";
        }
        return null;
    }

    public XSDObject buildHierarchy(XSDObject xSDObject) {
        XSDComponent xSDComponent;
        int n;
        Vector<XSDComponent> vector = xSDObject.getXsdComponents();
        XSDComponent xSDComponent2 = null;
        if (vector == null) {
            this.trace(1, "XSDCreator:buildHierarchy ", "XSDObject does not contain XSDComponents");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716802));
        }
        for (n = 0; n < vector.size(); ++n) {
            xSDComponent = vector.get(n);
            this.validateXSDComponent(xSDComponent);
            this.m_components.put(xSDComponent.getXcName(), xSDComponent);
        }
        for (n = 0; n < vector.size(); ++n) {
            xSDComponent = vector.get(n);
            String string = xSDComponent.getParentXCName();
            if (string != null && !string.equals("")) {
                if (this.m_components.get(string) == null) {
                    this.trace(0, "XSDCreator:buildHierarchy ", "Parent XSDComponent not created for selected XSDComponent");
                    throw new IllegalArgumentException(CSSMsgMgr.get(8716803));
                }
                this.m_components.get(string).addChildXSDComponent(xSDComponent);
                continue;
            }
            if (xSDComponent2 == null) {
                xSDComponent2 = xSDComponent;
                continue;
            }
            this.trace(0, "XSDCreator:buildHierarchy", "Input XSDObject has multiple root XSDComponents");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716805));
        }
        xSDObject.setXsdComponents(null);
        xSDObject.addXSDComponent(xSDComponent2);
        return xSDObject;
    }

    private void validateXSDComponent(XSDComponent xSDComponent) {
        if (xSDComponent.getXcFields() == null) {
            this.trace(2, "XSDCreator:validateXSDComponent", "XSDComponent : \"" + xSDComponent.getXcName() + "\" does not contain fields");
        }
        if (xSDComponent.getXcKeys() == null) {
            this.trace(3, "XSDCreator:validateXSDComponent", "XSDComponent : \"" + xSDComponent.getXcName() + "\" does not contain keys");
        } else {
            Vector<XSDCompKey> vector = xSDComponent.getXcKeys();
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i).getKeyFields() != null) continue;
                this.trace(1, "XSDCreator:validateXSDComponent", "XSDComponent : \"" + xSDComponent.getXcName() + "\" contains a key without fields");
                throw new IllegalArgumentException(CSSMsgMgr.get(8716804, vector.get(i).getKeyName(), xSDComponent.getXcName()));
            }
        }
    }

    private String[] generateXMLTagForKeyField(XSDComponent xSDComponent, String string) {
        Vector<XSDCompField> vector = xSDComponent.getXcFields();
        String[] stringArray = new String[2];
        for (int i = 0; i < vector.size(); ++i) {
            XSDCompField xSDCompField = vector.get(i);
            if (!xSDCompField.getFieldName().equals(string)) continue;
            stringArray[0] = xSDCompField.getXmlTag();
            stringArray[1] = this.getXSDCompFieldType(xSDCompField.getDataType());
            return stringArray;
        }
        this.trace(1, "XSDCreator:generateXMLTagForKeyField", "Key field " + string + " does not exist in " + xSDComponent.getXcName());
        throw new IllegalArgumentException(CSSMsgMgr.get(8716827, string, xSDComponent.getXcName()));
    }

    private String beautifyName(String string, boolean bl) {
        String string2 = " ()[]{}+=!@#$%^&*\\\\/?<>,;:\\\"\\'`~|";
        char c = '_';
        String string3 = string;
        for (int i = 0; i < string2.length(); ++i) {
            string3 = string3.replace(string2.charAt(i), c);
        }
        if (!bl) {
            String[] stringArray = string3.split("_");
            string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + stringArray[i];
            }
        }
        return string3;
    }

    private void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }
}

