/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSUtilities;
import com.siebel.common.common.SiebelErrorMsg;
import com.siebel.common.crypt.CryptIntr;
import com.siebel.common.crypt.JCECrypt;
import com.siebel.common.crypt.RSACrypt;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.ConnectInfo;
import com.siebel.om.conmgr.ConnectionManager;
import com.siebel.om.conmgr.ConnectionPool;
import com.siebel.om.conmgr.HelloNAKException;
import com.siebel.om.conmgr.MaxTasksException;
import com.siebel.om.conmgr.PendingTxMap;
import com.siebel.om.conmgr.SISString;
import com.siebel.om.conmgr.SSLClient;
import com.siebel.om.conmgr.SSLConfig;
import com.siebel.om.conmgr.Transaction;
import com.siebel.om.sisnapi.ACK;
import com.siebel.om.sisnapi.HelloACK;
import com.siebel.om.sisnapi.HelloRequest;
import com.siebel.om.sisnapi.LogoffACK;
import com.siebel.om.sisnapi.LogonACK;
import com.siebel.om.sisnapi.NAK;
import com.siebel.om.sisnapi.NSReadKeyACK;
import com.siebel.om.sisnapi.OMRPCACK;
import com.siebel.om.sisnapi.Packet;
import com.siebel.om.sisnapi.Request;
import com.siebel.om.sisnapi.RequestException;
import com.siebel.om.sisnapi.SISNotify;
import com.siebel.om.sisnapi.SessCloseAck;
import com.siebel.om.sisnapi.SessHelloAck;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Connection
implements Runnable {
    public static final int TX_TIMEOUT_MS = 600000;
    static final int SEQ_MAX = Integer.MAX_VALUE;
    static final int WAIT_INTERVAL = 250;
    protected SISString m_sis;
    protected Thread m_listener;
    protected ConnectionPool m_pool;
    protected boolean m_shutdown = false;
    protected boolean m_close = false;
    protected Exception m_shutdownEx = null;
    protected PendingTxMap m_txMap = new PendingTxMap();
    protected Socket m_socket;
    protected int m_version = 131077;
    protected byte[] m_serverKey;
    protected int m_conId;
    protected int m_transCode;
    protected int m_nMuxSession;
    protected int m_nMuxConn;
    protected int m_nMinSvcProc;
    protected int m_msgType = 0;
    protected int m_trailerOffset = 0;
    protected int m_trailerLen = 0;
    protected int m_txTimeout = 600000;
    protected CryptIntr m_crypt = null;
    protected volatile int m_sequence = 0;
    private static final byte[] m_postBuffer = new byte[]{80, 79, 83, 84, 32};
    private static final byte[] m_nSisMagicBuffer = new byte[]{-68, -106, 20, -25};

    public Connection(SISString sISString) throws IOException, CSSException, RequestException, ConMgrException, HelloNAKException, MaxTasksException {
        this(sISString, 600000);
    }

    public Connection(SISString sISString, int n) throws IOException, CSSException, RequestException, ConMgrException, HelloNAKException, MaxTasksException {
        this.m_sis = sISString;
        this.setTxTimeout(n);
        this.init();
    }

    public int getConId() {
        return this.m_conId;
    }

    public SISString getSISString() {
        return this.m_sis;
    }

    public boolean isShuttingDown() {
        return this.m_shutdown;
    }

    public int getMuxSession() {
        return this.m_nMuxSession;
    }

    public int getTransCode() {
        return this.m_transCode;
    }

    public int getMuxConn() {
        return this.m_nMuxConn;
    }

    public int getMinSvcProc() {
        return this.m_nMinSvcProc;
    }

    public PendingTxMap getTxMap() {
        return this.m_txMap;
    }

    public int getTxTimeout() {
        return this.m_txTimeout;
    }

    public void setTxTimeout(int n) {
        if (n > 0) {
            this.m_txTimeout = n;
        }
    }

    public void shutdownOutput() {
        if (this.m_shutdown) {
            return;
        }
        this.m_shutdown = true;
        if (this.m_pool != null) {
            this.m_pool.fail(this);
        }
        try {
            if (this.m_socket != null && !this.m_sis.isSSL()) {
                this.m_socket.shutdownOutput();
            }
        }
        catch (IOException iOException) {
            this.m_txMap.abandonAll();
        }
        if (this.m_txMap.isEmpty()) {
            this.requestClose();
        }
    }

    public void requestClose() {
        if (!this.m_shutdown) {
            this.shutdownOutput();
        }
        if (!this.m_txMap.isEmpty()) {
            this.m_txMap.abandonAll();
        }
        boolean bl = this.m_close;
        this.m_close = true;
        if (!bl && this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_shutdownEx == null) {
            this.m_shutdownEx = new ConMgrException(8716606, Integer.toHexString(this.getConId()));
        }
    }

    public ACK send(Transaction transaction) throws ConMgrException, CSSException, HelloNAKException, MaxTasksException {
        if (this.m_shutdown) {
            throw new ConMgrException(8716600, this.m_shutdownEx);
        }
        return this.send(transaction, 0, false);
    }

    public void setPool(ConnectionPool connectionPool) {
        this.m_pool = connectionPool;
    }

    protected void init() throws IOException, RequestException, CSSException, ConMgrException, HelloNAKException, MaxTasksException {
        Transaction transaction = new Transaction();
        byte[] byArray = null;
        if (this.m_sis.getEncryption() == 2 || this.m_sis.getEncryption() == 4) {
            if (this.m_crypt == null) {
                this.m_crypt = ConnectionManager.isJCE() ? new JCECrypt() : new RSACrypt();
                this.m_crypt.init();
            }
            byArray = this.m_crypt.getPublicKey();
        }
        HelloRequest helloRequest = new HelloRequest(131077, 8, this.m_sis.getEncryption(), this.m_sis.getCompression(), byArray);
        transaction.setRequest(helloRequest);
        this.m_listener = new Thread(ConnectionManager.getThreadGroup(), this);
        this.m_listener.setDaemon(true);
        this.open();
        Request request = transaction.getRequest();
        request.setSequence(this.getSequence());
        request.setTransCode(this.getTransCode());
        request.startRequest();
        this.writePacket(request, 1, true);
        if (this.m_pool != null) {
            this.m_pool.setFree(this);
        }
        helloRequest = null;
        request = null;
        HelloACK helloACK = (HelloACK)this.readPacket(this.m_socket.getInputStream());
        this.m_conId = helloACK.getSessionId();
        this.m_serverKey = helloACK.getServerKey();
        this.m_transCode = helloACK.getTransCode();
        this.m_nMuxSession = helloACK.getMuxSession();
        this.m_nMuxConn = helloACK.getMuxConn();
        this.m_nMinSvcProc = helloACK.getMinSvcProc();
        if (this.m_crypt != null) {
            this.m_crypt.importSessionKey(this.m_serverKey);
        }
        ConnectInfo connectInfo = this.m_sis.getConnectInfo();
        if (this.m_sis.isSSL()) {
            SSLClient sSLClient = new SSLClient();
            SSLConfig sSLConfig = SSLConfig.GetInstance();
            if (1 == sSLClient.open(this.m_socket, connectInfo.getHost(), connectInfo.getPort())) {
                this.m_socket = sSLClient.getSSLSocket();
            } else {
                this.m_socket.close();
                String[] stringArray = new String[]{connectInfo.getHost(), String.valueOf(connectInfo.getPort())};
                throw new RequestException(8716691, stringArray);
            }
        }
        this.m_listener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            Transaction transaction = null;
            Packet packet = null;
            Object var3_3 = null;
            InputStream inputStream = null;
            try {
                if (this.m_socket == null) {
                    throw new IOException(CSSMsgMgr.get(8716699));
                }
                inputStream = this.m_socket.getInputStream();
                while (!this.m_shutdown || !this.m_txMap.isEmpty()) {
                    packet = this.readPacket(inputStream);
                    transaction = this.m_txMap.removeTransaction(packet.getSequence());
                    if (transaction != null) {
                        Transaction transaction2 = transaction;
                        synchronized (transaction2) {
                            if (SiebelTrace.getInstance().getLogLevel() >= 3) {
                                transaction.setStopTimeFast(System.currentTimeMillis());
                            }
                            transaction.setResponseFast(packet);
                            continue;
                        }
                    }
                    System.err.println("[CMGR WARNING] Homeless packet: #" + packet.getSequence() + " " + packet + " connection:" + Integer.toHexString(this.getConId()));
                }
            }
            catch (Exception exception) {
                this.m_shutdownEx = exception;
                boolean bl = this.m_shutdown;
                this.requestClose();
                if (bl) break block9;
                exception.printStackTrace();
                System.err.println("[CMGR FATAL] Error: " + exception + " connection:" + Integer.toHexString(this.getConId()));
            }
        }
    }

    public String getQualifiedHostName() {
        return this.m_socket.getInetAddress().getHostName();
    }

    protected void open() throws IOException, RequestException, CSSException {
        ConnectInfo connectInfo = this.m_sis.getConnectInfo();
        try {
            this.m_socket = new Socket(connectInfo.getHost(), connectInfo.getPort());
            this.m_socket.setTcpNoDelay(true);
            if (this.m_socket.getReceiveBufferSize() < 16384) {
                this.m_socket.setReceiveBufferSize(16384);
                this.m_socket.setSendBufferSize(16384);
            }
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("creating socket for listening thread: host=");
            stringBuffer.append(connectInfo.getHost());
            stringBuffer.append(" port=");
            stringBuffer.append(connectInfo.getPort());
            SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
        }
        catch (ConnectException connectException) {
            String[] stringArray = new String[]{connectInfo.getHost(), String.valueOf(connectInfo.getPort())};
            throw new RequestException(8716691, stringArray);
        }
    }

    protected static int writeInt(byte[] byArray, int n, int n2) {
        byArray[n2++] = (byte)(n >> 24);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)n;
        return n2;
    }

    protected static int justReadInt(byte[] byArray, int n) {
        byte by = byArray[n++];
        int n2 = byArray[n++];
        int n3 = byArray[n++];
        int n4 = byArray[n++];
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        return by << 24 | n2 << 16 | n3 << 8 | n4;
    }

    protected void writePacket(Packet packet, int n, boolean bl) throws CSSException, IOException {
        int n2;
        int n3;
        byte[] byArray;
        Object[] objectArray;
        if (this.m_socket == null) {
            this.requestClose();
            throw new IOException(CSSMsgMgr.get(8716700));
        }
        int n4 = this.m_sis.getCompression() == 0 || (n & 2) != 0 ? 0 : (packet.getLength() >= 100 && !bl ? 16 : 0);
        int n5 = packet.getLength();
        if (n5 < 49) {
            throw new CSSException(8716689);
        }
        if (n4 == 16) {
            objectArray = new int[1];
            byArray = Connection.zlibDeflate(packet.getPacketData(), packet.getStartingOfst() + 48, packet.getLength() - 48, 48, objectArray);
            System.arraycopy(packet.getPacketData(), 0, byArray, 0, 48);
            n3 = objectArray[0];
            n5 = objectArray[0];
            n2 = 0;
        } else {
            n3 = packet.getLength();
            objectArray = this.m_sis.getTransportInfo(packet.getLength());
            if (bl && (objectArray == null || n4 != 0)) {
                throw new CSSException(8716602);
            }
            if (bl) {
                n3 += m_postBuffer.length + objectArray.length;
            }
            byArray = new byte[n3];
            n2 = 0;
            if (bl) {
                System.arraycopy(m_postBuffer, 0, byArray, n2, m_postBuffer.length);
                System.arraycopy(objectArray, 0, byArray, n2 += m_postBuffer.length, objectArray.length);
                n2 += objectArray.length;
            }
            System.arraycopy(packet.getPacketData(), packet.getStartingOfst(), byArray, n2, packet.getLength());
            n2 = bl ? m_postBuffer.length + objectArray.length : 0;
        }
        n2 = Connection.writeInt(byArray, n5 - 4, n2);
        int n6 = Connection.justReadInt(byArray, n2);
        n2 = n6 != -1 ? Connection.writeInt(byArray, n4, n2) : Connection.writeInt(byArray, n4, n2);
        int n7 = Connection.justReadInt(byArray, n2);
        n2 = n7 == 0 ? Connection.writeInt(byArray, this.m_version, n2) : (n2 += 4);
        n2 = Connection.writeInt(byArray, packet.getSequence(), n2);
        n2 = n6 != -1 ? Connection.writeInt(byArray, packet.getSessionId(), n2) : (n2 += 4);
        n2 = Connection.writeInt(byArray, packet.getMessageType(), n2);
        n2 = Connection.writeInt(byArray, n5 - 48, n2);
        n2 = Connection.writeInt(byArray, 0, n2);
        OutputStream outputStream = this.m_socket.getOutputStream();
        if (this.m_crypt == null || n == 1) {
            outputStream.write(byArray, 0, n3);
        } else {
            byte[] byArray2 = this.m_crypt.encrypt(byArray, 4, n3 - 4);
            Connection.writeInt(byArray, n3 - 4, 0);
            System.arraycopy(byArray2, 0, byArray, 4, n3 - 4);
            outputStream.write(byArray, 0, n3);
        }
        outputStream.flush();
    }

    protected Packet readPacket(InputStream inputStream) throws CSSException, IOException {
        int n;
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        for (n2 = 0; n2 < 4; n2 += n3) {
            n3 = inputStream.read(byArray, n2, 4 - n2);
            if (n3 >= 0) continue;
            throw new CSSException(8716601, String.valueOf(n2));
        }
        if (n2 != 4) {
            throw new CSSException(8716601, String.valueOf(n2));
        }
        int n4 = Connection.bytesToInt(byArray, 0);
        if (n4 < 48) {
            throw new CSSException(8716698);
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("about to read to bytes: len=");
        stringBuffer.append(n4);
        SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
        byArray = new byte[n4];
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; i += n2) {
            n2 = inputStream.read(byArray, i, n4 - i);
            ++n6;
            if (n2 < 1) {
                throw new IOException(CSSMsgMgr.get(8716699));
            }
            if (!bl && i + n2 >= 12) {
                n5 = Connection.bytesToInt(byArray, 8);
                bl = true;
            }
            stringBuffer = new StringBuffer(32);
            stringBuffer.append("read some bytes: tx=");
            stringBuffer.append(n5);
            stringBuffer.append(" len=");
            stringBuffer.append(n4);
            stringBuffer.append(" read=");
            stringBuffer.append(n2);
            stringBuffer.append(" left=");
            stringBuffer.append(n4 - i - n2);
            stringBuffer.append(" count=");
            stringBuffer.append(n6);
            SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
        }
        int n7 = 0;
        if (this.m_crypt != null) {
            byArray = this.m_crypt.decrypt(byArray, 0, byArray.length);
        }
        if (((n = Connection.bytesToInt(byArray, n7)) & 0x17) != 0 && (n & 0x10) == 0) {
            throw new CSSException(8716702);
        }
        Connection.bytesToInt(byArray, n7 += 4);
        int n8 = Connection.bytesToInt(byArray, n7 += 4);
        this.m_conId = Connection.bytesToInt(byArray, n7 += 4);
        this.m_msgType = Connection.bytesToInt(byArray, n7 += 4);
        this.m_trailerOffset = Connection.bytesToInt(byArray, n7 += 4);
        this.m_trailerLen = Connection.bytesToInt(byArray, n7 += 4);
        n7 += 4;
        n7 += 16;
        if ((n & 0x10) != 0) {
            int[] nArray = new int[1];
            byte[] byArray2 = Connection.zlibInflate(byArray, n7, n4 - n7, n7, nArray);
            System.arraycopy(byArray, 0, byArray2, 0, n7);
            byArray = byArray2;
            n4 = nArray[0];
            if (byArray == null) {
                throw new CSSException(8716698);
            }
        }
        int n9 = Connection.bytesToInt(byArray, n7);
        int n10 = Connection.bytesToInt(byArray, n7 + 0);
        int n11 = Connection.bytesToInt(byArray, n7 + 4);
        int n12 = Connection.bytesToInt(byArray, n7 + 8);
        n7 -= 36;
        switch (n9) {
            case 1: {
                throw new CSSException(8716696);
            }
            case 2: {
                if (n4 - n7 < 48) {
                    System.err.println("Connection.readPacket: ACK message ill formatted");
                    throw new CSSException(8716692);
                }
                int n13 = Connection.bytesToInt(byArray, n7 + 36 + 16);
                switch (n13) {
                    case 101: {
                        return new HelloACK(byArray, n7, n4 - n7);
                    }
                    case 102: {
                        return new LogonACK(byArray, n7, n4 - n7, this.m_transCode);
                    }
                    case 103: {
                        return new LogoffACK(byArray, n7, n4 - n7, this.m_transCode);
                    }
                    case 602: {
                        return new NSReadKeyACK(byArray, n7, n4 - n7, this.m_transCode);
                    }
                    case 401: {
                        return new OMRPCACK(byArray, n7, n4 - n7, this.m_transCode);
                    }
                    case 1101: {
                        return new SessHelloAck(byArray, n7, n4 - n7, this.m_transCode);
                    }
                    case 1102: {
                        return new SessCloseAck(byArray, n7, n4 - n7, this.m_transCode);
                    }
                }
                System.err.println("Connection.readPacket: unknown ACK code=" + n13 + " length=" + n4);
                throw new CSSException(8716692);
            }
            case 3: {
                if (this.m_transCode == 0) {
                    this.m_transCode = 3;
                }
                return new NAK(byArray, n7, n4 - n7, this.m_transCode);
            }
            case 5: {
                return new SISNotify(byArray, n7, n4 - n7, this.m_transCode);
            }
            case 4: {
                throw new CSSException(8716696);
            }
        }
        throw new CSSException(8716696);
    }

    protected static int bytesToInt(byte[] byArray, int n) {
        int n2;
        int n3;
        byte by = byArray[n + 0];
        int n4 = byArray[n + 1];
        if (n4 < 0) {
            n4 += 256;
        }
        if ((n3 = byArray[n + 2]) < 0) {
            n3 += 256;
        }
        if ((n2 = byArray[n + 3]) < 0) {
            n2 += 256;
        }
        int n5 = by << 24 | n4 << 16 | n3 << 8 | n2;
        return n5;
    }

    protected static final byte[] zlibInflate(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        try {
            int n4 = 512;
            int n5 = 0;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, n, n2);
            n5 = n3;
            do {
                byArray3 = byArray2;
                byArray2 = new byte[2 * n4];
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray2, 0, n5);
                    byArray3 = null;
                }
                n5 += inflater.inflate(byArray2, n5, (n4 *= 2) - n5);
            } while (!inflater.finished());
            inflater.end();
            nArray[0] = n5;
            return byArray2;
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
    }

    protected static final byte[] zlibDeflate(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        int n4 = 512;
        int n5 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        deflater.finish();
        n5 = n3;
        while (!deflater.finished()) {
            byArray3 = byArray2;
            byArray2 = new byte[2 * n4];
            if (byArray3 != null) {
                System.arraycopy(byArray3, 0, byArray2, 0, n5);
                byArray3 = null;
            }
            n5 += deflater.deflate(byArray2, n5, (n4 *= 2) - n5);
        }
        deflater.end();
        nArray[0] = n5;
        return byArray2;
    }

    protected int getSequence() {
        if (this.m_sequence >= Integer.MAX_VALUE) {
            this.m_sequence = 0;
        }
        return ++this.m_sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ACK send(Transaction transaction, int n, boolean bl) throws ConMgrException, CSSException, HelloNAKException, MaxTasksException {
        Request request = transaction.getRequestFast();
        if (request == null) {
            throw new ConMgrException(8716604);
        }
        int n2 = request.getRequestType();
        Packet packet = null;
        transaction.setRequestFast(null);
        int n3 = this.getSequence();
        request.setSequence(n3);
        request.setTransCode(this.getTransCode());
        request.startRequest();
        String string = request.getRequestTypeName();
        transaction.setSequenceFast(n3);
        transaction.setConnectionIdFast(this.m_sis.getScbURL());
        if (SiebelTrace.getInstance().getLogLevel() >= 3) {
            transaction.setStartTimeFast(System.currentTimeMillis());
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("set tx=");
        stringBuffer.append(transaction.getSequenceFast());
        SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
        this.m_txMap.addTransaction(transaction);
        try {
            this.writePacket(request, n, bl);
            if (this.m_pool != null) {
                this.m_pool.setFree(this);
            }
            request = null;
        }
        catch (IOException iOException) {
            if (SiebelTrace.getInstance().getLogLevel() >= 3) {
                transaction.setStopTime(System.currentTimeMillis());
            }
            transaction.abandon();
            this.m_txMap.removeTransaction(transaction.getSequence());
            this.shutdownOutput();
            this.m_shutdownEx = iOException;
            throw new ConMgrException(8716590, iOException);
        }
        catch (CSSException cSSException) {
            if (this.m_pool != null) {
                this.m_pool.setFree(this);
            }
            throw cSSException;
        }
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            long l = System.currentTimeMillis();
            long l2 = l + (long)this.m_txTimeout;
            int n4 = 0;
            boolean bl2 = true;
            long l3 = 0L;
            while (!(transaction.isDone() || transaction.isAbandoned() || this.m_close)) {
                try {
                    if (!bl2 && (l3 = l2 - System.currentTimeMillis()) <= 0L) break;
                    stringBuffer = new StringBuffer(64);
                    stringBuffer.append("wait=");
                    stringBuffer.append(Integer.toString(++n4));
                    stringBuffer.append(" tx=");
                    stringBuffer.append(transaction.getSequence());
                    SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
                    transaction.wait(l3 + 1L);
                    bl2 = false;
                }
                catch (InterruptedException interruptedException) {
                    transaction.abandon();
                }
            }
            stringBuffer = new StringBuffer(64);
            stringBuffer.append("end loop tx=");
            stringBuffer.append(transaction.getSequence());
            stringBuffer.append(' ');
            stringBuffer.append(transaction.isDone() ? "isDone" : (this.m_close ? "closed" : (transaction.isAbandoned() ? "abandoned" : "timeout")));
            SiebelTrace.getInstance().trace(null, 4, "", stringBuffer.toString());
            if (transaction.isDone()) {
                packet = transaction.getResponseFast();
                if (packet.getMessageType() != 2) {
                    String string2;
                    SiebelErrorMsg siebelErrorMsg;
                    Packet packet2;
                    if (packet.getMessageType() == 5 && ((SISNotify)(packet2 = (SISNotify)packet)).getNotifyCode() == 201) {
                        CSSUtilities.SSExecuteFile(((SISNotify)packet2).getDetailString());
                        throw new CSSException(8716788, ((SISNotify)packet2).getDetailString());
                    }
                    if (n2 == 101 && packet.getMessageType() == 3) {
                        Object object;
                        packet2 = (NAK)packet;
                        if (((NAK)packet2).getErrorCount() != 0 && ((SiebelErrorMsg)(object = ((NAK)packet2).getError(0))).getErrorCode() == 1003) {
                            CSSException cSSException = new CSSException(8716617);
                            this.m_shutdownEx = cSSException;
                            this.shutdownOutput();
                            throw cSSException;
                        }
                        this.m_shutdownEx = object = new HelloNAKException((NAK)packet2);
                        this.shutdownOutput();
                        throw object;
                    }
                    if (packet.getMessageType() == 5 && (siebelErrorMsg = ((SISNotify)(packet2 = (SISNotify)packet)).getError(0)) != null && (string2 = siebelErrorMsg.getErrorMsg()) != null && string2.indexOf("SBL-SSM-00012") != -1) {
                        throw new MaxTasksException((SISNotify)packet);
                    }
                    throw new RequestException(string, packet);
                }
            } else {
                if (this.m_close) {
                    if (SiebelTrace.getInstance().getLogLevel() >= 3) {
                        transaction.setStopTimeFast(System.currentTimeMillis());
                    }
                    throw new RequestException(8716591, new String[]{string, String.valueOf(transaction.getSequence()), String.valueOf(transaction.getDuration()), Integer.toHexString(this.getConId()), this.m_shutdownEx.getMessage()});
                }
                if (transaction.isAbandoned()) {
                    throw new RequestException(8716603, new String[]{string, String.valueOf(transaction.getSequence()), String.valueOf(transaction.getDuration()), Integer.toHexString(this.getConId())});
                }
                if (SiebelTrace.getInstance().getLogLevel() >= 3) {
                    transaction.setStopTimeFast(System.currentTimeMillis());
                }
                this.m_txMap.removeTransaction(transaction.getSequence());
                transaction.abandonFast();
                RequestException requestException = new RequestException(8716605, new String[]{string, String.valueOf(transaction.getSequenceFast()), Integer.toHexString(this.getConId()), String.valueOf(transaction.getDurationFast())});
                this.m_shutdownEx = requestException;
                this.shutdownOutput();
                throw requestException;
            }
        }
        return (ACK)packet;
    }
}

