/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.common.common.CSSException;
import com.siebel.debug.SiebelDebug;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.Connection;
import com.siebel.om.conmgr.ConnectionPool;
import com.siebel.om.conmgr.HelloNAKException;
import com.siebel.om.conmgr.IPoolManager;
import com.siebel.om.conmgr.MaxTasksException;
import com.siebel.om.conmgr.SISString;
import com.siebel.om.conmgr.SessionHandle;
import com.siebel.om.conmgr.Transaction;
import com.siebel.om.conmgr.VirtualServer;
import com.siebel.om.sisnapi.ACK;
import com.siebel.om.sisnapi.SessHelloAck;
import com.siebel.om.sisnapi.SessHelloReq;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class ConnectionManager
implements IPoolManager {
    public static final int SESS_TIMEOUT = 2700;
    public static final int GAP_RETRY = 3;
    protected static final String DEFAULT_PROPERTY_FILE_NAME = "siebel";
    protected static final String CM_TIMEOUT_PROPERTY = "siebel.conmgr.txtimeout";
    protected static final String CM_POOLSIZE_PROPERTY = "siebel.conmgr.poolsize";
    protected static final String CM_SESSTIMEOUT_PROPERTY = "siebel.conmgr.sesstimeout";
    protected static final String CM_RETRY_PROPERTY = "siebel.conmgr.retry";
    protected static final String CM_ENCRYPTION_JCE = "siebel.conmgr.jce";
    protected static final String CM_VIRTUAL_SERVERS = "siebel.conmgr.virtualhosts";
    private static ConnectionManager s_cm = new ConnectionManager();
    protected static ThreadGroup s_tg = new ThreadGroup("Listener Threads");
    protected ResourceBundle m_bundle = null;
    protected String m_bundleName = "siebel";
    protected Hashtable m_pools = new Hashtable();
    protected int m_poolSize = 2;
    protected int m_txTimeout = 600000;
    protected int m_sessTimeout = 2700;
    protected int m_retry = 3;
    protected boolean m_jce_enable = false;

    public static void setPoolSize(int n) {
        s_cm.resize(n);
    }

    public static void setSessionTimeout(int n) {
        s_cm.setSessTimeout(n);
    }

    public int getTxTimeout() {
        return this.m_txTimeout;
    }

    public void setTxTimeout(int n) {
        this.m_txTimeout = n;
    }

    public int getSessTimeout() {
        return this.m_sessTimeout;
    }

    public void setSessTimeout(int n) {
        this.m_sessTimeout = n;
    }

    public static boolean isJCE() {
        return ConnectionManager.s_cm.m_jce_enable;
    }

    @Override
    public void remove(ConnectionPool connectionPool) {
        String string;
        if (connectionPool != null && (string = connectionPool.getKey()) != null) {
            System.err.println("[CMGR WARNING] Removing connection pool " + string);
            this.m_pools.remove(string);
        }
    }

    protected void resize(int n) {
        if (0 < n && n < 200) {
            this.m_poolSize = n;
        }
    }

    static Hashtable getPools() {
        return (Hashtable)ConnectionManager.s_cm.m_pools.clone();
    }

    public static SessionHandle open(String string) throws CSSException {
        Connection connection = null;
        SessionHandle sessionHandle = null;
        Transaction transaction = new Transaction();
        SISString sISString = new SISString(string.trim());
        int n = 0;
        Exception exception = null;
        boolean bl = false;
        if (sISString == null || !sISString.verifySpec()) {
            throw new ConMgrException(8716589);
        }
        while (!bl && n++ < ConnectionManager.s_cm.m_retry) {
            try {
                exception = null;
                connection = new Connection(sISString, ConnectionManager.s_cm.m_txTimeout);
                SessHelloReq sessHelloReq = new SessHelloReq(1, ConnectionManager.s_cm.m_sessTimeout);
                sessHelloReq.setSessionId(connection.getConId());
                sessHelloReq.setTransCode(connection.getTransCode());
                transaction.setRequest(sessHelloReq);
                sessHelloReq = null;
                SessHelloAck sessHelloAck = (SessHelloAck)connection.send(transaction);
                sessionHandle = new SessionHandle(sessHelloAck, string);
                bl = true;
            }
            catch (HelloNAKException helloNAKException) {
                exception = helloNAKException;
                sISString.setNewServer();
            }
            catch (MaxTasksException maxTasksException) {
                if (connection != null) {
                    connection.shutdownOutput();
                }
                exception = maxTasksException;
                sISString.setNewServer();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                if (connection != null) {
                    connection.shutdownOutput();
                }
                if (sISString.isLoadBalanced()) {
                    SiebelDebug.printException("ConnectionManager", "open", exception2);
                }
                sISString.setNewServer();
            }
        }
        if (!bl) {
            if (exception == null) {
                throw new ConMgrException(8716488, String.valueOf(n));
            }
            throw new ConMgrException(8716488, String.valueOf(n), exception);
        }
        ConnectionPool connectionPool = s_cm.getPool(sessionHandle);
        connectionPool.addConnection(connection);
        return sessionHandle;
    }

    public static ACK send(SessionHandle sessionHandle, Transaction transaction) throws ConMgrException, CSSException {
        if (sessionHandle == null || transaction == null || transaction.getRequest() == null) {
            throw new ConMgrException(8716588);
        }
        try {
            transaction.getRequestFast().setSessionId(sessionHandle.getTid());
            return s_cm.getPool(sessionHandle).getConnection().send(transaction);
        }
        catch (HelloNAKException helloNAKException) {
            throw new CSSException(65535, helloNAKException.getMessage());
        }
        catch (MaxTasksException maxTasksException) {
            throw new CSSException(65535, maxTasksException.getMessage());
        }
    }

    public static ACK send(String string, Transaction transaction) throws ConMgrException, CSSException {
        if (string == null || transaction == null || transaction.getRequest() == null) {
            throw new ConMgrException(8716588);
        }
        SessionHandle sessionHandle = new SessionHandle(string);
        return ConnectionManager.send(sessionHandle, transaction);
    }

    protected ConnectionManager() {
        String string = null;
        int n = 0;
        try {
            this.m_bundle = ResourceBundle.getBundle(this.m_bundleName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_bundle != null) {
            try {
                string = this.m_bundle.getString(CM_TIMEOUT_PROPERTY);
                n = new Integer(string);
                if (n > 0) {
                    this.m_txTimeout = n;
                }
                string = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.m_bundle.getString(CM_POOLSIZE_PROPERTY);
                n = new Integer(string);
                if (n > 0) {
                    this.m_poolSize = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.m_bundle.getString(CM_SESSTIMEOUT_PROPERTY);
                n = new Integer(string);
                if (n >= 0) {
                    this.m_sessTimeout = n;
                }
                string = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.m_bundle.getString(CM_RETRY_PROPERTY);
                n = new Integer(string);
                if (n > 0) {
                    this.m_retry = n;
                }
                string = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.m_bundle.getString(CM_ENCRYPTION_JCE);
                n = new Integer(string);
                this.m_jce_enable = n >= 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.m_bundle.getString(CM_VIRTUAL_SERVERS);
                if (string != null && string.length() != 0) {
                    VirtualServer.initializeVirtualServers(string);
                }
            }
            catch (ConMgrException conMgrException) {
                conMgrException.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPool getPool(SessionHandle sessionHandle) throws ConMgrException, CSSException {
        ConnectionPool connectionPool = null;
        String string = null;
        Hashtable hashtable = this.m_pools;
        synchronized (hashtable) {
            connectionPool = (ConnectionPool)this.m_pools.get(sessionHandle.toPoolKey());
            if (connectionPool == null) {
                SISString sISString = new SISString(sessionHandle);
                string = sessionHandle.toPoolKey();
                connectionPool = new ConnectionPool(sISString, this.m_poolSize, s_cm, this.m_txTimeout);
                this.m_pools.put(string, connectionPool);
            }
        }
        return connectionPool;
    }

    static ThreadGroup getThreadGroup() {
        return s_tg;
    }

    public static void InitVirtualServer(String string) {
        try {
            VirtualServer.initializeVirtualServers(string);
            SiebelTrace.getInstance().trace(null, 3, "[ConnectionManager]", "Virtual servers sucessfully initilaised vitualhosts=" + string);
        }
        catch (ConMgrException conMgrException) {
            SiebelTrace.getInstance().trace(null, 1, "[ConnectionManager]", "Error in travesing the property virtualhosts . Please check the property virualhosts ");
        }
    }
}

