/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.Connection;
import com.siebel.om.conmgr.IPoolManager;
import com.siebel.om.conmgr.SISString;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectionPool {
    public static final int DEF_SIZE = 2;
    protected static final int WAIT_TIME = 37;
    protected static final int POOL_MAX = 500;
    protected int m_maxSize = 2;
    protected boolean m_clearPool = false;
    protected int m_count = 0;
    protected int m_failed = 0;
    protected Vector m_freeConnections = new Vector();
    protected Vector m_busyConnections = new Vector();
    protected boolean m_waiting = false;
    protected Boolean m_waitLock = new Boolean(true);
    protected int m_txTimeout = 600000;
    protected SISString m_poolSpec;
    protected IPoolManager m_mgr = null;

    public ConnectionPool(SISString sISString, int n, IPoolManager iPoolManager, int n2) throws ConMgrException {
        this(sISString);
        if (n > 0 && n < 500) {
            this.m_maxSize = n;
        }
        this.m_mgr = iPoolManager;
        this.m_txTimeout = n2;
    }

    public ConnectionPool(SISString sISString, int n) throws ConMgrException {
        this(sISString);
        if (n > 0 && n < 500) {
            this.m_maxSize = n;
        }
    }

    public ConnectionPool(SISString sISString) throws ConMgrException {
        if (!sISString.verifySpec()) {
            throw new ConMgrException(8716589);
        }
        this.m_poolSpec = sISString;
    }

    public String getKey() {
        return this.m_poolSpec.getKey();
    }

    public int getTxTimeout() {
        return this.m_txTimeout;
    }

    public void setTxTimeout(int n) {
        this.m_txTimeout = n;
    }

    public int getFailedCount() {
        return this.m_failed;
    }

    public void setMaxSize(int n) {
        if (n > 0 && n < 500) {
            this.m_maxSize = n;
        }
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public int getCurrentSize() {
        return this.m_count;
    }

    public int getBusyCount() {
        return this.m_busyConnections.size();
    }

    public int getFreeCount() {
        return this.m_freeConnections.size();
    }

    public boolean isShutdown() {
        return this.m_clearPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.m_clearPool = true;
        if (this.m_mgr != null) {
            this.m_mgr.remove(this);
        }
        this.m_mgr = null;
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            Connection connection = null;
            Enumeration enumeration = this.m_freeConnections.elements();
            while (enumeration.hasMoreElements()) {
                connection = (Connection)enumeration.nextElement();
                if (connection == null) continue;
                connection.shutdownOutput();
            }
            enumeration = this.m_busyConnections.elements();
            while (enumeration.hasMoreElements()) {
                connection = (Connection)enumeration.nextElement();
                if (connection == null) continue;
                connection.shutdownOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getConnections() {
        Vector vector = null;
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            vector = (Vector)this.m_busyConnections.clone();
            Enumeration enumeration = this.m_freeConnections.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBusy() {
        Vector vector = null;
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            vector = (Vector)this.m_busyConnections.clone();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFree() {
        Vector vector = null;
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            vector = (Vector)this.m_freeConnections.clone();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(Connection connection) throws ConMgrException {
        if (connection == null) {
            throw new ConMgrException(8716588);
        }
        if (this.m_clearPool) {
            throw new ConMgrException(8716599, " Pool Id: " + this.getKey());
        }
        boolean bl = false;
        Boolean bl2 = this.m_waitLock;
        synchronized (bl2) {
            if (this.m_busyConnections.size() + this.m_freeConnections.size() < this.m_maxSize) {
                connection.setPool(this);
                this.m_freeConnections.addElement(connection);
                bl = true;
            }
        }
        if (!bl) {
            connection.shutdownOutput();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ConMgrException {
        Connection connection = null;
        while (connection == null) {
            Boolean bl = this.m_waitLock;
            synchronized (bl) {
                if (this.m_clearPool) {
                    throw new ConMgrException(8716599);
                }
                if (!this.m_freeConnections.isEmpty()) {
                    connection = (Connection)this.m_freeConnections.elementAt(0);
                    this.m_freeConnections.removeElementAt(0);
                } else {
                    int n = this.m_busyConnections.size() + this.m_freeConnections.size();
                    if (n < this.m_maxSize) {
                        connection = this.newConnection();
                        if (connection == null) {
                            this.shutdown();
                            throw new ConMgrException(8716598);
                        }
                        connection.setPool(this);
                    } else {
                        this.m_waiting = true;
                    }
                }
                while (this.m_waiting && !this.m_clearPool) {
                    try {
                        this.m_waitLock.wait(37L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ConMgrException(8716592);
                    }
                }
                if (connection != null) {
                    this.m_busyConnections.addElement(connection);
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(Connection connection) {
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            boolean bl2 = this.m_busyConnections.removeElement(connection);
            if (bl2) {
                ++this.m_failed;
            }
            if (bl2 = this.m_freeConnections.removeElement(connection)) {
                ++this.m_failed;
            }
            if (this.m_busyConnections.isEmpty() && this.m_freeConnections.isEmpty()) {
                this.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFree(Connection connection) {
        Boolean bl = this.m_waitLock;
        synchronized (bl) {
            this.m_count = this.m_freeConnections.size() + this.m_busyConnections.size();
            this.m_busyConnections.removeElement(connection);
            if (this.m_count <= this.m_maxSize && !connection.isShuttingDown()) {
                this.m_freeConnections.addElement(connection);
                this.m_waiting = false;
                this.m_waitLock.notifyAll();
            } else {
                connection.shutdownOutput();
            }
        }
    }

    protected Connection newConnection() {
        Connection connection = null;
        try {
            connection = new Connection(this.m_poolSpec, this.m_txTimeout);
        }
        catch (Exception exception) {
            System.err.println("[CMGR WARNING] Failed to create a connection: " + exception.getMessage());
        }
        return connection;
    }
}

