/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.ConnectInfo;
import com.siebel.om.conmgr.SessionHandle;
import com.siebel.om.conmgr.VirtualServer;
import java.util.StringTokenizer;

public class SISString {
    public static final String _SCHEMA_NAME_STR = "siebel";
    public static final String _HTTP_STR = "http";
    public static final String _TCPIP_STR = "tcpip";
    public static final String _SSL_STR = "ssl";
    public static final String _NONE_STR = "none";
    public static final String _MSCRYPTO_STR = "mscrypto";
    public static final String _MSCRYPTO40_STR = "mscrypto40";
    public static final String _MSCRYPTO128_STR = "mscrypto128";
    public static final String _RSABSAFE_STR = "rsa";
    public static final String _RSABSAFE56_STR = "rsa56";
    public static final String _RSABSAFE128_STR = "rsa128";
    public static final String _ZLIB_STR = "zlib";
    public static final String _PKWARE_STR = "pkware";
    public static final String _ONE_STR = "1";
    public static final String _ZERO_STR = "0";
    public static final String _SHANDLE_SLASH_STR = "/";
    public static final String _SHANDLE_HP_STR = ":";
    public static final String _SHANDLE_DELIM_STR = "!";
    public static final String _SH_TOKEN_DELIM_STR = ".";
    public static final String _SIEBEL = "siebel://";
    public static final String _HTTP = "http://";
    public static final String ROUNDROBIN_TAG = "rr";
    protected static final int _URL_SCHEME_TOKENS = 5;
    protected static final int _URL_HOST_TOKENS = 2;
    protected static final int _URL_PATH_TOKENS = 3;
    protected static final int _URL_TOTAL_TOKENS = 10;
    protected static final int _SCHEMA_NAME_TOKEN = 0;
    protected static final int _SCHEMA_PROTO_TOKEN = 1;
    protected static final int _SCHEMA_CRYPT_TOKEN = 2;
    protected static final int _SCHEMA_COMPRESS_TOKEN = 3;
    protected static final int _SCHEMA_LB_TOKEN = 4;
    protected static final int _HOST_ADDRESS_TOKEN = 5;
    protected static final int _HOST_PORT_TOKEN = 6;
    protected static final int _PATH_ENTERPRISE_TOKEN = 7;
    protected static final int _PATH_COMPONENT_TOKEN = 8;
    protected static final int _PATH_SERVER_TOKEN = 9;
    protected String m_host;
    protected String m_urlPath;
    protected String m_scbURL;
    protected int m_type;
    protected int m_nPort;
    protected int m_encryption;
    protected int m_compression;
    protected String m_enterprise;
    protected String m_component;
    protected String m_server;
    protected String m_nameServer;
    protected String m_sid;
    protected String m_pid;
    protected String m_key;
    protected boolean m_bLoadBalanced;
    protected boolean m_bVirtualServer;
    protected boolean m_bSet;
    protected boolean m_bRoundRobin = false;
    protected ConnectInfo m_connInfo = null;

    public static int getCompressionType(String string) {
        if (CSSUtilities.compareNoCase(string, _ZLIB_STR) == 0) {
            return 16;
        }
        if (CSSUtilities.compareNoCase(string, _PKWARE_STR) == 0) {
            return 7;
        }
        return 0;
    }

    public static int getEncryptionType(String string, boolean bl) throws CSSException {
        if (CSSUtilities.isEmpty(string) || CSSUtilities.compareNoCase(string, _NONE_STR) == 0) {
            return 0;
        }
        if (CSSUtilities.compareNoCase(string, _RSABSAFE_STR) == 0) {
            return 2;
        }
        if (CSSUtilities.compareNoCase(string, _RSABSAFE56_STR) == 0) {
            return 2;
        }
        if (CSSUtilities.compareNoCase(string, _RSABSAFE128_STR) == 0) {
            return 4;
        }
        if (bl) {
            throw new CSSException(8716625, string);
        }
        if (CSSUtilities.compareNoCase(string, _MSCRYPTO_STR) == 0) {
            return 1;
        }
        if (CSSUtilities.compareNoCase(string, _MSCRYPTO40_STR) == 0) {
            return 1;
        }
        if (CSSUtilities.compareNoCase(string, _MSCRYPTO128_STR) == 0) {
            return 3;
        }
        throw new CSSException(8716624);
    }

    public static int getCommType(String string) {
        if (CSSUtilities.compareNoCase(string, _TCPIP_STR) == 0) {
            return 1;
        }
        if (CSSUtilities.compareNoCase(string, _HTTP_STR) == 0) {
            return 3;
        }
        if (CSSUtilities.compareNoCase(string, _SSL_STR) == 0) {
            return 4;
        }
        return 0;
    }

    public SISString(String string) throws CSSException {
        this.decode(string);
    }

    public SISString(SessionHandle sessionHandle) throws CSSException {
        this(sessionHandle.toString());
        this.m_key = sessionHandle.toPoolKey();
    }

    public String getKey() {
        return this.m_key;
    }

    public int getCommType() {
        return this.m_type;
    }

    public String getCommStr() {
        if (this.m_type == 3) {
            return _HTTP_STR;
        }
        return _TCPIP_STR;
    }

    public void setCommType(int n) {
        this.m_type = n;
    }

    public int getPort() {
        return this.m_nPort;
    }

    public void setPort(int n) {
        this.m_nPort = n;
    }

    public int getEncryption() {
        return this.m_encryption;
    }

    public String getEncryptionStr() {
        switch (this.m_encryption) {
            case 2: {
                return _RSABSAFE56_STR;
            }
            case 4: {
                return _RSABSAFE128_STR;
            }
        }
        return _NONE_STR;
    }

    public void setEncryption(int n) {
        this.m_encryption = n;
    }

    public int getCompression() {
        return this.m_compression;
    }

    public String getCompressionStr() {
        switch (this.m_compression) {
            case 16: {
                return _ZLIB_STR;
            }
            case 1: 
            case 2: 
            case 4: {
                return _PKWARE_STR;
            }
        }
        return _NONE_STR;
    }

    public void setCompression(int n) {
        this.m_compression = n;
    }

    public String getGateway() {
        return this.m_host + _SHANDLE_HP_STR + this.m_nPort;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    public String getURLPath() {
        return this.m_urlPath;
    }

    public void setURLPath(String string) {
        this.m_urlPath = string;
    }

    public String getEnterprise() {
        return this.m_enterprise;
    }

    public void setEnterprise(String string) {
        this.m_enterprise = string;
    }

    public String getComponent() {
        return this.m_component;
    }

    public void setComponent(String string) {
        this.m_component = string;
    }

    public String getServer() {
        return this.m_server;
    }

    public void setServer(String string) {
        this.m_server = string;
    }

    public String getNameServer() {
        return this.m_nameServer;
    }

    public void setNameServer(String string) {
        this.m_nameServer = string;
    }

    public void setScbURL(String string) {
        this.m_scbURL = string;
    }

    public boolean isLoadBalanced() {
        return this.m_bLoadBalanced;
    }

    public void setLoadBalanced(boolean bl) {
        this.m_bLoadBalanced = bl;
    }

    public boolean isTcpIp() {
        return this.m_type == 1;
    }

    public boolean isHTTP() {
        return this.m_type == 3;
    }

    public boolean isSSL() {
        return this.m_type == 4;
    }

    public void setRoundRobin() {
        this.m_bRoundRobin = true;
    }

    public ConnectInfo getConnectInfo() {
        return this.m_connInfo;
    }

    public String getScbURL() {
        if (!this.m_bLoadBalanced) {
            this.m_scbURL = _HTTP + this.m_connInfo.getHost() + _SHANDLE_HP_STR + this.m_connInfo.getPort() + _SHANDLE_SLASH_STR + this.m_urlPath;
            if (this.m_sid != null) {
                this.m_scbURL = this.m_scbURL + "/!";
                this.m_scbURL = this.m_scbURL + this.m_sid + _SH_TOKEN_DELIM_STR + this.m_pid;
            }
        }
        return this.m_scbURL;
    }

    public void setNewServer() throws ConMgrException {
        if (this.m_bLoadBalanced) {
            this.setRoundRobin();
        } else {
            this.m_connInfo = this.m_connInfo != null ? VirtualServer.getVirtualServer(this.m_host).getNextServer(this.m_connInfo) : VirtualServer.getVirtualServer(this.m_host).getNextServer();
        }
    }

    public boolean verifySpec() {
        if (this.getHost() == null) {
            return false;
        }
        if (this.isLoadBalanced()) {
            if (this.getPort() == 0) {
                return false;
            }
            String string = this.getScbURL();
            if (string == null) {
                return false;
            }
        } else if (!VirtualServer.isValid(this.m_host)) {
            return false;
        }
        return true;
    }

    public byte[] getTransportInfo(int n) {
        String string = this.getScbURL();
        if (this.m_bRoundRobin) {
            string = string + _SHANDLE_SLASH_STR;
            string = string + ROUNDROBIN_TAG;
        }
        string = string + " HTTP/1.1\r\n";
        string = string + "Content-Type: application/octet-stream\r\n";
        string = string + "Content-Length: ";
        string = string + n;
        string = string + "\r\n";
        string = string + "\r\n";
        byte[] byArray = new byte[string.length()];
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, 0, string.length());
        }
        return byArray;
    }

    public void decode(String string) throws CSSException {
        String string2 = (string = string.trim()).toLowerCase();
        int n = string2.indexOf(_SHANDLE_DELIM_STR);
        if (n != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1), _SH_TOKEN_DELIM_STR);
            if (stringTokenizer.countTokens() >= 2) {
                this.m_sid = stringTokenizer.nextToken();
                this.m_pid = stringTokenizer.nextToken();
            }
            if (string2.charAt(n - 1) == '/') {
                --n;
            }
            string2 = string2.substring(0, n);
            string = string.substring(0, n);
        }
        n = 0;
        if (string2.startsWith(_SCHEMA_NAME_STR) && string2.indexOf("://") != -1) {
            if (!this.decodeSiebelURL(string2)) {
                throw new CSSException(8716494, string);
            }
            if (this.isLoadBalanced()) {
                this.m_bSet = true;
                return;
            }
        }
        if (CSSUtilities.isEmpty(this.m_host) || CSSUtilities.isEmpty(this.m_enterprise) || CSSUtilities.isEmpty(this.m_component)) {
            this.m_bSet = false;
            return;
        }
    }

    public boolean decodeSiebelURL(String string) throws CSSException {
        block21: {
            String[] stringArray;
            block26: {
                block27: {
                    block25: {
                        block23: {
                            block24: {
                                block22: {
                                    int n;
                                    int n2;
                                    stringArray = new String[10];
                                    if (CSSUtilities.isEmpty(string)) break block21;
                                    if (this.m_bSet) {
                                        this.reset();
                                    }
                                    if ((n2 = string.indexOf("://")) == -1) break block21;
                                    String string2 = string.substring(0, n2);
                                    int n3 = string.indexOf(47, n2 += 3);
                                    if (n3 == -1) break block21;
                                    String string3 = string.substring(n2, n3);
                                    this.m_nameServer = new String(string3);
                                    String string4 = string.substring(++n3);
                                    for (n = 0; n < 10; ++n) {
                                        stringArray[n] = null;
                                    }
                                    n = 0;
                                    StringTokenizer stringTokenizer = new StringTokenizer(string2, _SH_TOKEN_DELIM_STR);
                                    while (n < 5 && stringTokenizer.hasMoreTokens()) {
                                        stringArray[n++] = stringTokenizer.nextToken();
                                    }
                                    n = 5;
                                    stringTokenizer = new StringTokenizer(string3, _SHANDLE_HP_STR);
                                    while (n < 7 && stringTokenizer.hasMoreTokens()) {
                                        stringArray[n++] = stringTokenizer.nextToken();
                                    }
                                    n = 7;
                                    this.m_urlPath = string4;
                                    if (CSSUtilities.isEmpty(this.m_urlPath)) break block21;
                                    stringTokenizer = new StringTokenizer(string4, _SHANDLE_SLASH_STR);
                                    while (n < 10 && stringTokenizer.hasMoreTokens()) {
                                        stringArray[n++] = stringTokenizer.nextToken();
                                    }
                                    if (CSSUtilities.compareNoCase(stringArray[0], _SCHEMA_NAME_STR) != 0) break block21;
                                    if (!CSSUtilities.isEmpty(stringArray[1]) && CSSUtilities.compareNoCase(stringArray[1], _TCPIP_STR) != 0) break block22;
                                    this.m_type = 1;
                                    break block23;
                                }
                                if (CSSUtilities.compareNoCase(stringArray[1], _HTTP_STR) != 0) break block24;
                                this.m_type = 3;
                                break block23;
                            }
                            if (CSSUtilities.compareNoCase(stringArray[1], _SSL_STR) != 0) break block21;
                            this.m_type = 4;
                        }
                        this.m_encryption = SISString.getEncryptionType(stringArray[2], true);
                        if (!CSSUtilities.isEmpty(stringArray[3]) && CSSUtilities.compareNoCase(stringArray[3], _NONE_STR) != 0) break block25;
                        this.m_compression = 0;
                        break block26;
                    }
                    if (CSSUtilities.compareNoCase(stringArray[3], _ZLIB_STR) != 0) break block27;
                    this.m_compression = 16;
                    break block26;
                }
                if (CSSUtilities.compareNoCase(stringArray[3], _PKWARE_STR) != 0) break block21;
                this.m_compression = 7;
            }
            if (!CSSUtilities.isEmpty(stringArray[5])) {
                this.m_host = stringArray[5];
                if (!CSSUtilities.isEmpty(stringArray[6])) {
                    this.m_nPort = Integer.parseInt(stringArray[6]);
                    this.m_connInfo = new ConnectInfo(this.m_host, this.m_nPort);
                } else {
                    this.m_bVirtualServer = true;
                    if (this.m_sid != null && !this.m_sid.equals("")) {
                        this.m_connInfo = VirtualServer.getVirtualServer(this.m_host).getConnectInfo(this.m_sid);
                    } else {
                        this.setNewServer();
                    }
                }
                if (!CSSUtilities.isEmpty(stringArray[7])) {
                    this.m_enterprise = stringArray[7];
                    if (!CSSUtilities.isEmpty(stringArray[8])) {
                        this.m_component = stringArray[8];
                        if (!CSSUtilities.isEmpty(stringArray[9])) {
                            this.m_server = stringArray[9];
                        }
                        if (this.m_server == null) {
                            if (!this.m_bVirtualServer) {
                                this.m_bLoadBalanced = true;
                            }
                        } else {
                            System.out.println("Server Name should not be specified");
                            this.m_bSet = false;
                            return false;
                        }
                        this.m_urlPath = this.m_urlPath.toLowerCase();
                        this.m_scbURL = _HTTP + this.m_host;
                        if (this.m_nPort != 0) {
                            this.m_scbURL = this.m_scbURL + _SHANDLE_HP_STR + this.m_nPort;
                        }
                        this.m_scbURL = this.m_scbURL + _SHANDLE_SLASH_STR + this.m_urlPath;
                        if (this.m_sid != null) {
                            this.m_scbURL = this.m_scbURL + "/!";
                            this.m_scbURL = this.m_scbURL + this.m_sid + _SH_TOKEN_DELIM_STR + this.m_pid;
                        }
                        this.m_bSet = true;
                        return true;
                    }
                }
            }
        }
        this.m_bSet = false;
        return false;
    }

    public void reset() {
        this.m_host = null;
        this.m_scbURL = null;
        this.m_urlPath = null;
        this.m_type = 0;
        this.m_nPort = 0;
        this.m_encryption = 0;
        this.m_compression = 0;
        this.m_enterprise = null;
        this.m_component = null;
        this.m_server = null;
        this.m_bLoadBalanced = false;
        this.m_bSet = false;
        this.m_bRoundRobin = false;
    }
}

