/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.SSLConfig;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLClient {
    private SSLSocket m_sslsocket;
    private SSLConfig m_sslconf;
    private SSLContext m_SSLcontext;
    private SiebelTrace m_logger = SiebelTrace.getInstance();

    public SSLClient() {
        this.m_sslconf = SSLConfig.GetInstance();
        if (!this.m_sslconf.isInitlized()) {
            this.m_logger.trace(null, 1, "SSLClient", "Error in initilising SSL context");
        } else {
            this.m_SSLcontext = this.m_sslconf.getSSLContext();
        }
    }

    public int open(Socket socket, String string, int n) {
        String string2 = "SSL open";
        if (!this.m_sslconf.isInitlized()) {
            this.m_logger.trace(null, 1, "SSL open", "Failed initilizing SSL context please check the configuration");
            return 0;
        }
        SSLSocketFactory sSLSocketFactory = this.m_SSLcontext.getSocketFactory();
        try {
            this.m_sslsocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, false);
            String[] stringArray = new String[]{"SSLv3"};
            this.m_sslsocket.setEnabledProtocols(stringArray);
            this.m_sslsocket.setUseClientMode(true);
            this.m_sslsocket.startHandshake();
            SSLSession sSLSession = this.m_sslsocket.getSession();
            this.m_logger.trace(null, 4, string2, "SSL handshake sucessfull to " + sSLSession.getPeerHost() + " " + sSLSession.getPeerPort());
            this.m_logger.trace(null, 4, string2, "Cipher suite " + sSLSession.getCipherSuite());
            this.m_logger.trace(null, 4, string2, "Protocol " + sSLSession.getProtocol());
        }
        catch (Exception exception) {
            this.m_logger.trace(null, 1, "SSL open", "Failed openeing SSL connection" + exception.toString());
            return 0;
        }
        return 1;
    }

    public SSLSocket getSSLSocket() {
        return this.m_sslsocket;
    }
}

