/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.conmgr;

import com.siebel.common.common.CSSException;
import com.siebel.common.crypt.SiebelCipher;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.SiebelKeyManager;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfig {
    private ResourceBundle m_bundle = null;
    private String m_bundleName = "siebel";
    private static final String DEFAULT_PROPERTY_FILE_NAME = "siebel";
    private static final String SSL_KEYSTORE_PROPERTY = "siebel.ssl.keystore";
    private static final String SSL_TRUSTORE_PROPERTY = "siebel.ssl.truststore";
    private static final String SSL_KEYSTOREALIAS_PROPERTY = "siebel.ssl.keystorealias";
    private static final String SSL_KEYSTORE_PASSWORD = "siebel.ssl.keystorepassword";
    private static final String SSL_TRUSTTORE_PASSWORD = "siebel.ssl.trutstorepassword";
    private static String m_strKeyStorename = null;
    private static String m_strTrustStorename = null;
    private static String m_strAlias = null;
    private static String m_strKeyStorePassword = null;
    private static String m_strTrustStorePassword = null;
    private static String m_siebelCipherSeed = null;
    private static boolean m_encrypted = true;
    private SiebelKeyManager m_keyManager;
    private TrustManager[] m_trustStore;
    private SSLContext m_sslcontext;
    private static SSLConfig m_sslconf = null;
    private boolean m_bIntilized = false;
    private static Object m_mutex = new Object();
    private SiebelTrace m_logger = SiebelTrace.getInstance();

    private SSLConfig() {
        if (!this.initallparams().booleanValue()) {
            this.m_bIntilized = false;
            return;
        }
        this.init();
    }

    private Boolean initallparams() {
        try {
            this.m_bundle = ResourceBundle.getBundle(this.m_bundleName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_bundle != null) {
            try {
                m_strKeyStorename = this.m_bundle.getString(SSL_KEYSTORE_PROPERTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                m_strAlias = this.m_bundle.getString(SSL_KEYSTOREALIAS_PROPERTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                m_strTrustStorename = this.m_bundle.getString(SSL_TRUSTORE_PROPERTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                m_strKeyStorePassword = this.m_bundle.getString(SSL_KEYSTORE_PASSWORD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                m_strTrustStorePassword = this.m_bundle.getString(SSL_TRUSTTORE_PASSWORD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logConfigValues(m_strKeyStorename, SSL_KEYSTORE_PROPERTY);
        this.logConfigValues(m_strTrustStorename, SSL_TRUSTORE_PROPERTY);
        this.logConfigValues(m_strAlias, SSL_KEYSTOREALIAS_PROPERTY);
        if (null == m_strTrustStorePassword || null == m_strKeyStorePassword || null == m_strAlias || null == m_strTrustStorename || null == m_strKeyStorename) {
            this.m_logger.trace(null, 1, "SSLConfig", "Error reading SSL parameters");
            return false;
        }
        return true;
    }

    private void init() {
        try {
            Boolean bl = true;
            Boolean bl2 = true;
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            if (null != m_strKeyStorename && !m_strKeyStorename.isEmpty() && null != m_strKeyStorePassword && !m_strKeyStorePassword.isEmpty()) {
                keyStore.load(new FileInputStream(m_strKeyStorename), m_strKeyStorePassword.toCharArray());
            } else {
                bl = false;
            }
            KeyStore keyStore2 = KeyStore.getInstance("JKS", "SUN");
            if (null != m_strTrustStorename && !m_strTrustStorename.isEmpty() && null != m_strTrustStorePassword && !m_strTrustStorePassword.isEmpty()) {
                keyStore2.load(new FileInputStream(m_strTrustStorename), m_strTrustStorePassword.toCharArray());
            } else {
                bl2 = false;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            if (bl2.booleanValue()) {
                trustManagerFactory.init(keyStore2);
                this.m_trustStore = trustManagerFactory.getTrustManagers();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyManager[] keyManagerArray = null;
            if (bl.booleanValue()) {
                keyManagerFactory.init(keyStore, m_strKeyStorePassword.toCharArray());
                KeyManager[] keyManagerArray2 = keyManagerFactory.getKeyManagers();
                this.m_keyManager = new SiebelKeyManager(keyManagerArray2[0], m_strAlias);
                keyManagerArray = new KeyManager[]{this.m_keyManager};
            }
            this.m_sslcontext = SSLContext.getInstance("SSLV3");
            this.m_sslcontext.init(keyManagerArray, this.m_trustStore, null);
            this.m_bIntilized = true;
        }
        catch (Exception exception) {
            this.m_logger.trace(null, 1, "SSLConfig", "Error initilaising SSL context" + exception.toString());
            this.m_bIntilized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLConfig GetInstance() {
        if (null == m_sslconf) {
            Object object = m_mutex;
            synchronized (object) {
                if (null == m_sslconf) {
                    m_sslconf = new SSLConfig();
                }
            }
        }
        return m_sslconf;
    }

    public boolean isInitlized() {
        return this.m_bIntilized;
    }

    public SiebelKeyManager getKeyManager() {
        if (this.m_bIntilized) {
            return this.m_keyManager;
        }
        return null;
    }

    public TrustManager getTrustManager() {
        if (this.m_bIntilized) {
            return this.m_trustStore[0];
        }
        return null;
    }

    public SSLContext getSSLContext() {
        if (this.m_bIntilized) {
            return this.m_sslcontext;
        }
        return null;
    }

    public static void setKeyStoreName(String string) {
        m_strKeyStorename = string;
    }

    public static void setTrustStorename(String string) {
        m_strTrustStorename = string;
    }

    public static void setKeyStoreAlias(String string) {
        m_strAlias = string;
    }

    public static void setKeyStorePassword(String string) {
        m_strKeyStorePassword = string;
    }

    public static void setTrustStorePassword(String string) {
        m_strTrustStorePassword = string;
    }

    private void logConfigValues(String string, String string2) {
        String string3 = "[SSL] Reading parameter";
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "  ";
        String string5 = "SSLConfig Initlisation";
        String string6 = "Failed";
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        stringBuffer.append(string2);
        stringBuffer.append(string4);
        if (null != string && !string.isEmpty()) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string6);
        }
        this.m_logger.trace(null, 3, string5, stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptPasswords(String string) throws CSSException {
        if (m_encrypted) {
            Object object = m_mutex;
            synchronized (object) {
                if (m_encrypted) {
                    m_siebelCipherSeed = string;
                    SiebelCipher siebelCipher = new SiebelCipher(m_siebelCipherSeed);
                    m_strTrustStorePassword = siebelCipher.decrypt(m_strTrustStorePassword);
                    m_strKeyStorePassword = siebelCipher.decrypt(m_strKeyStorePassword);
                    m_encrypted = false;
                }
            }
        }
    }
}

