/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.om;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSPropertySet;
import com.siebel.om.om.CSSBusComp;
import com.siebel.om.om.CSSIBusComp;
import com.siebel.om.om.CSSIBusCompNotify;
import com.siebel.om.om.CSSIBusObj;
import com.siebel.om.om.CSSIModel;
import com.siebel.om.om.CSSModel;
import com.siebel.om.sisnapi.ArgList;
import com.siebel.om.sisnapi.ArgSpec;
import com.siebel.om.sisnapi.FieldSpec;
import com.siebel.om.sisnapi.NotifySpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class CSSBusObj
implements CSSIBusObj {
    protected int m_sisBusObjId;
    private boolean m_bInNotify = false;
    private Hashtable m_allBusCompMap = new Hashtable();
    private Hashtable m_busCompMap = new Hashtable();
    private CSSModel m_iModel;
    private String m_name;
    private CSSBusComp m_queryListIBusComp;
    private int m_refCnt;

    protected CSSBusObj(CSSModel cSSModel, String string, int n) {
        this.m_iModel = cSSModel;
        this.m_name = string;
        this.m_queryListIBusComp = null;
        this.m_refCnt = 1;
        this.m_sisBusObjId = n;
    }

    protected void addBusComp(CSSBusComp cSSBusComp) throws CSSException {
        if (cSSBusComp.m_busCompType == 0) {
            if (this.m_busCompMap.containsKey(cSSBusComp.getName())) {
                throw new CSSException(65535);
            }
            this.m_busCompMap.put(cSSBusComp.getName(), cSSBusComp);
        }
        if (!this.m_allBusCompMap.containsKey(new Integer(cSSBusComp.m_sisBusCompId))) {
            this.m_allBusCompMap.put(new Integer(cSSBusComp.m_sisBusCompId), cSSBusComp);
        }
    }

    @Override
    public void addRef() {
        ++this.m_refCnt;
    }

    @Override
    public void buildQueryList(Vector vector, String[] stringArray, boolean[] blArray, boolean bl, String string) throws CSSException {
        ArgList argList = new ArgList();
        vector.removeAllElements();
        argList.addArg("bSetQuery", new ArgSpec(bl));
        argList.addArg("defaultQuery", new ArgSpec(string));
        argList = this.sendReceive(400, argList);
        String[] stringArray2 = argList.getArg("queryList").getValues();
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.addElement(stringArray2[i]);
        }
        stringArray[0] = argList.getArg("selectedQuery").getString();
        blArray[0] = argList.getArg("bHasQueryList").getBool();
    }

    @Override
    public CSSPropertySet createBookmark(boolean bl) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("bIgnoreContext", new ArgSpec(bl));
        argList = this.sendReceive(401, argList);
        return CSSModel.argListToPropertySet("", argList.getArg("bookmarkPropSet").getArgList());
    }

    protected void deleteObject() {
        this.releaseSISBusObj();
        Enumeration enumeration = this.enumBusComps();
        while (enumeration.hasMoreElements()) {
            CSSBusComp cSSBusComp = (CSSBusComp)enumeration.nextElement();
            if (cSSBusComp == null) continue;
            cSSBusComp.m_iBusObj = null;
            cSSBusComp.deleteObject();
        }
        if (this.m_queryListIBusComp != null) {
            this.m_queryListIBusComp.m_iBusObj = null;
            this.m_queryListIBusComp.deleteObject();
        }
        if (this.m_iModel != null) {
            this.m_iModel.removeBusObj(this);
        }
    }

    @Override
    public Enumeration enumAllBusComps() {
        return this.m_allBusCompMap.elements();
    }

    @Override
    public Enumeration enumBusComps() {
        return this.m_busCompMap.elements();
    }

    @Override
    public void execNamedQuery(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("queryName", new ArgSpec(string));
        this.sendReceive(402, argList);
    }

    protected CSSBusComp findBusComp(int n) {
        return (CSSBusComp)this.m_allBusCompMap.get(new Integer(n));
    }

    @Override
    public boolean getAdminMode() {
        ArgList argList;
        try {
            argList = this.sendReceive(404, null);
        }
        catch (CSSException cSSException) {
            return false;
        }
        return argList.getArg("bAdmin").getBool();
    }

    @Override
    public CSSIBusComp getBusComp(String string) throws CSSException {
        FieldSpec[] fieldSpecArray = null;
        if (this.m_busCompMap.containsKey(string)) {
            return (CSSBusComp)this.m_busCompMap.get(string);
        }
        ArgList argList = new ArgList();
        argList.addArg("busCompName", new ArgSpec(string));
        argList = this.sendReceive(1, argList, 5, this.m_sisBusObjId, false);
        int n = argList.getArg("busCompId").getInt();
        String[] stringArray = argList.getArg("fieldIndexList").getValues();
        ArgSpec argSpec = argList.getArg("newFieldList");
        if (argSpec != null) {
            fieldSpecArray = argSpec.getFieldList();
        }
        CSSBusComp cSSBusComp = new CSSBusComp(string, 0, this.m_iModel, this, n, stringArray, fieldSpecArray);
        this.addBusComp(cSSBusComp);
        this.processNotifyList(argList.getArg2("notifyList"));
        return cSSBusComp;
    }

    @Override
    public CSSIModel getModel() {
        return this.m_iModel;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNamedQuery() throws CSSException {
        ArgList argList = this.sendReceive(405, null);
        return argList.getArg("queryName").getString();
    }

    @Override
    public CSSIBusComp getQueryList() throws CSSException {
        FieldSpec[] fieldSpecArray = null;
        if (this.m_queryListIBusComp != null) {
            return this.m_queryListIBusComp;
        }
        ArgList argList = new ArgList();
        argList.addArg("bQueryList", new ArgSpec(true));
        argList = this.sendReceive(1, argList, 5, this.m_sisBusObjId, false);
        int n = argList.getArg("busCompId").getInt();
        String string = argList.getArg("busCompName").getString();
        String[] stringArray = argList.getArg("fieldIndexList").getValues();
        ArgSpec argSpec = argList.getArg("newFieldList");
        if (argSpec != null) {
            fieldSpecArray = argSpec.getFieldList();
        }
        this.m_queryListIBusComp = new CSSBusComp(string, 0, this.m_iModel, this, n, stringArray, fieldSpecArray);
        this.m_allBusCompMap.put(new Integer(n), this.m_queryListIBusComp);
        this.processNotifyList(argList.getArg2("notifyList"));
        return this.m_queryListIBusComp;
    }

    @Override
    public String getQuerySpec() throws CSSException {
        ArgList argList = this.sendReceive(406, null);
        String string = argList.getArg("queryText").getString();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void gotoBookmark(CSSPropertySet cSSPropertySet) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("bookmarkPropSet", new ArgSpec(CSSModel.propertySetToArgList(cSSPropertySet)));
        this.sendReceive(407, argList);
    }

    @Override
    public CSSIBusComp isBusCompLoaded(String string) {
        return (CSSIBusComp)this.m_busCompMap.get(string);
    }

    protected void processNotifyList(NotifySpec[] notifySpecArray) {
        CSSIBusCompNotify cSSIBusCompNotify;
        CSSBusComp cSSBusComp;
        int n;
        Vector<CSSIBusCompNotify> vector = new Vector<CSSIBusCompNotify>();
        if (this.m_bInNotify) {
            return;
        }
        for (n = 0; n < notifySpecArray.length; ++n) {
            cSSBusComp = this.findBusComp(notifySpecArray[n].getBusCompId());
            if (cSSBusComp == null || (cSSIBusCompNotify = cSSBusComp.isUserNotify(notifySpecArray[n])) == null || vector.contains(cSSIBusCompNotify)) continue;
            cSSIBusCompNotify.notifyBeginNotifys();
            vector.addElement(cSSIBusCompNotify);
        }
        this.m_bInNotify = true;
        for (n = 0; n < notifySpecArray.length; ++n) {
            cSSBusComp = this.findBusComp(notifySpecArray[n].getBusCompId());
            if (cSSBusComp == null) continue;
            cSSBusComp.processNotify(notifySpecArray[n]);
        }
        this.m_bInNotify = false;
        for (n = 0; n < vector.size(); ++n) {
            cSSIBusCompNotify = (CSSIBusCompNotify)vector.elementAt(n);
            cSSIBusCompNotify.notifyEndNotifys();
        }
    }

    private void processNotifyList(ArgSpec argSpec) {
        if (argSpec != null) {
            this.processNotifyList(argSpec.getNotifyList());
        }
    }

    @Override
    public void release() {
        if (--this.m_refCnt == 0) {
            this.deleteObject();
        }
    }

    private void releaseSISBusObj() {
        try {
            this.sendReceive(403, null);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    protected void removeBusComp(CSSBusComp cSSBusComp) {
        if (cSSBusComp.m_busCompType == 0 && this.m_busCompMap.containsKey(cSSBusComp.getName())) {
            this.m_busCompMap.remove(cSSBusComp.getName());
        }
        if (this.m_allBusCompMap.containsKey(new Integer(cSSBusComp.m_sisBusCompId))) {
            this.m_allBusCompMap.remove(new Integer(cSSBusComp.m_sisBusCompId));
        }
    }

    @Override
    public void reset() throws CSSException {
        this.sendReceive(408, null);
    }

    @Override
    public void setContext(String string, CSSPropertySet cSSPropertySet) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("busCompName", new ArgSpec(string));
        argList.addArg("bookmarkPropSet", new ArgSpec(CSSModel.propertySetToArgList(cSSPropertySet)));
        this.sendReceive(410, argList);
    }

    protected ArgList sendReceive(int n, ArgList argList) throws CSSException {
        return this.sendReceive(n, argList, 5, this.m_sisBusObjId, true);
    }

    protected ArgList sendReceive(int n, ArgList argList, int n2, int n3, boolean bl) throws CSSException {
        argList = this.m_iModel.sendReceive(n, argList, n2, n3, this);
        if (bl) {
            this.processNotifyList(argList.getArg2("notifyList"));
        }
        return argList;
    }

    @Override
    public void setNamedQuery(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("queryName", new ArgSpec(string));
        this.sendReceive(411, argList);
    }
}

