/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.om;

import com.siebel.common.common.CSSDate;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSPropertySet;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSStringRef;
import com.siebel.common.common.CSSUtilities;
import com.siebel.common.util.CSSSystem;
import com.siebel.om.om.CSSCurrData;
import com.siebel.om.om.CSSExchRate;
import com.siebel.om.om.CSSModel;
import com.siebel.om.sisnapi.ArgList;
import com.siebel.om.sisnapi.ArgSpec;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public final class CSSLocale {
    protected Hashtable m_currData;
    protected String m_currency;
    protected String m_dispDateSeparator;
    protected CSSString m_dispNumberDecimal;
    protected CSSString m_dispNumberSeparator;
    protected CSSString m_dispTimeAM;
    protected CSSString m_dispTimePM;
    protected String m_dispTimeSeparator;
    protected int m_phoneCountry;
    protected int m_phoneCountryMaxLen;
    protected Hashtable m_phoneFormat;
    protected Vector m_profile;
    protected int m_scale;
    protected Vector m_shortDay;
    protected Vector m_shortMonth;
    protected Vector m_longDay;
    protected Vector m_longMonth;
    private String m_currencyCode;
    private CSSModel m_model;
    private final int[] longMonth = new int[]{7717765, 7717769, 7717770, 7717771, 7717772, 7717773, 7717774, 7717775, 7717776, 7717766, 7717767, 7717768};
    private final int[] shortMonth = new int[]{7717784, 7717788, 7717789, 7717790, 7717791, 7717792, 7717793, 7717794, 7717795, 7717785, 7717786, 7717787};
    private final int[] longDay = new int[]{7717761, 7717759, 7717763, 7717764, 7717762, 7717758, 7717760};
    private final int[] shortDay = new int[]{7717780, 7717778, 7717782, 7717783, 7717781, 7717777, 7717779};

    public CSSLocale(CSSModel cSSModel) {
        this.m_model = cSSModel;
        this.m_currData = new Hashtable();
        this.m_currency = "";
        this.m_dispDateSeparator = "";
        this.m_dispNumberDecimal = new CSSString(this);
        this.m_dispNumberSeparator = new CSSString(this);
        this.m_dispTimeAM = new CSSString(this);
        this.m_dispTimePM = new CSSString(this);
        this.m_dispTimeSeparator = "";
        this.m_phoneCountry = 0;
        this.m_phoneCountryMaxLen = 0;
        this.m_phoneFormat = new Hashtable();
        this.m_profile = new Vector();
        this.m_scale = 0;
        this.m_shortDay = new Vector();
        this.m_shortMonth = new Vector();
        this.m_longDay = new Vector();
        this.m_longMonth = new Vector();
        this.m_currencyCode = "";
        this.m_profile.setSize(19);
        this.loadProfile(12);
        this.loadProfile(10);
        this.loadProfile(11);
        this.loadProfile(14);
        this.loadProfile(15);
        this.loadProfile(16);
        this.loadProfile(17);
        this.loadProfile(18);
    }

    public CSSCurrData getCurrency(String string) {
        if (this.m_currData.isEmpty()) {
            block9: {
                CSSNumber cSSNumber = new CSSNumber(this);
                ArgList argList = new ArgList();
                CSSPropertySet cSSPropertySet = null;
                CSSCurrData cSSCurrData = null;
                try {
                    argList = this.sendReceive(6, argList);
                    cSSPropertySet = CSSModel.argListToPropertySet("", argList);
                    this.m_currency = cSSPropertySet.getProperty("currency");
                    if (this.m_currency == null) break block9;
                    Enumeration enumeration = cSSPropertySet.enumSubsetKeys();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = (String)enumeration.nextElement();
                        CSSPropertySet cSSPropertySet2 = cSSPropertySet.getSubset(string3);
                        cSSCurrData = new CSSCurrData();
                        cSSCurrData.m_symbol = cSSPropertySet2.getProperty("symbol");
                        if (cSSCurrData.m_symbol != null && (string2 = cSSPropertySet2.getProperty("stdScale")) != null) {
                            cSSCurrData.m_stdScale = Integer.parseInt(string2);
                            string2 = cSSPropertySet2.getProperty("extScale");
                            if (string2 != null) {
                                cSSCurrData.m_extScale = Integer.parseInt(string2);
                                string2 = cSSPropertySet2.getProperty("minAcctUnit");
                                if (string2 != null) {
                                    cSSNumber.setAsString(string2);
                                    cSSCurrData.m_minAcctUnit = cSSNumber.getValue();
                                    string2 = cSSPropertySet2.getProperty("bEuro");
                                    if (string2 != null) {
                                        cSSCurrData.m_bEuro = Integer.parseInt(string2) != 0;
                                        this.m_currData.put(string3, cSSCurrData);
                                        cSSCurrData = null;
                                        continue;
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
                catch (CSSException cSSException) {
                    // empty catch block
                }
            }
            if (this.m_currData.isEmpty()) {
                this.m_currData.put("No Match", new CSSCurrData());
            }
        }
        return (CSSCurrData)this.m_currData.get(string);
    }

    public final String getDayOfWeek(int n) {
        return this.getDayOfWeek(n, false);
    }

    public String getDayOfWeek(int n, boolean bl) {
        if (this.m_shortDay.size() == 0) {
            this.m_shortDay.setSize(7);
            this.m_longDay.setSize(7);
            for (int i = 0; i < 7; ++i) {
                this.m_shortDay.setElementAt(this.getLocalString(this.shortDay[i]), i);
                this.m_longDay.setElementAt(this.getLocalString(this.longDay[i]), i);
            }
        }
        if (bl) {
            return (String)this.m_shortDay.elementAt(n);
        }
        return (String)this.m_longDay.elementAt(n);
    }

    public String getDispDateSeparator() {
        return this.m_dispDateSeparator;
    }

    public String getDispNumberDecimal() {
        return this.m_dispNumberDecimal.getValue();
    }

    public int getDispNumberScale() {
        return this.m_scale;
    }

    public String getDispNumberSeparator() {
        return this.m_dispNumberSeparator.getValue();
    }

    public String getDispTimeAM() {
        return this.m_dispTimeAM.getValue();
    }

    public String getDispTimePM() {
        return this.m_dispTimePM.getValue();
    }

    public String getDispTimeSeparator() {
        return this.m_dispTimeSeparator;
    }

    public double getExchangeRate(String string, String string2, CSSDate cSSDate) {
        int n;
        double d = 1.0;
        if (CSSUtilities.isEmpty(string) || CSSUtilities.isEmpty(string2) || string.equalsIgnoreCase(string2)) {
            return 1.0;
        }
        CSSDate cSSDate2 = new CSSDate(cSSDate);
        CSSCurrData cSSCurrData = null;
        Vector<CSSExchRate> vector = null;
        CSSExchRate cSSExchRate = null;
        if (cSSDate2.isNull()) {
            cSSDate2.setToToday();
        }
        if ((cSSCurrData = this.getCurrency(string)) == null) {
            return d;
        }
        vector = (Vector<CSSExchRate>)cSSCurrData.m_exchData.get(string2);
        if (vector == null) {
            vector = new Vector<CSSExchRate>();
            cSSCurrData.m_exchData.put(string2, vector);
        }
        for (n = 0; n < vector.size(); ++n) {
            cSSExchRate = (CSSExchRate)vector.elementAt(n);
            if (cSSDate2.getValue() > cSSExchRate.m_date2) break;
            if (cSSDate2.getValue() < cSSExchRate.m_date1) continue;
            d = cSSExchRate.m_rate;
            return d;
        }
        CSSDate cSSDate3 = new CSSDate(this);
        CSSNumber cSSNumber = new CSSNumber(this);
        ArgList argList = new ArgList();
        argList.addArg("from", new ArgSpec(string));
        argList.addArg("to", new ArgSpec(string2));
        String string3 = cSSDate2.getAsString();
        argList.addArg("date", new ArgSpec(string3));
        try {
            argList = this.sendReceive(8, argList);
        }
        catch (CSSException cSSException) {
            return d;
        }
        ArgSpec argSpec = argList.getArg("rate");
        if (argSpec == null) {
            return d;
        }
        try {
            cSSNumber.setAsString(argSpec.getString());
        }
        catch (CSSException cSSException) {
            return d;
        }
        d = cSSNumber.getValue();
        argSpec = argList.getArg("date1");
        if (argSpec == null) {
            return d;
        }
        try {
            cSSNumber.setAsString(argSpec.getString());
        }
        catch (CSSException cSSException) {
            return d;
        }
        cSSExchRate = new CSSExchRate();
        cSSExchRate.m_date1 = cSSDate3.getValue();
        cSSExchRate.m_date2 = cSSDate2.getValue();
        cSSExchRate.m_rate = d;
        vector.insertElementAt(cSSExchRate, n);
        return d;
    }

    public String getFuncCurrCode() {
        if (!CSSUtilities.isEmpty(this.m_currencyCode)) {
            return this.m_currencyCode;
        }
        ArgList argList = new ArgList();
        try {
            argList = this.sendReceive(7, argList);
            ArgSpec argSpec = argList.getArg("currencyCode");
            this.m_currencyCode = argSpec.getString();
        }
        catch (CSSException cSSException) {
            return "";
        }
        return this.m_currencyCode;
    }

    public final String getMonth(int n) {
        return this.getMonth(n, false);
    }

    public String getMonth(int n, boolean bl) {
        if (this.m_shortMonth.size() == 0) {
            this.m_shortMonth.setSize(12);
            this.m_longMonth.setSize(12);
            for (int i = 0; i < 12; ++i) {
                this.m_shortMonth.setElementAt(this.getLocalString(this.shortMonth[i]), i);
                this.m_longMonth.setElementAt(this.getLocalString(this.longMonth[i]), i);
            }
        }
        if (bl) {
            return (String)this.m_shortMonth.elementAt(n - 1);
        }
        return (String)this.m_longMonth.elementAt(n - 1);
    }

    public int getPhoneCountry() {
        return this.m_phoneCountry;
    }

    public String getPhoneFormat(String string, CSSStringRef cSSStringRef, CSSStringRef cSSStringRef2) {
        String string2;
        String string3 = string;
        if (this.m_phoneFormat.isEmpty()) {
            ArgList argList = new ArgList();
            try {
                argList = this.sendReceive(9, argList);
                CSSPropertySet cSSPropertySet = CSSModel.argListToPropertySet("", argList);
                Enumeration enumeration = cSSPropertySet.enumPropertyKeys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    String string4 = cSSPropertySet.getProperty(string2);
                    this.m_phoneFormat.put(string2, string4);
                    if (this.m_phoneCountryMaxLen >= string2.length()) continue;
                    this.m_phoneCountryMaxLen = string2.length();
                }
            }
            catch (CSSException cSSException) {
                // empty catch block
            }
            if (this.m_phoneFormat.isEmpty()) {
                this.m_phoneFormat.put("No Match", "");
            }
        }
        if (!CSSUtilities.isEmpty(string3)) {
            if (string3.charAt(0) != '+') {
                cSSStringRef.setValue(this.getProfile(18));
                string2 = (String)this.m_phoneFormat.get(cSSStringRef.toString());
                if (string2 != null) {
                    cSSStringRef2.setValue(string2);
                    return string3;
                }
            } else {
                for (int i = 2; i <= this.m_phoneCountryMaxLen && i <= string3.length(); ++i) {
                    cSSStringRef.setValue(string3.substring(0, i));
                    string2 = (String)this.m_phoneFormat.get(cSSStringRef.toString());
                    if (string2 == null) continue;
                    cSSStringRef2.setValue(string2);
                    string3 = string3.substring(cSSStringRef.toString().length());
                    return string3;
                }
            }
        }
        cSSStringRef.setValue("");
        cSSStringRef2.setValue("");
        return string3;
    }

    public String getProfile(int n) {
        return CSSUtilities.isEmpty((String)this.m_profile.elementAt(n)) ? this.loadProfile(n) : (String)this.m_profile.elementAt(n);
    }

    public void reset() {
        this.empty();
    }

    private void empty() {
        this.m_currData.clear();
        this.m_phoneFormat.clear();
        this.m_phoneCountryMaxLen = 0;
        this.m_currencyCode = "";
    }

    private String loadProfile(int n) {
        String string = "";
        String string2 = "";
        String string3 = "";
        CSSString cSSString = new CSSString(this);
        switch (n) {
            case 10: {
                this.m_scale = CSSLocale.getProfileInt("Intl", "iDigits", 5);
                break;
            }
            case 0: {
                string = "###,###,###,###,##";
                string = string + (CSSLocale.getProfileInt("Intl", "iLzero", 1) != 0 ? "0." : "#.");
                for (int i = 0; i < this.m_scale; ++i) {
                    string = string + '#';
                }
                break;
            }
            case 1: {
                string = "###,###,###,###,##0";
                break;
            }
            case 2: {
                string = this.getProfile(3) + " " + this.getProfile(4);
                break;
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(CSSLocale.getProfileString("Intl", "sShortDate", "MM/DD/YY"));
                block39: for (int i = 0; i < stringBuffer.length(); ++i) {
                    switch (stringBuffer.charAt(i)) {
                        case 'y': {
                            stringBuffer.setCharAt(i, 'Y');
                            continue block39;
                        }
                        case 'm': {
                            stringBuffer.setCharAt(i, 'M');
                            continue block39;
                        }
                        case 'd': {
                            stringBuffer.setCharAt(i, 'D');
                        }
                    }
                }
                string = stringBuffer.toString();
                break;
            }
            case 4: 
            case 5: {
                boolean bl = CSSLocale.getProfileInt("Intl", "iTime", 0) != 0;
                String string4 = string = bl ? "H" : "h";
                if (CSSLocale.getProfileInt("Intl", "iTLZero", 0) != 0) {
                    string = string + string;
                }
                string = string + ":mm";
                if (n == 4) {
                    string = string + ":ss";
                }
                if (bl) break;
                string = string + " p";
                break;
            }
            case 6: {
                string = "###,###,###,###,##0.";
                switch (CSSLocale.getProfileInt("Intl", "iCurrency", 0)) {
                    case 0: {
                        string2 = "$";
                        break;
                    }
                    case 1: {
                        string2 = "$";
                        break;
                    }
                    case 2: {
                        string2 = "$ ";
                        break;
                    }
                    case 3: {
                        string2 = " $";
                    }
                }
                switch (CSSLocale.getProfileInt("Intl", "iNegCurr", 0)) {
                    case 0: 
                    case 4: {
                        string2 = "(" + string2;
                        string3 = string3 + ")";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: 
                    case 9: {
                        string2 = "-" + string2;
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 10: {
                        string3 = string3 + "-";
                        break;
                    }
                    case 2: {
                        string2 = string2 + "-";
                        break;
                    }
                    case 6: {
                        string3 = "-" + string3;
                    }
                }
                string = string2 + string + string3;
                break;
            }
            case 11: {
                string = CSSLocale.getProfileString("Intl", "sThousand", ",");
                this.m_dispNumberSeparator.setValue(string);
                break;
            }
            case 12: {
                string = CSSLocale.getProfileString("Intl", "sDecimal", ".");
                this.m_dispNumberDecimal.setValue(string);
                break;
            }
            case 13: {
                this.getCurrency("");
                string = this.m_currency;
                break;
            }
            case 14: {
                this.m_dispDateSeparator = string = CSSLocale.getProfileString("Intl", "sDate", "/");
                break;
            }
            case 15: {
                this.m_dispTimeSeparator = string = CSSLocale.getProfileString("Intl", "sTime", ":");
                break;
            }
            case 16: {
                string = CSSLocale.getProfileString("Intl", "s1159", "AM");
                this.m_dispTimeAM.setValue(string);
                break;
            }
            case 17: {
                string = CSSLocale.getProfileString("Intl", "s2359", "PM");
                this.m_dispTimePM.setValue(string);
                break;
            }
            case 7: {
                CSSStringRef cSSStringRef = new CSSStringRef();
                CSSStringRef cSSStringRef2 = new CSSStringRef();
                this.getPhoneFormat(this.getProfile(18), cSSStringRef, cSSStringRef2);
                string2 = cSSStringRef.toString();
                string = cSSStringRef2.toString();
                break;
            }
            case 8: {
                string = this.getLocalString(7717967);
                break;
            }
            case 9: {
                string = this.getLocalString(7717968);
                break;
            }
            case 18: {
                this.m_phoneCountry = CSSLocale.getProfileInt("Intl", "iCountry", 1);
                if (this.m_phoneCountry == 2) {
                    this.m_phoneCountry = 1;
                }
                cSSString.setValue(this.m_phoneCountry);
                string = "+" + cSSString.getValue();
            }
        }
        this.m_profile.setElementAt(string, n);
        return (String)this.m_profile.elementAt(n);
    }

    public static final CSSPropertySet createLocaleProfile() {
        CSSPropertySet cSSPropertySet = new CSSPropertySet("");
        String string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iDigits", 5));
        cSSPropertySet.addProperty("Intl iDigits", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iLzero", 1));
        cSSPropertySet.addProperty("Intl iLzero", string);
        string = CSSLocale.getProfileString("Intl", "sShortDate", "MM/DD/YY");
        cSSPropertySet.addProperty("Intl sShortDate", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iTime", 0));
        cSSPropertySet.addProperty("Intl iTime", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iTLZero", 0));
        cSSPropertySet.addProperty("Intl iTLZero", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iCurrency", 0));
        cSSPropertySet.addProperty("Intl iCurrency", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iNegCurr", 0));
        cSSPropertySet.addProperty("Intl iNegCurr", string);
        string = CSSLocale.getProfileString("Intl", "sThousand", ",");
        cSSPropertySet.addProperty("Intl sThousand", string);
        string = CSSLocale.getProfileString("Intl", "sDecimal", ".");
        cSSPropertySet.addProperty("Intl sDecimal", string);
        string = CSSLocale.getProfileString("Intl", "sDate", "/");
        cSSPropertySet.addProperty("Intl sDate", string);
        string = CSSLocale.getProfileString("Intl", "sTime", ":");
        cSSPropertySet.addProperty("Intl sTime", string);
        string = CSSLocale.getProfileString("Intl", "s1159", "AM");
        cSSPropertySet.addProperty("Intl s1159", string);
        string = CSSLocale.getProfileString("Intl", "s2359", "PM");
        cSSPropertySet.addProperty("Intl s2359", string);
        string = CSSUtilities.itoa(CSSLocale.getProfileInt("Intl", "iCountry", 1));
        cSSPropertySet.addProperty("Intl iCountry", string);
        string = CSSLocale.getProfileString("Intl", "sCountry", "");
        cSSPropertySet.addProperty("Intl sCountry", string);
        string = CSSLocale.getProfileString("Intl", "sCurrency", "");
        cSSPropertySet.addProperty("Intl sCurrency", string);
        return cSSPropertySet;
    }

    private static final int getProfileInt(String string, String string2, int n) {
        if (string.equalsIgnoreCase("Intl")) {
            if (string2.equalsIgnoreCase("iDigits")) {
                String string3;
                Hashtable hashtable = CSSSystem.getCfgSection("Siebel");
                if (hashtable != null && (string3 = (String)hashtable.get("DecimalNumberScale")) != null) {
                    return Integer.parseInt(string3);
                }
                return NumberFormat.getNumberInstance().getMaximumFractionDigits();
            }
            if (string2.equalsIgnoreCase("iLzero")) {
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(((DecimalFormat)NumberFormat.getNumberInstance()).toPattern());
                int n2 = 0;
                char c = stringCharacterIterator.first();
                while (c != '\uffff') {
                    switch (c) {
                        case '0': {
                            n2 = 1;
                        }
                        case '.': {
                            return n2;
                        }
                    }
                    c = stringCharacterIterator.next();
                }
                return n2;
            }
            if (string2.equalsIgnoreCase("iTime")) {
                String string4 = ((SimpleDateFormat)DateFormat.getTimeInstance(3)).toPattern();
                if (string4.indexOf(72) == -1 && string4.indexOf(107) == -1) {
                    return 0;
                }
                return 1;
            }
            if (string2.equalsIgnoreCase("iTLZero")) {
                String string5 = ((SimpleDateFormat)DateFormat.getTimeInstance(3)).toPattern();
                if (CSSLocale.countChar(string5, 'h') > 1 || CSSLocale.countChar(string5, 'H') > 1 || CSSLocale.countChar(string5, 'k') > 1 || CSSLocale.countChar(string5, 'K') > 1) {
                    return 1;
                }
                return 0;
            }
            if (string2.equalsIgnoreCase("iCurrency")) {
                boolean bl;
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
                String string6 = decimalFormat.getPositivePrefix();
                String string7 = decimalFormat.getPositiveSuffix();
                boolean bl2 = string6 != null && string6.length() != 0;
                boolean bl3 = string7 != null && string7.length() != 0;
                boolean bl4 = bl2 && string6.charAt(string6.length() - 1) == ' ';
                boolean bl5 = bl = bl3 && string7.charAt(0) == ' ';
                if (bl2 && !bl3) {
                    if (!bl4) {
                        return 0;
                    }
                    return 2;
                }
                if (!bl2 && bl3) {
                    if (bl) {
                        return 1;
                    }
                    return 3;
                }
            } else if (string2.equalsIgnoreCase("iNegCurr")) {
                boolean bl;
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
                String string8 = decimalFormat.getNegativePrefix();
                String string9 = decimalFormat.getNegativeSuffix();
                boolean bl6 = string8 != null && string8.length() != 0;
                boolean bl7 = string9 != null && string9.length() != 0;
                boolean bl8 = bl6 && bl7 && string8.charAt(0) == '(' && string9.charAt(string9.length() - 1) == ')';
                boolean bl9 = bl8 && string8.length() == 1;
                boolean bl10 = bl6 && string8.indexOf(32) != -1;
                boolean bl11 = bl7 && string9.indexOf(32) != -1;
                boolean bl12 = bl10 || bl11;
                boolean bl13 = bl6 && string8.charAt(0) == '-';
                boolean bl14 = bl6 && string8.charAt(string8.length() - 1) == '-';
                boolean bl15 = bl7 && string9.charAt(0) == '-';
                boolean bl16 = bl = bl7 && string9.charAt(string9.length() - 1) == '-';
                if (bl8 && !bl9 && !bl12) {
                    return 0;
                }
                if (bl13 && !bl7 && !bl12) {
                    return 1;
                }
                if (bl14 && !bl7 && !bl12) {
                    return 2;
                }
                if (bl6 && bl15 && !bl12) {
                    return 3;
                }
                if (bl8 && bl9 && !bl12) {
                    return 4;
                }
                if (bl13 && bl7 && !bl12) {
                    return 5;
                }
                if (!bl6 && bl15 && !bl12) {
                    return 6;
                }
                if (!bl6 && bl && !bl12) {
                    return 7;
                }
                if (bl13 && bl11) {
                    return 8;
                }
                if (bl13 && bl10 && !bl7) {
                    return 9;
                }
                if (!bl6 && bl11 && bl) {
                    return 10;
                }
                if (bl10 && bl15) {
                    return 11;
                }
                if (bl10 && bl14 && !bl7) {
                    return 12;
                }
                if (!bl6 && bl11 && bl15) {
                    return 13;
                }
                if (bl8 && bl10) {
                    return 14;
                }
                if (bl8 && bl11) {
                    return 15;
                }
            } else if (string2.equalsIgnoreCase("iCountry")) {
                // empty if block
            }
        }
        return n;
    }

    private static final String getProfileString(String string, String string2, String string3) {
        if (string.equalsIgnoreCase("Intl")) {
            if (string2.equalsIgnoreCase("sShortDate")) {
                int n;
                String string4;
                String string5 = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
                Hashtable hashtable = CSSSystem.getCfgSection("Siebel");
                if (hashtable != null && (string4 = (String)hashtable.get("DateYearFormat")) != null && (n = string5.indexOf(121)) != -1) {
                    String string6 = string5.substring(0, n);
                    String string7 = "";
                    n = string5.lastIndexOf(121);
                    if (n != -1) {
                        string7 = string5.substring(n + 1, string5.length());
                    }
                    for (n = 0; n < string4.length(); ++n) {
                        switch (string4.charAt(n)) {
                            case 'Y': 
                            case 'y': {
                                string6 = string6 + 'y';
                            }
                        }
                    }
                    return string6 + string7;
                }
                return CSSLocale.replaceSeparator(string5, "dDyYmM", "/");
            }
            if (string2.equalsIgnoreCase("sThousand")) {
                return String.valueOf(((DecimalFormat)NumberFormat.getNumberInstance()).getDecimalFormatSymbols().getGroupingSeparator());
            }
            if (string2.equalsIgnoreCase("sDecimal")) {
                return String.valueOf(((DecimalFormat)NumberFormat.getNumberInstance()).getDecimalFormatSymbols().getDecimalSeparator());
            }
            if (string2.equalsIgnoreCase("sDate")) {
                String string8 = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
                return CSSLocale.getSeparator(string8, "dMy'", "/");
            }
            if (string2.equalsIgnoreCase("sTime")) {
                String string9 = ((SimpleDateFormat)DateFormat.getTimeInstance(3)).toPattern();
                return CSSLocale.getSeparator(string9, "hHkKma'", ":");
            }
            if (string2.equalsIgnoreCase("s1159")) {
                DateFormatSymbols dateFormatSymbols = ((SimpleDateFormat)DateFormat.getDateInstance(3)).getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (stringArray != null && stringArray.length > 1) {
                    return stringArray[0];
                }
            } else if (string2.equalsIgnoreCase("s2359")) {
                DateFormatSymbols dateFormatSymbols = ((SimpleDateFormat)DateFormat.getDateInstance(3)).getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (stringArray != null && stringArray.length > 1) {
                    return stringArray[1];
                }
            } else if (string2.equalsIgnoreCase("sCountry")) {
                return Locale.getDefault().getDisplayCountry();
            }
        }
        return string3;
    }

    private static String getSeparator(String string, String string2, String string3) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) < 0) continue;
            for (int j = i + 1; j < string.length(); ++j) {
                if (c == string.charAt(j)) continue;
                for (int k = j; k < string.length(); ++k) {
                    if (string2.indexOf(string.charAt(k)) < 0) continue;
                    return new String(string.substring(j, k));
                }
            }
        }
        return string3;
    }

    private static String replaceSeparator(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("");
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) == -1) {
                stringBuffer.append(string3);
                ++i;
                while (i < string.length()) {
                    c = string.charAt(i);
                    if (string2.indexOf(c) >= 0) {
                        stringBuffer.append(c);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static final int countChar(String string, char c) {
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            ++n;
            n2 = string.indexOf(c, n2 + 1);
        }
        return n;
    }

    private final String getLocalString(int n) {
        return CSSMsgMgr.get(n);
    }

    private ArgList sendReceive(int n, ArgList argList) throws CSSException {
        return this.m_model.sendReceive(n, argList, 0, 0, null);
    }
}

