/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.om;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSHashtable;
import com.siebel.common.common.CSSPropertySet;
import com.siebel.common.common.CSSUtilities;
import com.siebel.common.common.objdef.CSSBitmapCategoryDef;
import com.siebel.common.common.objdef.CSSBitmapDef;
import com.siebel.common.common.objdef.CSSClassDef;
import com.siebel.common.common.objdef.CSSCommandDef;
import com.siebel.common.common.objdef.CSSFindDef;
import com.siebel.common.common.objdef.CSSMenuDef;
import com.siebel.common.common.objdef.CSSPageTabDef;
import com.siebel.common.common.objdef.CSSScreenMenuDef;
import com.siebel.common.common.objdef.CSSServiceDef;
import com.siebel.common.common.objdef.CSSToolbarDef;
import com.siebel.common.common.objdef.CSSUdfFrame;
import com.siebel.common.common.objdef.CSSUdfScreen;
import com.siebel.common.common.objdef.CSSUdfView;
import com.siebel.common.common.objdef.CSSViewMenuDef;
import com.siebel.debug.SiebelDebug;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.ConnectionManager;
import com.siebel.om.conmgr.SessionHandle;
import com.siebel.om.conmgr.Transaction;
import com.siebel.om.om.CSSBusComp;
import com.siebel.om.om.CSSBusObj;
import com.siebel.om.om.CSSIBusObj;
import com.siebel.om.om.CSSIModel;
import com.siebel.om.om.CSSIService;
import com.siebel.om.om.CSSLocale;
import com.siebel.om.om.CSSService;
import com.siebel.om.sisnapi.ArgList;
import com.siebel.om.sisnapi.ArgSpec;
import com.siebel.om.sisnapi.FieldSpec;
import com.siebel.om.sisnapi.LogoffRequest;
import com.siebel.om.sisnapi.LogonACK;
import com.siebel.om.sisnapi.LogonRequest;
import com.siebel.om.sisnapi.OMRPCACK;
import com.siebel.om.sisnapi.OMRPCRequest;
import com.siebel.om.sisnapi.ObjectDef;
import com.siebel.om.sisnapi.ObjectSpec;
import com.siebel.om.sisnapi.Request;
import com.siebel.om.sisnapi.SessCloseReq;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class CSSModel
implements CSSIModel {
    public static final String file_id = "/v65/src/com/siebel/om/om/CSSModel.java";
    private boolean m_bFindDefsRetrieved;
    private boolean m_bLoggedIn;
    private boolean m_bPrefsDirty;
    private boolean m_bPrefsUserDirty;
    private boolean m_bInited;
    private boolean m_bSetup;
    private boolean m_bAttach;
    private CSSMenuDef m_appMenuDef;
    private Vector m_busObjArray;
    private String m_currencyCode;
    private Vector m_fieldArray;
    private Vector m_findDefArray;
    private String m_language;
    private Hashtable m_licensedModuleMap;
    private String m_loginId;
    private String m_loginName;
    private String m_lovLanguage;
    private Hashtable m_lovTypeNameMap;
    private Hashtable m_objectDefs;
    private String m_positionId;
    private String m_positionName;
    private CSSPropertySet m_prefs;
    private CSSPropertySet m_productConfig;
    private String m_schemaVersion;
    private String m_serverVersion;
    private Vector m_serviceArray;
    private Properties m_viewAccessMap;
    private CSSLocale m_locale;
    private ConnectionManager s_cm;
    private SessionHandle m_sHandle;
    private Transaction m_tx = new Transaction();

    public CSSModel() {
        SiebelDebug.printEntry(file_id, "CSSModel()");
        this.nullifyMem();
        this.initMem();
        SiebelDebug.printExit(file_id, "CSSModel()");
    }

    private void nullifyMem() {
        this.m_bInited = false;
        this.m_bSetup = false;
        this.m_bFindDefsRetrieved = false;
        this.m_bLoggedIn = false;
        this.m_bPrefsDirty = false;
        this.m_bPrefsUserDirty = false;
        this.m_bAttach = false;
        this.m_appMenuDef = null;
        this.m_currencyCode = null;
        this.m_language = null;
        this.m_objectDefs = null;
        this.m_prefs = null;
        this.m_productConfig = null;
        this.m_schemaVersion = null;
        this.m_serverVersion = null;
        this.m_loginId = null;
        this.m_locale = null;
        this.m_loginName = null;
        this.m_serviceArray = null;
        this.m_viewAccessMap = null;
        this.m_busObjArray = null;
        this.m_fieldArray = null;
        this.m_findDefArray = null;
        this.m_lovTypeNameMap = null;
        this.m_licensedModuleMap = null;
        this.m_positionId = null;
        this.m_positionName = null;
    }

    private void initMem() {
        if (this.m_serviceArray == null) {
            this.m_serviceArray = new Vector();
        }
        if (this.m_viewAccessMap == null) {
            this.m_viewAccessMap = new Properties();
        }
        if (this.m_busObjArray == null) {
            this.m_busObjArray = new Vector();
        }
        if (this.m_fieldArray == null) {
            this.m_fieldArray = new Vector();
        }
        if (this.m_findDefArray == null) {
            this.m_findDefArray = new Vector();
        }
        if (this.m_lovTypeNameMap == null) {
            this.m_lovTypeNameMap = new Hashtable();
        }
    }

    public void addField(FieldSpec fieldSpec) {
        this.m_fieldArray.addElement(fieldSpec);
    }

    protected static CSSPropertySet argListToPropertySet(String string, ArgList argList) throws CSSException {
        String string2;
        CSSPropertySet cSSPropertySet = new CSSPropertySet(string);
        ArgSpec argSpec = argList.getArg("type");
        if (argSpec != null && (string2 = argSpec.getString()) != null) {
            cSSPropertySet.setType(string2);
        }
        Enumeration enumeration = argList.enumArgNames();
        while (enumeration.hasMoreElements()) {
            String string3;
            Enumeration enumeration2;
            String string4 = (String)enumeration.nextElement();
            argSpec = argList.getArg(string4);
            if (string4.equalsIgnoreCase("propArray")) {
                ArgList argList2 = argSpec.getArgList();
                enumeration2 = argList2.enumArgNames();
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    string2 = argList2.getArg(string3).getString();
                    cSSPropertySet.addProperty(string3, string2);
                }
                continue;
            }
            if (!string4.equalsIgnoreCase("subsetArray")) continue;
            ArgList argList3 = argSpec.getArgList();
            enumeration2 = argList3.enumArgNames();
            while (enumeration2.hasMoreElements()) {
                string3 = (String)enumeration2.nextElement();
                ArgList argList4 = argList3.getArg(string3).getArgList();
                cSSPropertySet.addSubset(CSSModel.argListToPropertySet(string3, argList4));
            }
        }
        return cSSPropertySet;
    }

    @Override
    public CSSIBusObj beginSetupView(String string, CSSIBusObj cSSIBusObj, boolean bl, boolean bl2) throws CSSException {
        ArgSpec argSpec;
        ArgList argList = new ArgList();
        CSSBusObj cSSBusObj = null;
        int n = 0;
        String[] stringArray = null;
        argList.addArg("viewName", new ArgSpec(string));
        argList.addArg("bGetNewBusObj", new ArgSpec(bl));
        argList.addArg("bAdmin", new ArgSpec(bl2));
        if (!bl) {
            cSSBusObj = (CSSBusObj)cSSIBusObj;
            n = cSSBusObj.m_sisBusObjId;
        }
        argList = this.sendReceive(3, argList, 5, n, null);
        if (bl) {
            n = argList.getArg("busObjId").getInt();
            String string2 = argList.getArg("busObjName").getString();
            cSSBusObj = new CSSBusObj(this, string2, n);
            cSSIBusObj = cSSBusObj;
        }
        ObjectSpec[] objectSpecArray = argList.getArg("busCompList").getObjectList();
        ArgList argList2 = argList.getArg("fieldIndexList").getArgList();
        ArgList argList3 = argList.getArg("newFieldList").getArgList();
        ArgList argList4 = argList.getArg("userPropNameList").getArgList();
        ArgList argList5 = argList.getArg("userPropValueList").getArgList();
        for (int i = 0; i < objectSpecArray.length; ++i) {
            String string3 = objectSpecArray[i].getName();
            int n2 = objectSpecArray[i].getId();
            CSSBusComp cSSBusComp = (CSSBusComp)cSSIBusObj.isBusCompLoaded(string3);
            if (cSSBusComp != null) {
                if (cSSBusComp.m_sisBusCompId == n2) continue;
                throw new CSSException(65535);
            }
            String[] stringArray2 = argList2.getArg(string3).getValues();
            argSpec = argList3.getArg(string3);
            FieldSpec[] fieldSpecArray = argSpec != null ? argSpec.getFieldList() : null;
            argSpec = argList4.getArg2(string3);
            stringArray = argSpec != null ? argSpec.getValues() : null;
            String[] stringArray3 = stringArray != null ? argList5.getArg(string3).getValues() : null;
            cSSBusComp = new CSSBusComp(string3, 0, this, (CSSBusObj)cSSIBusObj, n2, stringArray2, fieldSpecArray);
            ((CSSBusObj)cSSIBusObj).addBusComp(cSSBusComp);
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                cSSBusComp.m_userPropMap.put(stringArray[j], stringArray3[j]);
            }
        }
        argSpec = argList.getArg2("notifyList");
        if (argSpec != null) {
            cSSBusObj.processNotifyList(argSpec.getNotifyList());
        }
        return cSSIBusObj;
    }

    private CSSPropertySet createLocaleProfile() {
        return CSSLocale.createLocaleProfile();
    }

    private void deleteObject() {
        this.m_objectDefs = null;
        this.m_fieldArray = null;
        this.m_findDefArray = null;
        this.m_lovTypeNameMap = null;
        this.empty();
    }

    protected void empty() {
        while (!this.m_busObjArray.isEmpty()) {
            CSSBusObj cSSBusObj = (CSSBusObj)this.m_busObjArray.elementAt(0);
            if (cSSBusObj != null) {
                cSSBusObj.deleteObject();
            }
            this.m_busObjArray.removeElement(cSSBusObj);
        }
        this.m_busObjArray.removeAllElements();
        while (!this.m_serviceArray.isEmpty()) {
            CSSIService cSSIService = (CSSIService)this.m_serviceArray.elementAt(0);
            if (cSSIService != null) {
                cSSIService.deleteObject();
            }
            this.m_serviceArray.removeElement(cSSIService);
        }
        this.m_serviceArray.removeAllElements();
        this.m_productConfig = null;
        this.m_prefs = null;
    }

    @Override
    public void emptyLOVCache() {
        if (this.m_lovTypeNameMap != null) {
            this.m_lovTypeNameMap.clear();
        }
    }

    @Override
    public void emptyCurrencyCache() {
        if (this.m_locale != null) {
            this.m_locale.reset();
        }
    }

    @Override
    public void endSetupView(CSSIBusObj cSSIBusObj, String string, CSSPropertySet cSSPropertySet, CSSPropertySet cSSPropertySet2, String string2, String string3, String string4, int n, boolean bl, String string5, Vector vector, String[] stringArray, boolean[] blArray) throws CSSException {
        ArgList argList = new ArgList();
        ArgList argList2 = null;
        ArgList argList3 = null;
        vector.removeAllElements();
        CSSBusObj cSSBusObj = (CSSBusObj)cSSIBusObj;
        if (cSSPropertySet != null) {
            argList3 = CSSModel.propertySetToArgList(cSSPropertySet);
        }
        if (cSSPropertySet2 != null) {
            argList2 = CSSModel.propertySetToArgList(cSSPropertySet2);
        }
        argList.addArg("viewName", new ArgSpec(string));
        argList.addArg("boBookmarkPropSet", new ArgSpec(argList3));
        argList.addArg("bcBookmarkPropSet", new ArgSpec(argList2));
        argList.addArg("busCompName", new ArgSpec(string2));
        argList.addArg("drillDownField", new ArgSpec(string3));
        argList.addArg("drillDownValue", new ArgSpec(string4));
        argList.addArg("drillDownViewMode", new ArgSpec(n));
        argList.addArg("bSetQuery", new ArgSpec(bl));
        argList.addArg("defaultQuery", new ArgSpec(string5));
        argList = this.sendReceive(4, argList, 5, cSSBusObj.m_sisBusObjId, null);
        String[] stringArray2 = argList.getArg("queryList").getValues();
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.addElement(stringArray2[i]);
        }
        stringArray[0] = argList.getArg("selectedQuery").getString();
        blArray[0] = argList.getArg("bHasQueryList").getBool();
        ArgSpec argSpec = argList.getArg2("notifyList");
        if (argSpec != null) {
            cSSBusObj.processNotifyList(argSpec.getNotifyList());
        }
    }

    @Override
    public Enumeration enumFindDefs() {
        try {
            this.loadFindDefs();
        }
        catch (CSSException cSSException) {
            return null;
        }
        return this.m_findDefArray.elements();
    }

    @Override
    public Enumeration enumMenuScreens() throws CSSException {
        this.initStartupState();
        Vector vector = (Vector)this.m_objectDefs.get("ScreenMenuName");
        return vector.elements();
    }

    @Override
    public Enumeration enumPageTabDefs() throws CSSException {
        this.initStartupState();
        Vector vector = (Vector)this.m_objectDefs.get("PageTab");
        return vector.elements();
    }

    @Override
    public Enumeration enumToolbarDefs() throws CSSException {
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Toolbar");
        return hashtable.elements();
    }

    @Override
    public CSSIService findService(String string) {
        for (int i = 0; i < this.m_serviceArray.size(); ++i) {
            CSSIService cSSIService = (CSSIService)this.m_serviceArray.elementAt(i);
            if (!cSSIService.getName().equalsIgnoreCase(string)) continue;
            return cSSIService;
        }
        return null;
    }

    @Override
    public String[] getAccessibleViews(String string) throws CSSException {
        Object[] objectArray = null;
        CSSScreenMenuDef cSSScreenMenuDef = this.getScreenMenuDef(string);
        if (cSSScreenMenuDef != null) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < cSSScreenMenuDef.m_viewMenuDefArray.size(); ++i) {
                CSSViewMenuDef cSSViewMenuDef = (CSSViewMenuDef)cSSScreenMenuDef.m_viewMenuDefArray.elementAt(i);
                if (!this.isViewAccessible(cSSViewMenuDef.m_name)) continue;
                vector.addElement(cSSViewMenuDef.m_name);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSUdfFrame getAppletDef(String string) throws CSSException {
        Hashtable hashtable;
        this.initStartupState();
        Hashtable hashtable2 = hashtable = (Hashtable)this.m_objectDefs.get("Applet");
        synchronized (hashtable2) {
            if (hashtable.containsKey(string)) {
                return (CSSUdfFrame)hashtable.get(string);
            }
            this.getObjectDef("Applet", string);
            return (CSSUdfFrame)hashtable.get(string);
        }
    }

    @Override
    public CSSMenuDef getAppMenuDef() throws CSSException {
        this.initStartupState();
        return this.m_appMenuDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSBitmapCategoryDef getBitmapCategoryDef(String string) throws CSSException {
        Hashtable hashtable;
        this.initStartupState();
        Hashtable hashtable2 = hashtable = (Hashtable)this.m_objectDefs.get("BitmapCategory");
        synchronized (hashtable2) {
            if (hashtable.containsKey(string)) {
                return (CSSBitmapCategoryDef)hashtable.get(string);
            }
            this.getObjectDef("BitmapCategory", string);
            return (CSSBitmapCategoryDef)hashtable.get(string);
        }
    }

    @Override
    public byte[] getBitmapData(CSSBitmapDef cSSBitmapDef, int[] nArray) {
        nArray[0] = cSSBitmapDef.m_len;
        return cSSBitmapDef.m_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSBitmapDef getBitmapDef(String string) throws CSSException {
        CSSHashtable cSSHashtable;
        this.initStartupState();
        CSSHashtable cSSHashtable2 = cSSHashtable = (CSSHashtable)this.m_objectDefs.get("Bitmap");
        synchronized (cSSHashtable2) {
            if (cSSHashtable.containsKey(string)) {
                return (CSSBitmapDef)cSSHashtable.get(string);
            }
            try {
                this.getObjectDef("Bitmap", string);
            }
            catch (CSSException cSSException) {
                return null;
            }
            if (cSSHashtable.containsKey(string)) {
                return (CSSBitmapDef)cSSHashtable.get(string);
            }
        }
        return null;
    }

    @Override
    public CSSIBusObj getBusObj(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("busObjName", new ArgSpec(string));
        argList = this.sendReceive(1, argList, 5, 0, null);
        int n = argList.getArg("busObjId").getInt();
        CSSBusObj cSSBusObj = new CSSBusObj(this, string, n);
        this.m_busObjArray.addElement(cSSBusObj);
        return cSSBusObj;
    }

    @Override
    public CSSCommandDef getCommandDef(String string) throws CSSException {
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Command");
        CSSCommandDef cSSCommandDef = (CSSCommandDef)hashtable.get(string);
        if (cSSCommandDef == null) {
            throw new CSSException(65535);
        }
        return cSSCommandDef;
    }

    @Override
    public String getConfigProp(String string) throws CSSException {
        this.initStartupState();
        return this.m_productConfig.getProperty(string);
    }

    @Override
    public String getCurrencyCode() throws CSSException {
        if (this.m_currencyCode == null) {
            this.initStartupState();
        }
        return this.m_currencyCode;
    }

    @Override
    public String getDefaultFindName() {
        String string = null;
        String string2 = new String("");
        try {
            this.loadFindDefs();
        }
        catch (CSSException cSSException) {
            return new String("");
        }
        for (int i = 0; i < this.m_findDefArray.size(); ++i) {
            CSSFindDef cSSFindDef = (CSSFindDef)this.m_findDefArray.elementAt(i);
            if (i == 0) {
                string2 = cSSFindDef.m_name;
            }
            if (!cSSFindDef.m_bDefaultFind) continue;
            string = cSSFindDef.m_name;
            break;
        }
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public FieldSpec getField(int n) {
        return (FieldSpec)this.m_fieldArray.elementAt(n);
    }

    @Override
    public void getFile(String string, String string2) throws CSSException, IOException {
        this.getFile(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFile(String string, String string2, boolean bl) throws CSSException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        try {
            boolean bl2 = true;
            while (bl2) {
                ArgList argList = new ArgList();
                argList.addArg("sourcePath", new ArgSpec(string));
                argList.addArg("bDeleteSource", new ArgSpec(bl));
                argList = this.sendReceive(11, argList);
                ArgSpec argSpec = argList.getArg2("more");
                if (argSpec == null) {
                    throw new CSSException(65535);
                }
                bl2 = argSpec.getBool();
                byte[] byArray = argList.getArg("data").getBytes();
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    @Override
    public CSSFindDef getFindDef(String string) {
        try {
            this.loadFindDefs();
        }
        catch (CSSException cSSException) {
            return null;
        }
        for (int i = 0; i < this.m_findDefArray.size(); ++i) {
            CSSFindDef cSSFindDef = (CSSFindDef)this.m_findDefArray.elementAt(i);
            if (cSSFindDef.m_name != string) continue;
            return cSSFindDef;
        }
        return null;
    }

    @Override
    public String getLanguage() throws CSSException {
        if (this.m_language != null) {
            this.initStartupState();
        }
        return this.m_language;
    }

    @Override
    public String getLoginId() throws CSSException {
        if (this.m_loginId == null) {
            this.initStartupState();
        }
        return this.m_loginId;
    }

    @Override
    public String getLoginName() throws CSSException {
        if (this.m_loginName == null) {
            this.initStartupState();
        }
        return this.m_loginName;
    }

    @Override
    public String getLovLanguage() {
        return this.m_lovLanguage;
    }

    @Override
    public String getLovNameVal(String string, String string2) throws CSSException {
        CSSHashtable cSSHashtable = (CSSHashtable)this.m_lovTypeNameMap.get(string2);
        if (cSSHashtable != null) {
            if (cSSHashtable.containsKey(string)) {
                return (String)cSSHashtable.get(string);
            }
        } else {
            cSSHashtable = new CSSHashtable();
            this.m_lovTypeNameMap.put(string2, cSSHashtable);
        }
        ArgList argList = new ArgList();
        argList.addArg("name", new ArgSpec(string));
        argList.addArg("type", new ArgSpec(string2));
        argList = this.sendReceive(503, argList, 0, 0, null);
        String string3 = argList.getArg("value").getString();
        cSSHashtable.put(string, string3);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getObjectDef(String string, String string2) throws CSSException {
        ArgList argList = new ArgList();
        this.initStartupState();
        argList.addArg("Type", new ArgSpec(string));
        argList.addArg("Name", new ArgSpec(string2));
        argList = this.sendReceive(2, argList);
        Enumeration enumeration = argList.enumArgVals();
        Enumeration enumeration2 = argList.enumArgNames();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable;
            Object object;
            ArgSpec argSpec = (ArgSpec)enumeration.nextElement();
            String string3 = (String)enumeration2.nextElement();
            ObjectDef objectDef = new ObjectDef(argSpec.getArgList());
            if (string3.equals("Applet")) {
                CSSUdfFrame cSSUdfFrame = new CSSUdfFrame(objectDef);
                Hashtable hashtable2 = (Hashtable)this.m_objectDefs.get("Applet");
                object = hashtable2;
                synchronized (object) {
                    hashtable2.put(cSSUdfFrame.m_name, cSSUdfFrame);
                    continue;
                }
            }
            if (string3.equals("Bitmap")) {
                String string4 = objectDef.name();
                string4 = string4.substring(0, string4.indexOf(46));
                CSSBitmapDef cSSBitmapDef = new CSSBitmapDef(objectDef);
                Hashtable hashtable3 = (Hashtable)this.m_objectDefs.get("Bitmap");
                object = hashtable3;
                synchronized (object) {
                    hashtable3.put(string4 + "." + cSSBitmapDef.m_name, cSSBitmapDef);
                    continue;
                }
            }
            if (string3.equals("BitmapCategory")) {
                CSSBitmapCategoryDef cSSBitmapCategoryDef = new CSSBitmapCategoryDef(objectDef);
                Hashtable hashtable4 = (Hashtable)this.m_objectDefs.get("BitmapCategory");
                object = hashtable4;
                synchronized (object) {
                    hashtable4.put(cSSBitmapCategoryDef.m_name, cSSBitmapCategoryDef);
                    continue;
                }
            }
            if (string3.equals("Class")) {
                CSSClassDef cSSClassDef = new CSSClassDef(objectDef);
                hashtable = (Hashtable)this.m_objectDefs.get("Class");
                object = hashtable;
                synchronized (object) {
                    hashtable.put(cSSClassDef.m_className, cSSClassDef);
                    continue;
                }
            }
            if (string3.equals("Screen")) {
                CSSUdfScreen cSSUdfScreen = new CSSUdfScreen(objectDef);
                Hashtable hashtable5 = (Hashtable)this.m_objectDefs.get("Screen");
                object = hashtable5;
                synchronized (object) {
                    hashtable5.put(cSSUdfScreen.m_name, cSSUdfScreen);
                    continue;
                }
            }
            if (string3.equals("View")) {
                CSSUdfView cSSUdfView = new CSSUdfView(objectDef);
                Hashtable hashtable6 = (Hashtable)this.m_objectDefs.get("View");
                object = hashtable6;
                synchronized (object) {
                    hashtable6.put(cSSUdfView.m_name, cSSUdfView);
                    continue;
                }
            }
            if (!string3.equals("Service")) continue;
            object = new CSSServiceDef(objectDef);
            Hashtable hashtable7 = hashtable = (Hashtable)this.m_objectDefs.get("Service");
            synchronized (hashtable7) {
                hashtable.put(((CSSServiceDef)object).m_name, object);
            }
        }
    }

    @Override
    public CSSPageTabDef getPageTabDef(String string) throws CSSException {
        this.initStartupState();
        Vector vector = (Vector)this.m_objectDefs.get("PageTab");
        for (int i = 0; i < vector.size(); ++i) {
            CSSPageTabDef cSSPageTabDef = (CSSPageTabDef)vector.elementAt(i);
            if (!cSSPageTabDef.m_caption.equals(string)) continue;
            return cSSPageTabDef;
        }
        return null;
    }

    @Override
    public String getPositionId() throws CSSException {
        if (this.m_positionId == null) {
            this.initStartupState();
        }
        return this.m_positionId;
    }

    @Override
    public String getPositionName() throws CSSException {
        if (this.m_positionName == null) {
            this.initStartupState();
        }
        return this.m_positionName;
    }

    @Override
    public String getPreference(String string, String string2) throws CSSException {
        this.initStartupState();
        return this.m_prefs.getSubProperty(string, string2);
    }

    @Override
    public CSSPropertySet getPrefSubset(String string) throws CSSException {
        this.initStartupState();
        if (string == null || string.equals("")) {
            return this.m_prefs;
        }
        return this.m_prefs.getSubset(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSUdfScreen getScreenDef(String string) throws CSSException {
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Screen");
        this.initStartupState();
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            if (hashtable.containsKey(string)) {
                return (CSSUdfScreen)hashtable.get(string);
            }
            this.getObjectDef("Screen", string);
            return (CSSUdfScreen)hashtable.get(string);
        }
    }

    @Override
    public CSSScreenMenuDef getScreenMenuDef(String string) throws CSSException {
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("ScreenMenu");
        return (CSSScreenMenuDef)hashtable.get(string);
    }

    @Override
    public CSSIService getService(String string) throws CSSException {
        CSSIService cSSIService = this.findService(string);
        if (cSSIService != null) {
            return cSSIService;
        }
        ArgList argList = new ArgList();
        argList.addArg("serviceName", new ArgSpec(string));
        argList.addArg("bRequestedByEL", new ArgSpec(false));
        argList = this.sendReceive(5, argList);
        int n = argList.getArg("serviceId").getInt();
        CSSService cSSService = new CSSService(string, this, n);
        cSSIService = cSSService;
        return cSSIService;
    }

    @Override
    public CSSPropertySet getSession() throws CSSException {
        ArgList argList = this.sendReceive(13, null, 0, 0, null);
        ArgList argList2 = argList.getArg("session").getArgList();
        return CSSModel.argListToPropertySet("session", argList2);
    }

    @Override
    public CSSToolbarDef getToolbarDef(String string) throws CSSException {
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Toolbar");
        CSSToolbarDef cSSToolbarDef = (CSSToolbarDef)hashtable.get(string);
        if (cSSToolbarDef == null) {
            throw new CSSException(65535);
        }
        return cSSToolbarDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSUdfView getViewDef(String string) throws CSSException {
        Hashtable hashtable;
        this.initStartupState();
        Hashtable hashtable2 = hashtable = (Hashtable)this.m_objectDefs.get("View");
        synchronized (hashtable2) {
            if (hashtable.containsKey(string)) {
                return (CSSUdfView)hashtable.get(string);
            }
            this.getObjectDef("View", string);
            return (CSSUdfView)hashtable.get(string);
        }
    }

    @Override
    public String initSchemaVersion() throws CSSException {
        if (this.m_schemaVersion != null) {
            return this.m_schemaVersion;
        }
        ArgList argList = this.sendReceive(502, null);
        this.m_schemaVersion = argList.getArg("schemaVersion").getString();
        return this.m_schemaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStartupState() throws CSSException {
        ArgList argList = new ArgList();
        if (this.m_bInited) {
            return;
        }
        this.setup();
        argList.addArg("SISNSIOMVersion", new ArgSpec(203));
        ArgList argList2 = CSSModel.propertySetToArgList(this.createLocaleProfile());
        argList.addArg("localeProfile", new ArgSpec(argList2));
        Hashtable hashtable = this.m_objectDefs;
        synchronized (hashtable) {
            ArgSpec argSpec;
            boolean bl = ((String)this.m_objectDefs.get("defInitDone")).equals("true");
            argList.addArg("bJavaClient", new ArgSpec(true));
            argList.addArg("bReturnCommonDefs", new ArgSpec(false));
            argList.addArg("bReturnProductConfig", new ArgSpec(false));
            argList.addArg("bReturnPreferences", new ArgSpec(false));
            argList.addArg("bReturnViewAccessMap", new ArgSpec(false));
            if (this.m_bAttach) {
                argList.addArg("bAttach", new ArgSpec(true));
            }
            if ((argSpec = (argList = this.sendReceive(501, argList, 0, 0, null)).getArg2("startupState")) != null) {
                ArgList argList3 = argSpec.getArgList();
                Enumeration enumeration = argList3.enumArgNames();
                while (enumeration.hasMoreElements()) {
                    int n;
                    String[] stringArray;
                    String string = (String)enumeration.nextElement();
                    ArgSpec argSpec2 = argList3.getArg(string);
                    if (!bl && string.equals("currencyCode")) {
                        this.m_currencyCode = argSpec2.getString();
                        if (this.m_currencyCode == null) continue;
                        this.m_objectDefs.put("CurrencyCode", this.m_currencyCode);
                        continue;
                    }
                    if (!bl && string.equals("language")) {
                        this.m_language = argSpec2.getString();
                        this.m_objectDefs.put("Language", this.m_language);
                        continue;
                    }
                    if (!bl && string.equals("licensedModuleArray")) {
                        stringArray = argSpec2.getValues();
                        for (n = 0; n < stringArray.length; ++n) {
                            this.m_licensedModuleMap.put(stringArray[n], "");
                        }
                        this.m_objectDefs.put("LicensedModules", this.m_licensedModuleMap);
                        continue;
                    }
                    if (string.equals("loginId")) {
                        this.m_loginId = argSpec2.getString();
                        continue;
                    }
                    if (string.equals("loginName")) {
                        this.m_loginName = argSpec2.getString();
                        continue;
                    }
                    if (string.equals("positionId")) {
                        this.m_positionId = argSpec2.getString();
                        continue;
                    }
                    if (string.equals("positionName")) {
                        this.m_positionName = argSpec2.getString();
                        continue;
                    }
                    if (string.equals("preferences")) {
                        this.m_prefs = CSSModel.argListToPropertySet("", argSpec2.getArgList());
                        continue;
                    }
                    if (!bl && string.equals("productConfig")) {
                        this.m_productConfig = CSSModel.argListToPropertySet("", argSpec2.getArgList());
                        this.m_objectDefs.put("ProductConfig", this.m_productConfig);
                        continue;
                    }
                    if (!string.equals("viewAccessMap")) continue;
                    stringArray = argSpec2.getValues();
                    for (n = 0; n < stringArray.length; ++n) {
                        this.m_viewAccessMap.put(stringArray[n], "");
                    }
                }
                if (!bl) {
                    this.m_objectDefs.put("defInitDone", "true");
                }
            }
        }
        if (this.m_locale != null) {
            this.m_locale = new CSSLocale(this);
        }
        this.m_bInited = true;
    }

    private boolean loadUIDefs(String string, ArgSpec argSpec, boolean bl) {
        block7: {
            ArgList argList;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                argList = null;
                                if (bl || !string.equals("AppMenu")) break block6;
                                argList = argSpec.getArgList();
                                Enumeration enumeration = argList.enumArgVals();
                                while (enumeration.hasMoreElements()) {
                                    ArgSpec argSpec2 = (ArgSpec)enumeration.nextElement();
                                    this.m_appMenuDef = new CSSMenuDef(new ObjectDef(argSpec2.getArgList()));
                                    this.m_objectDefs.put("AppMenu", this.m_appMenuDef);
                                }
                                break block7;
                            }
                            if (bl || !string.equals("bitmapDefArray")) break block8;
                            Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Bitmap");
                            argList = argSpec.getArgList();
                            Enumeration enumeration = argList.enumArgVals();
                            while (enumeration.hasMoreElements()) {
                                ArgSpec argSpec3 = (ArgSpec)enumeration.nextElement();
                                CSSBitmapDef cSSBitmapDef = new CSSBitmapDef(new ObjectDef(argSpec3.getArgList()));
                                hashtable.put("Command Icons." + cSSBitmapDef.m_name, cSSBitmapDef);
                            }
                            break block7;
                        }
                        if (bl || !string.equals("commandDefArray")) break block9;
                        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Command");
                        argList = argSpec.getArgList();
                        Enumeration enumeration = argList.enumArgVals();
                        while (enumeration.hasMoreElements()) {
                            ArgSpec argSpec4 = (ArgSpec)enumeration.nextElement();
                            CSSCommandDef cSSCommandDef = new CSSCommandDef(new ObjectDef(argSpec4.getArgList()));
                            hashtable.put(cSSCommandDef.m_name, cSSCommandDef);
                        }
                        break block7;
                    }
                    if (bl || !string.equals("pageTabDefArray")) break block10;
                    Vector vector = (Vector)this.m_objectDefs.get("PageTab");
                    argList = argSpec.getArgList();
                    Enumeration enumeration = argList.enumArgVals();
                    while (enumeration.hasMoreElements()) {
                        ArgSpec argSpec5 = (ArgSpec)enumeration.nextElement();
                        CSSPageTabDef cSSPageTabDef = new CSSPageTabDef(new ObjectDef(argSpec5.getArgList()));
                        vector.addElement(cSSPageTabDef);
                    }
                    break block7;
                }
                if (bl || !string.equals("screenMenuDefArray")) break block11;
                Hashtable hashtable = (Hashtable)this.m_objectDefs.get("ScreenMenu");
                Vector vector = (Vector)this.m_objectDefs.get("ScreenMenuName");
                argList = argSpec.getArgList();
                Enumeration enumeration = argList.enumArgVals();
                while (enumeration.hasMoreElements()) {
                    ArgSpec argSpec6 = (ArgSpec)enumeration.nextElement();
                    CSSScreenMenuDef cSSScreenMenuDef = new CSSScreenMenuDef(new ObjectDef(argSpec6.getArgList()));
                    hashtable.put(cSSScreenMenuDef.m_name, cSSScreenMenuDef);
                    vector.addElement(cSSScreenMenuDef.m_name);
                }
                break block7;
            }
            if (bl || !string.equals("toolbarDefArray")) break block7;
            Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Toolbar");
            argList = argSpec.getArgList();
            Enumeration enumeration = argList.enumArgVals();
            while (enumeration.hasMoreElements()) {
                ArgSpec argSpec7 = (ArgSpec)enumeration.nextElement();
                CSSToolbarDef cSSToolbarDef = new CSSToolbarDef(new ObjectDef(argSpec7.getArgList()));
                hashtable.put(cSSToolbarDef.m_name, cSSToolbarDef);
            }
        }
        return true;
    }

    @Override
    public String invokeMethod(String string, String[] stringArray) throws CSSException {
        ArgSpec argSpec;
        ArgList argList = new ArgList();
        String string2 = null;
        argList.addArg("methodName", new ArgSpec(string));
        if (stringArray != null) {
            argList.addArg("parameterArray", new ArgSpec(stringArray));
        }
        if ((argSpec = (argList = this.sendReceive(506, argList)).getArg2("returnVal")) != null) {
            string2 = argSpec.getString();
        }
        return string2;
    }

    @Override
    public boolean isModuleLicensed(String string) {
        return this.m_licensedModuleMap.containsKey(string);
    }

    @Override
    public boolean isPrefsDirty() {
        return this.m_bPrefsDirty;
    }

    @Override
    public boolean isPrefsUserDirty() {
        return this.m_bPrefsUserDirty;
    }

    @Override
    public boolean isViewAccessible(String string) throws CSSException {
        this.initStartupState();
        return this.m_viewAccessMap.containsKey(string);
    }

    private void loadFindDefs() throws CSSException {
        if (this.m_bFindDefsRetrieved) {
            return;
        }
        ArgList argList = this.sendReceive(500, null);
        ArgList argList2 = argList.getArg2("findDefArray").getArgList();
        if (argList2 != null) {
            Enumeration enumeration = argList2.enumArgNames();
            while (enumeration.hasMoreElements()) {
                ArgList argList3 = argList2.getArg((String)enumeration.nextElement()).getArgList();
                ObjectDef objectDef = new ObjectDef(argList3);
                CSSFindDef cSSFindDef = new CSSFindDef(objectDef);
                this.m_findDefArray.addElement(cSSFindDef);
            }
        }
        this.m_bFindDefsRetrieved = true;
    }

    @Override
    public void release() {
        if (this.m_bLoggedIn) {
            try {
                this.logoff();
            }
            catch (CSSException cSSException) {
                // empty catch block
            }
        }
        this.deleteObject();
    }

    @Override
    public void logoff() throws CSSException {
        Request request;
        Exception exception = null;
        if (!this.m_bLoggedIn) {
            throw new CSSException(8716495);
        }
        this.empty();
        this.m_bLoggedIn = false;
        try {
            request = new LogoffRequest(true);
            this.m_tx.reset();
            this.m_tx.setRequest(request);
            ConnectionManager.send(this.m_sHandle, this.m_tx);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        try {
            request = new SessCloseReq();
            this.m_tx.reset();
            this.m_tx.setRequest(request);
            ConnectionManager.send(this.m_sHandle, this.m_tx);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (exception != null) {
            if (exception instanceof CSSException) {
                throw (CSSException)exception;
            }
            throw new CSSException(65535, exception.getMessage(), false);
        }
        this.nullifyMem();
    }

    private boolean setup() {
        if (this.m_bSetup) {
            return true;
        }
        if (this.m_sHandle != null && this.m_objectDefs != null) {
            this.m_productConfig = (CSSPropertySet)this.m_objectDefs.get("ProductConfig");
            this.m_licensedModuleMap = (Hashtable)this.m_objectDefs.get("LicensedModules");
            this.m_language = (String)this.m_objectDefs.get("Language");
            this.m_currencyCode = (String)this.m_objectDefs.get("CurrencyCode");
            this.m_appMenuDef = (CSSMenuDef)this.m_objectDefs.get("AppMenu");
        } else {
            this.m_licensedModuleMap = new Hashtable();
            this.m_objectDefs = new Hashtable();
            this.m_objectDefs.put("Applet", new Hashtable());
            this.m_objectDefs.put("Class", new Hashtable());
            this.m_objectDefs.put("Screen", new Hashtable());
            this.m_objectDefs.put("ScreenMenuName", new Vector());
            this.m_objectDefs.put("ScreenMenu", new Hashtable());
            this.m_objectDefs.put("View", new Hashtable());
            this.m_objectDefs.put("Toolbar", new Hashtable());
            this.m_objectDefs.put("BitmapCategory", new Hashtable());
            this.m_objectDefs.put("Bitmap", new CSSHashtable());
            this.m_objectDefs.put("Command", new Hashtable());
            this.m_objectDefs.put("PageTab", new Vector());
            this.m_objectDefs.put("Service", new Hashtable());
            this.m_objectDefs.put("defInitDone", "false");
        }
        this.m_bSetup = true;
        return true;
    }

    @Override
    public void login(String string, String string2, String string3) throws CSSException, IOException {
        this.login(string, string2, string3, "enu");
    }

    @Override
    public void login(String string, String string2, String string3, String string4) throws CSSException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        SiebelDebug.printEntry(file_id, "login()");
        if (this.m_bLoggedIn) {
            throw new CSSException(8716493, this.m_loginName);
        }
        this.initMem();
        this.m_sHandle = ConnectionManager.open(string);
        SiebelDebug.printTrace(file_id, "login()", "SessionMgr/Session successfully opened session " + this.m_sHandle.toString());
        boolean bl3 = string2 == null || string3 == null;
        SiebelDebug.printTrace(file_id, "login()", "logon with User:" + string2 + " password:" + string3);
        LogonRequest logonRequest = new LogonRequest(null, string2, string3, 4, bl3, 1, n);
        this.m_tx.reset();
        this.m_tx.setRequest(logonRequest);
        try {
            LogonACK logonACK = (LogonACK)ConnectionManager.send(this.m_sHandle, this.m_tx);
        }
        catch (CSSException cSSException) {
            try {
                SessCloseReq sessCloseReq = new SessCloseReq();
                this.m_tx.reset();
                this.m_tx.setRequest(sessCloseReq);
                ConnectionManager.send(this.m_sHandle, this.m_tx);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw cSSException;
        }
        this.setup();
        this.m_locale = new CSSLocale(this);
        this.m_bLoggedIn = true;
        SiebelDebug.printTrace(file_id, "login()", "Logon successful");
    }

    protected static ArgList propertySetToArgList(CSSPropertySet cSSPropertySet) throws CSSException {
        ArgList argList = new ArgList();
        ArgList argList2 = new ArgList();
        ArgList argList3 = new ArgList();
        argList.addArg("type", new ArgSpec(cSSPropertySet.getType()));
        Enumeration enumeration = cSSPropertySet.enumPropertyKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            argList2.addArg(string, new ArgSpec(cSSPropertySet.getProperty(string)));
        }
        argList.addArg("propArray", new ArgSpec(argList2));
        enumeration = cSSPropertySet.enumSubsets();
        while (enumeration.hasMoreElements()) {
            CSSPropertySet cSSPropertySet2 = (CSSPropertySet)enumeration.nextElement();
            argList3.addArg(cSSPropertySet2.getType(), new ArgSpec(CSSModel.propertySetToArgList(cSSPropertySet2)));
        }
        argList.addArg("subsetArray", new ArgSpec(argList3));
        return argList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFile(String string, String string2) throws CSSException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        int n2 = n > 1000000 ? 1000000 : n;
        try {
            byte[] byArray = new byte[n2];
            boolean bl = true;
            while (bl) {
                int n3 = 0;
                if (n == 0) {
                    bl = false;
                } else {
                    while (n3 < byArray.length) {
                        int n4 = fileInputStream.read(byArray, n3, byArray.length - n3);
                        if (n4 != -1) continue;
                        bl = false;
                        break;
                    }
                }
                ArgList argList = new ArgList();
                argList.addArg("destPath", new ArgSpec(string2));
                argList.addArg("more", new ArgSpec(bl));
                argList.addArg("data", new ArgSpec(byArray));
                this.sendReceive(12, argList);
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    @Override
    public void putSession(CSSPropertySet cSSPropertySet) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("session", new ArgSpec(CSSModel.propertySetToArgList(cSSPropertySet)));
        this.sendReceive(14, argList, 0, 0, null);
    }

    @Override
    public void registerService(CSSIService cSSIService) {
        this.m_serviceArray.addElement(cSSIService);
    }

    protected void removeBusObj(CSSBusObj cSSBusObj) {
        for (int i = 0; i < this.m_busObjArray.size(); ++i) {
            CSSBusObj cSSBusObj2 = (CSSBusObj)this.m_busObjArray.elementAt(i);
            if (cSSBusObj2 != cSSBusObj) continue;
            this.m_busObjArray.removeElementAt(i);
            break;
        }
    }

    @Override
    public boolean savePreferences() throws CSSException {
        boolean bl = true;
        this.initStartupState();
        if (this.m_bPrefsDirty) {
            try {
                ArgList argList = new ArgList();
                argList.addArg("prefs", new ArgSpec(CSSModel.propertySetToArgList(this.m_prefs)));
                this.sendReceive(508, argList);
            }
            catch (CSSException cSSException) {
                bl = false;
            }
        }
        return bl;
    }

    private ArgList sendReceive(int n, ArgList argList) throws CSSException {
        return this.sendReceive(n, argList, 0, 0, null);
    }

    protected ArgList sendReceive(int n, ArgList argList, int n2, int n3, CSSBusObj cSSBusObj) throws CSSException {
        SiebelDebug.printEntry(file_id, "sendReceive()");
        if (!this.m_bLoggedIn) {
            throw new CSSException(8716495);
        }
        try {
            SiebelDebug.printTrace(file_id, "sendReceive()", "Sending OMRPC Request");
            OMRPCRequest oMRPCRequest = new OMRPCRequest(n, n2, n3, argList);
            this.m_tx.reset();
            this.m_tx.setRequest(oMRPCRequest);
            oMRPCRequest = null;
            OMRPCACK oMRPCACK = (OMRPCACK)ConnectionManager.send(this.m_sHandle, this.m_tx);
            SiebelDebug.printDebug(file_id, "sendReceive()", "Tx with sequence " + this.m_tx.getSequence() + " completed in " + this.m_tx.getDuration() + "ms" + " on connection " + this.m_tx.getConnectionId());
            int n4 = oMRPCACK.getErrorCount();
            if (n4 > 0) {
                SiebelDebug.printDebug(file_id, "sendReceive()", "Received errors for OMRPC requests");
                ArgSpec argSpec = oMRPCACK.getArgList().getArg2("notifyList");
                if (cSSBusObj != null && argSpec != null) {
                    cSSBusObj.processNotifyList(argSpec.getNotifyList());
                }
                CSSException cSSException = oMRPCACK.getError(0);
                for (int i = 1; i < n4; ++i) {
                    cSSException.addErrorMsg(oMRPCACK.getError(i));
                }
                throw cSSException;
            }
            return oMRPCACK.getArgList();
        }
        catch (ConMgrException conMgrException) {
            SiebelDebug.printException(file_id, "sendReceive()", conMgrException);
            throw conMgrException;
        }
    }

    @Override
    public void setPreference(String string, String string2, String string3) throws CSSException {
        String string4;
        this.initStartupState();
        CSSPropertySet cSSPropertySet = this.m_prefs.getSubset(string);
        if (cSSPropertySet == null) {
            cSSPropertySet = new CSSPropertySet(string);
            this.m_prefs.addSubset(cSSPropertySet);
        }
        if ((string4 = cSSPropertySet.getProperty(string2)) == null || !string4.equals(string3)) {
            cSSPropertySet.addProperty(string2, string3);
            this.setPrefsDirty(true);
        }
    }

    @Override
    public boolean setPrefsDirty() {
        return this.setPrefsDirty(true);
    }

    @Override
    public boolean setPrefsDirty(boolean bl) {
        boolean bl2 = this.m_bPrefsDirty;
        this.m_bPrefsDirty = bl;
        this.m_bPrefsUserDirty = bl;
        return bl2;
    }

    @Override
    public void setPrefsUserDirty(boolean bl) {
        this.m_bPrefsUserDirty = bl;
    }

    @Override
    public void unRegisterService(CSSIService cSSIService) {
        for (int i = 0; i < this.m_serviceArray.size(); ++i) {
            CSSIService cSSIService2 = (CSSIService)this.m_serviceArray.elementAt(i);
            if (cSSIService2 != cSSIService) continue;
            this.m_serviceArray.removeElementAt(i);
            break;
        }
    }

    @Override
    public CSSClassDef getClassDef(String string) throws CSSException {
        if (CSSUtilities.isEmpty(string)) {
            return null;
        }
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Class");
        CSSClassDef cSSClassDef = (CSSClassDef)hashtable.get(string);
        if (cSSClassDef == null) {
            try {
                this.getObjectDef("Class", string);
            }
            catch (CSSException cSSException) {
                return null;
            }
        }
        cSSClassDef = (CSSClassDef)hashtable.get(string);
        return cSSClassDef;
    }

    @Override
    public CSSServiceDef getServiceDef(String string) throws CSSException {
        if (CSSUtilities.isEmpty(string)) {
            return null;
        }
        this.initStartupState();
        Hashtable hashtable = (Hashtable)this.m_objectDefs.get("Service");
        CSSServiceDef cSSServiceDef = (CSSServiceDef)hashtable.get(string);
        if (cSSServiceDef == null) {
            try {
                this.getObjectDef("Service", string);
            }
            catch (CSSException cSSException) {
                return null;
            }
        }
        cSSServiceDef = (CSSServiceDef)hashtable.get(string);
        return cSSServiceDef;
    }

    @Override
    public String getServerVersion() throws CSSException {
        if (this.m_serverVersion != null) {
            return this.m_serverVersion;
        }
        try {
            ArgList argList = this.sendReceive(505, null);
            this.m_serverVersion = argList.getArg("strVersion").getString();
        }
        catch (Exception exception) {
            this.m_serverVersion = "";
        }
        return this.m_serverVersion;
    }

    @Override
    public void setPositionId(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("Value", new ArgSpec(string));
        ArgList argList2 = this.sendReceive(511, argList);
        this.m_positionName = argList2.getArg("positionName").getString();
        this.m_positionId = argList2.getArg("positionId").getString();
    }

    @Override
    public void setPositionName(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("Value", new ArgSpec(string));
        ArgList argList2 = this.sendReceive(512, argList);
        this.m_positionName = argList2.getArg("positionName").getString();
        this.m_positionId = argList2.getArg("positionId").getString();
    }

    @Override
    public void setProfileAttr(String string, String string2) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("Name", new ArgSpec(string));
        argList.addArg("Value", new ArgSpec(string2));
        this.sendReceive(703, argList);
    }

    @Override
    public String getProfileAttr(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("Name", new ArgSpec(string));
        ArgList argList2 = this.sendReceive(702, argList);
        return argList2.getArg("Value").getString();
    }

    @Override
    public String detach() throws CSSException {
        this.sendReceive(18, new ArgList());
        String string = this.m_sHandle.toString();
        this.nullifyMem();
        return string;
    }

    @Override
    public boolean attach(String string) throws CSSException {
        if (this.m_bLoggedIn) {
            throw new CSSException(8716493, this.m_loginName);
        }
        this.initMem();
        this.m_bAttach = true;
        this.m_bLoggedIn = true;
        this.m_sHandle = new SessionHandle(string);
        this.initStartupState();
        return true;
    }

    @Override
    public void trace(String string) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("Msg", new ArgSpec(string));
        this.sendReceive(15, argList);
    }

    @Override
    public void traceOn(String string, String string2, String string3) throws CSSException {
        ArgList argList = new ArgList();
        argList.addArg("FileName", new ArgSpec(string));
        argList.addArg("Category", new ArgSpec(string2));
        argList.addArg("Src", new ArgSpec(string3));
        this.sendReceive(17, argList);
    }

    @Override
    public void traceOff() throws CSSException {
        ArgList argList = new ArgList();
        this.sendReceive(16, argList);
    }

    public CSSLocale getLocale() {
        return this.m_locale;
    }
}

