/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.sisnapi;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.om.sisnapi.ArgException;
import com.siebel.om.sisnapi.ArgList;
import com.siebel.om.sisnapi.FieldSpec;
import com.siebel.om.sisnapi.IDataBlock;
import com.siebel.om.sisnapi.NotifySpec;
import com.siebel.om.sisnapi.ObjectSpec;
import com.siebel.om.sisnapi.Packet;

public class ArgSpec
implements IDataBlock {
    private int m_intVal;
    private Object m_objVal = null;
    private int m_type;

    public ArgSpec() {
        this.m_type = 0;
    }

    public ArgSpec(int n) {
        this.m_intVal = n;
        this.m_type = 2;
    }

    public ArgSpec(int n, int n2) {
        this.m_intVal = n;
        this.m_type = n2;
    }

    public ArgSpec(boolean bl) {
        this.m_intVal = bl ? 1 : 0;
        this.m_type = 2;
    }

    public ArgSpec(String string) {
        this.m_objVal = string;
        this.m_type = 1;
    }

    public ArgSpec(String[] stringArray) {
        this.m_objVal = stringArray;
        this.m_type = 9;
    }

    public ArgSpec(byte[] byArray) {
        this.m_objVal = byArray;
        this.m_type = 4;
    }

    public ArgSpec(ObjectSpec[] objectSpecArray) {
        this.m_objVal = objectSpecArray;
        this.m_type = 7;
    }

    public ArgSpec(FieldSpec[] fieldSpecArray) {
        this.m_objVal = fieldSpecArray;
        this.m_type = 8;
    }

    public ArgSpec(ArgList argList) {
        this.m_objVal = argList;
        this.m_type = 11;
    }

    @Override
    public void addEncoded(Packet packet) throws CSSException {
        packet.writeInt(this.m_type);
        switch (this.m_type) {
            case 2: 
            case 5: 
            case 6: 
            case 12: {
                packet.writeInt(this.m_intVal);
                break;
            }
            case 1: {
                packet.writeString((String)this.m_objVal);
                break;
            }
            case 9: {
                String[] stringArray = (String[])this.m_objVal;
                int n = stringArray.length;
                packet.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    packet.writeString(stringArray[i]);
                }
                break;
            }
            case 4: {
                packet.writeBytes((byte[])this.m_objVal);
                break;
            }
            case 7: 
            case 8: {
                IDataBlock[] iDataBlockArray = (IDataBlock[])this.m_objVal;
                int n = iDataBlockArray.length;
                packet.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    packet.writeDataBlock(iDataBlockArray[i]);
                }
                break;
            }
            case 11: {
                packet.writeDataBlock((ArgList)this.m_objVal);
                break;
            }
            default: {
                throw new CSSException(8716693, String.valueOf(this.m_type));
            }
        }
    }

    public ArgList getArgList() {
        if (this.m_type != 11) {
            return null;
        }
        return (ArgList)this.m_objVal;
    }

    public boolean getBool() {
        if (this.m_type != 2) {
            return false;
        }
        return this.m_intVal != 0;
    }

    public byte[] getBytes() {
        if (this.m_type != 4) {
            return null;
        }
        return (byte[])this.m_objVal;
    }

    @Override
    public void getDecoded(Packet packet) throws CSSException {
        this.m_type = packet.readInt();
        switch (this.m_type) {
            case 2: 
            case 5: 
            case 6: 
            case 12: {
                this.m_intVal = packet.readInt();
                break;
            }
            case 1: {
                this.m_objVal = packet.readString();
                break;
            }
            case 4: {
                this.m_objVal = packet.readBytes();
                break;
            }
            case 9: {
                int n = packet.readInt();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = packet.readString();
                }
                this.m_objVal = stringArray;
                break;
            }
            case 7: {
                int n = packet.readInt();
                ObjectSpec[] objectSpecArray = new ObjectSpec[n];
                for (int i = 0; i < n; ++i) {
                    objectSpecArray[i] = new ObjectSpec();
                    packet.readDataBlock(objectSpecArray[i]);
                }
                this.m_objVal = objectSpecArray;
                break;
            }
            case 8: {
                int n = packet.readInt();
                FieldSpec[] fieldSpecArray = new FieldSpec[n];
                for (int i = 0; i < n; ++i) {
                    fieldSpecArray[i] = new FieldSpec();
                    packet.readDataBlock(fieldSpecArray[i]);
                }
                this.m_objVal = fieldSpecArray;
                break;
            }
            case 10: {
                int n = packet.readInt();
                NotifySpec[] notifySpecArray = new NotifySpec[n];
                for (int i = 0; i < n; ++i) {
                    notifySpecArray[i] = new NotifySpec();
                    packet.readDataBlock(notifySpecArray[i]);
                }
                this.m_objVal = notifySpecArray;
                break;
            }
            case 11: {
                this.m_objVal = new ArgList();
                packet.readDataBlock((ArgList)this.m_objVal);
                break;
            }
            default: {
                throw new ArgException(CSSMsgMgr.get(8716693, Integer.toString(this.m_type)));
            }
        }
    }

    public FieldSpec[] getFieldList() {
        if (this.m_type != 8) {
            return null;
        }
        return (FieldSpec[])this.m_objVal;
    }

    public int getInt() {
        if (this.m_type != 2 && this.m_type != 5 && this.m_type != 6 && this.m_type != 12) {
            throw new ArgException(CSSMsgMgr.get(8716690));
        }
        return this.m_intVal;
    }

    public NotifySpec[] getNotifyList() {
        if (this.m_type != 10) {
            return null;
        }
        return (NotifySpec[])this.m_objVal;
    }

    public ObjectSpec[] getObjectList() {
        if (this.m_type != 7) {
            return null;
        }
        return (ObjectSpec[])this.m_objVal;
    }

    public String getString() {
        if (this.m_type != 1) {
            return null;
        }
        return (String)this.m_objVal;
    }

    public int getType() {
        return this.m_type;
    }

    public String[] getValues() {
        if (this.m_type != 9) {
            return null;
        }
        return (String[])this.m_objVal;
    }
}

