/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.sisnapi;

import com.siebel.common.common.CSSException;
import com.siebel.om.sisnapi.IDataBlock;
import java.io.UnsupportedEncodingException;

public abstract class Packet {
    private byte[] m_data;
    private int m_offset = 0;
    private int m_startingOfst = 0;
    private int m_msgType = 0;
    private int m_sequence;
    private int m_sessionId = 0;
    private int trailerLen;
    private int trailerOffset;
    protected int m_transCode = 1;

    protected Packet() {
    }

    protected void takePacketData(byte[] byArray, int n, int n2) throws CSSException {
        if (n < 0 || byArray.length <= 0 || n + n2 > byArray.length) {
            throw new CSSException(8716698);
        }
        this.m_data = byArray;
        this.m_startingOfst = n;
        this.m_offset = n;
    }

    protected void copyPacketData(byte[] byArray, int n, int n2) throws CSSException {
        if (n2 <= 0) {
            throw new CSSException(8716698);
        }
        this.m_data = new byte[n2];
        System.arraycopy(byArray, n, this.m_data, 0, n2);
        this.m_startingOfst = 0;
        this.m_offset = 0;
    }

    public int getMessageType() {
        return this.m_msgType;
    }

    public int getLength() {
        return this.m_offset - this.m_startingOfst;
    }

    public byte[] getPacketData() {
        return this.m_data;
    }

    public int getStartingOfst() {
        return this.m_startingOfst;
    }

    public int getSequence() {
        return this.m_sequence;
    }

    public void setSequence(int n) {
        this.m_sequence = n;
    }

    public int getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(int n) {
        this.m_sessionId = n;
    }

    public int getTrailerLen() {
        return this.trailerLen;
    }

    public int getTrailerOffset() {
        return this.trailerOffset;
    }

    protected void readHeader() throws CSSException {
        this.m_sequence = this.readInt();
        this.m_sessionId = this.readInt();
        this.readInt();
        this.trailerOffset = this.readInt();
        this.trailerLen = this.readInt();
        this.m_offset += 16;
        this.m_msgType = this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        if (this.m_msgType != 1 && this.m_msgType != 2 && this.m_msgType != 3 && this.m_msgType != 4 && this.m_msgType != 5) {
            throw new CSSException(8716696);
        }
        if (n != 12) {
            throw new CSSException(8716698);
        }
        if (n + n2 + this.m_startingOfst > this.m_data.length) {
            throw new CSSException(8716698);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTaskId(int n) {
        if (this.m_offset > 48) {
            int n2 = this.m_offset;
            try {
                this.m_offset = 16;
                this.writeInt(n);
                this.m_offset = 4;
                this.writeInt(-1);
            }
            finally {
                this.m_offset = n2;
            }
            return true;
        }
        return false;
    }

    protected void startPacket(int n) throws CSSException {
        if (n != 1) {
            throw new CSSException(8716694);
        }
        this.m_msgType = n;
        this.m_startingOfst = 0;
        this.m_offset = 0;
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(n);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(this.m_msgType);
        this.writeInt(12);
        this.writeInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishPacket() throws CSSException {
        if (this.m_offset - this.m_startingOfst < 12) {
            throw new CSSException(8716689);
        }
        int n = this.m_offset;
        int n2 = this.m_offset - this.m_startingOfst - 60;
        this.m_offset = this.m_startingOfst + 56;
        try {
            this.writeInt(n2);
        }
        finally {
            this.m_offset = n;
        }
    }

    protected int readInt() throws CSSException {
        int n;
        int n2;
        int n3;
        if (this.m_offset + 4 > this.m_data.length) {
            throw new CSSException(8716697);
        }
        byte by = this.m_data[this.m_offset++];
        if ((n3 = this.m_data[this.m_offset++]) < 0) {
            n3 += 256;
        }
        if ((n2 = this.m_data[this.m_offset++]) < 0) {
            n2 += 256;
        }
        if ((n = this.m_data[this.m_offset++]) < 0) {
            n += 256;
        }
        int n4 = by << 24 | n3 << 16 | n2 << 8 | n;
        return n4;
    }

    protected boolean readBool() throws CSSException {
        int n = this.readInt();
        return n != 0;
    }

    public void setTransCode(int n) {
        this.m_transCode = n;
    }

    public int getTransCode() {
        return this.m_transCode;
    }

    protected String readString() throws CSSException {
        byte[] byArray = this.readBytes();
        if (byArray == null) {
            return null;
        }
        String string = null;
        switch (this.m_transCode) {
            case 1: {
                string = new String(byArray);
                break;
            }
            case 2: {
                try {
                    string = new String(byArray, "ASCII");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CSSException(65535, unsupportedEncodingException.getMessage());
                }
            }
            case 3: {
                try {
                    string = new String(byArray, "UnicodeBig");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CSSException(65535, unsupportedEncodingException.getMessage());
                }
            }
            case 4: {
                try {
                    string = new String(byArray, "UTF8");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CSSException(65535, unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw new CSSException(8716623);
            }
        }
        if (string.endsWith("\u0000")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected byte[] readBytes() throws CSSException {
        byte[] byArray;
        int n = this.readInt();
        if (this.m_offset + n > this.m_data.length) {
            throw new CSSException(8716697);
        }
        if (n <= 0) {
            byArray = null;
        } else {
            byArray = new byte[n];
            System.arraycopy(this.m_data, this.m_offset, byArray, 0, n);
            this.m_offset += n;
        }
        return byArray;
    }

    protected void writeInt(int n) {
        this.extend(4);
        this.m_data[this.m_offset++] = (byte)(n >>> 24);
        this.m_data[this.m_offset++] = (byte)(n >>> 16);
        this.m_data[this.m_offset++] = (byte)(n >>> 8);
        this.m_data[this.m_offset++] = (byte)n;
    }

    protected void writeBool(boolean bl) {
        this.writeInt(bl ? 1 : 0);
    }

    protected void writeString(String string) throws CSSException {
        if (string == null) {
            this.writeBytes(null);
        } else {
            switch (this.m_transCode) {
                case 1: {
                    this.writeBytes(string.getBytes());
                    break;
                }
                case 2: {
                    try {
                        byte[] byArray = string.getBytes("ASCII");
                        this.writeBytes(byArray);
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new CSSException(65535, unsupportedEncodingException.getMessage());
                    }
                }
                case 3: {
                    try {
                        byte[] byArray = string.getBytes("UnicodeBigUnmarked");
                        byte[] byArray2 = new byte[byArray.length + 2];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        byArray2[byArray2.length - 1] = 0;
                        byArray2[byArray2.length - 2] = 0;
                        this.writeBytes(byArray2);
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new CSSException(-1, unsupportedEncodingException.getMessage());
                    }
                }
                case 4: {
                    try {
                        this.writeBytes(string.getBytes("UTF8"));
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new CSSException(65535, unsupportedEncodingException.getMessage());
                    }
                }
                default: {
                    throw new CSSException(8716623);
                }
            }
        }
    }

    protected void writeBytes(byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        this.extend(4 + n);
        this.writeInt(n);
        if (n > 0) {
            System.arraycopy(byArray, 0, this.m_data, this.m_offset, n);
            this.m_offset += n;
        }
    }

    private void extend(int n) {
        if (this.m_data == null) {
            int n2;
            for (n2 = 1024; n2 < n; n2 *= 2) {
            }
            this.m_data = new byte[n2];
            this.m_startingOfst = 0;
            this.m_offset = 0;
        } else if (this.m_offset + n > this.m_data.length) {
            int n3 = this.m_data.length * 2;
            while (n3 - this.m_offset < n) {
                n3 *= 2;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.m_data, 0, byArray, 0, this.m_offset);
            this.m_data = byArray;
        }
    }

    public void readDataBlock(IDataBlock iDataBlock) throws CSSException {
        iDataBlock.getDecoded(this);
    }

    public void writeDataBlock(IDataBlock iDataBlock) throws CSSException {
        if (iDataBlock == null) {
            this.writeInt(0);
            return;
        }
        iDataBlock.addEncoded(this);
    }
}

