/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.sisnapi;

import com.siebel.common.common.CSSException;
import com.siebel.om.sisnapi.Packet;

public abstract class Request
extends Packet {
    protected int m_requestType = 0;

    public int getRequestType() {
        return this.m_requestType;
    }

    public void setRequestType(int n) {
        this.m_requestType = n;
    }

    public boolean isValidType(int n) {
        return n == 101 || n == 102 || n == 103 || n == 602 || n == 401 || n == 1101 || n == 1102;
    }

    public void startRequest() throws CSSException {
        if (!this.isValidType(this.m_requestType)) {
            throw new CSSException(8716695);
        }
        this.startPacket(1);
        this.writeInt(this.m_requestType);
        this.writeInt(this.getSessionId());
        this.writeInt(this.getSequence());
    }

    public String getRequestTypeName() {
        switch (this.m_requestType) {
            case 101: {
                return "Hello";
            }
            case 102: {
                return "Logon";
            }
            case 103: {
                return "Logoff";
            }
            case 602: {
                return "NSReadKey";
            }
            case 401: {
                return "OMRPC";
            }
            case 1101: {
                return "SSMHello";
            }
            case 1102: {
                return "SSMClose";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return this.getRequestTypeName() + " Request";
    }
}

