/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.om.sisnapi;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.SiebelErrorMsg;
import com.siebel.om.sisnapi.NAK;
import com.siebel.om.sisnapi.Packet;
import com.siebel.om.sisnapi.Request;
import com.siebel.om.sisnapi.SISNotify;

public class RequestException
extends CSSException {
    private static int s_majorNumber = 256;

    private RequestException() {
    }

    public RequestException(int n, String string) {
        super(n, string);
    }

    public RequestException(int n, String string, boolean bl) {
        super(n, string, bl);
    }

    public RequestException(int n, String[] stringArray) {
        super(n, stringArray);
    }

    public RequestException(Request request, Packet packet) {
        this(request.getRequestTypeName(), packet);
    }

    public RequestException(String string, Packet packet) {
        if (packet == null) {
            super.setErrorInfo(8716619, CSSMsgMgr.get(8716619));
        } else if (packet.getMessageType() == 3) {
            NAK nAK = (NAK)packet;
            int n = nAK.getErrorCount();
            if (n <= 0) {
                this.setErrorInfo(8716622, CSSMsgMgr.get(8716622, string));
            } else {
                SiebelErrorMsg siebelErrorMsg = nAK.getError(0);
                SiebelErrorMsg siebelErrorMsg2 = this.getErrorMsgAt(0);
                siebelErrorMsg2.setErrorCode(siebelErrorMsg.getErrorCode());
                siebelErrorMsg2.setErrorMsg(siebelErrorMsg.getErrorMsg());
                if (siebelErrorMsg.getErrorCode() != 5004) {
                    this.setErrorInfo(siebelErrorMsg.getErrorCode(), siebelErrorMsg.getErrorMsg());
                } else {
                    this.setErrorInfo(8716622, CSSMsgMgr.get(8716622, string));
                }
                for (int i = 1; i < n; ++i) {
                    super.addErrorMsg(nAK.getError(i));
                }
            }
        } else if (packet.getMessageType() == 5) {
            SISNotify sISNotify = (SISNotify)packet;
            int n = sISNotify.getErrorCount();
            SiebelErrorMsg siebelErrorMsg = this.getErrorMsgAt(0);
            siebelErrorMsg.setErrorCode(sISNotify.getNotifyCode());
            siebelErrorMsg.setErrorMsg(sISNotify.getDetailString());
            if (n > 0) {
                this.setErrorInfo(sISNotify.getError(0));
                for (int i = 1; i < n; ++i) {
                    super.addErrorMsg(sISNotify.getError(i));
                }
            }
        } else {
            this.setErrorInfo(8716618, CSSMsgMgr.get(8716618));
        }
    }

    @Override
    public int getMajorCode() {
        return s_majorNumber;
    }
}

