/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator;

import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.impl.transform.Base64ImageTransform;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageCaptchaGenerator
implements ImageCaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractImageCaptchaGenerator.class);
    public static String DEFAULT_BG_IMAGE_TYPE = "jpeg";
    public static String DEFAULT_SLIDER_IMAGE_TYPE = "png";
    public String defaultBgImageType = DEFAULT_BG_IMAGE_TYPE;
    public String defaultSliderImageType = DEFAULT_SLIDER_IMAGE_TYPE;
    protected ImageCaptchaResourceManager imageCaptchaResourceManager;
    protected ImageTransform imageTransform;
    private boolean init = false;

    public AbstractImageCaptchaGenerator() {
    }

    @Override
    public ImageCaptchaGenerator init(boolean initDefaultResource) {
        if (this.init) {
            return this;
        }
        this.init = true;
        try {
            log.info("\u56fe\u7247\u9a8c\u8bc1\u7801[{}]\u521d\u59cb\u5316...", (Object)this.getClass().getSimpleName());
            if (this.getImageTransform() == null) {
                this.setImageTransform(new Base64ImageTransform());
            }
            this.doInit(initDefaultResource);
        }
        catch (Exception e) {
            this.init = false;
            log.error("[{}]\u521d\u59cb\u5316\u5931\u8d25,ex", (Object)this.getClass().getSimpleName(), (Object)e);
            throw e;
        }
        return this;
    }

    public AbstractImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        this.imageCaptchaResourceManager = imageCaptchaResourceManager;
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type) {
        return this.generateCaptchaImage(type, this.defaultBgImageType, this.defaultSliderImageType);
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type, String backgroundFormatName, String sliderFormatName) {
        return this.generateCaptchaImage(GenerateParam.builder().type(type).backgroundFormatName(backgroundFormatName).sliderFormatName(sliderFormatName).obfuscate(false).build());
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(GenerateParam param) {
        this.assertInit();
        return this.doGenerateCaptchaImage(param);
    }

    protected InputStream getTemplateFile(Map<String, Resource> templateImages, String imageName) {
        Resource resource = templateImages.get(imageName);
        if (resource == null) {
            throw new IllegalArgumentException("\u67e5\u627e\u6a21\u677f\u5f02\u5e38\uff0c \u8be5\u6a21\u677f\u4e0b\u672a\u627e\u5230 ".concat(imageName));
        }
        return this.getImageResourceManager().getResourceInputStream(resource);
    }

    protected void assertInit() {
        if (!this.init) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528 init(...) \u521d\u59cb\u5316\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
    }

    protected abstract void doInit(boolean var1);

    protected abstract ImageCaptchaInfo doGenerateCaptchaImage(GenerateParam var1);

    @Override
    public ImageCaptchaResourceManager getImageResourceManager() {
        return this.imageCaptchaResourceManager;
    }

    @Override
    public void setImageResourceManager(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        this.imageCaptchaResourceManager = imageCaptchaResourceManager;
    }

    @Override
    public ImageTransform getImageTransform() {
        return this.imageTransform;
    }

    @Override
    public void setImageTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
    }

    public String getDefaultBgImageType() {
        return this.defaultBgImageType;
    }

    public void setDefaultBgImageType(String defaultBgImageType) {
        this.defaultBgImageType = defaultBgImageType;
    }

    public String getDefaultSliderImageType() {
        return this.defaultSliderImageType;
    }

    public void setDefaultSliderImageType(String defaultSliderImageType) {
        this.defaultSliderImageType = defaultSliderImageType;
    }

    public boolean isInit() {
        return this.init;
    }
}

