/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.common.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;

public class CaptchaImageUtils {
    public static final String TYPE_JPG = "jpg";
    public static final String TYPE_JPEG = "jpeg";
    public static final String TYPE_PNG = "png";

    public static BufferedImage wrapFile2BufferedImage(URL resourceImage) {
        if (resourceImage == null) {
            throw new IllegalArgumentException("\u5305\u88c5\u6587\u4ef6\u5230 BufferedImage \u5931\u8d25\uff0c file\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ImageIO.setUseCache(false);
        return ImageIO.read(resourceImage);
    }

    public static BufferedImage wrapFile2BufferedImage(InputStream resource) {
        if (resource == null) {
            throw new IllegalArgumentException("\u5305\u88c5\u6587\u4ef6\u5230 BufferedImage \u5931\u8d25\uff0c file\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ImageIO.setUseCache(false);
        return ImageIO.read(resource);
    }

    public static void overlayImage(BufferedImage baseBufferedImage, BufferedImage coverBufferedImage, int x, int y) {
        Graphics2D g2d = baseBufferedImage.createGraphics();
        g2d.drawImage(coverBufferedImage, x, y, coverBufferedImage.getWidth(), coverBufferedImage.getHeight(), null);
        g2d.dispose();
    }

    public static Shape getImageShape(Image img, boolean transparent) throws InterruptedException {
        ArrayList<Integer> x = new ArrayList<Integer>();
        ArrayList<Integer> y = new ArrayList<Integer>();
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        PixelGrabber pgr = new PixelGrabber(img, 0, 0, -1, -1, true);
        pgr.grabPixels();
        int[] pixels = (int[])pgr.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = pixels[i] >> 24 & 0xFF;
            if (alpha == 0) continue;
            x.add(i % width > 0 ? i % width - 1 : 0);
            y.add(i % width == 0 ? (i == 0 ? 0 : i / width - 1) : i / width);
        }
        int[][] matrix = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                matrix[i][j] = 0;
            }
        }
        for (int c = 0; c < x.size(); ++c) {
            matrix[((Integer)y.get((int)c)).intValue()][((Integer)x.get((int)c)).intValue()] = 1;
        }
        Area rec = new Area();
        int temp = 0;
        int flag = transparent ? 0 : 1;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                if (matrix[i][j] == flag) {
                    if (temp != 0) continue;
                    temp = j;
                    continue;
                }
                if (temp == 0) continue;
                rec.add(new Area(new Rectangle(temp, i, j - temp, 1)));
                temp = 0;
            }
            temp = 0;
        }
        return rec;
    }

    public static BufferedImage cutImage(BufferedImage origin, BufferedImage template, int x, int y) {
        int bw = template.getWidth(null);
        int bh = template.getHeight(null);
        int lw = origin.getWidth(null);
        int lh = origin.getHeight(null);
        Shape imageShape = CaptchaImageUtils.getImageShape(template, false);
        BufferedImage image = new BufferedImage(bw, bh, 2);
        Graphics2D graphics = image.createGraphics();
        image = graphics.getDeviceConfiguration().createCompatibleImage(bw, bh, 3);
        graphics.dispose();
        Graphics2D graphics2 = image.createGraphics();
        graphics2.clip(imageShape);
        graphics2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2.setStroke(new BasicStroke(5.0f, 0, 2));
        graphics2.drawImage(origin, -x, -y, lw, lh, null);
        graphics2.dispose();
        return image;
    }

    public static BufferedImage rotateImage(BufferedImage bufferedimage, double degree) {
        int w = bufferedimage.getWidth();
        int h = bufferedimage.getHeight();
        int type = bufferedimage.getColorModel().getTransparency();
        BufferedImage img = new BufferedImage(w, h, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(Math.toRadians(degree), w / 2, h / 2);
        graphics2d.drawImage((Image)bufferedimage, 0, 0, null);
        graphics2d.dispose();
        return img;
    }

    public static void centerOverlayAndRotateImage(BufferedImage baseBufferedImage, BufferedImage coverBufferedImage, double degree) {
        coverBufferedImage = CaptchaImageUtils.rotateImage(coverBufferedImage, degree);
        int bw = baseBufferedImage.getWidth();
        int bh = baseBufferedImage.getHeight();
        int cw = coverBufferedImage.getWidth();
        int ch = coverBufferedImage.getHeight();
        CaptchaImageUtils.overlayImage(baseBufferedImage, coverBufferedImage, bw / 2 - cw / 2, bh / 2 - ch / 2);
    }

    public static BufferedImage subImage(int x, int y, int width, int height, BufferedImage img) {
        int[] simgRgb = new int[width * height];
        img.getRGB(x, y, width, height, simgRgb, 0, width);
        int type = img.getColorModel().getTransparency();
        BufferedImage newImage = new BufferedImage(width, height, type);
        newImage.setRGB(0, 0, width, height, simgRgb, 0, width);
        return newImage;
    }

    public static BufferedImage[] splitImage(int pos, boolean direction, BufferedImage img) {
        int endScanY;
        int endScanX;
        int endImageHeight;
        int endImageWidth;
        int startImageWidth;
        int startImageHeight;
        if (direction) {
            startImageHeight = img.getHeight() - pos;
            startImageWidth = img.getWidth();
            endImageWidth = img.getWidth();
            endImageHeight = pos;
            endScanX = 0;
            endScanY = startImageHeight;
        } else {
            startImageWidth = pos;
            startImageHeight = img.getHeight();
            endImageWidth = img.getWidth() - startImageWidth;
            endImageHeight = img.getHeight();
            endScanX = pos;
            endScanY = 0;
        }
        int[] rgbArr = new int[startImageWidth * startImageHeight];
        img.getRGB(0, 0, startImageWidth, startImageHeight, rgbArr, 0, startImageWidth);
        int type = img.getColorModel().getTransparency();
        BufferedImage startImg = new BufferedImage(startImageWidth, startImageHeight, type);
        startImg.setRGB(0, 0, startImageWidth, startImageHeight, rgbArr, 0, startImageWidth);
        rgbArr = new int[endImageWidth * endImageHeight];
        img.getRGB(endScanX, endScanY, endImageWidth, endImageHeight, rgbArr, 0, endImageWidth);
        BufferedImage endImg = new BufferedImage(endImageWidth, endImageHeight, type);
        endImg.setRGB(0, 0, endImageWidth, endImageHeight, rgbArr, 0, endImageWidth);
        BufferedImage[] splitImageArr = new BufferedImage[]{startImg, endImg};
        return splitImageArr;
    }

    public static BufferedImage concatImage(boolean direction, int width, int height, BufferedImage ... imgArr) {
        int pos = 0;
        BufferedImage newImage = new BufferedImage(width, height, imgArr[0].getColorModel().getTransparency());
        for (BufferedImage img : imgArr) {
            int[] rgbArr = new int[width * height];
            img.getRGB(0, 0, img.getWidth(), img.getHeight(), rgbArr, 0, img.getWidth());
            if (direction) {
                newImage.setRGB(pos, 0, img.getWidth(), img.getHeight(), rgbArr, 0, img.getWidth());
                pos += img.getWidth();
                continue;
            }
            newImage.setRGB(0, pos, img.getWidth(), img.getHeight(), rgbArr, 0, img.getWidth());
            pos += img.getHeight();
        }
        return newImage;
    }

    public static void main(String[] args) {
        char randomChar = CaptchaImageUtils.getRandomChar();
        System.out.println(randomChar);
    }

    public static char getRandomChar() {
        return (char)(19968 + (int)(Math.random() * 20902.0));
    }

    public static BufferedImage drawWordImg(Color fontColor, String word, Font font, float fontTopCoef, int imgWidth, int imgHeight, float deg) {
        BufferedImage fillRect = new BufferedImage(imgWidth, imgHeight, 2);
        Graphics2D g = fillRect.createGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, imgWidth, imgHeight);
        g.setColor(fontColor);
        g.setFont(font);
        float left = (float)(imgWidth - font.getSize()) / 2.0f;
        float top = (float)(imgHeight - font.getSize()) / 2.0f + (float)font.getSize() - fontTopCoef;
        g.rotate(Math.toRadians(deg), (float)imgWidth / 2.0f, (float)imgHeight / 2.0f);
        g.drawString(word, left, top);
        g.dispose();
        return fillRect;
    }

    public static void drawOval(int num, Color color, Graphics2D g, int width, int height, Random random) {
        for (int i = 0; i < num; ++i) {
            g.setColor(color == null ? CaptchaImageUtils.getRandomColor(random) : color);
            int w = 5 + random.nextInt(10);
            int x = random.nextInt(width - 25);
            int y = random.nextInt(height - 25);
            g.drawOval(x, y, w, w);
        }
    }

    public static void drawBesselLine(int num, Color color, Graphics2D g, int width, int height, ThreadLocalRandom random) {
        for (int i = 0; i < num; ++i) {
            g.setColor(color == null ? CaptchaImageUtils.getRandomColor(random) : color);
            int x1 = 5;
            int y1 = random.nextInt(5, height / 2);
            int x2 = width - 5;
            int y2 = random.nextInt(height / 2, height - 5);
            int ctrlx = random.nextInt(width / 4, width / 4 * 3);
            int ctrly = random.nextInt(5, height - 5);
            if (random.nextInt(2) == 0) {
                int ty = y1;
                y1 = y2;
                y2 = ty;
            }
            if (random.nextInt(2) == 0) {
                QuadCurve2D.Double shape = new QuadCurve2D.Double();
                ((QuadCurve2D)shape).setCurve(x1, y1, ctrlx, ctrly, x2, y2);
                g.draw(shape);
                continue;
            }
            int ctrlx1 = random.nextInt(width / 4, width / 4 * 3);
            int ctrly1 = random.nextInt(5, height - 5);
            CubicCurve2D.Double shape = new CubicCurve2D.Double(x1, y1, ctrlx, ctrly, ctrlx1, ctrly1, x2, y2);
            g.draw(shape);
        }
    }

    public static BufferedImage genSimpleImgCaptcha(String data, Font font, int width, int height, float startX, float startY, int interferenceLineNum, int interferencePointNum) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        g.setFont(font);
        char[] chars = data.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            g.setColor(CaptchaImageUtils.getRandomColor(random));
            g.drawString(String.valueOf(chars[i]), startX + (float)(i * font.getSize()), startY);
        }
        if (interferencePointNum > 0) {
            CaptchaImageUtils.drawOval(interferencePointNum, null, g, width, height, random);
        }
        if (interferencePointNum > 0) {
            g.setStroke(new BasicStroke(1.2f, 0, 2));
            CaptchaImageUtils.drawBesselLine(interferenceLineNum, null, g, width, height, random);
        }
        return bufferedImage;
    }

    public static Color getRandomColor(Random random) {
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return CaptchaImageUtils.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        int type = TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return CaptchaImageUtils.toBufferedImage(image, type);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = CaptchaImageUtils.copyImage(image, imageType);
            }
        } else {
            bufferedImage = CaptchaImageUtils.copyImage(image, imageType);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return CaptchaImageUtils.copyImage(img, imageType, null);
    }

    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = CaptchaImageUtils.createGraphics(bimage, backgroundColor);
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static boolean isJpeg(String type) {
        return TYPE_JPG.equalsIgnoreCase(type) || TYPE_JPEG.equalsIgnoreCase(type);
    }

    public static boolean isPng(String type) {
        return TYPE_PNG.equalsIgnoreCase(type);
    }
}

