/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbstractClickImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    protected Integer checkClickCount = 4;
    protected Integer interferenceCount = 2;

    public AbstractClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public AbstractClickImageCaptchaGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCaptchaInfo doGenerateCaptchaImage(GenerateParam param) {
        ImageCaptchaInfo imageCaptchaInfo;
        LinkedList<InputStream> inputStreams = new LinkedList<InputStream>();
        try {
            Resource resourceImage = this.getImageResourceManager().randomGetResource(param.getType());
            InputStream resourceInputStream = this.getImageResourceManager().getResourceInputStream(resourceImage);
            inputStreams.add(resourceInputStream);
            BufferedImage bgImage = CaptchaImageUtils.wrapFile2BufferedImage(resourceInputStream);
            ArrayList<ClickImageCheckDefinition> clickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(this.interferenceCount);
            int allImages = this.interferenceCount + this.checkClickCount;
            int avg = bgImage.getWidth() / allImages;
            List<String> imgTips = this.randomGetClickImgTips(allImages);
            if (allImages < imgTips.size()) {
                throw new IllegalStateException("\u968f\u673a\u751f\u6210\u70b9\u51fb\u56fe\u7247\u5c0f\u4e8e\u8bf7\u6c42\u6570\u91cf\uff0c \u8bf7\u6c42\u751f\u6210\u6570\u91cf=" + allImages + ",\u5b9e\u9645\u751f\u6210\u6570\u91cf=" + imgTips.size());
            }
            for (int i = 0; i < allImages; ++i) {
                ImgWrapper imgWrapper = this.getClickImg(imgTips.get(i));
                BufferedImage image = imgWrapper.getImage();
                int clickImgWidth = image.getWidth();
                int clickImgHeight = image.getHeight();
                int randomX = i == 0 ? 1 : avg * i;
                int randomY = ThreadLocalRandom.current().nextInt(10, bgImage.getHeight() - clickImgHeight);
                CaptchaImageUtils.overlayImage(bgImage, imgWrapper.getImage(), randomX, randomY);
                ClickImageCheckDefinition clickImageCheckDefinition = new ClickImageCheckDefinition();
                clickImageCheckDefinition.setTip(imgWrapper.getTip());
                clickImageCheckDefinition.setX(randomX + clickImgWidth / 2);
                clickImageCheckDefinition.setY(randomY + clickImgHeight / 2);
                clickImageCheckDefinition.setWidth(clickImgWidth);
                clickImageCheckDefinition.setHeight(clickImgHeight);
                clickImageCheckDefinitionList.add(clickImageCheckDefinition);
            }
            List<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = this.getCheckClickImageCheckDefinitionList(clickImageCheckDefinitionList, this.checkClickCount);
            imageCaptchaInfo = this.wrapClickImageCaptchaInfo(param, bgImage, checkClickImageCheckDefinitionList);
        }
        catch (Throwable throwable) {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        for (InputStream inputStream : inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return imageCaptchaInfo;
    }

    protected List<ClickImageCheckDefinition> getCheckClickImageCheckDefinitionList(List<ClickImageCheckDefinition> allCheckDefinitionList, Integer checkClickCount) {
        Collections.shuffle(allCheckDefinitionList);
        ArrayList<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(checkClickCount);
        for (int i = 0; i < checkClickCount; ++i) {
            ClickImageCheckDefinition clickImageCheckDefinition = allCheckDefinitionList.get(i);
            checkClickImageCheckDefinitionList.add(clickImageCheckDefinition);
        }
        return checkClickImageCheckDefinitionList;
    }

    protected abstract List<String> randomGetClickImgTips(int var1);

    public abstract ImgWrapper getClickImg(String var1);

    public abstract ImageCaptchaInfo wrapClickImageCaptchaInfo(GenerateParam var1, BufferedImage var2, List<ClickImageCheckDefinition> var3);

    public Integer getCheckClickCount() {
        return this.checkClickCount;
    }

    public void setCheckClickCount(Integer checkClickCount) {
        this.checkClickCount = checkClickCount;
    }

    public Integer getInterferenceCount() {
        return this.interferenceCount;
    }

    public void setInterferenceCount(Integer interferenceCount) {
        this.interferenceCount = interferenceCount;
    }

    public static class ImgWrapper {
        private BufferedImage image;
        private String tip;

        public BufferedImage getImage() {
            return this.image;
        }

        public String getTip() {
            return this.tip;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImgWrapper)) {
                return false;
            }
            ImgWrapper other = (ImgWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BufferedImage this$image = this.getImage();
            BufferedImage other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            String this$tip = this.getTip();
            String other$tip = other.getTip();
            return !(this$tip == null ? other$tip != null : !this$tip.equals(other$tip));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImgWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BufferedImage $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            String $tip = this.getTip();
            result = result * 59 + ($tip == null ? 43 : $tip.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractClickImageCaptchaGenerator.ImgWrapper(image=" + this.getImage() + ", tip=" + this.getTip() + ")";
        }

        public ImgWrapper() {
        }

        public ImgWrapper(BufferedImage image, String tip) {
            this.image = image;
            this.tip = tip;
        }
    }
}

