/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.concurrent.ThreadLocalRandom;

public class StandardConcatImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public StandardConcatImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardConcatImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("CONCAT", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCaptchaInfo doGenerateCaptchaImage(GenerateParam param) {
        LinkedList<InputStream> inputStreams = new LinkedList<InputStream>();
        try {
            Resource resourceImage = this.imageCaptchaResourceManager.randomGetResource(param.getType());
            InputStream resourceInputStream = this.imageCaptchaResourceManager.getResourceInputStream(resourceImage);
            inputStreams.add(resourceInputStream);
            BufferedImage bgImage = CaptchaImageUtils.wrapFile2BufferedImage(resourceInputStream);
            int spacingY = bgImage.getHeight() / 4;
            int randomY = ThreadLocalRandom.current().nextInt(spacingY, bgImage.getHeight() - spacingY);
            BufferedImage[] bgImageSplit = CaptchaImageUtils.splitImage(randomY, true, bgImage);
            int spacingX = bgImage.getWidth() / 8;
            int randomX = ThreadLocalRandom.current().nextInt(spacingX, bgImage.getWidth() - bgImage.getWidth() / 5);
            BufferedImage[] bgImageTopSplit = CaptchaImageUtils.splitImage(randomX, false, bgImageSplit[0]);
            BufferedImage sliderImage = CaptchaImageUtils.concatImage(true, bgImageTopSplit[0].getWidth() + bgImageTopSplit[1].getWidth(), bgImageTopSplit[0].getHeight(), bgImageTopSplit[1], bgImageTopSplit[0]);
            bgImage = CaptchaImageUtils.concatImage(false, bgImageSplit[1].getWidth(), sliderImage.getHeight() + bgImageSplit[1].getHeight(), sliderImage, bgImageSplit[1]);
            ImageCaptchaInfo imageCaptchaInfo = this.wrapConcatCaptchaInfo(randomX, randomY, bgImage, param);
            return imageCaptchaInfo;
        }
        finally {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ImageCaptchaInfo wrapConcatCaptchaInfo(int randomX, int randomY, BufferedImage bgImage, GenerateParam param) {
        String backGroundImageBase64 = this.getImageTransform().transform(bgImage, param.getBackgroundFormatName());
        ImageCaptchaInfo imageCaptchaInfo = ImageCaptchaInfo.of(backGroundImageBase64, null, bgImage.getWidth(), bgImage.getHeight(), null, null, randomX, "CONCAT");
        imageCaptchaInfo.setData(randomY);
        imageCaptchaInfo.setTolerant(Float.valueOf(0.05f));
        return imageCaptchaInfo;
    }
}

