/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.common.util.FontUtils;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.generator.impl.AbstractClickImageCaptchaGenerator;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.impl.provider.ClassPathResourceProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class StandardRandomWordClickImageCaptchaGenerator
extends AbstractClickImageCaptchaGenerator {
    protected Font font;
    protected Integer clickImgWidth = 80;
    protected Integer clickImgHeight = 80;
    protected int tipImageInterferenceLineNum = 2;
    protected int tipImageInterferencePointNum = 5;
    protected float intercept = 0.39583334f;
    protected float coef = 0.14645833f;
    protected float currentFontTopCoef = 0.0f;

    public StandardRandomWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardRandomWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected List<String> randomGetClickImgTips(int tipSize) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<String> tipList = new ArrayList<String>(tipSize);
        for (int i = 0; i < tipSize; ++i) {
            String randomWord = FontUtils.getRandomChar(random);
            tipList.add(randomWord);
        }
        return tipList;
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (this.font == null) {
            Resource fontResource = new Resource(null, "META-INF/fonts/SIMSUN.TTC");
            InputStream inputStream = new ClassPathResourceProvider().doGetResourceInputStream(fontResource);
            Font font = Font.createFont(0, inputStream);
            this.font = font.deriveFont(1, 70.0f);
        }
        this.currentFontTopCoef = this.coef * (float)this.font.getSize() + this.intercept;
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public StandardRandomWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, Font font) {
        super(imageCaptchaResourceManager);
        this.font = font;
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("WORD_IMAGE_CLICK", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg")));
    }

    public AbstractClickImageCaptchaGenerator.ImgWrapper genTipImage(List<ClickImageCheckDefinition> imageCheckDefinitions) {
        String tips = imageCheckDefinitions.stream().map(ClickImageCheckDefinition::getTip).collect(Collectors.joining());
        int fontWidth = tips.length() * this.font.getSize();
        int width = fontWidth + 6;
        int height = this.font.getSize() + 6;
        float left = (float)(width - fontWidth) / 2.0f;
        float top = 3.0f + (float)this.font.getSize() - this.currentFontTopCoef;
        BufferedImage bufferedImage = CaptchaImageUtils.genSimpleImgCaptcha(tips, this.font, width, height, left, top, this.tipImageInterferenceLineNum, this.tipImageInterferencePointNum);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(bufferedImage, tips);
    }

    @Override
    public AbstractClickImageCaptchaGenerator.ImgWrapper getClickImg(String tip) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Color randomColor = CaptchaImageUtils.getRandomColor(random);
        int randomDeg = ThreadLocalRandom.current().nextInt(0, 85);
        BufferedImage fontImage = CaptchaImageUtils.drawWordImg(randomColor, tip, this.font, this.currentFontTopCoef, this.clickImgWidth, this.clickImgHeight, randomDeg);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(fontImage, tip);
    }

    @Override
    public ImageCaptchaInfo wrapClickImageCaptchaInfo(GenerateParam param, BufferedImage bgImage, List<ClickImageCheckDefinition> checkClickImageCheckDefinitionList) {
        BufferedImage tipImage = this.genTipImage(checkClickImageCheckDefinitionList).getImage();
        ImageCaptchaInfo clickImageCaptchaInfo = new ImageCaptchaInfo();
        clickImageCaptchaInfo.setBackgroundImage(this.getImageTransform().transform(bgImage, param.getBackgroundFormatName()));
        clickImageCaptchaInfo.setSliderImage(this.getImageTransform().transform(tipImage, param.getSliderFormatName()));
        clickImageCaptchaInfo.setBgImageWidth(bgImage.getWidth());
        clickImageCaptchaInfo.setBgImageHeight(bgImage.getHeight());
        clickImageCaptchaInfo.setSliderImageWidth(tipImage.getWidth());
        clickImageCaptchaInfo.setSliderImageHeight(tipImage.getHeight());
        clickImageCaptchaInfo.setRandomX(null);
        clickImageCaptchaInfo.setTolerant(null);
        clickImageCaptchaInfo.setType("WORD_IMAGE_CLICK");
        clickImageCaptchaInfo.setExpand(checkClickImageCheckDefinitionList);
        return clickImageCaptchaInfo;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Integer getClickImgWidth() {
        return this.clickImgWidth;
    }

    public void setClickImgWidth(Integer clickImgWidth) {
        this.clickImgWidth = clickImgWidth;
    }

    public Integer getClickImgHeight() {
        return this.clickImgHeight;
    }

    public void setClickImgHeight(Integer clickImgHeight) {
        this.clickImgHeight = clickImgHeight;
    }

    public int getTipImageInterferenceLineNum() {
        return this.tipImageInterferenceLineNum;
    }

    public void setTipImageInterferenceLineNum(int tipImageInterferenceLineNum) {
        this.tipImageInterferenceLineNum = tipImageInterferenceLineNum;
    }

    public int getTipImageInterferencePointNum() {
        return this.tipImageInterferencePointNum;
    }

    public void setTipImageInterferencePointNum(int tipImageInterferencePointNum) {
        this.tipImageInterferencePointNum = tipImageInterferencePointNum;
    }
}

