/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.RotateImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class StandardRotateImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("ROTATE", new Resource("classpath", "META-INF/cut-image/resource".concat("/1.jpg")));
        HashMap<String, Resource> template1 = new HashMap<String, Resource>(4);
        template1.put("active.png", new Resource("classpath", "META-INF/cut-image/template".concat("/3/active.png")));
        template1.put("fixed.png", new Resource("classpath", "META-INF/cut-image/template".concat("/3/fixed.png")));
        template1.put("matrix.png", new Resource("classpath", "META-INF/cut-image/template".concat("/3/matrix.png")));
        resourceStore.addTemplate("ROTATE", template1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCaptchaInfo doGenerateCaptchaImage(GenerateParam param) {
        Map<String, Resource> templateImages = this.imageCaptchaResourceManager.randomGetTemplate(param.getType());
        if (templateImages == null || templateImages.isEmpty()) {
            return null;
        }
        LinkedList<InputStream> inputStreams = new LinkedList<InputStream>();
        try {
            Resource resourceImage = this.imageCaptchaResourceManager.randomGetResource(param.getType());
            InputStream resourceInputStream = this.imageCaptchaResourceManager.getResourceInputStream(resourceImage);
            inputStreams.add(resourceInputStream);
            BufferedImage cutBackground = CaptchaImageUtils.wrapFile2BufferedImage(resourceInputStream);
            BufferedImage targetBackground = CaptchaImageUtils.copyImage(cutBackground, cutBackground.getType());
            InputStream fixedTemplateInput = this.getTemplateFile(templateImages, "fixed.png");
            inputStreams.add(fixedTemplateInput);
            BufferedImage fixedTemplate = CaptchaImageUtils.wrapFile2BufferedImage(fixedTemplateInput);
            InputStream activeTemplateInput = this.getTemplateFile(templateImages, "active.png");
            inputStreams.add(activeTemplateInput);
            BufferedImage activeTemplate = CaptchaImageUtils.wrapFile2BufferedImage(activeTemplateInput);
            InputStream matrixTemplateInput = this.getTemplateFile(templateImages, "matrix.png");
            inputStreams.add(matrixTemplateInput);
            BufferedImage matrixTemplate = CaptchaImageUtils.wrapFile2BufferedImage(matrixTemplateInput);
            int x = targetBackground.getWidth() / 2 - fixedTemplate.getWidth() / 2;
            int y = targetBackground.getHeight() / 2 - fixedTemplate.getHeight() / 2;
            CaptchaImageUtils.overlayImage(targetBackground, fixedTemplate, x, y);
            BufferedImage cutImage = CaptchaImageUtils.cutImage(cutBackground, fixedTemplate, x, y);
            CaptchaImageUtils.overlayImage(cutImage, activeTemplate, 0, 0);
            int randomX = ThreadLocalRandom.current().nextInt(fixedTemplate.getWidth() + 10, targetBackground.getWidth() - 10);
            double degree = 360.0 - (double)randomX / ((double)targetBackground.getWidth() / 360.0);
            CaptchaImageUtils.centerOverlayAndRotateImage(matrixTemplate, cutImage, degree);
            ImageCaptchaInfo imageCaptchaInfo = this.wrapRotateCaptchaInfo(degree, randomX, targetBackground, matrixTemplate, param);
            return imageCaptchaInfo;
        }
        finally {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ImageCaptchaInfo wrapRotateCaptchaInfo(double degree, int randomX, BufferedImage backgroundImage, BufferedImage sliderImage, GenerateParam param) {
        String backgroundFormatName = param.getBackgroundFormatName();
        String sliderFormatName = param.getSliderFormatName();
        String backGroundImageBase64 = this.getImageTransform().transform(backgroundImage, backgroundFormatName);
        String sliderImageBase64 = this.getImageTransform().transform(sliderImage, sliderFormatName);
        return RotateImageCaptchaInfo.of(degree, randomX, backGroundImageBase64, sliderImageBase64, (Integer)backgroundImage.getWidth(), (Integer)backgroundImage.getHeight(), (Integer)sliderImage.getWidth(), sliderImage.getHeight());
    }
}

