/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.SliderImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSliderImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(StandardSliderImageCaptchaGenerator.class);
    public static final String DEFAULT_SLIDER_IMAGE_RESOURCE_PATH = "META-INF/cut-image/resource";
    public static final String DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH = "META-INF/cut-image/template";

    public StandardSliderImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardSliderImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit(boolean initDefaultResource) {
        if (initDefaultResource) {
            this.initDefaultResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCaptchaInfo doGenerateCaptchaImage(GenerateParam param) {
        SliderImageCaptchaInfo sliderImageCaptchaInfo;
        Boolean obfuscate = param.getObfuscate();
        Map<String, Resource> templateImages = this.imageCaptchaResourceManager.randomGetTemplate(param.getType());
        if (templateImages == null || templateImages.isEmpty()) {
            return null;
        }
        LinkedList<InputStream> inputStreams = new LinkedList<InputStream>();
        try {
            Resource resourceImage = this.imageCaptchaResourceManager.randomGetResource(param.getType());
            InputStream resourceInputStream = this.imageCaptchaResourceManager.getResourceInputStream(resourceImage);
            inputStreams.add(resourceInputStream);
            BufferedImage cutBackground = CaptchaImageUtils.wrapFile2BufferedImage(resourceInputStream);
            BufferedImage targetBackground = CaptchaImageUtils.copyImage(cutBackground, cutBackground.getType());
            InputStream fixedTemplateInput = this.getTemplateFile(templateImages, "fixed.png");
            inputStreams.add(fixedTemplateInput);
            BufferedImage fixedTemplate = CaptchaImageUtils.wrapFile2BufferedImage(fixedTemplateInput);
            InputStream activeTemplateInput = this.getTemplateFile(templateImages, "active.png");
            inputStreams.add(activeTemplateInput);
            BufferedImage activeTemplate = CaptchaImageUtils.wrapFile2BufferedImage(activeTemplateInput);
            InputStream matrixTemplateInput = this.getTemplateFile(templateImages, "matrix.png");
            inputStreams.add(matrixTemplateInput);
            BufferedImage matrixTemplate = CaptchaImageUtils.wrapFile2BufferedImage(matrixTemplateInput);
            int randomX = ThreadLocalRandom.current().nextInt(fixedTemplate.getWidth() + 5, targetBackground.getWidth() - fixedTemplate.getWidth() - 10);
            int randomY = ThreadLocalRandom.current().nextInt(targetBackground.getHeight() - fixedTemplate.getHeight());
            CaptchaImageUtils.overlayImage(targetBackground, fixedTemplate, randomX, randomY);
            if (obfuscate.booleanValue()) {
                int obfuscateX = this.randomObfuscateX(randomX, fixedTemplate.getWidth(), targetBackground.getWidth());
                CaptchaImageUtils.overlayImage(targetBackground, fixedTemplate, obfuscateX, randomY);
            }
            BufferedImage cutImage = CaptchaImageUtils.cutImage(cutBackground, fixedTemplate, randomX, randomY);
            CaptchaImageUtils.overlayImage(cutImage, activeTemplate, 0, 0);
            CaptchaImageUtils.overlayImage(matrixTemplate, cutImage, 0, randomY);
            sliderImageCaptchaInfo = this.wrapSliderCaptchaInfo(randomX, randomY, targetBackground, matrixTemplate, param);
        }
        catch (Throwable throwable) {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        for (InputStream inputStream : inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return sliderImageCaptchaInfo;
    }

    public SliderImageCaptchaInfo wrapSliderCaptchaInfo(int randomX, int randomY, BufferedImage backgroundImage, BufferedImage sliderImage, GenerateParam param) {
        String backgroundFormatName = param.getBackgroundFormatName();
        String sliderFormatName = param.getSliderFormatName();
        String backGroundImageBase64 = this.getImageTransform().transform(backgroundImage, backgroundFormatName);
        String sliderImageBase64 = this.getImageTransform().transform(sliderImage, sliderFormatName);
        return SliderImageCaptchaInfo.of(randomX, randomY, backGroundImageBase64, sliderImageBase64, (Integer)backgroundImage.getWidth(), (Integer)backgroundImage.getHeight(), (Integer)sliderImage.getWidth(), sliderImage.getHeight());
    }

    protected int randomObfuscateX(int sliderX, int slWidth, int bgWidth) {
        if (bgWidth / 2 > sliderX + slWidth / 2) {
            return ThreadLocalRandom.current().nextInt(sliderX + slWidth, bgWidth - slWidth);
        }
        return ThreadLocalRandom.current().nextInt(slWidth, sliderX - slWidth);
    }

    public void initDefaultResource() {
        ResourceStore resourceStore = this.imageCaptchaResourceManager.getResourceStore();
        resourceStore.addResource("SLIDER", new Resource("classpath", DEFAULT_SLIDER_IMAGE_RESOURCE_PATH.concat("/1.jpg")));
        HashMap<String, Resource> template1 = new HashMap<String, Resource>(4);
        template1.put("active.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/1/active.png")));
        template1.put("fixed.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/1/fixed.png")));
        template1.put("matrix.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/1/matrix.png")));
        resourceStore.addTemplate("SLIDER", template1);
        HashMap<String, Resource> template2 = new HashMap<String, Resource>(4);
        template2.put("active.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/2/active.png")));
        template2.put("fixed.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/2/fixed.png")));
        template2.put("matrix.png", new Resource("classpath", DEFAULT_SLIDER_IMAGE_TEMPLATE_PATH.concat("/2/matrix.png")));
        resourceStore.addTemplate("SLIDER", template2);
    }
}

