/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultResourceStore
implements ResourceStore {
    private Map<String, List<Map<String, Resource>>> templateResourceMap = new HashMap<String, List<Map<String, Resource>>>(2);
    private Map<String, List<Resource>> resourceMap = new HashMap<String, List<Resource>>(2);

    @Override
    public void addResource(String type, Resource resource) {
        this.resourceMap.computeIfAbsent(type, k -> new ArrayList(20)).add(resource);
    }

    @Override
    public void clearResources(String type) {
        this.resourceMap.remove(type);
    }

    @Override
    public void clearAllResources() {
        this.resourceMap.clear();
    }

    @Override
    public Map<String, List<Resource>> listAllResources() {
        return this.resourceMap;
    }

    @Override
    public List<Resource> listResourcesByType(String type) {
        return this.resourceMap.getOrDefault(type, Collections.emptyList());
    }

    @Override
    public Resource randomGetResource(String type) {
        List<Resource> resources = this.resourceMap.get(type);
        if (CollectionUtils.isEmpty(resources)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type);
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(resources.size());
        return resources.get(randomIndex);
    }

    @Override
    public int getAllResourceCount() {
        int count = 0;
        for (List<Resource> value : this.resourceMap.values()) {
            count += value.size();
        }
        return count;
    }

    @Override
    public int getResourceCount(String type) {
        return this.resourceMap.getOrDefault(type, Collections.emptyList()).size();
    }

    @Override
    public void addTemplate(String type, Map<String, Resource> template) {
        this.templateResourceMap.computeIfAbsent(type, k -> new ArrayList(2)).add(template);
    }

    @Override
    public void clearAllTemplates() {
        this.templateResourceMap.clear();
    }

    @Override
    public void clearTemplates(String type) {
        this.templateResourceMap.remove(type);
    }

    @Override
    public List<Map<String, Resource>> listTemplatesByType(String type) {
        return this.templateResourceMap.getOrDefault(type, Collections.emptyList());
    }

    @Override
    public Map<String, List<Map<String, Resource>>> listAllTemplates() {
        return this.templateResourceMap;
    }

    @Override
    public Map<String, Resource> randomGetTemplateByType(String type) {
        List<Map<String, Resource>> templateList = this.templateResourceMap.get(type);
        if (CollectionUtils.isEmpty(templateList)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type);
        }
        if (templateList.size() == 1) {
            return templateList.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(templateList.size());
        return templateList.get(randomIndex);
    }
}

