/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.validator.impl;

import cloud.tianai.captcha.common.util.CaptchaUtils;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleImageCaptchaValidator
implements ImageCaptchaValidator {
    private static final Logger log = LoggerFactory.getLogger(SimpleImageCaptchaValidator.class);
    public static float DEFAULT_TOLERANT = 0.02f;
    public static final String PERCENTAGE_KEY = "percentage";
    public static final String TOLERANT_KEY = "tolerant";
    public static final String TYPE_KEY = "type";
    public float defaultTolerant = DEFAULT_TOLERANT;

    public SimpleImageCaptchaValidator() {
    }

    public SimpleImageCaptchaValidator(float defaultTolerant) {
        this.defaultTolerant = defaultTolerant;
    }

    @Override
    public float calcPercentage(Number pos, Number maxPos) {
        return pos.floatValue() / maxPos.floatValue();
    }

    @Override
    public boolean checkPercentage(Float newPercentage, Float oriPercentage) {
        return this.checkPercentage(newPercentage, oriPercentage, this.defaultTolerant);
    }

    @Override
    public boolean checkPercentage(Float newPercentage, Float oriPercentage, float tolerant) {
        if (newPercentage == null || Float.isNaN(newPercentage.floatValue()) || Float.isInfinite(newPercentage.floatValue()) || oriPercentage == null || Float.isNaN(oriPercentage.floatValue()) || Float.isInfinite(oriPercentage.floatValue())) {
            return false;
        }
        float maxTolerant = oriPercentage.floatValue() + tolerant;
        float minTolerant = oriPercentage.floatValue() - tolerant;
        return newPercentage.floatValue() >= minTolerant && newPercentage.floatValue() <= maxTolerant;
    }

    @Override
    public Map<String, Object> generateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (this.beforeGenerateImageCaptchaValidData(imageCaptchaInfo, map)) {
            this.doGenerateImageCaptchaValidData(map, imageCaptchaInfo);
        }
        this.afterGenerateImageCaptchaValidData(imageCaptchaInfo, map);
        return map;
    }

    public boolean beforeGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo, Map<String, Object> map) {
        String type;
        Float tolerant = imageCaptchaInfo.getTolerant();
        if (tolerant != null && tolerant.floatValue() > 0.0f) {
            map.put(TOLERANT_KEY, tolerant);
        }
        if (ObjectUtils.isEmpty(type = imageCaptchaInfo.getType())) {
            type = "SLIDER";
        }
        map.put(TYPE_KEY, type);
        return true;
    }

    public void afterGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo, Map<String, Object> map) {
    }

    public void doGenerateImageCaptchaValidData(Map<String, Object> map, ImageCaptchaInfo imageCaptchaInfo) {
        String type = (String)map.getOrDefault(TYPE_KEY, "SLIDER");
        if (CaptchaUtils.isSliderCaptcha(type)) {
            this.addPercentage(imageCaptchaInfo, map);
        } else if (CaptchaUtils.isClickCaptcha(type)) {
            List clickImageCheckDefinitionList;
            Object expand = imageCaptchaInfo.getExpand();
            if (expand == null) {
                throw new IllegalArgumentException("\u70b9\u9009\u9a8c\u8bc1\u7801\u6269\u5c55\u6570\u636e\u8f6c\u6362\u4e3a List<ClickImageCheckDefinition> \u5931\u8d25\uff0c info=" + imageCaptchaInfo);
            }
            try {
                clickImageCheckDefinitionList = (List)expand;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u70b9\u9009\u9a8c\u8bc1\u7801\u6269\u5c55\u6570\u636e\u8f6c\u6362\u4e3a List<ClickImageCheckDefinition> \u5931\u8d25\uff0c info=" + imageCaptchaInfo);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < clickImageCheckDefinitionList.size(); ++i) {
                ClickImageCheckDefinition definition = (ClickImageCheckDefinition)clickImageCheckDefinitionList.get(i);
                Integer x = definition.getX();
                Integer y = definition.getY();
                Integer width = imageCaptchaInfo.getBgImageWidth();
                Integer height = imageCaptchaInfo.getBgImageHeight();
                float vx = this.calcPercentage(x, width);
                float vy = this.calcPercentage(y, height);
                sb.append(vx).append(",").append(vy).append(";");
                if (i != 0 || map.containsKey(TOLERANT_KEY)) continue;
                float minLeft = this.calcPercentage(Float.valueOf((float)x.intValue() - (float)definition.getWidth().intValue() / 2.0f), width);
                float tolerant = vx - minLeft;
                map.put(TOLERANT_KEY, Float.valueOf(tolerant));
            }
            map.put(PERCENTAGE_KEY, sb.toString());
        }
    }

    @Override
    public boolean valid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData) {
        String type;
        Float tolerant = this.getFloatParam(TOLERANT_KEY, sliderCaptchaValidData, Float.valueOf(this.defaultTolerant));
        if (!this.beforeValid(imageCaptchaTrack, sliderCaptchaValidData, tolerant, type = this.getStringParam(TYPE_KEY, sliderCaptchaValidData, "SLIDER"))) {
            return false;
        }
        Integer bgImageWidth = imageCaptchaTrack.getBgImageWidth();
        if (bgImageWidth == null || bgImageWidth < 1) {
            return false;
        }
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (CollectionUtils.isEmpty(trackList)) {
            return false;
        }
        boolean valid = this.doValid(imageCaptchaTrack, sliderCaptchaValidData, tolerant, type);
        if (valid) {
            valid = this.afterValid(imageCaptchaTrack, sliderCaptchaValidData, tolerant, type);
        }
        return valid;
    }

    public boolean beforeValid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        return true;
    }

    public boolean afterValid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        return true;
    }

    public boolean doValid(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        if (CaptchaUtils.isSliderCaptcha(type)) {
            return this.doValidSliderCaptcha(imageCaptchaTrack, sliderCaptchaValidData, tolerant, type);
        }
        if (CaptchaUtils.isClickCaptcha(type)) {
            return this.doValidClickCaptcha(imageCaptchaTrack, sliderCaptchaValidData, tolerant, type);
        }
        log.warn("\u6821\u9a8c\u9a8c\u8bc1\u7801\u8b66\u544a\uff0c \u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u7801\u7c7b\u578b:{}, \u8bf7\u624b\u52a8\u6269\u5c55 cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator.doValid \u8fdb\u884c\u6821\u9a8c\u6269\u5c55", (Object)type);
        return false;
    }

    public boolean doValidClickCaptcha(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        String validStr = this.getStringParam(PERCENTAGE_KEY, sliderCaptchaValidData, null);
        if (ObjectUtils.isEmpty(validStr)) {
            return false;
        }
        String[] splitArr = validStr.split(";");
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (trackList.size() < splitArr.length) {
            return false;
        }
        List clickTrackList = trackList.stream().filter(t -> "CLICK".equalsIgnoreCase(t.getType())).collect(Collectors.toList());
        if (clickTrackList.size() != splitArr.length) {
            return false;
        }
        for (int i = 0; i < splitArr.length; ++i) {
            ImageCaptchaTrack.Track track = (ImageCaptchaTrack.Track)clickTrackList.get(i);
            String posStr = splitArr[i];
            String[] posArr = posStr.split(",");
            float xPercentage = Float.parseFloat(posArr[0]);
            float yPercentage = Float.parseFloat(posArr[1]);
            float calcXPercentage = this.calcPercentage(track.getX(), imageCaptchaTrack.getBgImageWidth());
            float calcYPercentage = this.calcPercentage(track.getY(), imageCaptchaTrack.getBgImageHeight());
            if (this.checkPercentage(Float.valueOf(calcXPercentage), Float.valueOf(xPercentage), tolerant.floatValue()) && this.checkPercentage(Float.valueOf(calcYPercentage), Float.valueOf(yPercentage), tolerant.floatValue())) continue;
            return false;
        }
        return true;
    }

    public boolean doValidSliderCaptcha(ImageCaptchaTrack imageCaptchaTrack, Map<String, Object> sliderCaptchaValidData, Float tolerant, String type) {
        Float oriPercentage = this.getFloatParam(PERCENTAGE_KEY, sliderCaptchaValidData);
        if (oriPercentage == null) {
            return false;
        }
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        ImageCaptchaTrack.Track lastTrack = trackList.get(trackList.size() - 1);
        float calcPercentage = this.calcPercentage(lastTrack.getX(), imageCaptchaTrack.getBgImageWidth());
        return this.checkPercentage(Float.valueOf(calcPercentage), oriPercentage, tolerant.floatValue());
    }

    public Float getFloatParam(String key, Map<String, Object> sliderCaptchaValidData) {
        return this.getFloatParam(key, sliderCaptchaValidData, null);
    }

    public Float getFloatParam(String key, Map<String, Object> sliderCaptchaValidData, Float defaultData) {
        Object data = sliderCaptchaValidData.get(key);
        if (data != null) {
            if (data instanceof Number) {
                return Float.valueOf(((Number)data).floatValue());
            }
            try {
                if (data instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)data));
                }
            }
            catch (NumberFormatException e) {
                log.error("\u4ece sliderCaptchaValidData \u8bfb\u53d6\u5230\u7684 " + key + "\u65e0\u6cd5\u8f6c\u6362\u6210float\u7c7b\u578b, [{}]", data);
                throw e;
            }
        }
        return defaultData;
    }

    public String getStringParam(String key, Map<String, Object> sliderCaptchaValidData, String defaultData) {
        if (CollectionUtils.isEmpty(sliderCaptchaValidData)) {
            return defaultData;
        }
        Object data = sliderCaptchaValidData.get(key);
        if (data != null) {
            if (data instanceof String) {
                return (String)data;
            }
            try {
                return String.valueOf(data);
            }
            catch (NumberFormatException e) {
                log.error("\u4ece sliderCaptchaValidData \u8bfb\u53d6\u5230\u7684 " + key + "\u65e0\u6cd5\u8f6c\u6362\u6210String\u7c7b\u578b, [{}]", data);
                throw e;
            }
        }
        return defaultData;
    }

    protected void addPercentage(ImageCaptchaInfo imageCaptchaInfo, Map<String, Object> sliderCaptchaValidData) {
        float percentage = this.calcPercentage(imageCaptchaInfo.getRandomX(), imageCaptchaInfo.getBgImageWidth());
        sliderCaptchaValidData.put(PERCENTAGE_KEY, Float.valueOf(percentage));
    }

    public float getDefaultTolerant() {
        return this.defaultTolerant;
    }

    public void setDefaultTolerant(float defaultTolerant) {
        this.defaultTolerant = defaultTolerant;
    }
}

