/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.BeanException;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.clone.CloneSupport;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;

public class DynaBean
extends CloneSupport<DynaBean>
implements Serializable {
    private static final long serialVersionUID = 1197818330017827323L;
    private Class<?> beanClass;
    private Object bean;

    public static DynaBean create(Object bean) {
        return new DynaBean(bean);
    }

    public static DynaBean create(Class<?> beanClass, Object ... params) {
        return new DynaBean(beanClass, params);
    }

    public DynaBean(Class<?> beanClass, Object ... params) {
        this(ReflectUtil.newInstance(beanClass, params));
    }

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            bean = ((DynaBean)bean).getBean();
        }
        this.bean = bean;
        this.beanClass = ClassUtil.getClass(bean);
    }

    public <T> T get(String fieldName) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        try {
            Method method = BeanUtil.getBeanDesc(this.beanClass).getGetter(fieldName);
            if (null == method) {
                throw new BeanException("No get method for {}", fieldName);
            }
            return (T)method.invoke(this.bean, new Object[0]);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public <T> T safeGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void set(String fieldName, Object value) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
            return;
        }
        try {
            Method setter = BeanUtil.getBeanDesc(this.beanClass).getSetter(fieldName);
            if (null == setter) {
                throw new BeanException("No set method for {}", fieldName);
            }
            setter.invoke(this.bean, value);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public Object invoke(String methodName, Object ... params) {
        return ReflectUtil.invoke(this.bean, methodName, params);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)obj;
        return !(this.bean == null ? other.bean != null : !this.bean.equals(other.bean));
    }

    public String toString() {
        return this.bean.toString();
    }
}

