/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlFormatter;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    public static String buildEqualsWhere(Entity entity, List<Object> paramValues) {
        if (null == entity || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : entity.entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("`").append(" = ?");
            paramValues.add(entry.getValue());
        }
        return sb.toString();
    }

    public static Condition[] buildConditions(Entity entity) {
        if (null == entity || entity.isEmpty()) {
            return null;
        }
        Condition[] conditions = new Condition[entity.size()];
        int i = 0;
        for (Map.Entry entry : entity.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Condition) {
                conditions[i++] = (Condition)value;
                continue;
            }
            conditions[i++] = new Condition((String)entry.getKey(), value);
        }
        return conditions;
    }

    public static String buildLikeValue(String value, Condition.LikeType likeType, boolean withLikeKeyword) {
        if (null == value) {
            return value;
        }
        StringBuilder likeValue = StrUtil.builder(withLikeKeyword ? "LIKE " : "");
        switch (likeType) {
            case StartWith: {
                likeValue.append('%').append(value);
                break;
            }
            case EndWith: {
                likeValue.append(value).append('%');
                break;
            }
            case Contains: {
                likeValue.append('%').append(value).append('%');
                break;
            }
        }
        return likeValue.toString();
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str(rowId.getBytes(), CharsetUtil.CHARSET_ISO_8859_1);
    }

    public static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read(reader);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    public static String blobToStr(Blob blob, Charset charset) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static java.sql.Date toSqlDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    public static Timestamp toSqlTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }
}

