/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;

public class AdvancedClassTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(AdvancedClassTypeUtil.class);
    public static List<String> TEMP_SCAN_PACKAGE_LIST = null;

    public static boolean ensureEntityFlag(Class<?> clazz) {
        if (TEMP_SCAN_PACKAGE_LIST == null) {
            Object packageStr = null;
            try {
                ScannerProperties properties = (ScannerProperties)SpringUtil.getBean(ScannerProperties.class);
                String entityScanPackage = properties.getEntityScanPackage();
                if (ObjectUtil.isEmpty((Object)entityScanPackage)) {
                    TEMP_SCAN_PACKAGE_LIST = new ArrayList<String>();
                    return false;
                }
                Object[] scanPackages = entityScanPackage.split(",");
                TEMP_SCAN_PACKAGE_LIST = ListUtil.toLinkedList((Object[])scanPackages);
            }
            catch (Exception e) {
                TEMP_SCAN_PACKAGE_LIST = new ArrayList<String>();
                return false;
            }
        }
        for (String packageName : TEMP_SCAN_PACKAGE_LIST) {
            if (!clazz.getName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public static FieldTypeEnum getClassFieldType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (ClassUtil.isSimpleValueType((Class)clazz)) {
                return FieldTypeEnum.BASIC;
            }
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                if (ClassUtil.isSimpleValueType(componentType)) {
                    return FieldTypeEnum.BASE_ARRAY;
                }
                return FieldTypeEnum.ARRAY_WITH_OBJECT;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return FieldTypeEnum.BASE_COLLECTION;
            }
            if (AdvancedClassTypeUtil.ensureEntityFlag(clazz)) {
                return FieldTypeEnum.OBJECT;
            }
            if (Object.class.equals((Object)clazz)) {
                return FieldTypeEnum.BASIC;
            }
            log.debug("\u7c7b\u578b\u662fClass\uff0c\u4f46\u6709\u5904\u7406\u4e0d\u5230\u7684\u60c5\u51b5\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)clazz.toGenericString());
            return FieldTypeEnum.OTHER;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class rawTypeClass = (Class)rawType;
                if (Collection.class.isAssignableFrom(rawTypeClass)) {
                    return FieldTypeEnum.COLLECTION_WITH_OBJECT;
                }
                if (AdvancedClassTypeUtil.ensureEntityFlag(rawTypeClass)) {
                    return FieldTypeEnum.OBJECT_WITH_GENERIC;
                }
                if (Map.class.isAssignableFrom(rawTypeClass)) {
                    return FieldTypeEnum.BASIC;
                }
                log.debug("\u6cdb\u578b\u7684\u4e3b\u4f53\u60c5\u51b5\u4e0d\u786e\u5b9a\uff0c\u4e0d\u5904\u7406\uff0c\u6253\u5370\u51farawTypeClass\uff1a{}", (Object)rawTypeClass.getName());
                return FieldTypeEnum.OTHER;
            }
            log.debug("rawType\u4e3a\u975eClass\u7c7b\u578b\uff1f\u6253\u5370\u51farawType\uff1a{}", (Object)rawType.getTypeName());
            return FieldTypeEnum.OTHER;
        }
        if (type instanceof TypeVariableImpl) {
            return FieldTypeEnum.WITH_UNKNOWN_GENERIC;
        }
        if (type instanceof WildcardTypeImpl) {
            return FieldTypeEnum.OTHER;
        }
        log.debug("\u672a\u77e5\u7c7b\u578b\u7684\u5904\u7406\uff0c\u65e2\u4e0d\u662fclass\u4e5f\u4e0d\u662fParameterizedType\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)type.getTypeName());
        return FieldTypeEnum.OTHER;
    }
}

