/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.context.tenant;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TenantInformation {
    private static final Logger logger = LoggerFactory.getLogger(TenantInformation.class);
    private static final Integer LAST_LETTERS_NUMBER = 5;
    private static final String ENCRYPTION_PREFIX = "**********";
    @Value(value="${tenant.id:}")
    private String tenantId;
    @Value(value="${accessKey:}")
    private String accessKey;
    @Value(value="${secretKey:}")
    private String secretKey;

    @PostConstruct
    public void init() {
        String spasKeyLocationFromEnv;
        String spasKeyLocationFromJVM;
        String tenantIdFromJVM = System.getProperty("tenant.id");
        if (this.initTenantInfo(tenantIdFromJVM, spasKeyLocationFromJVM = System.getProperty("spas.identity"))) {
            return;
        }
        String tenantIdFromEnv = System.getenv("tenant.id");
        if (this.initTenantInfo(tenantIdFromEnv, spasKeyLocationFromEnv = System.getenv("spas.identity"))) {
            return;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.tenantId, this.accessKey, this.secretKey})) {
            logger.info("tenantId={},accessKey={},secretKey={}", new Object[]{this.tenantId, this.accessKey, this.encryptionString(this.secretKey)});
            return;
        }
        logger.warn("WARN!tenantId={},accessKey={},secretKey={}.missing tenant info!", new Object[]{this.tenantId, this.accessKey, this.encryptionString(this.secretKey)});
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    private boolean initTenantInfo(String tenant, String spasPath) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenant, spasPath})) {
            try {
                this.tenantId = tenant;
                Properties prop = new Properties();
                prop.load(new FileInputStream(spasPath));
                this.accessKey = prop.getProperty("accessKey");
                this.secretKey = prop.getProperty("secretKey");
            }
            catch (IOException e) {
                throw new RuntimeException("read spas.identity file error!", e);
            }
            logger.info("tenantId={},accessKey={},secretKey={}", new Object[]{this.tenantId, this.accessKey, this.encryptionString(this.secretKey)});
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)tenant) || StringUtils.isNotBlank((CharSequence)spasPath)) {
            throw new RuntimeException("ERROR, tenant.id and spas.identity should configured at the same time");
        }
        return false;
    }

    private String encryptionString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        int beginIndex = str.length() - LAST_LETTERS_NUMBER > 0 ? str.length() - LAST_LETTERS_NUMBER : 0;
        return ENCRYPTION_PREFIX + str.substring(beginIndex);
    }
}

