/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class PojoUtils {
    private static final ConcurrentMap<String, Method> NAME_METHODS_CACHE = new ConcurrentHashMap<String, Method>();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();

    public static Object[] generalize(Object[] objs) {
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.generalize(objs[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types) {
        if (objs.length != types.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types, Type[] gtypes) {
        if (objs.length != types.length || objs.length != gtypes.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i], gtypes[i]);
        }
        return dests;
    }

    public static Object generalize(Object pojo) {
        return PojoUtils.generalize(pojo, new IdentityHashMap<Object, Object>());
    }

    private static Object generalize(Object pojo, Map<Object, Object> history) {
        return null;
    }

    public static Object realize(Object pojo, Class<?> type) {
        return PojoUtils.realize0(pojo, type, null, new IdentityHashMap<Object, Object>());
    }

    public static Object realize(Object pojo, Class<?> type, Type genericType) {
        return PojoUtils.realize0(pojo, type, genericType, new IdentityHashMap<Object, Object>());
    }

    private static Collection<Object> createCollection(Class<?> type, int len) {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>(len);
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>(len);
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static Map createMap(Map src) {
        Class<?> cl = src.getClass();
        Map result = null;
        if (HashMap.class == cl) {
            result = new HashMap();
        } else if (Hashtable.class == cl) {
            result = new Hashtable();
        } else if (IdentityHashMap.class == cl) {
            result = new IdentityHashMap();
        } else if (LinkedHashMap.class == cl) {
            result = new LinkedHashMap();
        } else if (Properties.class == cl) {
            result = new Properties();
        } else if (TreeMap.class == cl) {
            result = new TreeMap();
        } else {
            if (WeakHashMap.class == cl) {
                return new WeakHashMap();
            }
            if (ConcurrentHashMap.class == cl) {
                result = new ConcurrentHashMap();
            } else if (ConcurrentSkipListMap.class == cl) {
                result = new ConcurrentSkipListMap();
            } else {
                try {
                    result = (Map)cl.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (result == null) {
                    try {
                        Constructor<?> constructor = cl.getConstructor(Map.class);
                        result = (Map)constructor.newInstance(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private static Object realize0(Object pojo, Class<?> type, Type genericType, Map<Object, Object> history) {
        return null;
    }

    private static Type getGenericClassByIndex(Type genericType, int index) {
        Type clazz = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)genericType;
            Type[] types = t.getActualTypeArguments();
            clazz = types[index];
        }
        return clazz;
    }

    private static Object newInstance(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Throwable t) {
            try {
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors != null && constructors.length == 0) {
                    throw new RuntimeException("Illegal constructor: " + cls.getName());
                }
                Constructor<?> constructor = constructors[0];
                if (constructor.getParameterTypes().length > 0) {
                    for (Constructor<?> c : constructors) {
                        if (c.getParameterTypes().length < constructor.getParameterTypes().length && (constructor = c).getParameterTypes().length == 0) break;
                    }
                }
                return constructor.newInstance(new Object[constructor.getParameterTypes().length]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static Method getSetterMethod(Class<?> cls, String property, Class<?> valueCls) {
        return null;
    }

    private static Field getField(Class<?> cls, String fieldName) {
        return null;
    }

    public static boolean isPojo(Class<?> cls) {
        return false;
    }

    private static class PojoInvocationHandler
    implements InvocationHandler {
        private Map<Object, Object> map;

        public PojoInvocationHandler(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.map, args);
            }
            String methodName = method.getName();
            Object value = null;
            value = methodName.length() > 3 && methodName.startsWith("get") ? this.map.get(methodName.substring(3, 4).toLowerCase() + methodName.substring(4)) : (methodName.length() > 2 && methodName.startsWith("is") ? this.map.get(methodName.substring(2, 3).toLowerCase() + methodName.substring(3)) : this.map.get(methodName.substring(0, 1).toLowerCase() + methodName.substring(1)));
            if (value instanceof Map && !Map.class.isAssignableFrom(method.getReturnType())) {
                value = PojoUtils.realize0((Map)value, method.getReturnType(), null, new IdentityHashMap());
            }
            return value;
        }
    }
}

