/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.status;

import java.util.HashMap;
import java.util.Map;

public enum ProcessResult {
    OK("HSF Provider process succeed.", 20),
    RemotingUnknownError("Some unknown exception happened in hsf provider during process IO protocol.Please check hsf.log in provider's machine.", 50),
    NoSuchService("HSF Provider cannot find target service.", 60),
    NoSuchMethod("HSF Provider cannot find target method.", 61),
    NoInterceptorFound("HSF cannot find a interceptor to process this request", 62),
    BizException("HSF Provider catch some exception when invoke biz method.", 70),
    ThreadPoolIsFull("Provider's HSF thread pool is full.", 81),
    ProviderSerializeError("Deserialize request error on provider side.Please make sure the arguments of request are serializable and your dependency is latest", 84),
    PermissionVerifyReject("HSF Provider reject your request because spas verify your permission failed.", 85),
    UnitVerifyReject("HSF Provider reject your request because of wrong target unit.", 86),
    ProviderUnknownError("Some unknown exception happened in hsf provider.Please check hsf.log in provider's machine.", 91);

    private String message;
    private int status;
    private static Map<Integer, ProcessResult> codeMap;

    private ProcessResult(String message, int status) {
        this.message = message;
        this.status = status;
    }

    public String message() {
        return this.message;
    }

    public int status() {
        return this.status;
    }

    public static ProcessResult valueOf(int status) {
        return codeMap.get(status);
    }

    static {
        codeMap = new HashMap<Integer, ProcessResult>();
        for (ProcessResult single : ProcessResult.values()) {
            codeMap.put(single.status(), single);
        }
    }
}

