/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.util.ReflectUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import sun.misc.Unsafe;

public class PojoUtils {
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Method>> NAME_METHODS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static boolean isUnSafeEnabled;
    private static Unsafe unsafe;
    private static List<Class> WARP_TYPE;

    public static Object[] generalize(Object[] objs) {
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.generalize(objs[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types) {
        if (objs.length != types.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types, Type[] gtypes) {
        if (objs == null) {
            return new Object[types.length];
        }
        if (objs.length != types.length || objs.length != gtypes.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i], gtypes[i]);
        }
        return dests;
    }

    public static Object removeGeneralizedClassInfo(Object appResponse) {
        return PojoUtils.simplifyPojo(appResponse, true, false);
    }

    public static Object simplifyPojo(Object appResponse, boolean removeClass, boolean removeNull) {
        if (!removeClass && !removeNull) {
            return appResponse;
        }
        if (appResponse == null || ReflectUtils.isPrimitives(appResponse.getClass())) {
            return appResponse;
        }
        if (appResponse.getClass().isArray()) {
            int len = Array.getLength(appResponse);
            Object[] dest = new Object[len];
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(appResponse, i);
                dest[i] = PojoUtils.simplifyPojo(obj, removeClass, removeNull);
            }
            return dest;
        }
        if (appResponse instanceof Collection) {
            Collection src = (Collection)appResponse;
            int len = src.size();
            AbstractCollection dest = appResponse instanceof List ? new ArrayList(len) : new HashSet(len);
            for (Object obj : src) {
                dest.add(PojoUtils.simplifyPojo(obj, removeClass, removeNull));
            }
            return dest;
        }
        if (appResponse instanceof Map) {
            Map src = (Map)appResponse;
            Map dest = PojoUtils.createMap(src);
            for (Map.Entry obj : src.entrySet()) {
                if (removeClass && obj.getKey().equals("class") || removeNull && obj.getValue() == null) continue;
                dest.put(PojoUtils.simplifyPojo(obj.getKey(), removeClass, removeNull), PojoUtils.simplifyPojo(obj.getValue(), removeClass, removeNull));
            }
            return dest;
        }
        return appResponse;
    }

    public static Object generalize(Object pojo) {
        return PojoUtils.generalize(pojo, new IdentityHashMap<Object, Object>(), false, false);
    }

    public static Object generalize(Object pojo, boolean removeClass, boolean removeNull) {
        return PojoUtils.generalize(pojo, new IdentityHashMap<Object, Object>(), removeClass, removeNull);
    }

    private static Object generalize(Object pojo, Map<Object, Object> history, boolean removeClass, boolean removeNull) {
        Object result;
        if (pojo == null) {
            return null;
        }
        if (pojo instanceof Enum) {
            return ((Enum)pojo).name();
        }
        if (pojo.getClass().isArray() && Enum.class.isAssignableFrom(pojo.getClass().getComponentType())) {
            int len = Array.getLength(pojo);
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = ((Enum)Array.get(pojo, i)).name();
            }
            return values;
        }
        if (ReflectUtils.isPrimitives(pojo.getClass())) {
            return pojo;
        }
        if (pojo instanceof Class) {
            return ((Class)pojo).getName();
        }
        Object o = history.get(pojo);
        if (o != null) {
            return o;
        }
        history.put(pojo, pojo);
        if (pojo.getClass().isArray()) {
            int len = Array.getLength(pojo);
            Object[] dest = new Object[len];
            history.put(pojo, dest);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(pojo, i);
                dest[i] = PojoUtils.generalize(obj, history, removeClass, removeNull);
            }
            return dest;
        }
        if (pojo instanceof Collection) {
            Collection src = (Collection)pojo;
            int len = src.size();
            AbstractCollection dest = pojo instanceof List ? new ArrayList(len) : new HashSet(len);
            history.put(pojo, dest);
            for (Object e : src) {
                dest.add(PojoUtils.generalize(e, history, removeClass, removeNull));
            }
            return dest;
        }
        if (pojo instanceof Map) {
            Map src = (Map)pojo;
            Map dest = PojoUtils.createMap(src);
            history.put(pojo, dest);
            for (Map.Entry obj : src.entrySet()) {
                dest.put(PojoUtils.generalize(obj.getKey(), history, removeClass, removeNull), PojoUtils.generalize(obj.getValue(), history, removeClass, removeNull));
            }
            return dest;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        history.put(pojo, map);
        if (!removeClass) {
            map.put("class", pojo.getClass().getName());
        }
        for (Method method : pojo.getClass().getMethods()) {
            if (!ReflectUtils.isBeanPropertyReadMethod(method)) continue;
            try {
                String propertyName = ReflectUtils.getPropertyNameFromBeanReadMethod(method);
                try {
                    Field field = pojo.getClass().getDeclaredField(propertyName);
                    if (null != field && method.getName().startsWith("is") && field.getType() != Boolean.TYPE && field.getType() != Boolean.class) {
                        continue;
                    }
                }
                catch (Exception t) {
                    // empty catch block
                }
                method.setAccessible(true);
                result = PojoUtils.generalize(method.invoke(pojo, new Object[0]), history, removeClass, removeNull);
                if (removeNull && result == null) continue;
                map.put(propertyName, result);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    throw new RuntimeException("Pojo generalized failed!", e.getCause());
                }
                throw new RuntimeException("Pojo generalized failed!", e);
            }
        }
        for (AccessibleObject accessibleObject : pojo.getClass().getFields()) {
            if (!ReflectUtils.isPublicInstanceField((Field)accessibleObject)) continue;
            try {
                Object pojoGenerilizedValue;
                Object fieldValue = ((Field)accessibleObject).get(pojo);
                if (history.containsKey(pojo) && (pojoGenerilizedValue = history.get(pojo)) instanceof Map && ((Map)pojoGenerilizedValue).containsKey(((Field)accessibleObject).getName()) || fieldValue == null) continue;
                result = PojoUtils.generalize(fieldValue, history, removeClass, removeNull);
                if (removeNull && result == null) continue;
                map.put(((Field)accessibleObject).getName(), result);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return map;
    }

    public static Object realize(Object pojo, Class<?> type) {
        return PojoUtils.realize0(pojo, type, null, new IdentityHashMap<Object, Object>());
    }

    public static Object realize(Object pojo, Class<?> type, Type genericType) {
        return PojoUtils.realize0(pojo, type, genericType, new IdentityHashMap<Object, Object>());
    }

    private static Collection<Object> createCollection(Class<?> type, int len) {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>(len);
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>(len);
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static Map createMap(Map src) {
        Class<?> cl = src.getClass();
        Map result = null;
        if (HashMap.class == cl) {
            result = new HashMap();
        } else if (Hashtable.class == cl) {
            result = new Hashtable();
        } else if (IdentityHashMap.class == cl) {
            result = new IdentityHashMap();
        } else if (LinkedHashMap.class == cl) {
            result = new LinkedHashMap();
        } else if (Properties.class == cl) {
            result = new Properties();
        } else if (TreeMap.class == cl) {
            result = new TreeMap();
        } else {
            if (WeakHashMap.class == cl) {
                return new WeakHashMap();
            }
            if (ConcurrentHashMap.class == cl) {
                result = new ConcurrentHashMap();
            } else if (ConcurrentSkipListMap.class == cl) {
                result = new ConcurrentSkipListMap();
            } else {
                try {
                    result = (Map)cl.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (result == null) {
                    try {
                        Constructor<?> constructor = cl.getConstructor(Map.class);
                        result = (Map)constructor.newInstance(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private static Object realize0(Object pojo, Class<?> type, Type genericType, Map<Object, Object> history) {
        return null;
    }

    private static Type getGenericClassByIndex(Type genericType, int index) {
        Type clazz = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)genericType;
            Type[] types = t.getActualTypeArguments();
            clazz = types[index];
        }
        return clazz;
    }

    private static Object newInstance(Class<?> cls) {
        return null;
    }

    private static Method getSetterMethod(Class<?> cls, String property, Class<?> valueCls) {
        String name = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method method = null;
        ConcurrentHashMap<String, Method> methods = (ConcurrentHashMap<String, Method>)NAME_METHODS_CACHE.get(cls);
        if (methods != null) {
            method = (Method)methods.get(name + "(" + valueCls.getName() + ")");
        } else {
            methods = new ConcurrentHashMap<String, Method>();
            NAME_METHODS_CACHE.put(cls, methods);
        }
        if (method == null) {
            block15: {
                try {
                    try {
                        method = cls.getMethod(name, valueCls);
                    }
                    catch (NoSuchMethodException e) {
                        if (WARP_TYPE.contains(valueCls)) {
                            try {
                                Field f = valueCls.getField("TYPE");
                                method = cls.getMethod(name, (Class)f.get(null));
                                break block15;
                            }
                            catch (NoSuchFieldException e1) {
                                throw e;
                            }
                            catch (IllegalAccessException e2) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
                catch (NoSuchMethodException e) {
                    ArrayList<Method> reloadMethods = new ArrayList<Method>();
                    for (Method m : cls.getMethods()) {
                        if (!ReflectUtils.isBeanPropertyWriteMethod(m) || !m.getName().equals(name)) continue;
                        reloadMethods.add(m);
                    }
                    if (reloadMethods.size() != 1 && !WARP_TYPE.contains(valueCls)) {
                        for (Method reload : reloadMethods) {
                            if (reload.getParameterTypes()[0].isPrimitive() || WARP_TYPE.contains(reload.getParameterTypes()[0])) continue;
                            method = reload;
                            break;
                        }
                    }
                    if (null != method || reloadMethods.size() <= 0) break block15;
                    method = (Method)reloadMethods.get(0);
                }
            }
            if (method != null) {
                methods.putIfAbsent(name + "(" + valueCls.getName() + ")", method);
            }
        }
        return method;
    }

    private static Field getField(Class<?> cls, String fieldName) {
        Field result = null;
        if (CLASS_FIELD_CACHE.containsKey(cls) && ((ConcurrentMap)CLASS_FIELD_CACHE.get(cls)).containsKey(fieldName)) {
            return (Field)((ConcurrentMap)CLASS_FIELD_CACHE.get(cls)).get(fieldName);
        }
        try {
            result = cls.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            for (Field field : cls.getFields()) {
                if (!fieldName.equals(field.getName()) || !ReflectUtils.isPublicInstanceField(field)) continue;
                result = field;
                break;
            }
        }
        if (result == null) {
            for (Field field : cls.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                field.setAccessible(true);
                result = field;
                break;
            }
        }
        if (result != null) {
            ConcurrentMap<String, Field> fields = (ConcurrentHashMap)CLASS_FIELD_CACHE.get(cls);
            if (fields == null) {
                fields = new ConcurrentHashMap();
                CLASS_FIELD_CACHE.putIfAbsent(cls, fields);
            }
            fields = (ConcurrentMap)CLASS_FIELD_CACHE.get(cls);
            fields.putIfAbsent(fieldName, result);
        }
        return result;
    }

    public static boolean isPojo(Class<?> cls) {
        return !ReflectUtils.isPrimitives(cls) && !Collection.class.isAssignableFrom(cls) && !Map.class.isAssignableFrom(cls);
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    public static boolean isGenericBizException(Object appResponse) {
        if (!(appResponse instanceof Map)) {
            return false;
        }
        Map response = (Map)appResponse;
        return response.containsKey("cause") && response.containsKey("message") && response.containsKey("stackTrace");
    }

    public static Throwable getGenericBizException(Object appResponse) {
        return null;
    }

    public static boolean isGenericMethod(String methodName, String[] sig) {
        return methodName.equals("$invoke") && sig != null && sig.length == 3;
    }

    static {
        WARP_TYPE = new ArrayList<Class>();
        WARP_TYPE.add(Byte.class);
        WARP_TYPE.add(Character.class);
        WARP_TYPE.add(Short.class);
        WARP_TYPE.add(Integer.class);
        WARP_TYPE.add(Float.class);
        WARP_TYPE.add(Double.class);
        WARP_TYPE.add(Long.class);
        try {
            unsafe = PojoUtils.getUnsafe();
            isUnSafeEnabled = unsafe != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PojoInvocationHandler
    implements InvocationHandler {
        private Map<Object, Object> map;

        public PojoInvocationHandler(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.map, args);
            }
            String methodName = method.getName();
            Object value = null;
            value = methodName.length() > 3 && methodName.startsWith("get") ? this.map.get(methodName.substring(3, 4).toLowerCase() + methodName.substring(4)) : (methodName.length() > 2 && methodName.startsWith("is") ? this.map.get(methodName.substring(2, 3).toLowerCase() + methodName.substring(3)) : this.map.get(methodName.substring(0, 1).toLowerCase() + methodName.substring(1)));
            if (value instanceof Map && !Map.class.isAssignableFrom(method.getReturnType())) {
                value = PojoUtils.realize0((Map)value, method.getReturnType(), null, new IdentityHashMap());
            }
            return value;
        }
    }
}

