/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.filter.impl;

import com.alibaba.nacos.api.config.filter.AbstractConfigFilter;
import com.alibaba.nacos.api.config.filter.IConfigFilterChain;
import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.util.Objects;
import java.util.Properties;

public class ConfigEncryptionFilter
extends AbstractConfigFilter {
    private static final String DEFAULT_NAME = ConfigEncryptionFilter.class.getName();

    @Override
    public void init(Properties properties) {
    }

    @Override
    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws NacosException {
        String dataId;
        if (Objects.nonNull(request) && request instanceof ConfigRequest && Objects.isNull(response)) {
            ConfigRequest configRequest = (ConfigRequest)request;
            dataId = configRequest.getDataId();
            String content = configRequest.getContent();
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            String secretKey = (String)pair.getFirst();
            String encryptContent = (String)pair.getSecond();
            if (!StringUtils.isBlank(encryptContent) && !encryptContent.equals(content)) {
                ((ConfigRequest)request).setContent(encryptContent);
            }
            if (!StringUtils.isBlank(secretKey) && !secretKey.equals(((ConfigRequest)request).getEncryptedDataKey())) {
                ((ConfigRequest)request).setEncryptedDataKey(secretKey);
            } else if (StringUtils.isBlank(((ConfigRequest)request).getEncryptedDataKey()) && StringUtils.isBlank(secretKey)) {
                ((ConfigRequest)request).setEncryptedDataKey("");
            }
        }
        if (Objects.nonNull(response) && response instanceof ConfigResponse && Objects.isNull(request)) {
            ConfigResponse configResponse = (ConfigResponse)response;
            dataId = configResponse.getDataId();
            String encryptedDataKey = configResponse.getEncryptedDataKey();
            String content = configResponse.getContent();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)content);
            String secretKey = (String)pair.getFirst();
            String decryptContent = (String)pair.getSecond();
            if (!StringUtils.isBlank(decryptContent) && !decryptContent.equals(content)) {
                ((ConfigResponse)response).setContent(decryptContent);
            }
            if (!StringUtils.isBlank(secretKey) && !secretKey.equals(((ConfigResponse)response).getEncryptedDataKey())) {
                ((ConfigResponse)response).setEncryptedDataKey(secretKey);
            } else if (StringUtils.isBlank(((ConfigResponse)response).getEncryptedDataKey()) && StringUtils.isBlank(secretKey)) {
                ((ConfigResponse)response).setEncryptedDataKey("");
            }
        }
        filterChain.doFilter(request, response);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String getFilterName() {
        return DEFAULT_NAME;
    }
}

