/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.selector;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.selector.NamingSelector;
import com.alibaba.nacos.client.naming.selector.DefaultNamingSelector;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class NamingSelectorFactory {
    public static final NamingSelector EMPTY_SELECTOR = context -> context::getInstances;
    public static final NamingSelector HEALTHY_SELECTOR = new DefaultNamingSelector(Instance::isHealthy);

    private NamingSelectorFactory() {
    }

    public static NamingSelector newClusterSelector(Collection<String> clusters) {
        if (CollectionUtils.isNotEmpty(clusters)) {
            HashSet<String> set = new HashSet<String>(clusters);
            Predicate<Instance> filter = instance -> set.contains(instance.getClusterName());
            String clusterString = NamingSelectorFactory.getUniqueClusterString(clusters);
            return new ClusterSelector(filter, clusterString);
        }
        return EMPTY_SELECTOR;
    }

    public static NamingSelector newIpSelector(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("The parameter 'regex' cannot be null.");
        }
        return new DefaultNamingSelector(instance -> Pattern.matches(regex, instance.getIp()));
    }

    public static NamingSelector newMetadataSelector(Map<String, String> metadata) {
        return NamingSelectorFactory.newMetadataSelector(metadata, false);
    }

    public static NamingSelector newMetadataSelector(Map<String, String> metadata, boolean isAny) {
        if (metadata == null) {
            throw new IllegalArgumentException("The parameter 'metadata' cannot be null.");
        }
        Predicate<Instance> filter = instance -> instance.getMetadata().size() >= metadata.size();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Predicate<Instance> nextFilter = instance -> {
                Map<String, String> map = instance.getMetadata();
                return Objects.equals(map.get(entry.getKey()), entry.getValue());
            };
            if (isAny) {
                filter = filter.or(nextFilter);
                continue;
            }
            filter = filter.and(nextFilter);
        }
        return new DefaultNamingSelector(filter);
    }

    public static String getUniqueClusterString(Collection<String> cluster) {
        TreeSet<String> treeSet = new TreeSet<String>(cluster);
        return StringUtils.join(treeSet, ",");
    }

    private static class ClusterSelector
    extends DefaultNamingSelector {
        private final String clusterString;

        public ClusterSelector(Predicate<Instance> filter, String clusterString) {
            super(filter);
            this.clusterString = clusterString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterSelector that = (ClusterSelector)o;
            return Objects.equals(this.clusterString, that.clusterString);
        }

        public int hashCode() {
            return Objects.hashCode(this.clusterString);
        }
    }
}

