/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.spi.LogbackFilterGenerator;
import com.alipay.sofa.common.log.spi.LogbackReInitializer;
import com.alipay.sofa.common.log.spi.ReInitializeChecker;
import com.alipay.sofa.common.utils.AssertUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class LogbackLoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private SpaceId spaceId;
    private LoggerContext loggerContext;
    private Properties properties;
    private URL confFile;

    public LogbackLoggerSpaceFactory(SpaceId spaceId, LoggerContext loggerContext, Properties properties, URL confFile, String source) {
        super(source);
        this.spaceId = spaceId;
        this.loggerContext = loggerContext;
        this.properties = properties;
        this.confFile = confFile;
        boolean willReinitialize = false;
        Iterator<ReInitializeChecker> checkers = ServiceLoader.load(ReInitializeChecker.class, this.getClass().getClassLoader()).iterator();
        while (checkers.hasNext()) {
            willReinitialize = !checkers.next().isReInitialize();
        }
        Iterator<LogbackFilterGenerator> matchers = ServiceLoader.load(LogbackFilterGenerator.class, this.getClass().getClassLoader()).iterator();
        while (matchers.hasNext() && willReinitialize) {
            LogbackFilterGenerator matcher = matchers.next();
            this.loggerContext.getTurboFilterList().addAll(Arrays.asList(matcher.generatorFilters()));
        }
        this.initialize(willReinitialize);
    }

    public Logger getLogger(String name) {
        return this.loggerContext.getLogger(name);
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) throws Exception {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)this.getLogger(loggerName);
        Level logbackLevel = this.toLogbackLevel(adapterLevel);
        logbackLogger.setLevel(logbackLevel);
        return logbackLogger;
    }

    private Level toLogbackLevel(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to logback.");
        }
        switch (adapterLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to logback.");
    }

    private void initialize(boolean willReInitialize) {
        AssertUtil.notNull(this.loggerContext);
        AssertUtil.notNull(this.properties);
        AssertUtil.notNull(this.confFile);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            this.loggerContext.putProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.confFile != null && !willReInitialize) {
            try {
                new ContextInitializer(this.loggerContext).configureByResource(this.confFile);
            }
            catch (JoranException e) {
                throw new IllegalStateException("Logback loggerSpaceFactory build error", e);
            }
        } else {
            BasicConfigurator basicConfigurator = new BasicConfigurator();
            basicConfigurator.setContext((Context)this.loggerContext);
            basicConfigurator.configure(this.loggerContext);
        }
    }

    public void reInitialize(Map<String, String> environment) {
        Iterator<LogbackReInitializer> matchers;
        String spaceLoggingConfig;
        this.properties.putAll(environment);
        String spaceLoggingPath = environment.get("logging.path." + this.spaceId.getSpaceName());
        if (!StringUtil.isBlank(spaceLoggingPath)) {
            this.properties.setProperty("logging.path." + this.spaceId.getSpaceName(), spaceLoggingPath);
        } else if (Boolean.TRUE.toString().equals(this.properties.getProperty("isDefaultLogPath"))) {
            this.properties.setProperty("logging.path." + this.spaceId.getSpaceName(), this.properties.getProperty("logging.path"));
        }
        String loggingLevelKey = "logging.level." + this.spaceId.getSpaceName();
        if (Boolean.TRUE.toString().equals(this.properties.getProperty("isDefaultLogLevel")) && StringUtil.isBlank(environment.get(loggingLevelKey))) {
            for (int i = "logging.level".length(); i < loggingLevelKey.length(); ++i) {
                String level;
                if (loggingLevelKey.charAt(i) != '.' || StringUtil.isBlank(level = environment.get(loggingLevelKey.substring(0, i + 1) + "*"))) continue;
                this.properties.setProperty(loggingLevelKey, level);
            }
        }
        if (!StringUtil.isBlank(spaceLoggingConfig = environment.get(String.format("logging.config.%s", this.spaceId.getSpaceName())))) {
            this.confFile = this.getClass().getClassLoader().getResource(spaceLoggingConfig);
        }
        if ((matchers = ServiceLoader.load(LogbackReInitializer.class, this.getClass().getClassLoader()).iterator()).hasNext()) {
            LogbackReInitializer logbackReInitializer = matchers.next();
            logbackReInitializer.reInitialize(this.spaceId, this.loggerContext, this.properties, this.confFile);
        }
    }
}

