/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.exception;

import com.taobao.api.internal.toplink.embedded.websocket.exception.ErrorCode;

public class WebSocketException
extends Exception {
    private static final long serialVersionUID = -1043043011439925850L;
    private final ErrorCode code;
    private String[] formatArgs;

    public WebSocketException(ErrorCode code) {
        this.code = code;
    }

    public WebSocketException(ErrorCode code, String ... formatArgs) {
        this.code = code;
        this.formatArgs = formatArgs;
    }

    public WebSocketException(ErrorCode code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public WebSocketException(ErrorCode code, Throwable cause, String ... formatArgs) {
        super(cause);
        this.code = code;
        this.formatArgs = formatArgs;
    }

    public String getMessage() {
        int errorCode = this.getErrorCode();
        if (this.formatArgs != null) {
            return "[" + errorCode + "] " + String.format(this.code.getMessage(), this.formatArgs);
        }
        return "[" + errorCode + "] " + this.code.getMessage();
    }

    public int getErrorCode() {
        int errorCode = Integer.valueOf(this.code.name().substring(1, 5));
        return errorCode;
    }
}

