/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.request;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import darabonba.core.RequestStyle;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.utils.CommonUtil;
import java.util.Map;

public class RpcReqInterceptor
implements RequestInterceptor {
    private final ClientLogger logger = new ClientLogger(RpcReqInterceptor.class);

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        this.logger.verbose("RPC request pre-process begin.");
        TeaRequest request = context.teaRequest();
        if (!request.style().equals((Object)RequestStyle.RPC) && !request.style().equals((Object)RequestStyle.SSE)) {
            return request;
        }
        TeaConfiguration configuration = context.configuration();
        ClientConfiguration clientConfiguration = configuration.clientConfiguration();
        PopSigner signer = (PopSigner)clientConfiguration.option(ClientOption.SIGNER);
        if (signer.getSignerVersion() != SignatureVersion.V1) {
            return request;
        }
        Map query = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)request.action()), new TeaPair("Format", (Object)"JSON"), new TeaPair("Version", (Object)request.version())}), request.query()});
        Map headers = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("x-acs-version", (Object)request.version()), new TeaPair("x-acs-action", (Object)request.action()), new TeaPair("user-agent", clientConfiguration.option(ClientOption.USER_AGENT))}), request.headers().toMap()});
        if (request.style().equals((Object)RequestStyle.SSE)) {
            headers.put("X-DashScope-SSE", "enable");
        }
        request.setQuery(query).setHeaders(new HttpHeaders(headers));
        return request;
    }
}

