/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.DataFilterBase;
import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.utils.DataFilterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class DataFilter
implements DataFilterBase {
    private String oldBranchDb = null;
    private String filterInfo;
    private String sourceFilter;
    private String connectStoreFilterConditions;
    private final StringBuilder builder;
    private final Map<String, Map<String, List<String>>> requires;
    private final Map<String, Map<String, List<String>>> dbTableColsReflectionMap;
    private boolean isAllMatch = true;
    private String tenant;

    public DataFilter() {
        this.filterInfo = null;
        this.builder = new StringBuilder();
        this.requires = new HashMap<String, Map<String, List<String>>>();
        this.dbTableColsReflectionMap = new HashMap<String, Map<String, List<String>>>();
    }

    public DataFilter(String tenant, String tableFields) {
        this(tableFields);
        this.tenant = tenant;
    }

    public DataFilter(String tableFields) {
        this.builder = new StringBuilder();
        this.requires = new HashMap<String, Map<String, List<String>>>();
        this.dbTableColsReflectionMap = new HashMap<String, Map<String, List<String>>>();
        this.builder.append(tableFields);
        this.sourceFilter = tableFields;
    }

    @Override
    public void setBranchDb(String db) {
        this.oldBranchDb = db;
    }

    public void addTablesFields(String tableFields) {
        this.builder.append(tableFields);
    }

    @Override
    public boolean getIsAllMatch() {
        return this.isAllMatch;
    }

    @Override
    public Map<String, Map<String, List<String>>> getReflectionMap() {
        return this.dbTableColsReflectionMap;
    }

    @Override
    public Map<String, Map<String, List<String>>> getRequireMap() {
        return this.requires;
    }

    public String toString() {
        return this.connectStoreFilterConditions;
    }

    private boolean validateNormalFilterString() {
        if (this.filterInfo != null) {
            return true;
        }
        String s = this.builder.toString();
        String[] tbs = s.split("\\|");
        if (tbs == null) {
            return false;
        }
        StringBuilder builder1 = new StringBuilder();
        for (String s1 : tbs) {
            String itemTb;
            int colStart;
            String itemDb;
            String[] tb = s1.split("[;,\\.]");
            if (tb == null || tb.length <= 0) continue;
            if (tb.length <= 2) {
                itemDb = this.oldBranchDb != null ? this.oldBranchDb : "*";
                colStart = 1;
                itemTb = tb[0];
            } else {
                colStart = 2;
                itemDb = tb[0];
                itemTb = tb[1];
            }
            if (this.tenant != null) {
                builder1.append(this.tenant).append(".");
            }
            builder1.append(itemDb).append(".").append(itemTb).append("|");
            if (colStart <= 0 || tb.length <= colStart) continue;
            ArrayList<String> cols = new ArrayList<String>();
            for (int i = colStart; i < tb.length; ++i) {
                cols.add(tb[i]);
                if ("*".equals(tb[i])) continue;
                this.isAllMatch = false;
            }
            DataFilterUtil.putColNames(itemDb, itemTb, cols, this);
        }
        if (builder1.charAt(builder1.length() - 1) == '|') {
            builder1.deleteCharAt(builder1.length() - 1);
        }
        this.connectStoreFilterConditions = this.filterInfo = builder1.toString();
        return true;
    }

    private boolean validateOB10FilterString() {
        if (this.sourceFilter == null) {
            return false;
        }
        String[] tenantAndDbAndTBAndCols = this.sourceFilter.split("\\|");
        if (tenantAndDbAndTBAndCols == null) {
            return false;
        }
        this.requires.clear();
        StringBuilder filterConditionBuilder = new StringBuilder();
        for (String s1 : tenantAndDbAndTBAndCols) {
            String[] tb = s1.split("[;,\\.]");
            if (null == tb || tb.length < 4) {
                return false;
            }
            String tenant = tb[0];
            String dbname = this.oldBranchDb != null ? this.oldBranchDb : tb[1];
            String tableName = tb[2];
            ArrayList<String> cols = new ArrayList<String>();
            for (int i = 3; i < tb.length; ++i) {
                cols.add(tb[i]);
                if ("*".equals(tb[i])) continue;
                this.isAllMatch = false;
            }
            String formatDBName = tenant + "." + dbname;
            filterConditionBuilder.append(formatDBName).append(".");
            filterConditionBuilder.append(tableName).append("|");
            DataFilterUtil.putColNames(formatDBName, tableName, cols, this);
        }
        this.connectStoreFilterConditions = filterConditionBuilder.toString();
        return true;
    }

    @Override
    public boolean validateFilter(DBType dbType) throws DRCClientException {
        switch (dbType) {
            case OCEANBASE1: {
                return this.validateOB10FilterString();
            }
        }
        return this.validateNormalFilterString();
    }

    @Override
    public String getConnectStoreFilterConditions() {
        return this.connectStoreFilterConditions;
    }
}

