/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.client.message.Message;
import java.io.DataInputStream;
import java.io.IOException;

public class MonitorMessage
extends Message {
    private String monitorName;
    private boolean switchOn;
    private String monitorIP;
    private String monitorPort;
    private static final String delimiter = " ";

    public String getName() {
        return this.monitorName;
    }

    public void setName(String name) {
        this.monitorName = name;
    }

    public boolean willOn() {
        return this.switchOn;
    }

    public void switchOn() {
        this.switchOn = true;
    }

    public void switchOff() {
        this.switchOn = false;
    }

    public String getIP() {
        return this.monitorIP;
    }

    public void setIP(String ip) {
        this.monitorIP = ip;
    }

    public String getPort() {
        return this.monitorPort;
    }

    public void setPort(String port) {
        this.monitorPort = port;
    }

    @Override
    public void mergeFrom(DataInputStream in) throws IOException {
        String line = in.readLine();
        String[] params = line.split(delimiter);
        if (params.length != 4) {
            throw new IOException("Parse monitor message " + line + " error");
        }
        this.monitorName = params[0];
        this.switchOn = params[1].equalsIgnoreCase("on");
        this.monitorIP = params[2];
        this.monitorPort = params[3];
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.monitorName + delimiter + this.switchOn + delimiter + this.monitorIP + delimiter + this.monitorPort + System.getProperty("line.separator"));
        return builder.toString();
    }
}

