/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.impl.DRCClientRunTimeException;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.utils.BinaryMessageUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;

public class DrcNETBinaryRecord
extends DataMessage.Record {
    private static final String DEFAULT_ENCODING = "ASCII";
    private static final String SEP = System.getProperty("line.separator");
    private static final int OLD_VERSION_2_HEADER_LEN = 88;
    private static final int NEW_VERSION_2_HEADER_LEN = 96;
    private static final int VERSION_3_HEADER_LEN = 104;
    private static final int PREFIX_LENGTH = 12;
    private int brVersion = -1;
    private int srcType = -1;
    private int op = -1;
    private int lastInLogEvent = -1;
    private long srcCategory = -1L;
    private long id = -1L;
    private long timestamp = -1L;
    private long encoding = -1L;
    private long instanceOffset = -1L;
    private long timeMarkOffset = -1L;
    private long dbNameOffset = -1L;
    private long tbNameOffset = -1L;
    private long colNamesOffset = -1L;
    private long colTypesOffset = -1L;
    private long fileNameOffset = -1L;
    private long fileOffset = -1L;
    private long oldColsOffset = -1L;
    private long newColsOffset = -1L;
    private long pkKeysOffset = -1L;
    private long ukColsOffset = -1L;
    private long colsEncodingOffset = -1L;
    private long filterRuleValOffset = -1L;
    private long tailOffset = -1L;
    private String dbName;
    private String tableName;
    private String serverId;
    private List<Integer> primaryKeyIndexList;
    private String uniqueKeyList;
    private ByteBuf byteBuf;
    private List<String> pkValues;
    private List<Long> timeMarks = null;
    private static final int[] elementArray = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
    private static final int BYTE_SIZE = 1;
    private static final int INT_SIZE = 4;
    private final CRC32 crc32 = new CRC32();
    private boolean isCheckCRC = false;

    public DrcNETBinaryRecord(boolean isCheckCRC) {
        this.isCheckCRC = isCheckCRC;
    }

    public int getVersion() {
        return this.brVersion;
    }

    @Override
    public DBType getDbType() {
        switch (this.srcType) {
            case 0: {
                return DBType.MYSQL;
            }
            case 1: {
                return DBType.OCEANBASE;
            }
            case 2: {
                return DBType.HBASE;
            }
            case 3: {
                return DBType.ORACLE;
            }
            case 4: {
                return DBType.OCEANBASE1;
            }
        }
        return DBType.UNKNOWN;
    }

    @Override
    public boolean isQueryBack() {
        switch ((int)this.srcCategory) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFirstInLogevent() {
        return this.lastInLogEvent == 1;
    }

    @Override
    public DataMessage.Record.Type getOpt() {
        return DataMessage.Record.Type.valueOf(this.op);
    }

    @Override
    public String getId() {
        return Long.toString(this.id);
    }

    @Override
    public String getDbname() {
        if (this.dbName == null) {
            if ((int)this.dbNameOffset < 0) {
                this.dbName = "";
            } else {
                try {
                    this.dbName = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.dbNameOffset, DEFAULT_ENCODING);
                }
                catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return this.dbName == "" ? null : this.dbName;
    }

    @Override
    public final String getTablename() {
        if (this.tableName == null) {
            if ((int)this.tbNameOffset < 0) {
                this.tableName = "";
            } else {
                try {
                    this.tableName = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.tbNameOffset, DEFAULT_ENCODING);
                }
                catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return this.tableName == "" ? null : this.tableName;
    }

    @Override
    public String getCheckpoint() {
        return this.fileOffset + "@" + this.fileNameOffset;
    }

    @Override
    public String getTimestamp() {
        return Long.toString(this.timestamp);
    }

    @Override
    public String getServerId() {
        if (this.serverId == null) {
            if ((int)this.instanceOffset < 0) {
                this.serverId = "";
            } else {
                try {
                    this.serverId = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.instanceOffset, DEFAULT_ENCODING);
                }
                catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return this.serverId == "" ? null : this.serverId;
    }

    @Override
    public synchronized List<DataMessage.Record.Field> getFieldList() {
        try {
            if (this.fields == null) {
                if (this.colNamesOffset < 0L || this.colTypesOffset < 0L || this.oldColsOffset < 0L || this.newColsOffset < 0L) {
                    return this.fields;
                }
                String encodingStr = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.encoding, DEFAULT_ENCODING);
                List pks = null;
                if ((int)this.pkKeysOffset > 0) {
                    pks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
                }
                ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])this.byteBuf.array()).order(ByteOrder.LITTLE_ENDIAN);
                wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L));
                int count = wrapByteBuf.readInt();
                this.fields = new ArrayList(count);
                wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset);
                byte t = wrapByteBuf.readByte();
                int elementSize = elementArray[t & 0xF];
                int colEncodingsCount = 0;
                int currentEncodingOffset = 0;
                if (this.colsEncodingOffset > 0L) {
                    wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L));
                    colEncodingsCount = wrapByteBuf.readInt();
                    currentEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L));
                int currentColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L));
                int oldColCount = wrapByteBuf.readInt();
                int currentOldColOffset = -1;
                if (0 != oldColCount) {
                    currentOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L));
                int newColCount = wrapByteBuf.readInt();
                int currentNewColOffset = -1;
                if (0 != newColCount) {
                    currentNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                for (int i = 0; i < count; ++i) {
                    ByteString value;
                    boolean isPk = false;
                    if (pks != null && pks.contains(i)) {
                        isPk = true;
                    }
                    int type = 0;
                    wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset + 1 + 4 + i * elementSize);
                    switch (elementSize) {
                        case 1: {
                            type = wrapByteBuf.readUnsignedByte();
                            break;
                        }
                        case 2: {
                            type = wrapByteBuf.readUnsignedShort();
                            break;
                        }
                        case 4: {
                            type = (int)wrapByteBuf.readUnsignedInt();
                            break;
                        }
                        case 8: {
                            type = (int)wrapByteBuf.readLong();
                        }
                    }
                    String realEncoding = encodingStr;
                    wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L + 4L + (long)((i + 1) * 4)));
                    if (colEncodingsCount > 0) {
                        int nextEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                        ByteString encodingByteString = new ByteString(wrapByteBuf.array(), 12 + currentEncodingOffset + 1 + 4 + (count + 1) * 4 + (int)this.colsEncodingOffset, nextEncodingOffset - currentEncodingOffset - 1);
                        realEncoding = encodingByteString.toString();
                        if (realEncoding.isEmpty()) {
                            realEncoding = (type == 253 || type == 254) && DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.STRING ? "binary" : (DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.BLOB ? "" : (type == 245 ? "utf8mb4" : DEFAULT_ENCODING));
                        }
                        currentEncodingOffset = nextEncodingOffset;
                    }
                    if (!realEncoding.isEmpty() && type == DataMessage.Record.Field.Type.BLOB.ordinal()) {
                        type = 15;
                    }
                    wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                    ByteString ColNameByteString = new ByteString(wrapByteBuf.array(), 12 + currentColNameOffset + 1 + 4 + (count + 1) * 4 + (int)this.colNamesOffset, nextColNameOffset - currentColNameOffset - 1);
                    String columnName = ColNameByteString.toString();
                    currentColNameOffset = nextColNameOffset;
                    if (oldColCount != 0) {
                        wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                        int nextOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                        value = null;
                        if (nextOldColOffset != currentOldColOffset) {
                            value = new ByteString(wrapByteBuf.array(), 12 + currentOldColOffset + 1 + 4 + (count + 1) * 4 + (int)this.oldColsOffset, nextOldColOffset - currentOldColOffset - 1);
                        }
                        this.fields.add(new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk));
                        currentOldColOffset = nextOldColOffset;
                    }
                    if (newColCount == 0) continue;
                    wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                    value = null;
                    if (currentNewColOffset != nextNewColOffset) {
                        value = new ByteString(wrapByteBuf.array(), 12 + currentNewColOffset + 1 + 4 + (count + 1) * 4 + (int)this.newColsOffset, nextNewColOffset - currentNewColOffset - 1);
                    }
                    this.fields.add(new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk));
                    currentNewColOffset = nextNewColOffset;
                }
            }
        }
        catch (Exception e) {
            this.fields = null;
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return this.fields;
    }

    @Override
    public int getFieldCount() {
        return this.getFieldList().size();
    }

    public List getPrimaryKeyIndex() {
        try {
            if (this.primaryKeyIndexList == null) {
                this.primaryKeyIndexList = (int)this.pkKeysOffset < 0 ? new ArrayList<Integer>() : BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
            }
        }
        catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return this.primaryKeyIndexList;
    }

    @Override
    public void parse(byte[] data) throws Exception {
        ByteBuf inner = Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length).order(ByteOrder.LITTLE_ENDIAN);
        this.setByteBuf(inner);
    }

    public void setByteBuf(ByteBuf byteBuf) throws Exception {
        this.byteBuf = byteBuf;
        byteBuf.readerIndex(12);
        if ((byteBuf.readByte() & 0xF) != 2) {
            throw new Exception("parse error");
        }
        long count = byteBuf.readInt();
        boolean old = false;
        switch ((int)count) {
            case 88: {
                old = true;
                break;
            }
            case 96: 
            case 104: {
                break;
            }
            default: {
                throw new Exception("");
            }
        }
        this.brVersion = byteBuf.readUnsignedByte();
        this.srcType = byteBuf.readUnsignedByte();
        this.op = byteBuf.readUnsignedByte();
        this.lastInLogEvent = byteBuf.readByte();
        this.srcCategory = byteBuf.readInt();
        this.id = byteBuf.readLong();
        this.timestamp = byteBuf.readLong();
        this.encoding = byteBuf.readInt();
        this.instanceOffset = byteBuf.readInt();
        this.timeMarkOffset = byteBuf.readInt();
        this.dbNameOffset = byteBuf.readInt();
        this.tbNameOffset = byteBuf.readInt();
        this.colNamesOffset = byteBuf.readInt();
        this.colTypesOffset = byteBuf.readInt();
        if (!old) {
            byteBuf.readInt();
            this.fileNameOffset = byteBuf.readLong();
            this.fileOffset = byteBuf.readLong();
            if (this.fileNameOffset < -1L || this.fileOffset < -1L) {
                throw new IOException("f: " + this.fileNameOffset + " and o: " + this.fileOffset + " should both be signed integer");
            }
            this.oldColsOffset = byteBuf.readInt();
            this.newColsOffset = byteBuf.readInt();
        } else {
            this.fileNameOffset = byteBuf.readInt();
            this.fileOffset = byteBuf.readInt();
            this.oldColsOffset = byteBuf.readInt();
            this.newColsOffset = byteBuf.readInt();
            byteBuf.readInt();
        }
        this.pkKeysOffset = byteBuf.readInt();
        this.ukColsOffset = byteBuf.readInt();
        if (this.brVersion > 1) {
            this.colsEncodingOffset = byteBuf.readLong();
        }
        if (this.brVersion == 3) {
            this.filterRuleValOffset = byteBuf.readInt();
            this.tailOffset = byteBuf.readInt();
        }
        DataMessage.Record.Type type = DataMessage.Record.Type.valueOf(this.op);
        String ts = Long.toString(this.timestamp);
        if (this.getDbType() == DBType.OCEANBASE1) {
            gloalSafeTimestamp.set(String.valueOf(this.fileNameOffset));
        } else {
            if (type == DataMessage.Record.Type.BEGIN) {
                gloalSafeTimestamp.set(ts);
                txEnd.set(false);
            }
            if (((Boolean)txEnd.get()).booleanValue()) {
                gloalSafeTimestamp.set(ts);
            }
            if (type == DataMessage.Record.Type.COMMIT || type == DataMessage.Record.Type.ROLLBACK) {
                txEnd.set(true);
            }
        }
        this.safeTimestamp = new String((String)gloalSafeTimestamp.get());
        if (this.isCheckCRC) {
            this.checkCRC();
        }
    }

    private void checkCRC() throws IOException {
        long value = this.getCRCValue();
        if (value == 0L) {
            return;
        }
        this.crc32.update(this.byteBuf.array(), 0, this.byteBuf.array().length - 4);
        long actual = this.crc32.getValue();
        this.crc32.reset();
        if (value != actual) {
            throw new IOException("crc 32 check failed,expect:" + value + ",actual:" + actual);
        }
    }

    @Override
    public String getTraceId() throws Exception {
        List<ByteString> list = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.filterRuleValOffset);
        if (list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString traceId = list.get(2);
        return traceId == null ? null : traceId.toString();
    }

    @Override
    public String getThreadId() throws Exception {
        long threadId = 0L;
        if (this.tailOffset == -1L) {
            return null;
        }
        List list = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.tailOffset);
        if (list == null || list.size() == 0) {
            return null;
        }
        threadId += (long)((Integer)list.get(0)).intValue();
        threadId += (long)((Integer)list.get(1)).intValue() << 8;
        threadId += (long)((Integer)list.get(2)).intValue() << 16;
        return String.valueOf(threadId += (long)((Integer)list.get(3)).intValue() << 24);
    }

    public List<String> getPrimaryKeyValue() {
        try {
            if (this.pkValues != null) {
                return this.pkValues;
            }
            if (this.colNamesOffset < 0L || this.pkKeysOffset < 0L) {
                return null;
            }
            this.pkValues = new ArrayList<String>();
            List pks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
            List<ByteString> names = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.colNamesOffset);
            if (pks != null) {
                Iterator iterator = pks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    this.pkValues.add(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return this.pkValues;
        }
        catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getPrimaryKeys() {
        List<String> primaryKeyStringList = this.getPrimaryKeyValue();
        if (primaryKeyStringList != null) {
            StringBuilder pkKeyName = new StringBuilder();
            for (String idx : primaryKeyStringList) {
                if (pkKeyName.length() != 0) {
                    pkKeyName.append(",");
                }
                pkKeyName.append(idx);
            }
            return pkKeyName.toString();
        }
        return "";
    }

    @Override
    public String getUniqueColNames() {
        try {
            if (this.uniqueKeyList == null) {
                if ((int)this.ukColsOffset < 0) {
                    this.uniqueKeyList = "";
                    return this.uniqueKeyList;
                }
                List uks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.ukColsOffset);
                List<ByteString> names = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.colNamesOffset);
                StringBuilder ukKeyName = new StringBuilder();
                if (uks != null) {
                    Iterator iterator = uks.iterator();
                    while (iterator.hasNext()) {
                        int idx = (Integer)iterator.next();
                        if (ukKeyName.length() != 0) {
                            ukKeyName.append(",");
                        }
                        ukKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                    }
                }
                this.uniqueKeyList = ukKeyName.toString();
                return this.uniqueKeyList;
            }
        }
        catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return this.uniqueKeyList;
    }

    public List<Long> getTimemarks() throws IOException {
        if (this.timeMarkOffset == -1L) {
            return null;
        }
        if (this.timeMarks == null) {
            this.timeMarks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.timeMarkOffset);
        }
        return this.timeMarks;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:" + (Object)((Object)this.getOpt())).append(SEP);
        builder.append("record_id:" + this.getId()).append(SEP);
        builder.append("db:" + this.getDbname()).append(SEP);
        builder.append("tb:" + this.getTablename()).append(SEP);
        builder.append("serverId:" + this.getServerId()).append(SEP);
        builder.append("checkpoint:" + this.getCheckpoint()).append(SEP);
        builder.append("primary_value:" + this.getPrimaryKeys()).append(SEP);
        builder.append("unique_keys:" + this.getUniqueColNames()).append(SEP);
        builder.append(SEP);
        this.getFieldList();
        if (this.fields != null) {
            for (DataMessage.Record.Field field : this.fields) {
                builder.append(field.toString());
            }
        }
        builder.append(SEP);
        return builder.toString();
    }

    private long getCRCValue() throws IOException {
        long crcValue = 0L;
        if (this.tailOffset == -1L) {
            return 0L;
        }
        List list = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.tailOffset);
        if (list == null || list.size() != 12) {
            return 0L;
        }
        crcValue += (long)((Integer)list.get(8)).intValue();
        crcValue += (long)((Integer)list.get(9)).intValue() << 8;
        crcValue += (long)((Integer)list.get(10)).intValue() << 16;
        return crcValue += (long)((Integer)list.get(11)).intValue() << 24;
    }
}

