/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.clusterclient;

import com.aliyun.drc.clusterclient.ClusterClient;
import com.aliyun.drc.clusterclient.ClusterContext;
import com.aliyun.drc.clusterclient.ClusterListener;
import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.clusterclient.impl.CloudPartitionClientFactory;
import com.aliyun.drc.clusterclient.message.ClusterMessage;
import com.aliyun.drc.regionmanager.RegionRouter;
import com.taobao.drc.clusterclient.BaseClusterContext;
import com.taobao.drc.clusterclient.PartitionClientFactory;
import com.taobao.drc.clusterclient.impl.DefaultClusterClientImpl;
import com.taobao.drc.clusterclient.partition.PartitionStateChangeListener;
import com.taobao.drc.clusterclient.util.ManifestUtils;
import java.util.ArrayList;
import java.util.List;

public class DefaultClusterClient
implements ClusterClient {
    private final RegionContext regionContext;
    private volatile ClusterContext clusterContext;
    private volatile String guid;
    private final List<ClusterListener> messageListeners = new ArrayList<ClusterListener>();
    private final List<PartitionStateChangeListener> partitionStateChangeListeners = new ArrayList<PartitionStateChangeListener>();
    private volatile DefaultClusterClientImpl<ClusterContext, ClusterMessage, ClusterListener, CloudPartitionClientFactory> consumer;
    private volatile boolean started;

    public DefaultClusterClient(RegionContext regionContext) {
        if (regionContext == null) {
            throw new NullPointerException("RegionContext is null");
        }
        this.regionContext = regionContext;
        this.clusterContext = null;
    }

    public DefaultClusterClient(ClusterContext clusterContext) {
        if (clusterContext == null) {
            throw new NullPointerException("ClusterContext is null");
        }
        this.regionContext = null;
        this.clusterContext = clusterContext;
    }

    @Override
    public void askForGUID(String guid) throws Exception {
        this.guid = guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            if (this.started) {
                throw new IllegalStateException("The client has already been started");
            }
            if (this.regionContext != null) {
                RegionRouter router = new RegionRouter();
                this.clusterContext = router.getRegionRouterInfo(this.regionContext, this.guid);
            }
            if (this.clusterContext.getAppGuid() == null) {
                this.clusterContext.setAppGuid(this.guid);
            }
            this.consumer = new DefaultClusterClientImpl((BaseClusterContext)this.clusterContext, (PartitionClientFactory)new CloudPartitionClientFactory(), this.messageListeners, this.partitionStateChangeListeners, ManifestUtils.getVersion(this.getClass()));
            this.consumer.start();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStop(long timeLimitInSec) throws InterruptedException {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            if (this.consumer != null) {
                this.consumer.waitForStop(timeLimitInSec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            if (this.consumer != null) {
                this.consumer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConcurrentListener(ClusterListener listener) {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            this.messageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConcurrentListener(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            this.addConcurrentListener((ClusterListener)Class.forName(className).newInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClusterListener> getConcurrentListeners() {
        DefaultClusterClient defaultClusterClient = this;
        synchronized (defaultClusterClient) {
            return this.messageListeners;
        }
    }
}

