/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.annotation.valid.keyvalue;

import com.anji.plus.gaea.annotation.valid.keyvalue.AssertKeyValue;
import com.anji.plus.gaea.cache.CacheHelper;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class AssertKeyValueValidator
implements ConstraintValidator<AssertKeyValue, Object> {
    private String dictCode;
    private String key;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        CacheHelper cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
        if (cacheHelper == null) {
            return true;
        }
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            return true;
        }
        String locale = LocaleContextHolder.getLocale().getLanguage();
        Map<Object, Object> map = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)this.dictCode)) {
            String dictKey = "gaea:dict:prefix:" + locale + ":" + this.dictCode;
            map = cacheHelper.hashGet(dictKey);
        } else if (StringUtils.isNotBlank((CharSequence)this.key)) {
            if (this.key.contains("${")) {
                Map<String, Object> params = UserContentHolder.getContext().getParams();
                this.key = GaeaUtils.replaceFormatString(this.key, params);
            }
            map = cacheHelper.hashGet(this.key);
        } else {
            return true;
        }
        if (String.valueOf(value).contains(",")) {
            String[] values;
            for (String v : values = ((String)value).split(",")) {
                if (map.containsKey(v)) continue;
                return false;
            }
            return true;
        }
        return map.containsKey(String.valueOf(value));
    }

    public void initialize(AssertKeyValue assertKeyValue) {
        this.dictCode = assertKeyValue.dictCode();
        this.key = assertKeyValue.key();
    }
}

