/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.anji.plus.gaea.annotation.DtoSkip;
import com.anji.plus.gaea.annotation.Formatter;
import com.anji.plus.gaea.annotation.FormatterType;
import com.anji.plus.gaea.cache.CacheHelper;
import com.anji.plus.gaea.constant.Enabled;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.CollectionUtils;

public abstract class GaeaBeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(GaeaBeanUtils.class);
    private static CacheHelper cacheHelper = null;

    public static <T> T copyAndFormatter(Object source, T target) {
        Field[] declaredFields = target.getClass().getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length);
        ArrayList<String> skipFields = new ArrayList<String>();
        ArrayList<Field> formatterTypeFields = new ArrayList<Field>();
        GaeaBeanUtils.setFormatterFields(target.getClass(), declaredFields, fields, skipFields, formatterTypeFields);
        BeanUtils.copyProperties((Object)source, target, (String[])skipFields.toArray(new String[0]));
        GaeaBeanUtils.formatterHandler(source, target, fields);
        for (Field field : formatterTypeFields) {
            GaeaBeanUtils.formatSubFields(source, target, field);
        }
        return target;
    }

    public static <T> List<T> copyList(List<? extends Object> sourceList, Class<T> targetClass) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList();
        }
        Field[] declaredFields = targetClass.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length);
        ArrayList<String> skipFields = new ArrayList<String>();
        ArrayList<Field> formatterTypeFields = new ArrayList<Field>();
        GaeaBeanUtils.setFormatterFields(targetClass, declaredFields, fields, skipFields, formatterTypeFields);
        ArrayList<T> ret = new ArrayList<T>();
        try {
            int i;
            for (Object object : sourceList) {
                T target = targetClass.newInstance();
                BeanUtils.copyProperties((Object)object, target, (String[])skipFields.toArray(new String[0]));
                ret.add(target);
            }
            Locale locale = LocaleContextHolder.getLocale();
            String string = locale.getLanguage();
            Map<String, Object> params = UserContentHolder.getContext().getParams();
            List<Field> formatterFields = ((Stream)fields.stream().parallel()).filter(field -> field.isAnnotationPresent(Formatter.class)).collect(Collectors.toList());
            HashMap hashKeys = new HashMap();
            for (int i2 = 0; i2 < sourceList.size(); ++i2) {
                Iterator s1 = sourceList.get(i2);
                Object e = ret.get(i2);
                formatterFields.forEach(field -> GaeaBeanUtils.extractDefinition(s1, t1, language, params, hashKeys, field));
            }
            HashMap<String, Map<String, String>> cacheResult = new HashMap<String, Map<String, String>>();
            if (cacheHelper == null) {
                cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
            }
            for (Map.Entry<String, Set<String>> entry : hashKeys.entrySet()) {
                GaeaBeanUtils.fillCacheMap(cacheResult, entry);
            }
            for (i = 0; i < sourceList.size(); ++i) {
                Object object = sourceList.get(i);
                Object t2 = ret.get(i);
                formatterFields.forEach(field -> GaeaBeanUtils.fieldFormat(s2, t2, language, params, cacheResult, field));
            }
            for (i = 0; i < sourceList.size(); ++i) {
                Object object = sourceList.get(i);
                Object t3 = ret.get(i);
                for (Field field2 : formatterTypeFields) {
                    GaeaBeanUtils.formatSubFields(object, t3, field2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static <T> void formatSubFields(Object s3, T t3, Field field) {
        try {
            PropertyDescriptor sd = new PropertyDescriptor(field.getName(), s3.getClass());
            PropertyDescriptor td = new PropertyDescriptor(field.getName(), t3.getClass());
            Object fieldSource = sd.getReadMethod().invoke(s3, new Object[0]);
            if (fieldSource == null) {
                return;
            }
            Method writeMethod = td.getWriteMethod();
            FormatterType ft = field.getAnnotation(FormatterType.class);
            switch (ft.type()) {
                case OBJECT: {
                    Object fieldTarget = field.getType().newInstance();
                    GaeaBeanUtils.copyAndFormatter(fieldSource, fieldTarget);
                    writeMethod.invoke(t3, fieldTarget);
                    break;
                }
                case LIST: {
                    Type genericType = field.getGenericType();
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Class fieldTargetClass = (Class)parameterizedType.getActualTypeArguments()[0];
                    if (!ft.target().getName().equals(Object.class.getName())) {
                        fieldTargetClass = ft.target();
                    }
                    List<T> fieldTargetList = GaeaBeanUtils.copyList((List)fieldSource, fieldTargetClass);
                    writeMethod.invoke(t3, fieldTargetList);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("FormatterType\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }

    private static <T> void setFormatterFields(Class<T> targetCls, Field[] declaredFields, List<Field> fields, List<String> skipFields, List<Field> formatterTypeFields) {
        for (Field field : declaredFields) {
            if (field.isAnnotationPresent(DtoSkip.class)) {
                skipFields.add(field.getName());
                continue;
            }
            if (field.isAnnotationPresent(FormatterType.class)) {
                formatterTypeFields.add(field);
                continue;
            }
            fields.add(field);
        }
        skipFields.addAll(formatterTypeFields.stream().map(Field::getName).collect(Collectors.toList()));
        Field[] superDeclaredFields = targetCls.getSuperclass().getDeclaredFields();
        fields.addAll(Arrays.asList(superDeclaredFields));
    }

    private static <T> void formatterHandler(Object source, T target, List<Field> fields) {
        Locale locale = LocaleContextHolder.getLocale();
        String language = locale.getLanguage();
        Map<String, Object> params = UserContentHolder.getContext().getParams();
        List<Field> formatterFields = ((Stream)fields.stream().parallel()).filter(field -> field.isAnnotationPresent(Formatter.class)).collect(Collectors.toList());
        HashMap hashKeys = new HashMap();
        formatterFields.forEach(field -> GaeaBeanUtils.extractDefinition(source, target, language, params, hashKeys, field));
        HashMap<String, Map<String, String>> cacheResult = new HashMap<String, Map<String, String>>();
        if (cacheHelper == null) {
            cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
        }
        for (Map.Entry<String, Set<String>> entry : hashKeys.entrySet()) {
            GaeaBeanUtils.fillCacheMap(cacheResult, entry);
        }
        formatterFields.forEach(field -> GaeaBeanUtils.fieldFormat(source, target, language, params, cacheResult, field));
    }

    private static <T> void fieldFormat(Object source, T target, String language, Map<String, Object> params, Map<String, Map<String, String>> cacheResult, Field field) {
        try {
            Formatter annotation = field.getAnnotation(Formatter.class);
            String key = GaeaBeanUtils.getCacheKey(annotation, language, params, source);
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), target.getClass());
            Method readMethod = descriptor.getReadMethod();
            String val = readMethod.invoke(target, new Object[0]) + "";
            val = cacheResult.get(key).get(val);
            if (StringUtils.isNotBlank((CharSequence)val)) {
                PropertyDescriptor t = new PropertyDescriptor(field.getName(), target.getClass());
                if (StringUtils.isBlank((CharSequence)annotation.targetField())) {
                    Method writeMethod = t.getWriteMethod();
                    writeMethod.invoke(target, val);
                } else {
                    t = new PropertyDescriptor(annotation.targetField(), target.getClass());
                    if (t != null) {
                        t.getWriteMethod().invoke(target, val);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fillCacheMap(Map<String, Map<String, String>> cacheResult, Map.Entry<String, Set<String>> item) {
        List<String> keys = item.getValue().stream().distinct().collect(Collectors.toList());
        List<String> values = cacheHelper.hashMultiGet(item.getKey(), keys);
        ArrayList<String> lowcase = new ArrayList<String>();
        HashMap<String, String> kv = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(values)) {
            for (int i = 0; i < values.size(); ++i) {
                if (Objects.isNull(values.get(i))) {
                    lowcase.add(keys.get(i));
                    continue;
                }
                kv.put(keys.get(i), values.get(i));
            }
        }
        cacheResult.put(item.getKey(), kv);
    }

    private static <T> void extractDefinition(Object source, T target, String language, Map<String, Object> params, Map<String, Set<String>> hashKeys, Field field) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), target.getClass());
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(target, new Object[0]);
            if (result instanceof Boolean) {
                Object object = result = (Boolean)result != false ? Enabled.YES.getValue() : Enabled.NO.getValue();
            }
            if (result != null) {
                Formatter annotation = field.getAnnotation(Formatter.class);
                String key = GaeaBeanUtils.getCacheKey(annotation, language, params, source);
                String hashKey = result.toString();
                hashKeys.putIfAbsent(key, new HashSet());
                hashKeys.get(key).add(hashKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getCacheKey(Formatter annotation, String language, Map params, Object source) {
        if (StringUtils.isBlank((CharSequence)annotation.key())) {
            String dictCode = annotation.dictCode();
            return "gaea:dict:prefix:" + language + ":" + dictCode;
        }
        return GaeaBeanUtils.formatKey(annotation.key(), annotation.replace(), params, source);
    }

    public static String formatKey(String key, String[] replaceArray, Map<String, Object> params, Object source) {
        if (key.contains("${")) {
            HashMap<String, Object> keyPatternMap = new HashMap<String, Object>(2);
            for (String fieldName : replaceArray) {
                try {
                    Object value = params.get(fieldName);
                    if (null == value || "".equals(value)) {
                        Field declaredField = source.getClass().getDeclaredField(fieldName);
                        declaredField.setAccessible(true);
                        value = declaredField.get(source);
                    }
                    keyPatternMap.put(fieldName, value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((key = GaeaUtils.replaceFormatString(key, keyPatternMap)).contains("${")) {
                return null;
            }
        }
        return key;
    }
}

