/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtils {
    public static Object getValue(Object o, String target) {
        try {
            Field declaredField = o.getClass().getDeclaredField(target);
            declaredField.setAccessible(true);
            return declaredField.get(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getSuperValue(Object o, String target) {
        try {
            Field declaredField = o.getClass().getSuperclass().getDeclaredField(target);
            declaredField.setAccessible(true);
            return declaredField.get(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setValue(Object o, String fieldName, Object value) {
        try {
            Field declaredField = o.getClass().getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            declaredField.set(o, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Field> getAllFields(Object from) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = from.getClass(); tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    public static List<Field> getAllFields(Class tempClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object")) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass();
        }
        return fieldList;
    }

    public static Field[] getAllFieldsArr(Object from) {
        List<Field> fieldList = ReflectionUtils.getAllFields(from);
        return (Field[])fieldList.stream().toArray(Field[]::new);
    }

    public static Field[] getAllFieldsArr(Class tempClass) {
        List<Field> fieldList = ReflectionUtils.getAllFields(tempClass);
        return (Field[])fieldList.stream().toArray(Field[]::new);
    }

    public static Field getField(Class tempClass, String replace) throws NoSuchFieldException {
        Field declaredField;
        try {
            declaredField = tempClass.getDeclaredField(replace);
        }
        catch (NoSuchFieldException e) {
            declaredField = tempClass.getSuperclass().getDeclaredField(replace);
        }
        return declaredField;
    }

    public static Field getField(Object object, String replace) throws NoSuchFieldException {
        Field declaredField;
        Class<?> tempClass = object.getClass();
        try {
            declaredField = tempClass.getDeclaredField(replace);
        }
        catch (NoSuchFieldException e) {
            declaredField = tempClass.getSuperclass().getDeclaredField(replace);
        }
        return declaredField;
    }
}

