/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInNoticeReportVO;
import com.dtyunxi.cis.pms.biz.model.GetInNoticeListPageParams;
import com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillInNoticeOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WmsTrackStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_in_notice_sheet")
public class ExportInNoticeServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Resource
    private InventoryCenterBillInNoticeOrderService inventoryCenterBillInNoticeOrderService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetInNoticeListPageParams params = new GetInNoticeListPageParams();
        params = (GetInNoticeListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInNoticeListPageParams.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse<PageInfo<InNoticeOrderVO>> pageInfoRestResponse = this.inventoryCenterBillInNoticeOrderService.getInNoticeListPage((GetInNoticeListPageParams)re);
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            PageInfo im = new PageInfo();
            BeanUtil.copyProperties((Object)respDtoPageInfo, (Object)im, (boolean)false);
            if (ObjectUtils.isEmpty((Object)respDtoPageInfo)) {
                return im;
            }
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    ExportInNoticeReportVO vo = new ExportInNoticeReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                        if (ObjectUtils.isNotEmpty((Object)CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()))) {
                            return String.valueOf(CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()).getDesc());
                        }
                        if (ObjectUtils.isNotEmpty((Object)ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()))) {
                            return String.valueOf(ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()));
                        }
                        return o.getBusinessType();
                    }).orElse(""));
                    vo.setDocumentStatus(Optional.ofNullable(o.getDocumentStatus()).filter(StringUtils::isNotBlank).map(documentStatus -> {
                        switch (documentStatus) {
                            case "ino_total_in": {
                                return "\u5168\u90e8\u5165\u5e93";
                            }
                            case "ino_wait_in": {
                                return "\u5f85\u5165\u5e93";
                            }
                            case "ino_portion_in": {
                                return "\u90e8\u5206\u5165\u5e93";
                            }
                            case "ino_cancel": {
                                return "\u5df2\u53d6\u6d88";
                            }
                            case "finish": {
                                return "\u5df2\u5b8c\u6210";
                            }
                        }
                        return o.getDocumentStatus();
                    }).orElse(""));
                    if (StringUtils.isNotEmpty((CharSequence)o.getWmsStatus())) {
                        try {
                            vo.setWmsStatisStr(WmsTrackStatusEnum.getByType((String)o.getWmsStatus()).getDesc());
                        }
                        catch (Exception e) {
                            vo.setWmsStatisStr(o.getWmsStatus());
                        }
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, params, ExportInNoticeReportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetInNoticeListPageParams params = new GetInNoticeListPageParams();
        params = (GetInNoticeListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInNoticeListPageParams.class);
        params.setPageSize(1);
        params.setPageNum(1);
        RestResponse<PageInfo<InNoticeOrderVO>> pageInfoRestResponse = this.inventoryCenterBillInNoticeOrderService.getInNoticeListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

