/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.BizExceptionCode;
import com.dtyunxi.cis.pms.biz.annotation.OptLog;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.EnableEnum;
import com.dtyunxi.cis.pms.biz.enums.IsAllEnum;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableChannel;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableChannelWarehouse;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableCustomers;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableDocumentTypes;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableLogicalWarehouse;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableOrganization;
import com.dtyunxi.cis.pms.biz.model.ApplicableStrategyVOApplicableVirtualWarehouse;
import com.dtyunxi.cis.pms.biz.model.ChannelWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.DeleteSourcingRuleParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OrderChannelVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.SourcingRuleVO;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParams;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldData;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableChannelWarehouse;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableCustomers;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableDocumentTypes;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableLogicalWarehouse;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableOrderChannel;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableOrganization;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableVirtualWarehouse;
import com.dtyunxi.cis.pms.biz.model.SubruleStrategyVO;
import com.dtyunxi.cis.pms.biz.model.UpdateDisablePhysicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.UpdateSourcingStatusParams;
import com.dtyunxi.cis.pms.biz.model.VirtualWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.WarehouseStrategyVO;
import com.dtyunxi.cis.pms.biz.service.StrategyManagementSourcingRuleService;
import com.dtyunxi.cube.center.source.api.IClueOptApi;
import com.dtyunxi.cube.center.source.api.IPhysicsWarehouseDisableApi;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceItemBlackTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.ClueActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueModifyActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeModifyReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupModifyActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleDeliveryReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleModifyReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupUpdateActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseItemBlackListReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.PhysicsWarehouseDisableReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueSuitAttributeRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.PhysicsWarehouseDisableRespDto;
import com.dtyunxi.cube.center.source.api.query.IClueQueryApi;
import com.dtyunxi.cube.center.source.api.query.IPhysicsWarehouseDisableQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ClueReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IClueReportQueryApi;
import com.dtyunxi.tcbj.api.query.IOrganizationExpandQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class StrategyManagementSourcingRuleServiceServiceImpl
implements StrategyManagementSourcingRuleService {
    @Resource
    private IClueReportQueryApi clueReportQueryApi;
    @Resource
    private IClueOptApi clueOptApi;
    @Resource
    private IClueQueryApi clueQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IPcpOrderChannelQueryApi pcpOrderChannelQueryApi;
    @Resource
    private IPCPCustomerQueryApi pcpCustomerQueryApi;
    @Resource
    private IPhysicsWarehouseDisableApi iPhysicsWarehouseDisableApi;
    @Resource
    private IPhysicsWarehouseDisableQueryApi iPhysicsWarehouseDisableQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi iCsPhysicsWarehouseExposedQueryApi;
    @Resource
    private IOrganizationExpandQueryApi organizationExpandQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    private static final String batch_regex = "^[A-Za-z0-9_.,\uff0c;\uff1b-]+$";

    @Override
    @OptLog(optOrderType=OptLogTypeEnum.SOURCE, type=OptLogTypeEnum.ADD)
    public RestResponse<Object> addSourcingRule(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitSourcingRuleParams submitSourcingRuleParams) {
        SubmitSourcingRuleParamsOldData submitSourcingRuleParamsData = Optional.ofNullable(submitSourcingRuleParams).map(SubmitSourcingRuleParams::getNewData).orElse(null);
        if (ObjectUtil.isEmpty((Object)submitSourcingRuleParamsData)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!Objects.equals(submitSourcingRuleParamsData.getItemBlackType(), SourceItemBlackTypeEnum.NO.code)) {
            this.checkSourceItemBlack(submitSourcingRuleParamsData.getClueItemBlacklist());
        }
        ClueActReqDto clueActReqDto = new ClueActReqDto();
        clueActReqDto.setClueCode(submitSourcingRuleParamsData.getRuleCode());
        clueActReqDto.setClueName(submitSourcingRuleParamsData.getRuleName());
        clueActReqDto.setClueDismantleCount(Integer.valueOf(submitSourcingRuleParamsData.getSplitOrderNum().intValue()));
        clueActReqDto.setClueDismantleEnable(EnableEnum.getStatusByCode(submitSourcingRuleParamsData.getIsSplitOrder()));
        clueActReqDto.setClueEnableStartTime(DateUtil.parse((String)submitSourcingRuleParamsData.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        clueActReqDto.setClueEnableEndTime(DateUtil.parse((String)submitSourcingRuleParamsData.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        clueActReqDto.setCluePriorityLevel(Integer.valueOf(submitSourcingRuleParamsData.getRulePriority()));
        clueActReqDto.setClueEnableStatus(EnableEnum.ENABLE.getStatus());
        clueActReqDto.setClueOldBatch(submitSourcingRuleParamsData.getClueOldBatch());
        clueActReqDto.setClueOldBatchMonth(submitSourcingRuleParamsData.getClueOldBatchMonth());
        clueActReqDto.setClueNotOldBatch(submitSourcingRuleParamsData.getClueNotOldBatch());
        clueActReqDto.setClueNotOldBatchMonth(submitSourcingRuleParamsData.getClueNotOldBatchMonth());
        clueActReqDto.setSingleWarehouseDelivery(submitSourcingRuleParamsData.getSingleWarehouseDelivery());
        clueActReqDto.setIntransitStockStatus(submitSourcingRuleParamsData.getIntransitStockStatus());
        clueActReqDto.setItemBlackType(submitSourcingRuleParamsData.getItemBlackType());
        clueActReqDto.setClueItemBlacklist(submitSourcingRuleParamsData.getClueItemBlacklist());
        clueActReqDto.setWarehouseBlackList(submitSourcingRuleParamsData.getWarehouseBlackList());
        clueActReqDto.setClueDeliveryWarehouseBlackReqDtoList(submitSourcingRuleParamsData.getClueDeliveryWarehouseBlackReqDtoList());
        ArrayList<ClueWarehouseGroupActReqDto> clueWarehouseGroupActReqDtoList = new ArrayList<ClueWarehouseGroupActReqDto>();
        List<WarehouseStrategyVO> warehouseStrategy = submitSourcingRuleParamsData.getWarehouseStrategy();
        if (CollectionUtil.isNotEmpty(warehouseStrategy)) {
            for (WarehouseStrategyVO warehouseStrategyVO : warehouseStrategy) {
                ClueWarehouseGroupActReqDto clueWarehouseGroupActReqDto = new ClueWarehouseGroupActReqDto();
                clueWarehouseGroupActReqDto.setWarehouseGroupName(warehouseStrategyVO.getShipWarehouseName());
                clueWarehouseGroupActReqDto.setWarehouseGroupType(warehouseStrategyVO.getShipWarehouseKey());
                clueWarehouseGroupActReqDto.setEnableStatus(EnableEnum.ENABLE.getStatus());
                clueWarehouseGroupActReqDto.setWarehouseGroupPriorityLevel(Integer.valueOf(warehouseStrategyVO.getPriority()));
                List<SubruleStrategyVO> subrule = warehouseStrategyVO.getSubrule();
                if (ObjectUtil.isEmpty(subrule)) {
                    throw new BizException("\u7b56\u7565\u914d\u7f6e\u5b50\u89c4\u5219\u4e0d\u53ef\u4e3a\u7a7a");
                }
                ArrayList<ClueWarehouseGroupRuleReqDto> clueWarehouseGroupRuleReqDtoList = new ArrayList<ClueWarehouseGroupRuleReqDto>();
                for (SubruleStrategyVO subruleStrategyVO : subrule) {
                    ClueWarehouseGroupRuleReqDto clueWarehouseGroupRuleReqDto = new ClueWarehouseGroupRuleReqDto();
                    clueWarehouseGroupRuleReqDto.setEnableStatus(EnableEnum.getStatusByCode(subruleStrategyVO.getEnableStatus()));
                    clueWarehouseGroupRuleReqDto.setRuleScoreProportion(subruleStrategyVO.getRuleScoreProportion());
                    clueWarehouseGroupRuleReqDto.setRuleTypeCode(subruleStrategyVO.getRuleTypeCode());
                    clueWarehouseGroupRuleReqDto.setRuleTypeName(subruleStrategyVO.getRuleTypeName());
                    clueWarehouseGroupRuleReqDto.setClueWarehouseGroupRuleDeliveryReqDtoList(subruleStrategyVO.getClueWarehouseGroupRuleDeliveryReqDtoList());
                    clueWarehouseGroupRuleReqDtoList.add(clueWarehouseGroupRuleReqDto);
                }
                clueWarehouseGroupActReqDto.setClueWarehouseGroupRuleReqDtoList(clueWarehouseGroupRuleReqDtoList);
                clueWarehouseGroupActReqDtoList.add(clueWarehouseGroupActReqDto);
            }
        }
        clueActReqDto.setClueWarehouseGroupActReqDtoList(clueWarehouseGroupActReqDtoList);
        ArrayList<Object> suitChannelList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableOrderChannel applicableOrderChannel = submitSourcingRuleParamsData.getApplicableOrderChannel();
        if (ObjectUtil.isNotEmpty((Object)applicableOrderChannel)) {
            List<OrderChannelVO> orderChannelVOList = applicableOrderChannel.getList();
            String isAll = applicableOrderChannel.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrderChannelReqDto = new ClueSuitAttributeReqDto();
                clueOrderChannelReqDto.setSgSuitKey("");
                clueOrderChannelReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL.getCode());
                clueOrderChannelReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitChannelList.add(clueOrderChannelReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderChannelVOList)) {
                    throw new BizException(BizExceptionCode.ORDER_CHANNEL_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_CHANNEL_LIST_EMPTY.getMsg());
                }
                for (OrderChannelVO orderChannelVO : orderChannelVOList) {
                    ClueSuitAttributeReqDto clueOrderChannelReqDto = new ClueSuitAttributeReqDto();
                    clueOrderChannelReqDto.setSgSuitKey(orderChannelVO.getOrderChannelId());
                    clueOrderChannelReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL.getCode());
                    clueOrderChannelReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitChannelList.add(clueOrderChannelReqDto);
                }
            }
        }
        clueActReqDto.setSuitChannelList(suitChannelList);
        ArrayList<Object> suitCustomerList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableCustomers applicableCustomers = submitSourcingRuleParamsData.getApplicableCustomers();
        if (ObjectUtil.isNotEmpty((Object)applicableCustomers)) {
            List<CustomerVO> customerVOlist = applicableCustomers.getList();
            String isAll = applicableCustomers.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueCustomerReqDto = new ClueSuitAttributeReqDto();
                clueCustomerReqDto.setSgSuitKey("");
                clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitCustomerList.add(clueCustomerReqDto);
            } else {
                if (CollectionUtil.isEmpty(customerVOlist)) {
                    throw new BizException(BizExceptionCode.CUSTOMER_LIST_EMPTY.getCode(), BizExceptionCode.CUSTOMER_LIST_EMPTY.getMsg());
                }
                for (CustomerVO customerVO : customerVOlist) {
                    ClueSuitAttributeReqDto clueCustomerReqDto = new ClueSuitAttributeReqDto();
                    clueCustomerReqDto.setSgSuitKey(customerVO.getCustomerId());
                    clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                    clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitCustomerList.add(clueCustomerReqDto);
                }
            }
        }
        clueActReqDto.setSuitCustomerList(suitCustomerList);
        ArrayList<Object> suitOrderTypeList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableDocumentTypes applicableDocumentTypes = submitSourcingRuleParamsData.getApplicableDocumentTypes();
        if (ObjectUtil.isNotEmpty((Object)applicableDocumentTypes)) {
            List<String> orderTypelist = applicableDocumentTypes.getList();
            String isAll = applicableDocumentTypes.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrderTypeReqDto = new ClueSuitAttributeReqDto();
                clueOrderTypeReqDto.setSgSuitKey("");
                clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrderTypeList.add(clueOrderTypeReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderTypelist)) {
                    throw new BizException(BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getMsg());
                }
                for (String orderType : orderTypelist) {
                    ClueSuitAttributeReqDto clueOrderTypeReqDto = new ClueSuitAttributeReqDto();
                    clueOrderTypeReqDto.setSgSuitKey(orderType);
                    clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                    clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrderTypeList.add(clueOrderTypeReqDto);
                }
            }
        }
        clueActReqDto.setSuitOrderTypeList(suitOrderTypeList);
        ArrayList<Object> suitWarehouseList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableLogicalWarehouse applicableLogicalWarehouse = submitSourcingRuleParamsData.getApplicableLogicalWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableLogicalWarehouse)) {
            List<LogicalWarehouseVO> logicalWarehouseVOList = applicableLogicalWarehouse.getList();
            String isAll = applicableLogicalWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                clueWarehouseReqDto.setSgSuitKey("");
                clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode());
                clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitWarehouseList.add(clueWarehouseReqDto);
            } else {
                if (CollectionUtil.isEmpty(logicalWarehouseVOList)) {
                    throw new BizException(BizExceptionCode.LOGIC_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.LOGIC_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (LogicalWarehouseVO logicalWarehouseVO : logicalWarehouseVOList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)logicalWarehouseVO.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueActReqDto.setSuitWarehouseList(suitWarehouseList);
        ArrayList<Object> suitOrganizationList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableOrganization applicableOrganization = submitSourcingRuleParamsData.getApplicableOrganization();
        if (ObjectUtil.isNotEmpty((Object)applicableOrganization)) {
            List<OrganizationDto> applicableOrganizationList = applicableOrganization.getList();
            String isAll = applicableOrganization.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrganizationReqDto = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrganizationList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableOrganizationList)) {
                    throw new BizException(BizExceptionCode.ORGANIZATION_LIST_EMPTY.getCode(), BizExceptionCode.ORGANIZATION_LIST_EMPTY.getMsg());
                }
                for (OrganizationDto organizationDto : applicableOrganizationList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)organizationDto.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrganizationList.add(clueWarehouseReqDto);
                }
            }
        }
        clueActReqDto.setSuitOrganizationList(suitOrganizationList);
        ArrayList<Object> suitChannleWarehouseList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableChannelWarehouse applicableChannelWarehouse = submitSourcingRuleParamsData.getApplicableChannelWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableChannelWarehouse)) {
            List<ChannelWarehouseVO> applicableChannelWarehouseList = applicableChannelWarehouse.getList();
            String isAll = applicableChannelWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrganizationReqDto = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitChannleWarehouseList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableChannelWarehouseList)) {
                    throw new BizException(BizExceptionCode.CHANNEL_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.CHANNEL_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (ChannelWarehouseVO channelWarehouseVO : applicableChannelWarehouseList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)channelWarehouseVO.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitChannleWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueActReqDto.setSuitChannelWarehouseList(suitChannleWarehouseList);
        ArrayList<ClueSuitAttributeReqDto> suitVirtualWarehouseList = new ArrayList<ClueSuitAttributeReqDto>();
        SubmitSourcingRuleParamsOldDataApplicableVirtualWarehouse applicableVirtualWarehouse = submitSourcingRuleParamsData.getApplicableVirtualWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableVirtualWarehouse)) {
            List<VirtualWarehouseVO> applicableVirtualWarehouseList = applicableVirtualWarehouse.getList();
            String isAll = applicableVirtualWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrganizationReqDto = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitVirtualWarehouseList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableVirtualWarehouseList)) {
                    throw new BizException(BizExceptionCode.VIRTUAL_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.VIRTUAL_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (VirtualWarehouseVO virtualWarehouseVO : applicableVirtualWarehouseList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(virtualWarehouseVO.getWarehouseCode());
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitVirtualWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueActReqDto.setSuitVirtualWarehouseList(suitVirtualWarehouseList);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.clueOptApi.addClueOpt(clueActReqDto)));
    }

    private void checkSourceItemBlack(List<ClueWarehouseItemBlackListReqDto> clueItemBlacklist) {
        if (ObjectUtil.isEmpty(clueItemBlacklist)) {
            throw new BizException("\u5546\u54c1\u9ed1\u540d\u5355\u4fe1\u606f\u5fc5\u586b!");
        }
        HashSet<String> soleVerifySet = new HashSet<String>();
        for (ClueWarehouseItemBlackListReqDto blackListReqDto : clueItemBlacklist) {
            boolean batchNoFlag;
            String soleKey = blackListReqDto.getSkuCode() + "-" + blackListReqDto.getBatchNo();
            if (soleVerifySet.contains(soleKey)) {
                throw new BizException("\u5546\u54c1\u9ed1\u540d\u5355sku+\u6279\u6b21\u5b58\u5728\u91cd\u590d\u6570\u636e!");
            }
            soleVerifySet.add(soleKey);
            if (StringUtils.isNotBlank((CharSequence)blackListReqDto.getBatchNo()) && !(batchNoFlag = Pattern.matches(batch_regex, blackListReqDto.getBatchNo()))) {
                throw new BizException("\u6279\u6b21\u5fc5\u987b\u4e3a\u5927\u5c0f\u5199\u82f1\u6587\u6216\u6570\u5b57!");
            }
            if (!CollectionUtils.isEmpty((Collection)blackListReqDto.getReceiveCityCodeList())) continue;
            throw new BizException("\u6536\u8d27\u7701\u5e02\u4fe1\u606f\u5fc5\u586b!");
        }
    }

    @Override
    public RestResponse<Object> deleteSourcingRule(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteSourcingRuleParams deleteSourcingRuleParams) {
        if (CollectionUtils.isEmpty(deleteSourcingRuleParams.getRuleIds())) {
            throw new BizException("\u5bfb\u6e90\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List ids = deleteSourcingRuleParams.getRuleIds().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.clueOptApi.deleteClueOpt(ids)));
    }

    @Override
    public RestResponse<SourcingRuleVO> getSourcingRuleById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5bfb\u6e90\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ClueActRespDto clueActRespDto = (ClueActRespDto)RestResponseHelper.extractData((RestResponse)this.clueQueryApi.queryActRespById(Long.valueOf(id)));
        SourcingRuleVO vo = new SourcingRuleVO();
        if (clueActRespDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)clueActRespDto, (Object)vo);
        vo.setCreateTime(DateUtil.format((Date)clueActRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        vo.setUpdateTime(DateUtil.format((Date)clueActRespDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        vo.setRuleCode(clueActRespDto.getClueCode());
        vo.setRuleName(clueActRespDto.getClueName());
        if (clueActRespDto.getClueEnableStartTime() != null) {
            vo.setStartTime(DateUtil.format((Date)clueActRespDto.getClueEnableStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (clueActRespDto.getClueEnableEndTime() != null) {
            vo.setEndTime(DateUtil.format((Date)clueActRespDto.getClueEnableEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setRulePriority(clueActRespDto.getCluePriorityLevel());
        vo.setRuleStatus(EnableEnum.getCodeByStatus(clueActRespDto.getClueEnableStatus()));
        vo.setIsSplitOrder(EnableEnum.getCodeByStatus(clueActRespDto.getClueDismantleEnable()));
        vo.setSplitOrderNum(clueActRespDto.getClueDismantleCount());
        vo.setClueItemBlacklist(clueActRespDto.getClueItemBlacklist());
        vo.setClueDeliveryWarehouseBlackRespDtoList(clueActRespDto.getClueDeliveryWarehouseBlackRespDto());
        ArrayList<WarehouseStrategyVO> warehouseStrategyVOList = new ArrayList<WarehouseStrategyVO>();
        vo.setWarehouseStrategy(warehouseStrategyVOList);
        List clueWarehouseGroupActRespDtoList = clueActRespDto.getClueWarehouseGroupActRespDtoList();
        if (CollectionUtil.isNotEmpty((Collection)clueWarehouseGroupActRespDtoList)) {
            for (ClueWarehouseGroupActRespDto clueWarehouseGroupActRespDto : clueWarehouseGroupActRespDtoList) {
                WarehouseStrategyVO warehouseStrategyVO = new WarehouseStrategyVO();
                warehouseStrategyVO.setShipId(clueWarehouseGroupActRespDto.getId().toString());
                warehouseStrategyVO.setIsEnable(EnableEnum.getCodeByStatus(clueWarehouseGroupActRespDto.getEnableStatus()));
                warehouseStrategyVO.setPriority(clueWarehouseGroupActRespDto.getWarehouseGroupPriorityLevel().toString());
                warehouseStrategyVO.setShipWarehouseKey(clueWarehouseGroupActRespDto.getWarehouseGroupType());
                warehouseStrategyVO.setShipWarehouseName(clueWarehouseGroupActRespDto.getWarehouseGroupName());
                List clueWarehouseGroupRuleRespDtoList = clueWarehouseGroupActRespDto.getClueWarehouseGroupRuleRespDtoList();
                ArrayList<SubruleStrategyVO> subrule = new ArrayList<SubruleStrategyVO>();
                warehouseStrategyVO.setSubrule(subrule);
                if (CollectionUtil.isNotEmpty((Collection)clueWarehouseGroupRuleRespDtoList)) {
                    for (Object clueWarehouseGroupRuleRespDto : clueWarehouseGroupRuleRespDtoList) {
                        SubruleStrategyVO subruleStrategyVO = new SubruleStrategyVO();
                        BeanUtil.copyProperties((Object)clueWarehouseGroupRuleRespDto, (Object)subruleStrategyVO, (String[])new String[0]);
                        subruleStrategyVO.setEnableStatus(EnableEnum.getCodeByStatus(clueWarehouseGroupRuleRespDto.getEnableStatus()));
                        subruleStrategyVO.setRuleScoreProportion(clueWarehouseGroupRuleRespDto.getRuleScoreProportion());
                        subruleStrategyVO.setRuleTypeCode(clueWarehouseGroupRuleRespDto.getRuleTypeCode());
                        subruleStrategyVO.setRuleTypeName(clueWarehouseGroupRuleRespDto.getRuleTypeName());
                        List clueWarehouseGroupRuleDeliveryRespDtos = clueWarehouseGroupRuleRespDto.getClueWarehouseGroupRuleDeliveryRespDtos();
                        ArrayList clueWarehouseGroupRuleDeliveryReqDtos = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)clueWarehouseGroupRuleDeliveryReqDtos, (Collection)clueWarehouseGroupRuleDeliveryRespDtos, ClueWarehouseGroupRuleDeliveryReqDto.class);
                        subruleStrategyVO.setClueWarehouseGroupRuleDeliveryReqDtoList(clueWarehouseGroupRuleDeliveryReqDtos);
                        subrule.add(subruleStrategyVO);
                    }
                }
                warehouseStrategyVOList.add(warehouseStrategyVO);
            }
        }
        ApplicableStrategyVOApplicableChannel applicableChannel = new ApplicableStrategyVOApplicableChannel();
        vo.setApplicableOrderChannel(applicableChannel);
        ArrayList<OrderChannelVO> orderChannelVOList = new ArrayList<OrderChannelVO>();
        applicableChannel.setList(orderChannelVOList);
        List suitChannelList = clueActRespDto.getSuitChannelList();
        if (CollectionUtils.isNotEmpty((Collection)suitChannelList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitChannelList.get(0)).getSgSuitSelectType())) {
            applicableChannel.setIsAll(IsAllEnum.SELECT.getCode());
            List suitChannelIdList = suitChannelList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            PcpOrderChannelReqDto pcpOrderChannelReqDto = new PcpOrderChannelReqDto();
            pcpOrderChannelReqDto.setIds(suitChannelIdList);
            List pcpOrderChannelRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryByShopChannel(pcpOrderChannelReqDto));
            if (CollectionUtil.isNotEmpty((Collection)pcpOrderChannelRespDtoList)) {
                for (PcpOrderChannelRespDto pcpOrderChannelRespDto : pcpOrderChannelRespDtoList) {
                    OrderChannelVO orderChannelVO = new OrderChannelVO();
                    BeanUtil.copyProperties((Object)pcpOrderChannelRespDto, (Object)orderChannelVO, (String[])new String[0]);
                    orderChannelVO.setOrderChannelId(pcpOrderChannelRespDto.getId().toString());
                    orderChannelVO.setOrderChannelCode(pcpOrderChannelRespDto.getChannelCode());
                    orderChannelVO.setOrderChannelName(pcpOrderChannelRespDto.getChannelName());
                    orderChannelVOList.add(orderChannelVO);
                }
                applicableChannel.setList(orderChannelVOList);
            }
        } else {
            applicableChannel.setIsAll(IsAllEnum.ALL.getCode());
        }
        ApplicableStrategyVOApplicableDocumentTypes applicableOrderType = new ApplicableStrategyVOApplicableDocumentTypes();
        vo.setApplicableDocumentTypes(applicableOrderType);
        List<String> orderTypeList = new ArrayList<String>();
        applicableOrderType.setList(orderTypeList);
        List suitOrderTypeList = clueActRespDto.getSuitOrderTypeList();
        if (CollectionUtils.isNotEmpty((Collection)suitOrderTypeList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitOrderTypeList.get(0)).getSgSuitSelectType())) {
            applicableOrderType.setIsAll(IsAllEnum.SELECT.getCode());
            orderTypeList = suitOrderTypeList.stream().map(o -> o.getSgSuitKey()).collect(Collectors.toList());
            applicableOrderType.setList(orderTypeList);
        } else {
            applicableOrderType.setIsAll(IsAllEnum.ALL.getCode());
        }
        ApplicableStrategyVOApplicableCustomers applicableCustomer = new ApplicableStrategyVOApplicableCustomers();
        vo.setApplicableCustomers(applicableCustomer);
        ArrayList<CustomerVO> orderCustomerVOList = new ArrayList<CustomerVO>();
        applicableCustomer.setList(orderCustomerVOList);
        List suitCustomerList = clueActRespDto.getSuitCustomerList();
        if (CollectionUtils.isNotEmpty((Collection)suitCustomerList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitCustomerList.get(0)).getSgSuitSelectType())) {
            applicableCustomer.setIsAll(IsAllEnum.SELECT.getCode());
            List suitCustomerIdList = suitCustomerList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            PCPCustomerSearchReqDto pcpCustomerSearchReqDto = new PCPCustomerSearchReqDto();
            pcpCustomerSearchReqDto.setIdList(suitCustomerIdList);
            List pcpCustomerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpCustomerQueryApi.queryPCPCustomerDetail(pcpCustomerSearchReqDto));
            if (CollectionUtil.isNotEmpty((Collection)pcpCustomerRespDtoList)) {
                for (PCPCustomerRespDto pCPCustomerRespDto : pcpCustomerRespDtoList) {
                    CustomerVO customerVO = new CustomerVO();
                    BeanUtil.copyProperties((Object)pCPCustomerRespDto, (Object)customerVO, (String[])new String[0]);
                    customerVO.setId(pCPCustomerRespDto.getId());
                    customerVO.setCustomerName(pCPCustomerRespDto.getCustomerName());
                    customerVO.setCustomerCode(pCPCustomerRespDto.getCustomerCode());
                    orderCustomerVOList.add(customerVO);
                }
                applicableCustomer.setList(orderCustomerVOList);
            }
        } else {
            applicableCustomer.setIsAll(IsAllEnum.ALL.getCode());
        }
        ApplicableStrategyVOApplicableLogicalWarehouse applicableLogicalWarehouse = new ApplicableStrategyVOApplicableLogicalWarehouse();
        ArrayList<LogicalWarehouseVO> logicalWarehouseVOList = new ArrayList<LogicalWarehouseVO>();
        applicableLogicalWarehouse.setList(logicalWarehouseVOList);
        List suitWarehouseList = clueActRespDto.getSuitWarehouseList();
        if (CollectionUtils.isNotEmpty((Collection)suitWarehouseList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitWarehouseList.get(0)).getSgSuitSelectType())) {
            applicableLogicalWarehouse.setIsAll(IsAllEnum.SELECT.getCode());
            List suitWarehouseIdList = suitWarehouseList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
            csLogicWarehouseParamQueryDto.setWarehouseIdList(suitWarehouseIdList);
            List csLogicWarehousePageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(csLogicWarehouseParamQueryDto));
            if (CollectionUtil.isNotEmpty((Collection)csLogicWarehousePageRespDtoList)) {
                for (CsLogicWarehousePageRespDto csLogicWarehousePageRespDto : csLogicWarehousePageRespDtoList) {
                    LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
                    BeanUtil.copyProperties((Object)csLogicWarehousePageRespDto, (Object)logicalWarehouseVO, (String[])new String[0]);
                    logicalWarehouseVO.setId(csLogicWarehousePageRespDto.getId());
                    logicalWarehouseVO.setWarehouseCode(csLogicWarehousePageRespDto.getWarehouseCode());
                    logicalWarehouseVO.setWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
                    logicalWarehouseVOList.add(logicalWarehouseVO);
                }
                applicableLogicalWarehouse.setList(logicalWarehouseVOList);
            }
        } else {
            applicableLogicalWarehouse.setIsAll(IsAllEnum.ALL.getCode());
        }
        vo.setApplicableLogicalWarehouse(applicableLogicalWarehouse);
        ApplicableStrategyVOApplicableOrganization applicableOrganization = new ApplicableStrategyVOApplicableOrganization();
        ArrayList<OrganizationDto> organizationDtoList = new ArrayList<OrganizationDto>();
        applicableOrganization.setList(organizationDtoList);
        List suitOrganizationList = clueActRespDto.getSuitOrganizationList();
        if (CollectionUtils.isNotEmpty((Collection)suitOrganizationList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitOrganizationList.get(0)).getSgSuitSelectType())) {
            applicableOrganization.setIsAll(IsAllEnum.SELECT.getCode());
            List suitOrganizationIdList = suitOrganizationList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationExpandQueryApi.queryOrgDtoByIds(suitOrganizationIdList));
            if (CollectionUtil.isNotEmpty((Collection)organizationDtos)) {
                applicableOrganization.setList(organizationDtos);
            }
        } else {
            applicableOrganization.setIsAll(IsAllEnum.ALL.getCode());
        }
        vo.setApplicableOrganization(applicableOrganization);
        ApplicableStrategyVOApplicableChannelWarehouse applicableChannelWarehouse = new ApplicableStrategyVOApplicableChannelWarehouse();
        ArrayList<ChannelWarehouseVO> channelWarehouseVOList = new ArrayList<ChannelWarehouseVO>();
        applicableChannelWarehouse.setList(channelWarehouseVOList);
        List suitChannelWarehouseList = clueActRespDto.getSuitChannelWarehouseList();
        if (CollectionUtils.isNotEmpty((Collection)suitChannelWarehouseList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitChannelWarehouseList.get(0)).getSgSuitSelectType())) {
            applicableChannelWarehouse.setIsAll(IsAllEnum.SELECT.getCode());
            List suitChannelWarehouseIdList = suitChannelWarehouseList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            ArrayList list = Lists.newArrayList();
            for (Long channelWarehouseId : suitChannelWarehouseIdList) {
                ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByPrimaryKey(channelWarehouseId));
                if (!Objects.nonNull(channelWarehouseRespDto)) continue;
                ChannelWarehouseVO channelWarehouseVO = new ChannelWarehouseVO();
                CubeBeanUtils.copyProperties((Object)channelWarehouseVO, (Object)channelWarehouseRespDto, (String[])new String[0]);
                channelWarehouseVO.setWarehouseId(channelWarehouseRespDto.getId() + "");
                list.add(channelWarehouseVO);
            }
            applicableChannelWarehouse.setList(list);
        } else {
            applicableChannelWarehouse.setIsAll(IsAllEnum.ALL.getCode());
        }
        vo.setApplicableChannelWarehouse(applicableChannelWarehouse);
        ApplicableStrategyVOApplicableVirtualWarehouse applicableVirtualWarehouse = new ApplicableStrategyVOApplicableVirtualWarehouse();
        ArrayList<VirtualWarehouseVO> virtualWarehouseVOList = new ArrayList<VirtualWarehouseVO>();
        applicableVirtualWarehouse.setList(virtualWarehouseVOList);
        List suitVirtualWarehouseList = clueActRespDto.getSuitVirtualWarehouseList();
        if (CollectionUtils.isNotEmpty((Collection)suitVirtualWarehouseList) && IsAllEnum.SELECT.getStatus().equals(((ClueSuitAttributeRespDto)suitVirtualWarehouseList.get(0)).getSgSuitSelectType())) {
            applicableVirtualWarehouse.setIsAll(IsAllEnum.SELECT.getCode());
            List suitVirtualWarehouseCodeList = suitVirtualWarehouseList.stream().map(ClueSuitAttributeRespDto::getSgSuitKey).collect(Collectors.toList());
            VirtualWarehouseListReqDto virtualWarehouseListReqDto = new VirtualWarehouseListReqDto();
            virtualWarehouseListReqDto.setVirtualWarehouseCodes(suitVirtualWarehouseCodeList);
            List virtualWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryByList(virtualWarehouseListReqDto));
            ArrayList list = Lists.newArrayList();
            for (VirtualWarehouseRespDto virtualWarehouseRespDto : virtualWarehouseRespDtos) {
                VirtualWarehouseVO virtualWarehouseVO = new VirtualWarehouseVO();
                CubeBeanUtils.copyProperties((Object)virtualWarehouseVO, (Object)virtualWarehouseRespDto, (String[])new String[0]);
                virtualWarehouseVO.setWarehouseId(virtualWarehouseRespDto.getId() + "");
                list.add(virtualWarehouseVO);
            }
            applicableVirtualWarehouse.setList(list);
        } else {
            applicableVirtualWarehouse.setIsAll(IsAllEnum.ALL.getCode());
        }
        vo.setApplicableVirtualWarehouse(applicableVirtualWarehouse);
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<List<PhysicalWarehouseVO>> getSourcingRuleDisablePhysicalWarehouse() {
        List<Object> voList = Lists.newArrayList();
        List list = (List)RestResponseHelper.extractData((RestResponse)this.iPhysicsWarehouseDisableQueryApi.queryList());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List whCodes = list.stream().map(PhysicsWarehouseDisableRespDto::getWarehouseCode).collect(Collectors.toList());
            List whList = Lists.newArrayList();
            if (whCodes != null && CollectionUtils.isNotEmpty(whCodes)) {
                CsLogicWarehouseParamQueryDto dto = new CsLogicWarehouseParamQueryDto();
                dto.setWarehouseCodeList(whCodes);
                whList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(dto));
            }
            Map whMap = null;
            if (CollectionUtils.isNotEmpty((Collection)whList)) {
                whMap = whList.stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            Map finalWhMap = whMap;
            voList = list.stream().map(i -> {
                PhysicalWarehouseVO vo = new PhysicalWarehouseVO();
                if (finalWhMap != null && finalWhMap.containsKey(i.getWarehouseCode())) {
                    CsLogicWarehousePageRespDto wh = (CsLogicWarehousePageRespDto)finalWhMap.get(i.getWarehouseCode());
                    vo.setWarehouseName(wh.getWarehouseName());
                    vo.setId(wh.getId());
                    vo.setWarehouseCode(wh.getWarehouseCode());
                }
                return vo;
            }).collect(Collectors.toList());
        }
        return new RestResponse((Object)voList);
    }

    @Override
    public RestResponse<PageInfo<SourcingRuleVO>> getSourcingRuleListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingListPageParams getSourcingListPageParams) {
        ClueReportReqDto reqDto = new ClueReportReqDto();
        BeanUtils.copyProperties((Object)getSourcingListPageParams, (Object)reqDto);
        reqDto.setApplicableChannelCodes(getSourcingListPageParams.getApplicableChannelCodes());
        reqDto.setApplicableCustomersCodes(getSourcingListPageParams.getApplicableCustomersCodes());
        reqDto.setApplicableDocumentTypes(getSourcingListPageParams.getApplicableDocumentTypes());
        reqDto.setApplicableLogicalWarehouseCodes(getSourcingListPageParams.getApplicableLogicalWarehouseCodes());
        reqDto.setApplicableOrganizationCodes(getSourcingListPageParams.getApplicableOrganizationCodes());
        String ruleStatus = getSourcingListPageParams.getRuleStatus();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ruleStatus})) {
            reqDto.setRuleStatus(EnableEnum.getStatusByCode(ruleStatus));
        }
        if (StringUtils.isNotBlank((CharSequence)getSourcingListPageParams.getUpdateTimeStart())) {
            reqDto.setUpdateTimeStart(DateUtil.parse((String)(getSourcingListPageParams.getUpdateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSourcingListPageParams.getUpdateTimeEnd())) {
            reqDto.setUpdateTimeEnd(DateUtil.parse((String)(getSourcingListPageParams.getUpdateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.clueReportQueryApi.queryCluePage(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SourcingRuleVO vo = new SourcingRuleVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (o.getStartTime() != null) {
                vo.setStartTime(DateUtil.format((Date)o.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getEndTime() != null) {
                vo.setEndTime(DateUtil.format((Date)o.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setRuleStatus(EnableEnum.getCodeByStatus(o.getRuleStatus()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    @OptLog(optOrderType=OptLogTypeEnum.SOURCE, type=OptLogTypeEnum.UPD, optNo="#id")
    public RestResponse<Object> updateSourcingRule(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitSourcingRuleParams submitSourcingRuleParams) {
        Object clueOrganizationReqDto;
        SubmitSourcingRuleParamsOldData oldData = submitSourcingRuleParams.getOldData();
        SubmitSourcingRuleParamsOldData newData = submitSourcingRuleParams.getNewData();
        if (!Objects.equals(newData.getItemBlackType(), SourceItemBlackTypeEnum.NO.code)) {
            this.checkSourceItemBlack(newData.getClueItemBlacklist());
        }
        ClueModifyActReqDto clueModifyActReqDto = new ClueModifyActReqDto();
        clueModifyActReqDto.setId(Long.valueOf(id));
        clueModifyActReqDto.setClueCode(newData.getRuleCode());
        clueModifyActReqDto.setClueName(newData.getRuleName());
        clueModifyActReqDto.setClueOldBatch(newData.getClueOldBatch());
        clueModifyActReqDto.setClueOldBatchMonth(newData.getClueOldBatchMonth());
        clueModifyActReqDto.setClueNotOldBatch(newData.getClueNotOldBatch());
        clueModifyActReqDto.setClueNotOldBatchMonth(newData.getClueNotOldBatchMonth());
        clueModifyActReqDto.setSingleWarehouseDelivery(newData.getSingleWarehouseDelivery());
        clueModifyActReqDto.setIntransitStockStatus(newData.getIntransitStockStatus());
        clueModifyActReqDto.setClueDismantleCount(Integer.valueOf(newData.getSplitOrderNum().intValue()));
        clueModifyActReqDto.setClueDismantleEnable(EnableEnum.getStatusByCode(newData.getIsSplitOrder()));
        clueModifyActReqDto.setClueEnableStartTime(DateUtil.parse((String)newData.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        clueModifyActReqDto.setClueEnableEndTime(DateUtil.parse((String)newData.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        clueModifyActReqDto.setCluePriorityLevel(Integer.valueOf(newData.getRulePriority()));
        clueModifyActReqDto.setItemBlackType(newData.getItemBlackType());
        clueModifyActReqDto.setClueItemBlacklist(newData.getClueItemBlacklist());
        clueModifyActReqDto.setWarehouseBlackList(newData.getWarehouseBlackList());
        clueModifyActReqDto.setClueDeliveryWarehouseBlackReqDtoList(newData.getClueDeliveryWarehouseBlackReqDtoList());
        ClueWarehouseGroupModifyActReqDto clueWarehouseGroupModifyActReqDto = new ClueWarehouseGroupModifyActReqDto();
        Map<String, WarehouseStrategyVO> oldWarehouseStrategyVOMap = oldData.getWarehouseStrategy().stream().collect(Collectors.toMap(WarehouseStrategyVO::getShipId, warehouseStrategyVO -> warehouseStrategyVO, (o1, o2) -> o1));
        List<WarehouseStrategyVO> warehouseStrategy = newData.getWarehouseStrategy();
        ArrayList<ClueWarehouseGroupUpdateActReqDto> add = new ArrayList<ClueWarehouseGroupUpdateActReqDto>();
        ArrayList delete = new ArrayList();
        ArrayList update = new ArrayList();
        clueWarehouseGroupModifyActReqDto.setAdd(add);
        if (CollectionUtil.isNotEmpty(warehouseStrategy)) {
            for (WarehouseStrategyVO warehouseStrategyVO2 : warehouseStrategy) {
                ClueWarehouseGroupUpdateActReqDto clueWarehouseGroupUpdateActReqDto = new ClueWarehouseGroupUpdateActReqDto();
                clueWarehouseGroupUpdateActReqDto.setEnableStatus(EnableEnum.ENABLE.getStatus());
                clueWarehouseGroupUpdateActReqDto.setWarehouseGroupName(warehouseStrategyVO2.getShipWarehouseName());
                clueWarehouseGroupUpdateActReqDto.setWarehouseGroupPriorityLevel(Integer.valueOf(warehouseStrategyVO2.getPriority()));
                clueWarehouseGroupUpdateActReqDto.setWarehouseGroupType(warehouseStrategyVO2.getShipWarehouseKey());
                clueWarehouseGroupUpdateActReqDto.setId(Long.valueOf(warehouseStrategyVO2.getShipId()));
                List<SubruleStrategyVO> subrule = warehouseStrategyVO2.getSubrule();
                if (ObjectUtil.isEmpty(subrule)) {
                    throw new BizException("\u7b56\u7565\u914d\u7f6e\u5b50\u89c4\u5219\u4e0d\u53ef\u4e3a\u7a7a");
                }
                ClueWarehouseGroupRuleModifyReqDto clueWarehouseGroupRuleModifyReqDto = new ClueWarehouseGroupRuleModifyReqDto();
                ArrayList<ClueWarehouseGroupRuleReqDto> subRuleAdd = new ArrayList<ClueWarehouseGroupRuleReqDto>();
                clueWarehouseGroupRuleModifyReqDto.setAdd(subRuleAdd);
                for (SubruleStrategyVO subruleStrategyVO : subrule) {
                    ClueWarehouseGroupRuleReqDto clueWarehouseGroupRuleReqDto = new ClueWarehouseGroupRuleReqDto();
                    clueWarehouseGroupRuleReqDto.setEnableStatus(EnableEnum.getStatusByCode(subruleStrategyVO.getEnableStatus()));
                    clueWarehouseGroupRuleReqDto.setRuleScoreProportion(subruleStrategyVO.getRuleScoreProportion());
                    clueWarehouseGroupRuleReqDto.setRuleTypeCode(subruleStrategyVO.getRuleTypeCode());
                    clueWarehouseGroupRuleReqDto.setRuleTypeName(subruleStrategyVO.getRuleTypeName());
                    clueWarehouseGroupRuleReqDto.setClueWarehouseGroupRuleDeliveryReqDtoList(subruleStrategyVO.getClueWarehouseGroupRuleDeliveryReqDtoList());
                    subRuleAdd.add(clueWarehouseGroupRuleReqDto);
                }
                clueWarehouseGroupUpdateActReqDto.setClueWarehouseGroupRuleReqDtoList(clueWarehouseGroupRuleModifyReqDto);
                add.add(clueWarehouseGroupUpdateActReqDto);
            }
        }
        clueModifyActReqDto.setClueWarehouseGroupActReqDtoList(clueWarehouseGroupModifyActReqDto);
        ClueSuitAttributeModifyReqDto clueSuitChannelList = new ClueSuitAttributeModifyReqDto();
        ArrayList<Object> suitChannelList = new ArrayList<Object>();
        clueSuitChannelList.setAdd(suitChannelList);
        SubmitSourcingRuleParamsOldDataApplicableOrderChannel applicableOrderChannel = newData.getApplicableOrderChannel();
        if (ObjectUtil.isNotEmpty((Object)applicableOrderChannel)) {
            List<OrderChannelVO> orderChannelVOList = applicableOrderChannel.getList();
            String isAll = applicableOrderChannel.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrderChannelReqDto = new ClueSuitAttributeReqDto();
                clueOrderChannelReqDto.setSgSuitKey("");
                clueOrderChannelReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL.getCode());
                clueOrderChannelReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitChannelList.add(clueOrderChannelReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderChannelVOList)) {
                    throw new BizException(BizExceptionCode.ORDER_CHANNEL_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_CHANNEL_LIST_EMPTY.getMsg());
                }
                for (OrderChannelVO orderChannelVO : orderChannelVOList) {
                    ClueSuitAttributeReqDto clueOrderChannelReqDto = new ClueSuitAttributeReqDto();
                    clueOrderChannelReqDto.setSgSuitKey(orderChannelVO.getOrderChannelId());
                    clueOrderChannelReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL.getCode());
                    clueOrderChannelReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitChannelList.add(clueOrderChannelReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitChannelList(clueSuitChannelList);
        ClueSuitAttributeModifyReqDto clueSuitCustomerList = new ClueSuitAttributeModifyReqDto();
        ArrayList<Object> suitCustomerList = new ArrayList<Object>();
        clueSuitCustomerList.setAdd(suitCustomerList);
        SubmitSourcingRuleParamsOldDataApplicableCustomers applicableCustomers = newData.getApplicableCustomers();
        if (ObjectUtil.isNotEmpty((Object)applicableCustomers)) {
            List<CustomerVO> customerVOlist = applicableCustomers.getList();
            String isAll = applicableCustomers.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueCustomerReqDto = new ClueSuitAttributeReqDto();
                clueCustomerReqDto.setSgSuitKey("");
                clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitCustomerList.add(clueCustomerReqDto);
            } else {
                if (CollectionUtil.isEmpty(customerVOlist)) {
                    throw new BizException(BizExceptionCode.CUSTOMER_LIST_EMPTY.getCode(), BizExceptionCode.CUSTOMER_LIST_EMPTY.getMsg());
                }
                for (CustomerVO customerVO : customerVOlist) {
                    ClueSuitAttributeReqDto clueCustomerReqDto = new ClueSuitAttributeReqDto();
                    clueCustomerReqDto.setSgSuitKey(customerVO.getCustomerId());
                    clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                    clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitCustomerList.add(clueCustomerReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitCustomerList(clueSuitCustomerList);
        ClueSuitAttributeModifyReqDto clueSuitOrderTypeList = new ClueSuitAttributeModifyReqDto();
        ArrayList<Object> suitOrderTypeList = new ArrayList<Object>();
        clueSuitOrderTypeList.setAdd(suitOrderTypeList);
        SubmitSourcingRuleParamsOldDataApplicableDocumentTypes applicableDocumentTypes = newData.getApplicableDocumentTypes();
        if (ObjectUtil.isNotEmpty((Object)applicableDocumentTypes)) {
            List<String> orderTypelist = applicableDocumentTypes.getList();
            String isAll = applicableDocumentTypes.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrderTypeReqDto = new ClueSuitAttributeReqDto();
                clueOrderTypeReqDto.setSgSuitKey("");
                clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrderTypeList.add(clueOrderTypeReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderTypelist)) {
                    throw new BizException(BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getMsg());
                }
                for (String orderType : orderTypelist) {
                    ClueSuitAttributeReqDto clueOrderTypeReqDto = new ClueSuitAttributeReqDto();
                    clueOrderTypeReqDto.setSgSuitKey(orderType);
                    clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                    clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrderTypeList.add(clueOrderTypeReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitOrderTypeList(clueSuitOrderTypeList);
        ClueSuitAttributeModifyReqDto clueSuitWareHouseList = new ClueSuitAttributeModifyReqDto();
        ArrayList<Object> suitWarehouseList = new ArrayList<Object>();
        clueSuitWareHouseList.setAdd(suitWarehouseList);
        SubmitSourcingRuleParamsOldDataApplicableLogicalWarehouse applicableLogicalWarehouse = newData.getApplicableLogicalWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableLogicalWarehouse)) {
            List<LogicalWarehouseVO> logicalWarehouseVOList = applicableLogicalWarehouse.getList();
            String isAll = applicableLogicalWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                clueWarehouseReqDto.setSgSuitKey("");
                clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode());
                clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitWarehouseList.add(clueWarehouseReqDto);
            } else {
                if (CollectionUtil.isEmpty(logicalWarehouseVOList)) {
                    throw new BizException(BizExceptionCode.LOGIC_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.LOGIC_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (LogicalWarehouseVO logicalWarehouseVO : logicalWarehouseVOList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)logicalWarehouseVO.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitWarehouseList(clueSuitWareHouseList);
        ClueSuitAttributeModifyReqDto clueSuitOrganizationList = new ClueSuitAttributeModifyReqDto();
        ArrayList<Object> suitOrganizationList = new ArrayList<Object>();
        clueSuitOrganizationList.setAdd(suitOrganizationList);
        SubmitSourcingRuleParamsOldDataApplicableOrganization applicableOrganization = newData.getApplicableOrganization();
        if (ObjectUtil.isNotEmpty((Object)applicableOrganization)) {
            List<OrganizationDto> applicableOrganizationList = applicableOrganization.getList();
            String isAll = applicableOrganization.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrganizationReqDto2 = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto2.setSgSuitKey("");
                clueOrganizationReqDto2.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                clueOrganizationReqDto2.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrganizationList.add(clueOrganizationReqDto2);
            } else {
                if (CollectionUtil.isEmpty(applicableOrganizationList)) {
                    throw new BizException(BizExceptionCode.ORGANIZATION_LIST_EMPTY.getCode(), BizExceptionCode.ORGANIZATION_LIST_EMPTY.getMsg());
                }
                for (OrganizationDto organizationDto : applicableOrganizationList) {
                    clueOrganizationReqDto = new ClueSuitAttributeReqDto();
                    clueOrganizationReqDto.setSgSuitKey(ParamConverter.convertToString((Object)organizationDto.getId()));
                    clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                    clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrganizationList.add(clueOrganizationReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitOrganizationList(suitOrganizationList);
        ArrayList<Object> suitChannleWarehouseList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableChannelWarehouse applicableChannelWarehouse = newData.getApplicableChannelWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableChannelWarehouse)) {
            List<ChannelWarehouseVO> applicableChannelWarehouseList = applicableChannelWarehouse.getList();
            String isAll = applicableChannelWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                clueOrganizationReqDto = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitChannleWarehouseList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableChannelWarehouseList)) {
                    throw new BizException(BizExceptionCode.CHANNEL_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.CHANNEL_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (ChannelWarehouseVO channelWarehouseVO : applicableChannelWarehouseList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)channelWarehouseVO.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitChannleWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitChannelWarehouseList(suitChannleWarehouseList);
        ArrayList<ClueSuitAttributeReqDto> suitVirtualWarehouseList = new ArrayList<ClueSuitAttributeReqDto>();
        SubmitSourcingRuleParamsOldDataApplicableVirtualWarehouse applicableVirtualWarehouse = newData.getApplicableVirtualWarehouse();
        if (ObjectUtil.isNotEmpty((Object)applicableVirtualWarehouse)) {
            List<VirtualWarehouseVO> applicableVirtualWarehouseList = applicableVirtualWarehouse.getList();
            String isAll = applicableVirtualWarehouse.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                ClueSuitAttributeReqDto clueOrganizationReqDto3 = new ClueSuitAttributeReqDto();
                clueOrganizationReqDto3.setSgSuitKey("");
                clueOrganizationReqDto3.setSgSuitType(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode());
                clueOrganizationReqDto3.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitVirtualWarehouseList.add(clueOrganizationReqDto3);
            } else {
                if (CollectionUtil.isEmpty(applicableVirtualWarehouseList)) {
                    throw new BizException(BizExceptionCode.VIRTUAL_WAREHOUSE_LIST_EMPTY.getCode(), BizExceptionCode.VIRTUAL_WAREHOUSE_LIST_EMPTY.getMsg());
                }
                for (VirtualWarehouseVO virtualWarehouseVO : applicableVirtualWarehouseList) {
                    ClueSuitAttributeReqDto clueWarehouseReqDto = new ClueSuitAttributeReqDto();
                    clueWarehouseReqDto.setSgSuitKey(virtualWarehouseVO.getWarehouseCode());
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitVirtualWarehouseList.add(clueWarehouseReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitVirtualWarehouseList(suitVirtualWarehouseList);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.clueOptApi.modifyClueOpt(clueModifyActReqDto)));
    }

    @Override
    public RestResponse<Object> updateSourcingRuleDisablePhysicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateDisablePhysicalWarehouseParams params) {
        List<Object> list = Lists.newArrayList();
        List whList = Lists.newArrayList();
        if (params.getPhysicalWarehouseCodes() != null && CollectionUtils.isNotEmpty(params.getPhysicalWarehouseCodes())) {
            CsLogicWarehouseParamQueryDto dto = new CsLogicWarehouseParamQueryDto();
            dto.setWarehouseCodeList(params.getPhysicalWarehouseCodes());
            whList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(dto));
        }
        if (CollectionUtils.isNotEmpty(params.getPhysicalWarehouseCodes()) && CollectionUtils.isNotEmpty((Collection)whList)) {
            list = whList.stream().map(i -> {
                PhysicsWarehouseDisableReqDto warehouseDisableReqDto = new PhysicsWarehouseDisableReqDto();
                warehouseDisableReqDto.setWarehouseId(i.getId());
                warehouseDisableReqDto.setWarehouseCode(i.getWarehouseCode());
                return warehouseDisableReqDto;
            }).collect(Collectors.toList());
        }
        RestResponseHelper.extractData((RestResponse)this.iPhysicsWarehouseDisableApi.batchSave((List)list));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateSourcingRuleStatus(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateSourcingStatusParams updateSourcingStatusParams) {
        if (CollectionUtils.isEmpty(updateSourcingStatusParams.getRuleIds())) {
            throw new BizException("\u5bfb\u6e90\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.clueOptApi.openEnable(Long.valueOf(updateSourcingStatusParams.getRuleIds().get(0)), EnableEnum.getStatusByCode(updateSourcingStatusParams.getRuleStatus()))));
    }
}

