/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportSortingBillReportMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportSortingBillReportVO;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.IStorageChargeBillApi;
import com.dtyunxi.tcbj.api.dto.request.SortingBillReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.ISortingBillQueryApi;
import com.dtyunxi.tcbj.api.query.ISortingExpenseQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.entity.IBillApi;
import com.yunxi.dg.base.center.report.dto.entity.BillDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sorting_bill_report_import")
public class ImportSortingBillReportImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportSortingBillReportImpl.class);
    @Resource
    private ISortingBillQueryApi sortingBillQueryApi;
    @Resource
    private ISortingExpenseQueryApi sortingExpenseQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IStorageChargeBillApi storageChargeBillApi;
    @Resource
    private IBillApi billApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportSortingBillReportVO.class);
        log.info("\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            ImportSortingBillReportMsgVO msgDto = new ImportSortingBillReportMsgVO();
            CubeBeanUtils.copyProperties((Object)i, (Object)msgDto, (String[])new String[0]);
            this.checkForm((ImportSortingBillReportVO)((Object)i), msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5bfc\u5165\u6210\u529f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saveList));
        log.info("\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5bfc\u5165\u5931\u8d25\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)msgList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            log.info("===\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            for (ImportSortingBillReportVO v : saveList) {
                BillDto d = new BillDto();
                try {
                    BeanUtils.copyProperties((Object)((Object)v), (Object)d);
                    d.setAdjustType(Long.valueOf(v.getAdjustType().equals("\u589e\u52a0") ? 1L : 2L));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
                    d.setOutWarehouseTime(sdf.parse(v.getOutWarehouseTime()));
                }
                catch (Exception e) {
                    log.error("error:" + e);
                }
                this.billApi.update(d);
            }
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportSortingBillReportMsgVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, SortingBillRespDto> getcodesMap(List<ImportSortingBillReportVO> list) {
        HashMap codesMap = Maps.newHashMap();
        for (ImportSortingBillReportVO vo : list) {
            List list1;
            log.info("vo\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
            Date time = new Date();
            try {
                time = sdf.parse(vo.getOutWarehouseTime());
                log.info("\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u5df2\u8f6c\u4e3a\uff1a{yyyy/MM}");
            }
            catch (Exception e) {
                log.info("\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u4e0d\u53ef\u8f6c\u4e3a\uff1a{yyyy/MM}");
                try {
                    time = sdf1.parse(vo.getOutWarehouseTime());
                    log.info("\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u8f6c\u4e3a\uff1a{yyyy-MM}");
                }
                catch (Exception e1) {
                    log.info("\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u4e0d\u53ef\u8f6c\u4e3a\uff1a{yyyy-MM}");
                }
            }
            ArrayList<String> codes1 = new ArrayList<String>();
            codes1.add(vo.getOutPhysicsWarehouseCode());
            ArrayList<String> codes2 = new ArrayList<String>();
            codes2.add(vo.getExpenseOrganizationId());
            SortingBillReportListPageReqDto reqDto = new SortingBillReportListPageReqDto();
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(1000));
            reqDto.setStatisticsMonth(time.toString());
            reqDto.setOutPhysicsWarehouseCodeList(codes1);
            reqDto.setExpenseOrganizationCodeList(codes2);
            PageInfo respDto = (PageInfo)this.sortingBillQueryApi.getSortingBillReportListPage(reqDto).getData();
            if (respDto == null || null == (list1 = respDto.getList()) || list1.isEmpty()) continue;
            String key = time + vo.getOutPhysicsWarehouseCode() + vo.getExpenseOrganizationId();
            codesMap.put(key, list1.get(0));
        }
        return codesMap;
    }

    private void checkForm(ImportSortingBillReportVO i, ImportSortingBillReportMsgVO msgDto) {
        log.info("checkForm starting ...");
        log.info("\u6821\u9a8c\u5bf9\u8c61: {}", (Object)JSON.toJSONString((Object)((Object)i)));
        BeanUtils.copyProperties((Object)((Object)i), (Object)msgDto);
        if (i.getOutWarehouseTime() == null || i.getOutWarehouseTime().equals("")) {
            msgDto.setErrorMsg("\u6708\u4efd\u7f3a\u5931");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
            try {
                Date date = sdf.parse(i.getOutWarehouseTime());
            }
            catch (ParseException e) {
                msgDto.setErrorMsg("\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (i.getOutPhysicsWarehouseCode() == null || i.getOutPhysicsWarehouseCode().isEmpty()) {
            msgDto.setErrorMsg("\u51fa\u5e93\u7269\u7406\u4ed3\u7f16\u7801\u7f3a\u5931");
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(i.getOutPhysicsWarehouseCode());
            List respDto = (List)this.logicWarehouseQueryApi.queryWarehouseByCode(list).getData();
            if (null == respDto || list.isEmpty()) {
                msgDto.setErrorMsg("\u4ed3\u5e93\u4e0d\u5b58\u5728");
            }
        }
        if (i.getExpenseOrganizationName() == null || i.getExpenseOrganizationName().isEmpty()) {
            msgDto.setErrorMsg("\u8ba1\u8d39\u7ec4\u7ec7\u7f3a\u5931");
        }
        if (i.getAdjustType() == null) {
            msgDto.setErrorMsg("\u8c03\u6574\u7c7b\u578b\u7f3a\u5931");
        } else if (!i.getAdjustType().equals("\u589e\u52a0") && !i.getAdjustType().equals("\u51cf\u5c11")) {
            msgDto.setErrorMsg("\u8c03\u6574\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e");
        }
        if (i.getAdjustNum() == null) {
            msgDto.setErrorMsg("\u8c03\u6574\u91d1\u989d\u7f3a\u5931");
        }
        if (i.getOutWarehouseTime() != null && i.getOutPhysicsWarehouseCode() != null && i.getExpenseOrganizationName() != null) {
            SortingBillReportListPageReqDto reqDto = new SortingBillReportListPageReqDto();
            String[] yearMonth = i.getOutWarehouseTime().split("/");
            reqDto.setStatisticsYear(yearMonth[0]);
            reqDto.setStatisticsMonth(yearMonth[1]);
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(1000));
            reqDto.setOutPhysicsWarehouseCode(i.getOutPhysicsWarehouseCode());
            reqDto.setExpenseOrganizationName(i.getExpenseOrganizationName());
            log.info("\u67e5\u8be2\u5206\u62e3\u8d26\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            List list = ((PageInfo)this.sortingBillQueryApi.getSortingBillReportListPage(reqDto).getData()).getList();
            log.info("\u67e5\u8be2\u5bf9\u5e94\u5bfc\u5165\u9700\u8981\u4fee\u6539\u7684\u5206\u62e3\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)list));
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                i.setId(((SortingBillRespDto)list.get(0)).getId());
            } else {
                msgDto.setErrorMsg("\u4e0d\u5b58\u5728\u8be5\u6570\u636e,\u65e0\u6cd5\u4fee\u6539");
            }
        }
    }
}

