/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.ItemTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.ZhInversionEnum;
import com.dtyunxi.cis.pms.biz.export.ExportProperties;
import com.dtyunxi.cis.pms.biz.model.BatchInversionReportVO;
import com.dtyunxi.cis.pms.biz.model.ExportBatchInversionReportVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetBatchInversionReportListPageParams;
import com.dtyunxi.cis.pms.biz.service.ReportCenterFinishedGoodsInventoryBatchInversionReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BatchInversionReqDto;
import com.dtyunxi.tcbj.api.query.IPcpItemQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_batch_inversion_report")
public class ReportCenterFinishedGoodsInventoryBatchInversionReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterFinishedGoodsInventoryBatchInversionReportService {
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;

    @Override
    public RestResponse<PageInfo<BatchInversionReportVO>> getBatchInversionReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetBatchInversionReportListPageParams getBatchInversionReportListPageParams) {
        BatchInversionReqDto reqDto = new BatchInversionReqDto();
        this.getParams(getBatchInversionReportListPageParams, reqDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByBatchInversion(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BatchInversionReportVO vo = new BatchInversionReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsName(o.getCargoName());
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsType(ParamConverter.convertToString((Object)o.getItemType()));
            vo.setOldBalance(ParamConverter.convertToString((Object)o.getOldBalance()));
            vo.setRdcInversion(ParamConverter.convertToString((Object)o.getRdcInversion()));
            vo.setZhInversion(ParamConverter.convertToString((Object)o.getZhInversion()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(GetBatchInversionReportListPageParams getBatchInversionReportListPageParams, BatchInversionReqDto reqDto) {
        BeanUtils.copyProperties((Object)getBatchInversionReportListPageParams, (Object)reqDto);
        reqDto.setLongCode(getBatchInversionReportListPageParams.getGoodsLongCode());
        reqDto.setCargoName(getBatchInversionReportListPageParams.getGoodsName());
        reqDto.setOldWarehouseNames(getBatchInversionReportListPageParams.getOldWarehouseNames());
        reqDto.setItemType(ParamConverter.convertToInteger((Object)getBatchInversionReportListPageParams.getGoodsType()));
        reqDto.setRdcInversion(ParamConverter.convertToInteger((Object)getBatchInversionReportListPageParams.getRdcInversion()));
        reqDto.setZhInversion(ParamConverter.convertToInteger((Object)getBatchInversionReportListPageParams.getZhInversion()));
        reqDto.setBusinessTypes(getBatchInversionReportListPageParams.getBusinessTypes());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetBatchInversionReportListPageParams params = new GetBatchInversionReportListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetBatchInversionReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBatchInversionReportListPageParams.class);
        }
        params.setPageSize(commonReqDto.getPageSize());
        params.setPageNum(commonReqDto.getPageNum());
        ExportProperties exportProperties = new ExportProperties();
        exportProperties.setHasTemp(1);
        exportProperties.setTempPath("templates/ExportBatchInversionReportModel.xlsx");
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)this.getBatchInversionReportListPage((GetBatchInversionReportListPageParams)re).getData();
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportBatchInversionReportVO vo = new ExportBatchInversionReportVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setGoodsLongCode(o.getGoodsLongCode());
                vo.setGoodsName(o.getGoodsName());
                if (StringUtils.isNotBlank((CharSequence)o.getOldBalance())) {
                    vo.setOldBalance(new BigDecimal(o.getOldBalance()).intValue());
                }
                vo.setGoodsType(ItemTypeEnum.getDescByCode(String.valueOf(o.getGoodsType())));
                if (StringUtils.isNotBlank((CharSequence)o.getRdcInversion())) {
                    vo.setRdcInversion(ZhInversionEnum.getDescByCode(Integer.parseInt(o.getRdcInversion().trim())));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getZhInversion())) {
                    vo.setZhInversion(ZhInversionEnum.getDescByCode(Integer.parseInt(o.getZhInversion().trim())));
                }
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportBatchInversionReportVO.class, commonReqDto.getFileName(), exportProperties);
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetBatchInversionReportListPageParams params = new GetBatchInversionReportListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetBatchInversionReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBatchInversionReportListPageParams.class);
        }
        params.setPageSize(1);
        params.setPageNum(1);
        RestResponse<PageInfo<BatchInversionReportVO>> respDtoPageInfoList = this.getBatchInversionReportListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)respDtoPageInfoList.getData();
        if (null == respDtoPageInfo || CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

